/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.codec.binary;

import java.nio.charset.Charset;
import org.dromara.hutool.core.codec.binary.Base16Codec;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class Hex {
    public static char[] encode(byte[] data) {
        return Hex.encode(data, true);
    }

    public static char[] encode(String str, Charset charset) {
        return Hex.encode(ByteUtil.toBytes(str, charset), true);
    }

    public static char[] encode(byte[] data, boolean toLowerCase) {
        if (null == data) {
            return null;
        }
        return (toLowerCase ? Base16Codec.CODEC_LOWER : Base16Codec.CODEC_UPPER).encode(data);
    }

    public static String encodeStr(byte[] data) {
        return Hex.encodeStr(data, true);
    }

    public static String encodeStr(CharSequence data) {
        return Hex.encodeStr(data, CharsetUtil.UTF_8);
    }

    public static String encodeStr(CharSequence data, Charset charset) {
        return Hex.encodeStr(ByteUtil.toBytes(data, charset), true);
    }

    public static String encodeStr(byte[] data, boolean toLowerCase) {
        return StrUtil.str(Hex.encode(data, toLowerCase), CharsetUtil.UTF_8);
    }

    public static String decodeStr(CharSequence hexStr) {
        return Hex.decodeStr(hexStr, CharsetUtil.UTF_8);
    }

    public static String decodeStr(CharSequence hexStr, Charset charset) {
        if (StrUtil.isEmpty(hexStr)) {
            return StrUtil.toStringOrNull(hexStr);
        }
        return StrUtil.str(Hex.decode(hexStr), charset);
    }

    public static String decodeStr(char[] hexData, Charset charset) {
        return StrUtil.str(Hex.decode(hexData), charset);
    }

    public static byte[] decode(char[] hexData) {
        return Hex.decode(String.valueOf(hexData));
    }

    public static byte[] decode(CharSequence hexData) {
        return Base16Codec.CODEC_LOWER.decode(hexData);
    }
}

