/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Configurations {
    DISABLE_EXIF_WORKAROUND("thumbnailator.disableExifWorkaround"),
    DEBUG_LOG("thumbnailator.debugLog"),
    DEBUG_LOG_EXIF_WORKAROUND("thumbnailator.debugLog.exifWorkaround"),
    CONSERVE_MEMORY_WORKAROUND("thumbnailator.conserveMemoryWorkaround");

    private final String key;
    private static final Properties properties;

    static void init() {
        properties.clear();
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("thumbnailator.properties");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error while reading thumbnailator.properties", iOException);
            }
        }
    }

    static void clear() {
        properties.clear();
    }

    private Configurations(String string2) {
        this.key = string2;
    }

    public boolean getBoolean() {
        String string = properties.getProperty(this.key);
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return Boolean.getBoolean(this.key);
    }

    static {
        properties = new Properties();
        Configurations.init();
    }
}

