/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services.transport.rsocket;

import io.scalecube.utils.MaskUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public final class ConnectionSetup
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> credentials = Collections.emptyMap();

    @Deprecated
    public ConnectionSetup() {
    }

    public ConnectionSetup(Map<String, String> credentials) {
        this.credentials = Collections.unmodifiableMap(new HashMap<String, String>(Objects.requireNonNull(credentials, "ConnectionSetup.credentials")));
    }

    public Map<String, String> credentials() {
        return this.credentials;
    }

    public boolean hasCredentials() {
        return !this.credentials.isEmpty();
    }

    public String toString() {
        return new StringJoiner(", ", ConnectionSetup.class.getSimpleName() + "[", "]").add("credentials=" + MaskUtil.mask(this.credentials)).toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.credentials.size());
        for (Map.Entry<String, String> entry : this.credentials.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int credsSize = in.readInt();
        HashMap<String, String> creds = new HashMap<String, String>(credsSize);
        for (int i = 0; i < credsSize; ++i) {
            String key = in.readUTF();
            String value = (String)in.readObject();
            creds.put(key, value);
        }
        this.credentials = Collections.unmodifiableMap(creds);
    }
}

