/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.services;

import io.scalecube.services.Reflect;
import io.scalecube.services.ServiceReference;
import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.DefaultErrorMapper;
import io.scalecube.services.exceptions.ServiceClientErrorMapper;
import io.scalecube.services.exceptions.ServiceUnavailableException;
import io.scalecube.services.methods.MethodInfo;
import io.scalecube.services.methods.ServiceMethodInvoker;
import io.scalecube.services.methods.ServiceMethodRegistry;
import io.scalecube.services.registry.api.ServiceRegistry;
import io.scalecube.services.routing.Router;
import io.scalecube.services.routing.Routers;
import io.scalecube.services.transport.api.ClientTransport;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServiceCall {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCall.class);
    private ClientTransport transport;
    private ServiceMethodRegistry methodRegistry;
    private ServiceRegistry serviceRegistry;
    private Router router;
    private ServiceClientErrorMapper errorMapper = DefaultErrorMapper.INSTANCE;
    private Map<String, String> credentials = Collections.emptyMap();
    private String contentType = "application/json";

    public ServiceCall() {
    }

    private ServiceCall(ServiceCall other) {
        this.transport = other.transport;
        this.methodRegistry = other.methodRegistry;
        this.serviceRegistry = other.serviceRegistry;
        this.router = other.router;
        this.errorMapper = other.errorMapper;
        this.contentType = other.contentType;
        this.credentials = Collections.unmodifiableMap(new HashMap<String, String>(other.credentials));
    }

    public ServiceCall transport(ClientTransport clientTransport) {
        ServiceCall target = new ServiceCall(this);
        target.transport = clientTransport;
        return target;
    }

    public ServiceCall serviceRegistry(ServiceRegistry serviceRegistry) {
        ServiceCall target = new ServiceCall(this);
        target.serviceRegistry = serviceRegistry;
        return target;
    }

    public ServiceCall methodRegistry(ServiceMethodRegistry methodRegistry) {
        ServiceCall target = new ServiceCall(this);
        target.methodRegistry = methodRegistry;
        return target;
    }

    public ServiceCall router(Class<? extends Router> routerType) {
        ServiceCall target = new ServiceCall(this);
        target.router = Routers.getRouter(routerType);
        return target;
    }

    public ServiceCall router(Router router) {
        ServiceCall target = new ServiceCall(this);
        target.router = router;
        return target;
    }

    public ServiceCall errorMapper(ServiceClientErrorMapper errorMapper) {
        ServiceCall target = new ServiceCall(this);
        target.errorMapper = errorMapper;
        return target;
    }

    public ServiceCall credentials(Map<String, String> credentials) {
        ServiceCall target = new ServiceCall(this);
        target.credentials = Collections.unmodifiableMap(new HashMap<String, String>(credentials));
        return target;
    }

    public ServiceCall contentType(String contentType) {
        ServiceCall target = new ServiceCall(this);
        target.contentType = contentType;
        return target;
    }

    public Mono<Void> oneWay(ServiceMessage request) {
        return Mono.defer(() -> this.requestOne(request, (Type)((Object)Void.class)).then());
    }

    public Mono<ServiceMessage> requestOne(ServiceMessage request) {
        return this.requestOne(request, null);
    }

    public Mono<ServiceMessage> requestOne(ServiceMessage request, Type responseType) {
        return Mono.defer(() -> {
            ServiceMethodInvoker methodInvoker;
            if (this.methodRegistry != null && (methodInvoker = this.methodRegistry.getInvoker(request.qualifier())) != null) {
                return methodInvoker.invokeOne(request).map(this::throwIfError);
            }
            Objects.requireNonNull(this.transport, "[requestOne] transport");
            return Mono.fromCallable(() -> this.serviceLookup(request)).flatMap(serviceReference -> this.transport.create((ServiceReference)serviceReference).requestResponse(request, responseType).map(this::throwIfError));
        });
    }

    public Flux<ServiceMessage> requestMany(ServiceMessage request) {
        return this.requestMany(request, null);
    }

    public Flux<ServiceMessage> requestMany(ServiceMessage request, Type responseType) {
        return Flux.defer(() -> {
            ServiceMethodInvoker methodInvoker;
            if (this.methodRegistry != null && (methodInvoker = this.methodRegistry.getInvoker(request.qualifier())) != null) {
                return methodInvoker.invokeMany(request).map(this::throwIfError);
            }
            Objects.requireNonNull(this.transport, "[requestMany] transport");
            return Mono.fromCallable(() -> this.serviceLookup(request)).flatMapMany(serviceReference -> this.transport.create((ServiceReference)serviceReference).requestStream(request, responseType).map(this::throwIfError));
        });
    }

    public Flux<ServiceMessage> requestBidirectional(Publisher<ServiceMessage> publisher) {
        return this.requestBidirectional(publisher, null);
    }

    public Flux<ServiceMessage> requestBidirectional(Publisher<ServiceMessage> publisher, Type responseType) {
        return Flux.from(publisher).switchOnFirst((first, messages) -> {
            if (first.hasValue()) {
                ServiceMethodInvoker methodInvoker;
                ServiceMessage request = (ServiceMessage)first.get();
                if (this.methodRegistry != null && (methodInvoker = this.methodRegistry.getInvoker(request.qualifier())) != null) {
                    return methodInvoker.invokeBidirectional((Publisher<ServiceMessage>)messages).map(this::throwIfError);
                }
                Objects.requireNonNull(this.transport, "[requestBidirectional] transport");
                return Mono.fromCallable(() -> this.serviceLookup(request)).flatMapMany(serviceReference -> this.transport.create((ServiceReference)serviceReference).requestChannel((Publisher<ServiceMessage>)messages, responseType).map(this::throwIfError));
            }
            return messages;
        });
    }

    public <T> T api(final Class<T> serviceInterface) {
        final ServiceCall serviceCall = this;
        final Map<Method, MethodInfo> genericReturnTypes = Reflect.methodsInfo(serviceInterface);
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{serviceInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] params) {
                Optional check = ServiceCall.this.toStringOrEqualsOrHashCode(method.getName(), serviceInterface, params);
                if (check.isPresent()) {
                    return check.get();
                }
                MethodInfo methodInfo = (MethodInfo)genericReturnTypes.get(method);
                Type returnType = methodInfo.parameterizedReturnType();
                boolean isServiceMessage = methodInfo.isReturnTypeServiceMessage();
                Object request = methodInfo.requestType() == Void.TYPE ? null : params[0];
                switch (methodInfo.communicationMode()) {
                    case FIRE_AND_FORGET: {
                        return serviceCall.oneWay(ServiceCall.this.toServiceMessage(methodInfo, request));
                    }
                    case REQUEST_RESPONSE: {
                        return serviceCall.requestOne(ServiceCall.this.toServiceMessage(methodInfo, request), returnType).transform(ServiceCall.this.asMono(isServiceMessage));
                    }
                    case REQUEST_STREAM: {
                        return serviceCall.requestMany(ServiceCall.this.toServiceMessage(methodInfo, request), returnType).transform(ServiceCall.this.asFlux(isServiceMessage));
                    }
                    case REQUEST_CHANNEL: {
                        return serviceCall.requestBidirectional((Publisher<ServiceMessage>)Flux.from((Publisher)((Publisher)request)).map(data -> ServiceCall.this.toServiceMessage(methodInfo, data)), returnType).transform(ServiceCall.this.asFlux(isServiceMessage));
                    }
                }
                throw new IllegalArgumentException("Communication mode is not supported: " + method);
            }
        });
    }

    private ServiceReference serviceLookup(ServiceMessage request) {
        return this.router.route(this.serviceRegistry, request).orElseThrow(() -> this.noReachableMemberException(request));
    }

    private ServiceMessage toServiceMessage(MethodInfo methodInfo, Object request) {
        if (request instanceof ServiceMessage) {
            return ServiceMessage.from((ServiceMessage)request).qualifier(methodInfo.serviceName(), methodInfo.methodName()).headers(this.credentials).dataFormatIfAbsent(this.contentType).build();
        }
        return ServiceMessage.builder().qualifier(methodInfo.serviceName(), methodInfo.methodName()).headers(this.credentials).data(request).dataFormatIfAbsent(this.contentType).build();
    }

    private ServiceUnavailableException noReachableMemberException(ServiceMessage request) {
        LOGGER.error("Failed  to invoke service, No reachable member with such service definition [{}], args [{}]", (Object)request.qualifier(), (Object)request);
        return new ServiceUnavailableException("No reachable member with such service: " + request.qualifier());
    }

    private Optional<Object> toStringOrEqualsOrHashCode(String method, Class<?> serviceInterface, Object ... args) {
        switch (method) {
            case "toString": {
                return Optional.of(serviceInterface.toString());
            }
            case "equals": {
                return Optional.of(serviceInterface.equals(args[0]));
            }
            case "hashCode": {
                return Optional.of(serviceInterface.hashCode());
            }
        }
        return Optional.empty();
    }

    private Function<Flux<ServiceMessage>, Flux<Object>> asFlux(boolean isReturnTypeServiceMessage) {
        return flux -> isReturnTypeServiceMessage ? flux.cast(Object.class) : flux.map(ServiceMessage::data);
    }

    private Function<Mono<ServiceMessage>, Mono<Object>> asMono(boolean isReturnTypeServiceMessage) {
        return mono -> isReturnTypeServiceMessage ? mono.cast(Object.class) : mono.map(ServiceMessage::data);
    }

    private ServiceMessage throwIfError(ServiceMessage message) {
        if (message.isError() && message.hasData(ErrorData.class)) {
            throw Exceptions.propagate((Throwable)this.errorMapper.toError(message));
        }
        return message;
    }
}

