/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.auth;

import com.volcengine.ApiException;
import com.volcengine.auth.CredentialValue;
import com.volcengine.auth.Provider;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CredentialProvider {
    private Provider provider;
    private ReadWriteLock readWriteLock;

    public CredentialProvider(Provider provider) {
        this.provider = provider;
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public CredentialValue get() throws ApiException {
        try {
            this.readWriteLock.readLock().lock();
            if (!this.provider.isExpired()) {
                CredentialValue credentialValue = this.provider.retrieve();
                return credentialValue;
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        try {
            this.readWriteLock.writeLock().lock();
            if (this.provider.isExpired()) {
                this.provider.refresh();
            }
            CredentialValue credentialValue = this.provider.retrieve();
            return credentialValue;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

