/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.bspay.sdk.opps.core.utils;

import com.huifu.bspay.sdk.opps.core.BasePay;
import com.huifu.bspay.sdk.opps.core.exception.BasePayException;
import com.huifu.bspay.sdk.opps.core.exception.FailureCode;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class OkHttpClientTools {
    private static int readTimeout = 20000;
    private static int connectTimout = 20000;
    private static int writeTimeout = 30000;
    private static final int SUCCESS_CODE = 200;
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    public static String httpPost(String url, String jsonData, String productId) throws BasePayException {
        try {
            RequestBody body = RequestBody.create((String)jsonData, (MediaType)JSON);
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)connectTimout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).build();
            Request.Builder builder = new Request.Builder().url(url).addHeader("format", "JSON").addHeader("charset", "UTF-8").addHeader("version", "1.0.0").addHeader("product_id", productId).addHeader("Accept", "application/json;charset=utf-8").addHeader("Content-Type", "application/json; charset=utf-8").post(body);
            Call call = client.newCall(builder.build());
            try {
                Response response = call.execute();
                int statusCode = response.code();
                if (200 != statusCode) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u5931\u8d25\uff0cresponse.code: ".concat(String.valueOf(statusCode)));
                    }
                    throw new BasePayException(FailureCode.POST_REQUEST_FALI.getFailureCode(), "post request fail. response.code=".concat(String.valueOf(statusCode)));
                }
                String responseData = response.body().string();
                if (StringUtils.isBlank((CharSequence)responseData)) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u5931\u8d25\uff0c\u8c03\u7528\u4e0b\u6e38\u7cfb\u7edf\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a: ");
                    }
                    throw new BasePayException(FailureCode.POST_REQUEST_FALI_NULL.getFailureCode(), "post request huifu system fail, reponse data null.");
                }
                return responseData;
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25\uff0cSocketTimeout");
                    }
                    throw new BasePayException(FailureCode.SOCKET_TIME_EXCEPTION.getFailureCode(), "post request huifu system fail, socket timeout exception.");
                }
                if (e instanceof ConnectException) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25\uff0c \u5efa\u7acb\u8fde\u63a5\u8d85\u65f6");
                    }
                    throw new BasePayException(FailureCode.CONNECT_EXCEPTION.getFailureCode(), "post request huifu system fail, connection timeout.");
                }
                if (BasePay.debug) {
                    System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25");
                }
                throw new BasePayException(FailureCode.POST_REQUEST_FALI.getFailureCode(), "post request huifu system fail,IOException.");
            }
        }
        catch (Exception e) {
            if (BasePay.debug) {
                System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25");
            }
            throw new BasePayException(FailureCode.POST_REQUEST_FALI.getFailureCode(), "post request huifu system fail.");
        }
    }

    public static String httpPostFile(String url, String jsonData, String productId, File file) throws BasePayException {
        try {
            if (file == null || !file.exists()) {
                return "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a";
            }
            RequestBody body = RequestBody.create((String)jsonData, (MediaType)JSON);
            RequestBody fileBody = RequestBody.create((File)file, (MediaType)JSON);
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)connectTimout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).build();
            MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.ALTERNATIVE).addFormDataPart("file", file.getName(), fileBody).addPart(body).build();
            Request.Builder builder = new Request.Builder().url(url).addHeader("format", "JSON").addHeader("charset", "UTF-8").addHeader("version", "1.0.0").addHeader("product_id", productId).addHeader("Accept", "application/json;charset=utf-8").addHeader("Content-Type", "application/json; charset=utf-8").post((RequestBody)multipartBody);
            Call call = client.newCall(builder.build());
            try {
                Response response = call.execute();
                int statusCode = response.code();
                if (200 != statusCode) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u5931\u8d25\uff0cresponse.code: ".concat(String.valueOf(statusCode)));
                    }
                    throw new BasePayException(FailureCode.POST_REQUEST_FALI.getFailureCode(), "post request fail. response.code=".concat(String.valueOf(statusCode)));
                }
                String responseData = response.body().string();
                if (StringUtils.isBlank((CharSequence)responseData)) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u5931\u8d25\uff0c\u8c03\u7528\u4e0b\u6e38\u7cfb\u7edf\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a: ");
                    }
                    throw new BasePayException(FailureCode.POST_REQUEST_FALI_NULL.getFailureCode(), "post request huifu system fail, reponse data null.");
                }
                return responseData;
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25\uff0cSocketTimeout");
                    }
                    throw new BasePayException(FailureCode.SOCKET_TIME_EXCEPTION.getFailureCode(), "post request huifu system fail, socket timeout exception.");
                }
                if (e instanceof ConnectException) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25\uff0c \u5efa\u7acb\u8fde\u63a5\u8d85\u65f6");
                    }
                    throw new BasePayException(FailureCode.CONNECT_EXCEPTION.getFailureCode(), "post request huifu system fail, connection timeout.");
                }
                if (BasePay.debug) {
                    System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25");
                }
                throw new BasePayException(FailureCode.POST_REQUEST_FALI.getFailureCode(), "post request huifu system fail, IOException.");
            }
        }
        catch (Exception e) {
            if (BasePay.debug) {
                System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25");
            }
            throw new BasePayException(FailureCode.POST_REQUEST_FALI.getFailureCode(), "post request huifu system fail.");
        }
    }

    public static String httpGet(String url, String jsonData, String productId) throws BasePayException {
        try {
            RequestBody body = RequestBody.create((String)jsonData, (MediaType)JSON);
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)connectTimout, TimeUnit.MILLISECONDS).readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).build();
            Request.Builder builder = new Request.Builder().url(url).patch(body).addHeader("format", "JSON").addHeader("charset", "UTF-8").addHeader("version", "1.0.0").addHeader("product_id", productId).addHeader("Accept", "application/json;charset=utf-8").addHeader("Content-Type", "application/json; charset=utf-8").get();
            Call call = client.newCall(builder.build());
            try {
                Response response = call.execute();
                int statusCode = response.code();
                if (200 != statusCode) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u5931\u8d25\uff0cresponse.code: ".concat(String.valueOf(statusCode)));
                    }
                    throw new BasePayException(FailureCode.POST_REQUEST_FALI.getFailureCode(), "post request fail. response.code=".concat(String.valueOf(statusCode)));
                }
                String responseData = response.body().string();
                if (StringUtils.isBlank((CharSequence)responseData)) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u5931\u8d25\uff0c\u8c03\u7528\u4e0b\u6e38\u7cfb\u7edf\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a: ");
                    }
                    throw new BasePayException(FailureCode.POST_REQUEST_FALI_NULL.getFailureCode(), "post request huifu system fail, reponse data null.");
                }
                return responseData;
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25\uff0cSocketTimeout");
                    }
                    throw new BasePayException(FailureCode.SOCKET_TIME_EXCEPTION.getFailureCode(), "post request huifu system fail, socket timeout exception.");
                }
                if (e instanceof ConnectException) {
                    if (BasePay.debug) {
                        System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25\uff0c \u5efa\u7acb\u8fde\u63a5\u8d85\u65f6");
                    }
                    throw new BasePayException(FailureCode.CONNECT_EXCEPTION.getFailureCode(), "post request huifu system fail, connection timeout.");
                }
                if (BasePay.debug) {
                    System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25");
                }
                throw new BasePayException(FailureCode.POST_REQUEST_FALI.getFailureCode(), "post request huifu system fail.");
            }
        }
        catch (Exception e) {
            if (BasePay.debug) {
                System.out.println("POST\u8bf7\u6c42\u6c47\u4ed8\u4ea4\u6613\u7cfb\u7edf\u5931\u8d25");
            }
            throw new BasePayException(FailureCode.POST_REQUEST_FALI.getFailureCode(), "post request huifu system fail.");
        }
    }
}

