/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.bspay.sdk.opps.core.utils;

import com.alibaba.fastjson.JSON;
import com.huifu.bspay.sdk.opps.core.BasePay;
import com.huifu.bspay.sdk.opps.core.config.MerConfig;
import com.huifu.bspay.sdk.opps.core.exception.BasePayException;
import com.huifu.bspay.sdk.opps.core.exception.FailureCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ParseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static CloseableHttpClient httpClient;
    private static RequestConfig requestConfig;
    private static int connectionRequestTimeout;
    private static int socketTimeout;
    private static int connectTimout;
    private static final ReentrantLock lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient(String url) {
        URL aUrl = null;
        try {
            aUrl = new URL(url);
        }
        catch (Exception ex) {
            return null;
        }
        int port = 80;
        port = "https".equals(aUrl.getProtocol()) ? (aUrl.getPort() == -1 ? 443 : aUrl.getPort()) : (aUrl.getPort() == -1 ? 80 : aUrl.getPort());
        String hostname = aUrl.getHost();
        if (httpClient == null) {
            lock.lock();
            try {
                if (httpClient == null) {
                    httpClient = HttpClientUtils.createHttpClient(500, 40, 100, hostname, port);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return httpClient;
    }

    public static CloseableHttpClient createHttpClient(int maxTotal, int maxPerRoute, int maxRoute, String hostname, int port) {
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        SSLContext sslcontext = SSLContexts.createDefault();
        TrustManager[] trustAllCerts = new TrustManager[1];
        X509TrustManager tm = HttpClientUtils.getX509TrustManager();
        trustAllCerts[0] = tm;
        try {
            sslcontext.init(null, trustAllCerts, null);
        }
        catch (KeyManagementException keyManagementException) {
            // empty catch block
        }
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, hostnameVerifier);
        Registry registry = RegistryBuilder.create().register("http", (Object)plainsf).register("https", (Object)sslsf).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry, null, null, null, 5L, TimeUnit.MINUTES);
        cm.setMaxTotal(maxTotal);
        cm.setDefaultMaxPerRoute(maxPerRoute);
        HttpHost httpHost = new HttpHost(hostname, port);
        cm.setMaxPerRoute(new HttpRoute(httpHost), maxRoute);
        HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 3) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return false;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        if (requestConfig == null) {
            HttpClientUtils.initRequestConfig();
        }
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).setRetryHandler(httpRequestRetryHandler).build();
        HttpClientUtils.closeExpiredConnectionsPeriodTask(1, cm);
        return httpClient;
    }

    public static X509TrustManager getX509TrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
    }

    private static void closeExpiredConnectionsPeriodTask(int timeUnitBySecond, final PoolingHttpClientConnectionManager cm) {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1);
        executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (cm != null) {
                    cm.closeExpiredConnections();
                }
            }
        }, 10L, timeUnitBySecond, TimeUnit.MINUTES);
    }

    static void initRequestConfig() {
        requestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimout).setConnectionRequestTimeout(connectionRequestTimeout).build();
    }

    public static String httpPost(String url, Map<String, Object> params, boolean isJson) throws BasePayException {
        return HttpClientUtils.httpPost(url, null, params, false, null, isJson, null, null);
    }

    public static String httpPost(String url, Map<String, String> headers, Map<String, Object> params) throws BasePayException {
        return HttpClientUtils.httpPost(url, headers, params, false, null, false, null, null);
    }

    public static String httpPostJson(String url, Map<String, String> headers, String json) throws BasePayException {
        return HttpClientUtils.httpPost(url, headers, null, false, json, true, null, null);
    }

    public static String httpPostFile(String url, Map<String, String> headers, Map<String, Object> params, File file, String fileParam) throws BasePayException {
        return HttpClientUtils.httpPost(url, headers, params, false, null, false, file, fileParam);
    }

    public static String httpPostNoFile(String url, Map<String, String> headers, Map<String, Object> params, File file, String fileParam) throws BasePayException {
        HttpPost httpPost = new HttpPost(url);
        if (null != headers) {
            if (BasePay.debug) {
                System.out.println("request headers=" + JSON.toJSONString(headers));
                System.out.println("request url = " + url);
                System.out.println("request param = " + null);
            }
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(Charset.forName("UTF-8"));
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            builder.addTextBody(entry.getKey(), entry.getValue().toString(), ContentType.APPLICATION_FORM_URLENCODED.withCharset("utf-8"));
        }
        httpPost.setEntity(builder.build());
        return HttpClientUtils.getResult((HttpRequestBase)httpPost, url, false);
    }

    public static String httpPost(String url, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout, String json, boolean isJson) throws BasePayException {
        return HttpClientUtils.httpPost(url, null, params, false, json, isJson, null, null);
    }

    public static String httpPost(String url, Map<String, String> headers, Map<String, Object> params, boolean isStream, String json, boolean isJson, File file, String fileParam) throws BasePayException {
        HttpPost httpPost = new HttpPost(url);
        if (null != headers) {
            if (BasePay.debug) {
                System.out.println("request headers=" + JSON.toJSONString(headers));
                System.out.println("request url = " + url);
                System.out.println("request param = " + json);
            }
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (file != null) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName("UTF-8"));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart(fileParam, (ContentBody)new FileBody(file));
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                builder.addTextBody(entry.getKey(), entry.getValue().toString(), ContentType.APPLICATION_FORM_URLENCODED.withCharset("utf-8"));
            }
            httpPost.setEntity(builder.build());
        }
        if (file == null && null != params) {
            try {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpClientUtils.covertParams2NVPS(params), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                if (BasePay.debug) {
                    e.printStackTrace();
                }
                throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
            }
        }
        if (isJson && json != null && json.length() != 0) {
            StringEntity entity = new StringEntity(json, "UTF-8");
            entity.setContentEncoding("UTF-8");
            entity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)entity);
        }
        return HttpClientUtils.getResult((HttpRequestBase)httpPost, url, isStream);
    }

    public static String httpGet(String url, Map<String, Object> params) throws BasePayException {
        return HttpClientUtils.httpGet(url, null, params, 10000, 30000, 30000, false);
    }

    public static String httpGet(String url, Map<String, String> headers, Map<String, Object> params) throws BasePayException {
        return HttpClientUtils.httpGet(url, headers, params, 10000, 30000, 30000, false);
    }

    public static String httpGet(String url, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout) throws BasePayException {
        return HttpClientUtils.httpGet(url, null, params, connectionRequestTimeout, connectTimeout, socketTimeout, false);
    }

    public static String httpGet(String url, Map<String, String> headers, Map<String, Object> params, int connectionRequestTimeout, int connectTimeout, int socketTimeout, boolean isStream) throws BasePayException {
        HttpGet httpGet;
        URIBuilder uriBuilder;
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            if (BasePay.debug) {
                e.printStackTrace();
            }
            throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
        }
        if (null != params) {
            uriBuilder.setParameters(HttpClientUtils.covertParams2NVPS(params));
        }
        try {
            httpGet = new HttpGet(uriBuilder.build());
        }
        catch (Exception e) {
            if (BasePay.debug) {
                e.printStackTrace();
            }
            throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
        }
        if (null != headers) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpGet.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return HttpClientUtils.getResult((HttpRequestBase)httpGet, url, isStream);
    }

    private static String getResult(HttpRequestBase httpRequest, String url, boolean isStream) throws BasePayException {
        StringBuilder sb = new StringBuilder();
        CloseableHttpResponse response = null;
        BufferedReader br = null;
        CloseableHttpClient httpClient = null;
        try {
            if (!BasePay.userDefaultCloseableHttpClient) {
                httpClient = HttpClientUtils.getHttpClient(url);
            } else {
                httpClient = HttpClients.createDefault();
                MerConfig merConfig = BasePay.getConfig("default");
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Integer.parseInt(Optional.ofNullable(merConfig).map(MerConfig::getCustomConnectTimeout).orElse("30000"))).setSocketTimeout(Integer.parseInt(Optional.ofNullable(merConfig).map(MerConfig::getCustomSocketTimeout).orElse("30000"))).setConnectionRequestTimeout(Integer.parseInt(Optional.ofNullable(merConfig).map(MerConfig::getCustomConnectionRequestTimeout).orElse("30000"))).build();
                httpRequest.setConfig(requestConfig);
            }
            response = httpClient.execute((HttpUriRequest)httpRequest);
            int respCode = response.getStatusLine().getStatusCode();
            if (BasePay.debug) {
                System.out.println("response code = " + respCode);
            }
            if (200 == respCode) {
                HttpEntity entity = response.getEntity();
                if (isStream) {
                    String len;
                    br = new BufferedReader(new InputStreamReader(entity.getContent(), "UTF-8"));
                    while ((len = br.readLine()) != null) {
                        sb.append(len);
                    }
                } else {
                    sb.append(EntityUtils.toString((HttpEntity)entity, (String)"UTF-8"));
                }
            } else {
                sb.append(response.getEntity() == null ? "" : EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            }
            String string = sb.toString();
            return string;
        }
        catch (SocketTimeoutException | ConnectTimeoutException e) {
            if (BasePay.debug) {
                e.printStackTrace();
            }
            if (e instanceof SocketTimeoutException) {
                throw new BasePayException(FailureCode.SOCKET_TIME_EXCEPTION.getFailureCode(), "post request  fail, socket timeout exception.");
            }
            throw new BasePayException(FailureCode.CONNECT_EXCEPTION.getFailureCode(), "post request fail, connection timeout.");
        }
        catch (IOException | UnsupportedOperationException | ParseException e) {
            if (BasePay.debug) {
                e.printStackTrace();
            }
            throw new BasePayException(FailureCode.SYSTEM_EXCEPTION, e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    if (BasePay.debug) {
                        e.printStackTrace();
                    }
                    throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
                }
            }
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    if (BasePay.debug) {
                        e.printStackTrace();
                    }
                    throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
                }
            }
            if (BasePay.userDefaultCloseableHttpClient && null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException ioe) {
                    if (BasePay.debug) {
                        ioe.printStackTrace();
                    }
                    throw new BasePayException(FailureCode.SYSTEM_EXCEPTION);
                }
            }
        }
    }

    private static List<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        LinkedList<NameValuePair> paramList = new LinkedList<NameValuePair>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), null == entry.getValue() ? "" : entry.getValue().toString()));
        }
        return paramList;
    }

    static {
        connectionRequestTimeout = 30000;
        socketTimeout = 20000;
        connectTimout = 20000;
        lock = new ReentrantLock();
    }
}

