/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.impl.BaseWxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaStableAccessTokenRequest;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import java.io.IOException;
import java.util.Objects;
import me.chanjar.weixin.common.util.http.HttpType;
import me.chanjar.weixin.common.util.http.okhttp.DefaultOkHttpClientBuilder;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang3.StringUtils;

public class WxMaServiceOkHttpImpl
extends BaseWxMaServiceImpl<OkHttpClient, OkHttpProxyInfo> {
    private OkHttpClient httpClient;
    private OkHttpProxyInfo httpProxy;

    @Override
    public void initHttp() {
        WxMaConfig wxMpConfigStorage = this.getWxMaConfig();
        if (wxMpConfigStorage.getHttpProxyHost() != null && wxMpConfigStorage.getHttpProxyPort() > 0) {
            this.httpProxy = OkHttpProxyInfo.httpProxy((String)wxMpConfigStorage.getHttpProxyHost(), (int)wxMpConfigStorage.getHttpProxyPort(), (String)wxMpConfigStorage.getHttpProxyUsername(), (String)wxMpConfigStorage.getHttpProxyPassword());
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            clientBuilder.proxy(this.getRequestHttpProxy().getProxy());
            clientBuilder.authenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)WxMaServiceOkHttpImpl.this.httpProxy.getProxyUsername(), (String)WxMaServiceOkHttpImpl.this.httpProxy.getProxyPassword());
                    return response.request().newBuilder().header("Authorization", credential).build();
                }
            });
            this.httpClient = clientBuilder.build();
        } else {
            this.httpClient = DefaultOkHttpClientBuilder.get().build();
        }
    }

    public OkHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public OkHttpProxyInfo getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpType getRequestType() {
        return HttpType.OK_HTTP;
    }

    @Override
    protected String doGetAccessTokenRequest() throws IOException {
        String url = StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getAccessTokenUrl()) ? this.getWxMaConfig().getAccessTokenUrl() : (StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getApiHostUrl()) ? "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s".replace("https://api.weixin.qq.com", this.getWxMaConfig().getApiHostUrl()) : "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s");
        url = String.format(url, this.getWxMaConfig().getAppid(), this.getWxMaConfig().getSecret());
        Request request = new Request.Builder().url(url).get().build();
        try (Response response = this.getRequestHttpClient().newCall(request).execute();){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }

    @Override
    protected String doGetStableAccessTokenRequest(boolean forceRefresh) throws IOException {
        String url = StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getAccessTokenUrl()) ? this.getWxMaConfig().getAccessTokenUrl() : (StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getApiHostUrl()) ? "https://api.weixin.qq.com/cgi-bin/stable_token".replace("https://api.weixin.qq.com", this.getWxMaConfig().getApiHostUrl()) : "https://api.weixin.qq.com/cgi-bin/stable_token");
        WxMaStableAccessTokenRequest wxMaAccessTokenRequest = new WxMaStableAccessTokenRequest();
        wxMaAccessTokenRequest.setAppid(this.getWxMaConfig().getAppid());
        wxMaAccessTokenRequest.setSecret(this.getWxMaConfig().getSecret());
        wxMaAccessTokenRequest.setGrantType("client_credential");
        wxMaAccessTokenRequest.setForceRefresh(forceRefresh);
        RequestBody body = RequestBody.Companion.create(wxMaAccessTokenRequest.toJson(), MediaType.parse((String)"application/json; charset=utf-8"));
        Request request = new Request.Builder().url(url).post(body).build();
        try (Response response = this.getRequestHttpClient().newCall(request).execute();){
            String string = Objects.requireNonNull(response.body()).string();
            return string;
        }
    }
}

