/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.api;

import com.alibaba.cloud.ai.dashscope.api.ApiUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.model.ApiKey;
import org.springframework.ai.model.SimpleApiKey;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

public class DashScopeImageApi {
    private final String baseUrl;
    private final ApiKey apiKey;
    public static final String DEFAULT_IMAGE_MODEL = ImageModel.WANX_V1.getValue();
    private final RestClient restClient;
    private final ResponseErrorHandler responseErrorHandler;

    public Builder mutate() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public DashScopeImageApi(String baseUrl, ApiKey apiKey, String workSpaceId, RestClient.Builder restClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.responseErrorHandler = responseErrorHandler;
        Assert.notNull((Object)apiKey, (String)"ApiKey must not be null");
        Assert.notNull((Object)baseUrl, (String)"Base URL must not be null");
        Assert.notNull((Object)restClientBuilder, (String)"RestClientBuilder must not be null");
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(ApiUtils.getJsonContentHeaders(apiKey.getValue(), workSpaceId)).defaultStatusHandler(responseErrorHandler).build();
    }

    public ResponseEntity<DashScopeImageAsyncResponse> submitImageGenTask(DashScopeImageRequest request) {
        String baseUrl = "/api/v1/services/aigc/";
        String model = request.model();
        String endpoint = model.equals(ImageModel.WANX2_1_IMAGE_EDIT.getValue()) || model.equals(ImageModel.WANX_X_PAINTING.getValue()) || model.equals(ImageModel.WANX_SKETCH_TO_IMAGE_LITE.getValue()) || model.equals(ImageModel.IMAGE_OUT_PAINTING.getValue()) ? "image2image" : "text2image";
        String url = baseUrl + endpoint + "/image-synthesis";
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(url, new Object[0])).header("X-DashScope-Async", new String[]{"enable"})).body((Object)request).retrieve().toEntity(DashScopeImageAsyncResponse.class);
    }

    public ResponseEntity<DashScopeImageAsyncResponse> getImageGenTaskResult(String taskId) {
        return this.restClient.get().uri("/api/v1/tasks/{task_id}", new Object[]{taskId}).retrieve().toEntity(DashScopeImageAsyncResponse.class);
    }

    String getBaseUrl() {
        return this.baseUrl;
    }

    ApiKey getApiKey() {
        return this.apiKey;
    }

    RestClient getRestClient() {
        return this.restClient;
    }

    ResponseErrorHandler getResponseErrorHandler() {
        return this.responseErrorHandler;
    }

    public static class Builder {
        private String baseUrl = "https://dashscope.aliyuncs.com";
        private ApiKey apiKey;
        private String workSpaceId;
        private RestClient.Builder restClientBuilder = RestClient.builder();
        private ResponseErrorHandler responseErrorHandler = RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER;

        public Builder() {
        }

        public Builder(DashScopeImageApi api) {
            this.baseUrl = api.getBaseUrl();
            this.apiKey = api.getApiKey();
            this.restClientBuilder = api.restClient != null ? api.restClient.mutate() : RestClient.builder();
            this.responseErrorHandler = api.getResponseErrorHandler();
        }

        public Builder baseUrl(String baseUrl) {
            Assert.notNull((Object)baseUrl, (String)"Base URL cannot be null");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder workSpaceId(String workSpaceId) {
            if (StringUtils.hasText((String)workSpaceId)) {
                Assert.notNull((Object)workSpaceId, (String)"Workspace ID cannot be null");
            }
            this.workSpaceId = workSpaceId;
            return this;
        }

        public Builder apiKey(String simpleApiKey) {
            Assert.notNull((Object)simpleApiKey, (String)"Simple api key cannot be null");
            this.apiKey = new SimpleApiKey(simpleApiKey);
            return this;
        }

        public Builder restClientBuilder(RestClient.Builder restClientBuilder) {
            Assert.notNull((Object)restClientBuilder, (String)"Rest client builder cannot be null");
            this.restClientBuilder = restClientBuilder;
            return this;
        }

        public Builder responseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            Assert.notNull((Object)responseErrorHandler, (String)"Response error handler cannot be null");
            this.responseErrorHandler = responseErrorHandler;
            return this;
        }

        public DashScopeImageApi build() {
            Assert.notNull((Object)this.apiKey, (String)"API key cannot be null");
            return new DashScopeImageApi(this.baseUrl, this.apiKey, this.workSpaceId, this.restClientBuilder, this.responseErrorHandler);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DashScopeImageRequest(@JsonProperty(value="model") String model, @JsonProperty(value="input") DashScopeImageRequestInput input, @JsonProperty(value="parameters") DashScopeImageRequestParameter parameters) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageRequestInput(@JsonProperty(value="prompt") String prompt, @JsonProperty(value="negative_prompt") String negativePrompt, @JsonProperty(value="ref_img") String refImg, @JsonProperty(value="function") String function, @JsonProperty(value="base_image_url") String baseImageUrl, @JsonProperty(value="mask_image_url") String maskImageUrl, @JsonProperty(value="sketch_image_url") String sketchImageUrl) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageRequestParameter(@JsonProperty(value="style") String style, @JsonProperty(value="size") String size, @JsonProperty(value="n") Integer n, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="ref_strength") Float refStrength, @JsonProperty(value="ref_mode") String refMode, @JsonProperty(value="prompt_extend") Boolean promptExtend, @JsonProperty(value="watermark") Boolean watermark, @JsonProperty(value="sketch_weight") Integer sketchWeight, @JsonProperty(value="sketch_extraction") Boolean sketchExtraction, @JsonProperty(value="sketch_color") Integer[][] sketchColor, @JsonProperty(value="mask_color") Integer[][] maskColor) {
        }
    }

    public static enum ImageModel {
        WANX_V1("wanx-v1"),
        WANX2_1_T2I_TURBO("wanx2.1-t2i-turbo"),
        WANX2_1_T2I_PLUS("wanx2.1-t2i-plus"),
        WANX2_0_T2I_TURBO("wanx2.0-t2i-turbo"),
        WANX2_1_IMAGE_EDIT("wanx2.1-imageedit"),
        WANX_SKETCH_TO_IMAGE_LITE("wanx-sketch-to-image-lite"),
        WANX_X_PAINTING("wanx-x-painting"),
        IMAGE_OUT_PAINTING("image-out-painting");

        public final String value;

        private ImageModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record DashScopeImageAsyncResponse(@JsonProperty(value="request_id") String requestId, @JsonProperty(value="output") DashScopeImageAsyncResponseOutput output, @JsonProperty(value="usage") DashScopeImageAsyncResponseUsage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncResponseOutput(@JsonProperty(value="task_id") String taskId, @JsonProperty(value="task_status") String taskStatus, @JsonProperty(value="results") List<DashScopeImageAsyncResponseResult> results, @JsonProperty(value="task_metrics") DashScopeImageAsyncResponseTaskMetrics taskMetrics, @JsonProperty(value="code") String code, @JsonProperty(value="message") String message) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncResponseUsage(@JsonProperty(value="image_count") Integer imageCount) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncResponseResult(@JsonProperty(value="url") String url) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record DashScopeImageAsyncResponseTaskMetrics(@JsonProperty(value="TOTAL") Integer total, @JsonProperty(value="SUCCEEDED") Integer SUCCEEDED, @JsonProperty(value="FAILED") Integer FAILED) {
        }
    }
}

