/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.message;

import com.agentsflex.core.llm.functions.Function;
import com.agentsflex.core.llm.functions.JavaNativeFunctions;
import com.agentsflex.core.message.AbstractTextMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HumanMessage
extends AbstractTextMessage {
    private List<Function> functions;
    private String toolChoice;

    public HumanMessage() {
    }

    public HumanMessage(String content) {
        this.setContent(content);
    }

    public void addFunction(Function function) {
        if (this.functions == null) {
            this.functions = new ArrayList<Function>();
        }
        this.functions.add(function);
    }

    public void addFunctions(Collection<Function> functions) {
        if (this.functions == null) {
            this.functions = new ArrayList<Function>();
        }
        this.functions.addAll(functions);
    }

    public void addFunctions(Class<?> funcClass, String ... methodNames) {
        if (this.functions == null) {
            this.functions = new ArrayList<Function>();
        }
        this.functions.addAll(JavaNativeFunctions.from(funcClass, methodNames));
    }

    public void addFunctions(Object funcObject, String ... methodNames) {
        if (this.functions == null) {
            this.functions = new ArrayList<Function>();
        }
        this.functions.addAll(JavaNativeFunctions.from(funcObject, methodNames));
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public Map<String, Function> getFunctionMap() {
        if (this.functions == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Function> map = new HashMap<String, Function>(this.functions.size());
        for (Function function : this.functions) {
            map.put(function.getName(), function);
        }
        return map;
    }

    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    public String getToolChoice() {
        return this.toolChoice;
    }

    public void setToolChoice(String toolChoice) {
        this.toolChoice = toolChoice;
    }
}

