/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuiee.menu.pptmanage;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.file.cloudfile.LPCloudFileModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseUIConstant;
import com.baijiayun.liveuibase.utils.ExtensionKt;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareContract;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareFragment;
import com.baijiayun.liveuibase.widgets.courseware.ICourseWareViewListener;
import com.baijiayun.liveuibase.widgets.courseware.models.TabState;
import com.baijiayun.liveuiee.R;
import java.util.List;

public abstract class LiveEECourseWareFragment
extends BaseCourseWareFragment {
    private CloudTitleChangeListener cloudTitleChangeListener;

    protected LiveEECourseWareFragment() {
        this.defaultPickImageOrientation = 1;
    }

    protected void initTabsAndDirTextView() {
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container2, @Nullable Bundle savedInstanceState) {
        this.context = this.getContext();
        this.contentView = LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_ee_courseware_content_list, container2, false);
        this.presenter = this.initPresenter();
        this.initChildData();
        this.initViewId();
        this.courseWareViewListener = this.initCourseWareViewListener();
        this.contentView.setOnTouchListener((View.OnTouchListener)this);
        this.contentView.setBackground(ThemeDataUtil.getCommonWindowBg((Context)this.context));
        this.initCoursewareContainer();
        this.updateAllowUpdateHomework(true);
        this.contentView.findViewById(R.id.window_course_ware_enable_student_upload_tv).setOnClickListener(v -> this.cbEnableStudentUpload.performClick());
        this.cbEnableStudentUpload.setOnClickListener(v -> this.courseWareViewListener.onUpdateAllowUploadHomework(this.cbEnableStudentUpload.isChecked()));
        this.etSearcher.setOnEditorActionListener((v, actionId, event) -> {
            this.clearEditFocus((View)this.etSearcher);
            return true;
        });
        this.contentView.findViewById(R.id.window_course_ware_search_clear).setOnClickListener(v -> {
            this.clearEditFocus((View)this.etSearcher);
            this.etSearcher.setText((CharSequence)"");
        });
        this.contentView.findViewById(R.id.window_course_ware_cloud_more_iv).setOnClickListener(v -> this.showMoreMenuPopupWindow());
        this.updateTabView(this.tabState);
        this.showAsUserType();
        return this.contentView;
    }

    private void showAsUserType() {
        if (!this.isTeacherOrAssistant()) {
            this.updateTabView(TabState.HomeworkFile);
            this.setVisibility(R.id.window_course_ware_homework_stu_permission_container, false);
            this.setVisibility(R.id.window_course_ware_search_container, false);
        }
    }

    protected void updateUploadText() {
    }

    protected void updateTabSelected() {
    }

    protected void updateHomeworkHintVisibility() {
        this.setVisibility(R.id.window_course_ware_homework_stu_permission_container, this.tabState == TabState.HomeworkFile);
    }

    protected void updateFinderRecordView() {
        boolean hideFinderRecordView = this.tabState != TabState.CloudFile || this.dirRecordList.size() == 0;
        this.setVisibility(R.id.window_course_ware_cloud_more_iv, hideFinderRecordView);
    }

    protected abstract void initChildData();

    protected abstract ICourseWareViewListener initCourseWareViewListener();

    protected abstract BaseCourseWareContract.BaseCourseWarePresenter initPresenter();

    protected abstract LiveRoom getLiveRoom();

    public void updateAllowUpdateHomework(boolean isAllow) {
        this.cbEnableStudentUpload.setChecked(isAllow);
        if (!this.isTeacherOrAssistant()) {
            int visibility = isAllow ? 0 : 8;
            this.contentView.findViewById(R.id.window_course_ware_doc_operate_container).setVisibility(visibility);
        }
    }

    public void updateCloudDirRecord(List<LPCloudFileModel> dirRecordModels) {
        this.dirRecordList = dirRecordModels;
        this.updateFinderRecordView();
        if (this.tabState != TabState.CloudFile) {
            return;
        }
        if (dirRecordModels.isEmpty()) {
            this.cloudTitleChangeListener.changeTitle(null, true);
            return;
        }
        this.cloudTitleChangeListener.changeTitle(dirRecordModels.get(dirRecordModels.size() - 1).getName(), false);
    }

    public void back2ParentDir() {
        if (this.tabState != TabState.CloudFile) {
            return;
        }
        if (this.dirRecordList.isEmpty()) {
            return;
        }
        if (this.dirRecordList.size() == 1) {
            this.getLiveRoom().getCloudFileVM().requestCloudFileAll();
        }
        this.getLiveRoom().getCloudFileVM().requestBackDirRecord(this.dirRecordList.size() - 2);
    }

    protected void showMoreMenuPopupWindow() {
        View view = View.inflate((Context)this.context, (int)R.layout.bjy_ee_popup_window_cloud_create_layout, null);
        view.setBackground(ThemeDataUtil.getPopWindowBg((Context)this.context));
        ((TextView)view.findViewById(R.id.window_course_ware_upload_name)).setText(this.tabState == TabState.HomeworkFile ? R.string.base_course_manage_upload_homework_file : R.string.base_course_manage_upload_file);
        PopupWindow createPopupWindow = new PopupWindow(view);
        view.findViewById(R.id.window_course_ware_upload).setOnClickListener(v -> {
            createPopupWindow.dismiss();
            if (this.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant && !this.getLiveRoom().getAdminAuth().documentUpload) {
                this.showToast(this.getString(R.string.base_ui_forbid_upload_ppt));
                return;
            }
            if (this.tabState == TabState.HomeworkFile) {
                ExtensionKt.openSystemFileManager((Fragment)this, (int)BaseUIConstant.UploadType.HomeWork.getValue(), (boolean)false);
            } else {
                this.showUploadDialog();
            }
        });
        view.findViewById(R.id.window_course_ware_upload_image).setOnClickListener(v -> {
            createPopupWindow.dismiss();
            this.doUploadImage();
        });
        createPopupWindow.setWidth(UtilsKt.getDp((int)150));
        createPopupWindow.setHeight(-2);
        createPopupWindow.setFocusable(true);
        createPopupWindow.showAsDropDown(this.contentView.findViewById(R.id.window_course_ware_cloud_more_iv));
        createPopupWindow.update();
    }

    public void setCloudTitleChangeListener(CloudTitleChangeListener cloudTitleChangeListener) {
        this.cloudTitleChangeListener = cloudTitleChangeListener;
    }

    static interface CloudTitleChangeListener {
        public void changeTitle(String var1, boolean var2);
    }
}

