/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.view.clearscreen;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.baijiayun.liveshow.ui.R;
import com.baijiayun.liveshow.ui.view.clearscreen.ClearScreenUtils;
import com.baijiayun.liveshow.ui.view.clearscreen.ViewDragHelper;
import java.util.ArrayList;
import java.util.List;

public class ClearScreenLayout
extends ViewGroup {
    private final ViewDragHelper mViewDragHelper;
    private List<DragListener> mListeners;
    private int mDragState;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private float mLastMotionX;
    private float mLastMotionY;
    private int mTouchSlop;
    private int mActivePointerId = -1;
    private boolean enableDrag = true;
    private static final float RIGHT_RANG_SIZE = 0.2f;
    private static final float LEFT_RANG_SIZE = 0.8f;
    private static final int INVALID_POINTER = -1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;

    public ClearScreenLayout(Context context) {
        this(context, null);
    }

    public ClearScreenLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClearScreenLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ClearScreenLayout);
        float sensitivity = a.getFloat(R.styleable.ClearScreenLayout_touch_slop_sensitivity, 2.0f);
        a.recycle();
        int edgeSize = ClearScreenUtils.getScreenWidth(context);
        ViewDragCallback viewDragCallback = new ViewDragCallback();
        this.mViewDragHelper = ViewDragHelper.create(this, sensitivity, edgeSize, viewDragCallback);
        this.mViewDragHelper.setEdgeTrackingEnabled(2);
        this.mTouchSlop = this.mViewDragHelper.getTouchSlop();
        viewDragCallback.setDragger(this.mViewDragHelper);
    }

    public void addDragListener(@NonNull DragListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mListeners == null) {
            this.mListeners = new ArrayList<DragListener>();
        }
        this.mListeners.add(listener);
    }

    public void removeDragListener(@NonNull DragListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    public void open() {
        View draggerChild = this.findDraggerChild();
        if (!this.isSlideOut(draggerChild)) {
            return;
        }
        this.mViewDragHelper.smoothSlideViewTo(draggerChild, this.getWidth() - draggerChild.getWidth(), draggerChild.getTop());
        this.invalidate();
    }

    public void close() {
        View draggerChild = this.findDraggerChild();
        if (this.isSlideOut(draggerChild)) {
            return;
        }
        this.mViewDragHelper.smoothSlideViewTo(draggerChild, this.getWidth(), draggerChild.getTop());
        this.invalidate();
    }

    public boolean isOpen() {
        View draggerChild = this.findDraggerChild();
        return this.isSlideOut(draggerChild);
    }

    public void enableDrag(boolean enableDrag) {
        this.enableDrag = enableDrag;
    }

    void setDragViewOffset(View dragView, float slideOffset) {
        LayoutParams lp = (LayoutParams)dragView.getLayoutParams();
        if (slideOffset == lp.onScreen) {
            return;
        }
        lp.onScreen = slideOffset;
        this.dispatchOnDragging(dragView, slideOffset);
    }

    float getDragViewOffset(View drawerView) {
        LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
        return lp.onScreen;
    }

    public void updateDragState(int activeState, View activeView) {
        int rightState = this.mViewDragHelper.getViewDragState();
        int state = rightState == 1 ? 1 : (rightState == 2 ? 2 : 0);
        if (activeView != null && activeState == 0) {
            LayoutParams lp = (LayoutParams)activeView.getLayoutParams();
            if (lp.onScreen == 0.0f) {
                this.dispatchDragToOutState(activeView);
            } else if (lp.onScreen == 1.0f) {
                this.dispatchDragToInState(activeView);
            }
        }
        if (state != this.mDragState) {
            this.mDragState = state;
            if (this.mListeners != null) {
                int listenerCount = this.mListeners.size();
                for (int i = listenerCount - 1; i >= 0; --i) {
                    this.mListeners.get(i).onDragStateChanged(state);
                }
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == Integer.MIN_VALUE) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)0x40000000);
        }
        if (heightMode == Integer.MIN_VALUE) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)0x40000000);
        }
        this.setMeasuredDimension(ClearScreenLayout.getDefaultSize((int)0, (int)widthMeasureSpec), ClearScreenLayout.getDefaultSize((int)0, (int)heightMeasureSpec));
        boolean hasDraggerView = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.isDrag && hasDraggerView) {
                throw new IllegalStateException("\u6682\u4e0d\u652f\u6301\u6dfb\u52a0\u591a\u4e2a\u53ef\u62d6\u52a8\u7684child");
            }
            hasDraggerView = lp.isDrag;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = r - l;
        for (int i = 0; i < this.getChildCount(); ++i) {
            boolean changeOffset;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (this.isContentView(child)) {
                child.layout(lp.leftMargin, lp.topMargin, lp.leftMargin + child.getMeasuredWidth(), lp.topMargin + child.getMeasuredHeight());
                continue;
            }
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childLeft = width - (int)((float)childWidth * lp.onScreen);
            float newOffset = (float)(width - childLeft) / (float)childWidth;
            child.layout(childLeft, lp.topMargin, childLeft + childWidth, lp.topMargin + childHeight);
            boolean bl = changeOffset = newOffset != lp.onScreen;
            if (!changeOffset) continue;
            this.setDragViewOffset(child, newOffset);
        }
    }

    public void computeScroll() {
        if (this.mViewDragHelper != null && this.mViewDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.enableDrag) {
            return super.onInterceptTouchEvent(ev);
        }
        int action = ev.getActionMasked();
        boolean interceptTouchEvent = this.mViewDragHelper.shouldInterceptTouchEvent(ev);
        switch (action) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                break;
            }
            case 2: {
                int pointerIndex;
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1 || (pointerIndex = ev.findPointerIndex(activePointerId)) == -1) break;
                float x = ev.getX(pointerIndex);
                float dx = x - this.mLastMotionX;
                float xDiff = Math.abs(dx);
                float y = ev.getY(pointerIndex);
                float yDiff = Math.abs(y - this.mInitialMotionY);
                if (!(xDiff > (float)this.mTouchSlop) || !(xDiff * 0.5f > yDiff)) break;
                this.requestParentDisallowInterceptTouchEvent(true);
                this.mLastMotionX = dx > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                this.mLastMotionY = y;
                break;
            }
        }
        return interceptTouchEvent;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.enableDrag) {
            return super.onTouchEvent(ev);
        }
        if (this.mDragState == 2) {
            return false;
        }
        this.mViewDragHelper.processTouchEvent(ev);
        switch (ev.getAction()) {
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                break;
            }
            case 2: {
                float x = ev.getX();
                float xDiff = Math.abs(x - this.mLastMotionX);
                float y = ev.getY();
                float yDiff = Math.abs(y - this.mLastMotionY);
                if (!(xDiff > (float)this.mTouchSlop) || !(xDiff > yDiff)) break;
                this.requestParentDisallowInterceptTouchEvent(true);
                this.mLastMotionX = x - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                this.mLastMotionY = y;
            }
        }
        return true;
    }

    private void requestParentDisallowInterceptTouchEvent(boolean disallowIntercept) {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams ? new LayoutParams((LayoutParams)p) : (p instanceof ViewGroup.MarginLayoutParams ? new LayoutParams((ViewGroup.MarginLayoutParams)p) : new LayoutParams(p));
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    View findDraggerChild() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!((LayoutParams)child.getLayoutParams()).isDrag) continue;
            return child;
        }
        return null;
    }

    void dispatchDragToOutState(View dragView) {
        ((LayoutParams)dragView.getLayoutParams()).isSlideOut = true;
        if (this.mListeners != null) {
            int listenerCount = this.mListeners.size();
            for (int i = listenerCount - 1; i >= 0; --i) {
                this.mListeners.get(i).onDragToOut(dragView);
            }
        }
    }

    void dispatchDragToInState(View dragView) {
        ((LayoutParams)dragView.getLayoutParams()).isSlideOut = false;
        if (this.mListeners != null) {
            int listenerCount = this.mListeners.size();
            for (int i = listenerCount - 1; i >= 0; --i) {
                this.mListeners.get(i).onDragToIn(dragView);
            }
        }
    }

    void dispatchOnDragging(View dragView, float slideOffset) {
        if (this.mListeners != null) {
            int listenerCount = this.mListeners.size();
            for (int i = listenerCount - 1; i >= 0; --i) {
                this.mListeners.get(i).onDragging(dragView, slideOffset);
            }
        }
    }

    boolean isContentView(View child) {
        return !((LayoutParams)child.getLayoutParams()).isDrag;
    }

    boolean isSlideOut(View dragView) {
        return ((LayoutParams)dragView.getLayoutParams()).isSlideOut;
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private ViewDragHelper mDragger;

        private ViewDragCallback() {
        }

        public void setDragger(ViewDragHelper dragger) {
            this.mDragger = dragger;
        }

        @Override
        public boolean tryCaptureView(@NonNull View child, int pointerId) {
            LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
            return layoutParams.isDrag && ClearScreenLayout.this.mDragState != 2;
        }

        @Override
        public void onViewReleased(@NonNull View releasedChild, float xvel, float yvel) {
            int width = ClearScreenLayout.this.getWidth();
            int childWidth = releasedChild.getWidth();
            float offset = ClearScreenLayout.this.getDragViewOffset(releasedChild);
            float v = ClearScreenLayout.this.isSlideOut(releasedChild) ? 0.2f : 0.8f;
            int left = xvel < 0.0f || xvel == 0.0f && offset > v ? width - childWidth : width;
            this.mDragger.settleCapturedViewAt(left, releasedChild.getTop());
            ClearScreenLayout.this.invalidate();
        }

        @Override
        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            int width = ClearScreenLayout.this.getWidth();
            return Math.max(width - child.getWidth(), Math.min(left, width));
        }

        @Override
        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            return child.getTop();
        }

        @Override
        public int getViewHorizontalDragRange(@NonNull View child) {
            return !ClearScreenLayout.this.isContentView(child) ? child.getWidth() : 0;
        }

        @Override
        public void onEdgeDragStarted(int edgeFlags, int pointerId) {
            super.onEdgeDragStarted(edgeFlags, pointerId);
            if (edgeFlags == 2) {
                View child = ClearScreenLayout.this.findDraggerChild();
                this.mDragger.captureChildView(child, pointerId);
            }
        }

        @Override
        public void onViewPositionChanged(@NonNull View changedView, int left, int top, int dx, int dy) {
            int childWidth = changedView.getWidth();
            int width = ClearScreenLayout.this.getWidth();
            float offset = (float)(width - left) / (float)childWidth;
            if (offset >= 0.0f) {
                ClearScreenLayout.this.setDragViewOffset(changedView, offset);
            }
        }

        @Override
        public void onViewDragStateChanged(int state) {
            ClearScreenLayout.this.updateDragState(state, this.mDragger.getCapturedView());
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public boolean isDrag;
        public boolean isSlideOut;
        public float onScreen = 1.0f;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = null;
            try {
                a = c.obtainStyledAttributes(attrs, R.styleable.ClearScreenLayout_Layout);
                this.isDrag = a.getBoolean(R.styleable.ClearScreenLayout_Layout_layout_dragEnable, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (a != null) {
                    a.recycle();
                }
            }
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(@NonNull ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }

    public static interface DragListener {
        public void onDragging(@NonNull View var1, float var2);

        public void onDragToOut(@NonNull View var1);

        public void onDragToIn(@NonNull View var1);

        public void onDragStateChanged(int var1);
    }
}

