/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui;

import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\t"}, d2={"getMediaUserCount", "", "liveRoom", "Lcom/baijiayun/livecore/context/LiveRoom;", "isPPTMode", "", "routerViewModel", "Lcom/baijiayun/liveuibase/viewmodel/RouterViewModel;", "playMixStreamWith3x3Mode", "liveplayer-sdk-live-show_release"})
public final class LiveShowUtilsKt {
    public static final boolean isPPTMode(@NotNull RouterViewModel routerViewModel2) {
        Intrinsics.checkNotNullParameter((Object)routerViewModel2, (String)"routerViewModel");
        return routerViewModel2.getLiveRoom().getLiveShowVM().getLiveShowType() == 2;
    }

    public static final int getMediaUserCount(@NotNull LiveRoom liveRoom2) {
        Intrinsics.checkNotNullParameter((Object)liveRoom2, (String)"liveRoom");
        Map activeUserMap = new LinkedHashMap();
        for (IMediaModel mediaModel : liveRoom2.getSpeakQueueVM().getActiveUserList()) {
            IUserModel iUserModel;
            String string2;
            if (!mediaModel.isVideoOn() && !liveRoom2.getSpeakQueueVM().isPresenterUser(mediaModel.getUser())) continue;
            Map map = activeUserMap;
            Intrinsics.checkNotNullExpressionValue((Object)mediaModel.getUser().getUserId(), (String)"mediaModel.user.userId");
            Intrinsics.checkNotNullExpressionValue((Object)mediaModel.getUser(), (String)"mediaModel.user");
            map.put(string2, iUserModel);
        }
        return activeUserMap.size();
    }

    public static final boolean playMixStreamWith3x3Mode(@NotNull LiveRoom liveRoom2) {
        Intrinsics.checkNotNullParameter((Object)liveRoom2, (String)"liveRoom");
        return liveRoom2.getSpeakQueueVM().isMixModeOn() && LiveShowUtilsKt.getMediaUserCount(liveRoom2) > 1 && Intrinsics.areEqual((Object)"3x3", (Object)liveRoom2.getSpeakQueueVM().getMixTemplate());
    }
}

