/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.wxapi;

import android.content.Context;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.liveshow.ui.R;
import com.baijiayun.liveshow.ui.wxapi.LoadingDialog;
import com.baijiayun.liveshow.ui.wxapi.SignModel;
import com.baijiayun.liveshow.ui.wxapi.WePayAPI;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelpay.PayReq;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.WXAPIFactory;

public class LiveShowWePayImpl
implements WePayAPI {
    private Context context;
    private IWXAPI iwxapi;
    private WePayAPI.ResultCallback callback;
    private LoadingDialog waitDialog;

    @Override
    public void startWePay(Context context, SignModel signModel) {
        this.context = context;
        if (this.iwxapi == null) {
            this.iwxapi = WXAPIFactory.createWXAPI((Context)context, null);
            this.iwxapi.registerApp(LiveSDK.WX_PAY_APP_ID);
            this.waitDialog = new LoadingDialog(context);
        }
        PayReq request = new PayReq();
        request.appId = signModel.appId;
        request.partnerId = signModel.mchId;
        request.prepayId = signModel.prepayId;
        request.packageValue = signModel.orderExtend;
        request.nonceStr = signModel.noncestr;
        request.timeStamp = signModel.timestamp;
        request.sign = signModel.sign;
        boolean result = this.iwxapi.sendReq((BaseReq)request);
        if (result) {
            this.waitDialog.setTips(context.getString(R.string.bjy_show_recharge_dialog_wait));
            this.waitDialog.show();
        } else {
            this.waitDialog.dismiss();
            String errorMsg = context.getString(R.string.bjy_show_recharge_wx_callup_unknown_error);
            if (!this.isWxAppInstalled()) {
                errorMsg = context.getString(R.string.bjy_show_recharge_not_install_wx);
            }
            if (!this.isWxApiSupported()) {
                errorMsg = context.getString(R.string.bjy_show_recharge_wx_version_not_support);
            }
            this.callback.notifyCheckOrderStatus(-1, errorMsg);
            this.unRegisterApp();
        }
    }

    @Override
    public void registerPayCallback(WePayAPI.ResultCallback callback) {
        this.callback = callback;
    }

    @Override
    public void notifyPaymentCallback(int errCode, String errString) {
        this.waitDialog.setTips(this.context.getString(R.string.bjy_show_recharge_dialog_result));
        this.waitDialog.dismiss();
        if (this.callback != null) {
            this.callback.notifyCheckOrderStatus(errCode, errString);
        }
    }

    boolean isWxAppInstalled() {
        return this.iwxapi.isWXAppInstalled();
    }

    boolean isWxApiSupported() {
        return this.iwxapi.getWXAppSupportAPI() >= 0x22000001;
    }

    @Override
    public void unRegisterApp() {
        this.iwxapi.unregisterApp();
        if (this.waitDialog != null) {
            this.waitDialog.dismiss();
        }
        this.callback = null;
    }
}

