/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.mainvideopanel;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class PlayerGestureListener
extends GestureDetector.SimpleOnGestureListener {
    private PlayerListener playerListener;
    private int touchSlop;

    public PlayerGestureListener(Context context) {
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public boolean onScroll(@Nullable MotionEvent e1, @NonNull MotionEvent e2, float distanceX, float distanceY) {
        float xDiff = e2.getX() - (e1 == null ? 0.0f : e1.getX());
        if (Math.abs(xDiff) > (float)this.touchSlop && this.playerListener != null) {
            this.playerListener.onScrollX((int)xDiff);
        }
        return true;
    }

    public boolean onSingleTapConfirmed(@NonNull MotionEvent e) {
        if (this.playerListener != null) {
            this.playerListener.onSingleTapConfirmed();
        }
        return super.onSingleTapUp(e);
    }

    public void setPlayerListener(PlayerListener playerStateListener) {
        this.playerListener = playerStateListener;
    }

    static interface PlayerListener {
        public void onScrollX(int var1);

        public void onSingleTapConfirmed();
    }
}

