/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.chat;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/baijiayun/liveshow/ui/chat/ChatItemDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "itemHeight", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "(FLandroidx/recyclerview/widget/RecyclerView;)V", "layerId", "", "linearGradient", "Landroid/graphics/LinearGradient;", "paint", "Landroid/graphics/Paint;", "getRecyclerView", "()Landroidx/recyclerview/widget/RecyclerView;", "xfermode", "Landroid/graphics/Xfermode;", "getItemOffsets", "", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onDraw", "c", "Landroid/graphics/Canvas;", "onDrawOver", "canvas", "liveplayer-sdk-live-show_release"})
public final class ChatItemDecoration
extends RecyclerView.ItemDecoration {
    private final float itemHeight;
    @NotNull
    private final RecyclerView recyclerView;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Xfermode xfermode;
    @NotNull
    private final LinearGradient linearGradient;
    private int layerId;

    public ChatItemDecoration(float itemHeight, @NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.itemHeight = itemHeight;
        this.recyclerView = recyclerView;
        this.paint = new Paint();
        this.xfermode = (Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
        int[] nArray = new int[]{0, -16777216};
        this.linearGradient = new LinearGradient(0.0f, 0.0f, 0.0f, this.itemHeight, nArray, null, Shader.TileMode.CLAMP);
    }

    @NotNull
    public final RecyclerView getRecyclerView() {
        return this.recyclerView;
    }

    public void onDrawOver(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onDrawOver(canvas, parent, state);
        this.paint.setXfermode(this.xfermode);
        this.paint.setShader((Shader)this.linearGradient);
        canvas.drawRect(0.0f, 0.0f, (float)parent.getRight(), this.itemHeight, this.paint);
        this.paint.setXfermode(null);
        canvas.restoreToCount(this.layerId);
    }

    public void onDraw(@NotNull Canvas c, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onDraw(c, parent, state);
        this.layerId = c.saveLayer(0.0f, 0.0f, (float)parent.getWidth(), (float)parent.getHeight(), this.paint, 31);
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.getItemOffsets(outRect, view, parent, state);
        outRect.bottom = UtilsKt.getDp((int)8);
    }
}

