/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.view;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import com.baijiayun.liveshow.ui.R;
import com.baijiayun.liveshow.ui.view.Config;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 -2\u00020\u0001:\u0003-./B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\tJ\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tJ\u001c\u0010(\u001a\u00020#2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u001c\u0010)\u001a\u00020\u001d2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010+\u001a\u00020\u001d2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010\u0012H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Lcom/baijiayun/liveshow/ui/view/CustomerIndicator;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mAnimatorIn", "Landroid/animation/Animator;", "mAnimatorOut", "mImmediateAnimatorIn", "mImmediateAnimatorOut", "mIndicatorBackgroundResId", "mIndicatorCreatedListener", "Lcom/baijiayun/liveshow/ui/view/CustomerIndicator$IndicatorCreatedListener;", "mIndicatorHeight", "mIndicatorMargin", "mIndicatorUnselectedBackgroundResId", "mIndicatorWidth", "mLastPosition", "getMLastPosition", "()I", "setMLastPosition", "(I)V", "addIndicator", "", "orientation", "animatePageSelected", "position", "createAnimatorIn", "config", "Lcom/baijiayun/liveshow/ui/view/Config;", "createAnimatorOut", "createIndicators", "count", "currentPosition", "handleTypedArray", "init", "initialize", "setIndicatorCreatedListener", "indicatorCreatedListener", "Companion", "IndicatorCreatedListener", "ReverseInterpolator", "liveplayer-sdk-live-show_release"})
public class CustomerIndicator
extends LinearLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mIndicatorMargin;
    private int mIndicatorWidth;
    private int mIndicatorHeight;
    private int mIndicatorBackgroundResId;
    private int mIndicatorUnselectedBackgroundResId;
    @Nullable
    private Animator mAnimatorOut;
    @Nullable
    private Animator mAnimatorIn;
    @Nullable
    private Animator mImmediateAnimatorOut;
    @Nullable
    private Animator mImmediateAnimatorIn;
    private int mLastPosition;
    @androidx.annotation.Nullable
    @Nullable
    private IndicatorCreatedListener mIndicatorCreatedListener;
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();
    private static final int DEFAULT_INDICATOR_WIDTH = 5;

    public final int getMLastPosition() {
        return this.mLastPosition;
    }

    public final void setMLastPosition(int n) {
        this.mLastPosition = n;
    }

    public CustomerIndicator(@Nullable Context context) {
        super(context);
        this.mIndicatorMargin = -1;
        this.mIndicatorWidth = -1;
        this.mIndicatorHeight = -1;
        this.mLastPosition = -1;
        this.init(context, null);
    }

    public CustomerIndicator(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mIndicatorMargin = -1;
        this.mIndicatorWidth = -1;
        this.mIndicatorHeight = -1;
        this.mLastPosition = -1;
        this.init(context, attrs);
    }

    public CustomerIndicator(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mIndicatorMargin = -1;
        this.mIndicatorWidth = -1;
        this.mIndicatorHeight = -1;
        this.mLastPosition = -1;
        this.init(context, attrs);
    }

    private final void init(Context context, AttributeSet attrs) {
        Config config = this.handleTypedArray(context, attrs);
        this.initialize(config);
        if (this.isInEditMode()) {
            this.createIndicators(3, 1);
        }
    }

    private final Config handleTypedArray(Context context, AttributeSet attrs) {
        Config config = new Config();
        if (attrs == null || context == null) {
            return config;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CustomerIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026leable.CustomerIndicator)");
        TypedArray typedArray2 = typedArray;
        config.setWidth(typedArray2.getDimensionPixelSize(R.styleable.CustomerIndicator_ci_width, -1));
        config.setHeight(typedArray2.getDimensionPixelSize(R.styleable.CustomerIndicator_ci_height, -1));
        config.setMargin(typedArray2.getDimensionPixelSize(R.styleable.CustomerIndicator_ci_margin, -1));
        config.setAnimatorResId(typedArray2.getResourceId(R.styleable.CustomerIndicator_ci_animator, R.animator.bjls_scale_with_alpha));
        config.setAnimatorReverseResId(typedArray2.getResourceId(R.styleable.CustomerIndicator_ci_animator_reverse, 0));
        config.setBackgroundResId(typedArray2.getResourceId(R.styleable.CustomerIndicator_ci_drawable, R.drawable.bjls_white_radius));
        config.setUnselectedBackgroundId(typedArray2.getResourceId(R.styleable.CustomerIndicator_ci_drawable_unselected, config.getBackgroundResId()));
        config.setOrientation(typedArray2.getInt(R.styleable.CustomerIndicator_liveshow_ci_orientation, -1));
        config.setGravity(typedArray2.getInt(R.styleable.CustomerIndicator_liveshow_ci_gravity, -1));
        typedArray2.recycle();
        return config;
    }

    private final void initialize(Config config) {
        int miniSize = (int)(TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()) + 0.5f);
        this.mIndicatorWidth = config.getWidth() < 0 ? miniSize : config.getWidth();
        this.mIndicatorHeight = config.getHeight() < 0 ? miniSize : config.getHeight();
        this.mIndicatorMargin = config.getMargin() < 0 ? miniSize : config.getMargin();
        this.mAnimatorOut = this.createAnimatorOut(config);
        Animator animator2 = this.mImmediateAnimatorOut = this.createAnimatorOut(config);
        if (animator2 != null) {
            animator2.setDuration(0L);
        }
        this.mAnimatorIn = this.createAnimatorIn(config);
        Animator animator3 = this.mImmediateAnimatorIn = this.createAnimatorIn(config);
        if (animator3 != null) {
            animator3.setDuration(0L);
        }
        this.mIndicatorBackgroundResId = config.getBackgroundResId() == 0 ? R.drawable.bjls_white_radius : config.getBackgroundResId();
        this.mIndicatorUnselectedBackgroundResId = config.getUnselectedBackgroundId() == 0 ? config.getBackgroundResId() : config.getUnselectedBackgroundId();
        this.setOrientation(config.getOrientation() == 1 ? 1 : 0);
        this.setGravity(config.getGravity() >= 0 ? config.getGravity() : 17);
    }

    private final void setIndicatorCreatedListener(@androidx.annotation.Nullable IndicatorCreatedListener indicatorCreatedListener) {
        this.mIndicatorCreatedListener = indicatorCreatedListener;
    }

    private final Animator createAnimatorOut(Config config) {
        Animator animator2 = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)config.getAnimatorResId());
        Intrinsics.checkNotNullExpressionValue((Object)animator2, (String)"loadAnimator(context, config.animatorResId)");
        return animator2;
    }

    private final Animator createAnimatorIn(Config config) {
        Animator animatorIn = null;
        if (config.getAnimatorReverseResId() == 0) {
            Animator animator2 = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)config.getAnimatorResId());
            Intrinsics.checkNotNullExpressionValue((Object)animator2, (String)"loadAnimator(context, config.animatorResId)");
            animatorIn = animator2;
            animatorIn.setInterpolator((TimeInterpolator)new ReverseInterpolator());
        } else {
            Animator animator3 = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)config.getAnimatorReverseResId());
            Intrinsics.checkNotNullExpressionValue((Object)animator3, (String)"loadAnimator(context, config.animatorReverseResId)");
            animatorIn = animator3;
        }
        return animatorIn;
    }

    public final void createIndicators(int count, int currentPosition) {
        int childViewCount;
        if (count <= 1) {
            return;
        }
        Animator animator2 = this.mImmediateAnimatorOut;
        boolean bl = animator2 != null ? animator2.isRunning() : false;
        if (bl) {
            Animator animator3 = this.mImmediateAnimatorOut;
            if (animator3 != null) {
                animator3.end();
            }
            Animator animator4 = this.mImmediateAnimatorOut;
            if (animator4 != null) {
                animator4.cancel();
            }
        }
        Animator animator5 = this.mImmediateAnimatorIn;
        boolean bl2 = animator5 != null ? animator5.isRunning() : false;
        if (bl2) {
            Animator animator6 = this.mImmediateAnimatorIn;
            if (animator6 != null) {
                animator6.end();
            }
            Animator animator7 = this.mImmediateAnimatorIn;
            if (animator7 != null) {
                animator7.cancel();
            }
        }
        if (count < (childViewCount = this.getChildCount())) {
            this.removeViews(count, childViewCount - count);
        } else if (count > childViewCount) {
            int addCount = count - childViewCount;
            int orientation = this.getOrientation();
            for (int i = 0; i < addCount; ++i) {
                this.addIndicator(orientation);
            }
        }
        View indicator = null;
        for (int i = 0; i < count; ++i) {
            Intrinsics.checkNotNullExpressionValue((Object)this.getChildAt(i), (String)"getChildAt(i)");
            if (currentPosition == i) {
                indicator.setBackgroundResource(this.mIndicatorBackgroundResId);
                if (this.mImmediateAnimatorOut != null) {
                    Animator $this$createIndicators_u24lambda_u240;
                    boolean bl3 = false;
                    $this$createIndicators_u24lambda_u240.setTarget((Object)indicator);
                    $this$createIndicators_u24lambda_u240.start();
                    $this$createIndicators_u24lambda_u240.end();
                }
            } else {
                indicator.setBackgroundResource(this.mIndicatorUnselectedBackgroundResId);
                if (this.mImmediateAnimatorIn != null) {
                    Animator $this$createIndicators_u24lambda_u241;
                    boolean bl4 = false;
                    $this$createIndicators_u24lambda_u241.setTarget((Object)indicator);
                    $this$createIndicators_u24lambda_u241.start();
                    $this$createIndicators_u24lambda_u241.end();
                }
            }
            IndicatorCreatedListener indicatorCreatedListener = this.mIndicatorCreatedListener;
            if (indicatorCreatedListener == null) continue;
            indicatorCreatedListener.onIndicatorCreated(indicator, i);
        }
        this.mLastPosition = currentPosition;
    }

    private final void addIndicator(int orientation) {
        View indicator = new View(this.getContext());
        LinearLayout.LayoutParams params = this.generateDefaultLayoutParams();
        params.width = this.mIndicatorWidth;
        params.height = this.mIndicatorHeight;
        if (orientation == 0) {
            params.leftMargin = this.mIndicatorMargin;
            params.rightMargin = this.mIndicatorMargin;
        } else {
            params.topMargin = this.mIndicatorMargin;
            params.bottomMargin = this.mIndicatorMargin;
        }
        this.addView(indicator, (ViewGroup.LayoutParams)params);
    }

    public final void animatePageSelected(int position) {
        View selectedIndicator;
        if (this.mLastPosition == position) {
            return;
        }
        Animator animator2 = this.mAnimatorIn;
        boolean bl = animator2 != null ? animator2.isRunning() : false;
        if (bl) {
            Animator animator3 = this.mAnimatorIn;
            if (animator3 != null) {
                animator3.end();
            }
            Animator animator4 = this.mAnimatorIn;
            if (animator4 != null) {
                animator4.cancel();
            }
        }
        Animator animator5 = this.mAnimatorOut;
        boolean bl2 = animator5 != null ? animator5.isRunning() : false;
        if (bl2) {
            Animator animator6 = this.mAnimatorOut;
            if (animator6 != null) {
                animator6.end();
            }
            Animator animator7 = this.mAnimatorOut;
            if (animator7 != null) {
                animator7.cancel();
            }
        }
        View currentIndicator = null;
        if (this.mLastPosition >= 0) {
            View view;
            View it = view = this.getChildAt(this.mLastPosition);
            boolean bl3 = false;
            currentIndicator = it;
            if (view != null) {
                View view2 = currentIndicator;
                if (view2 != null) {
                    view2.setBackgroundResource(this.mIndicatorUnselectedBackgroundResId);
                }
                Animator animator8 = this.mAnimatorIn;
                if (animator8 != null) {
                    animator8.setTarget((Object)currentIndicator);
                }
                Animator animator9 = this.mAnimatorIn;
                if (animator9 != null) {
                    animator9.start();
                }
            }
        }
        if ((selectedIndicator = this.getChildAt(position)) != null) {
            selectedIndicator.setBackgroundResource(this.mIndicatorBackgroundResId);
            Animator animator10 = this.mAnimatorOut;
            if (animator10 != null) {
                animator10.setTarget((Object)selectedIndicator);
            }
            Animator animator11 = this.mAnimatorOut;
            if (animator11 != null) {
                animator11.start();
            }
        }
        this.mLastPosition = position;
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/baijiayun/liveshow/ui/view/CustomerIndicator$IndicatorCreatedListener;", "", "onIndicatorCreated", "", "view", "Landroid/view/View;", "position", "", "liveplayer-sdk-live-show_release"})
    public static interface IndicatorCreatedListener {
        public void onIndicatorCreated(@Nullable View var1, int var2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/baijiayun/liveshow/ui/view/CustomerIndicator$ReverseInterpolator;", "Landroid/view/animation/Interpolator;", "(Lcom/baijiayun/liveshow/ui/view/CustomerIndicator;)V", "getInterpolation", "", "value", "liveplayer-sdk-live-show_release"})
    public final class ReverseInterpolator
    implements Interpolator {
        public float getInterpolation(float value) {
            return Math.abs(1.0f - value);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/baijiayun/liveshow/ui/view/CustomerIndicator$Companion;", "", "()V", "DEFAULT_INDICATOR_WIDTH", "", "liveplayer-sdk-live-show_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

