/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.toolbox.reward.fragment;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.livecore.models.livereward.LPLiveRewardConfigModel;
import com.baijiayun.liveshow.ui.R;
import com.baijiayun.liveshow.ui.toolbox.reward.RewardViewModel;
import com.baijiayun.liveshow.ui.toolbox.reward.fragment.RewardBaseFragment;
import com.baijiayun.liveshow.ui.view.HorizontalPageLayoutManager;
import com.baijiayun.liveshow.ui.view.PageIndicator;
import com.baijiayun.liveshow.ui.view.PageScrollHelper;
import com.baijiayun.liveuibase.listeners.CallbackManager;
import com.baijiayun.liveuibase.listeners.LPLiveShowRoomListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0014R\u0018\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082.\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\b\u0018\u00010\nR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/GiftFragment;", "Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/RewardBaseFragment;", "rewardViewModel", "Lcom/baijiayun/liveshow/ui/toolbox/reward/RewardViewModel;", "(Lcom/baijiayun/liveshow/ui/toolbox/reward/RewardViewModel;)V", "drawableList", "", "Landroid/graphics/drawable/Drawable;", "[Landroid/graphics/drawable/Drawable;", "giftAdapter", "Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/GiftFragment$GiftAdapter;", "selectedPosition", "", "clickToStartReward", "", "price", "", "(Ljava/lang/Float;)V", "getLayoutId", "init", "view", "Landroid/view/View;", "isNotEnoughBalance", "", "observeActions", "GiftAdapter", "GiftViewHolder", "liveplayer-sdk-live-show_release"})
public final class GiftFragment
extends RewardBaseFragment {
    @Nullable
    private GiftAdapter giftAdapter;
    private int selectedPosition;
    private Drawable[] drawableList;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    public GiftFragment(@NotNull RewardViewModel rewardViewModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)rewardViewModel), (String)"rewardViewModel");
        this._$_findViewCache = new LinkedHashMap();
        super(rewardViewModel);
        this.selectedPosition = -1;
    }

    protected void init(@NotNull View view) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super.init(view);
            int n = 0;
            int n2 = this.getRewardViewModel().getRouterViewModel().getGiftModels().size();
            Drawable[] drawableArray = new Drawable[n2];
            GiftFragment giftFragment = this;
            while (n < n2) {
                int n3 = n++;
                drawableArray[n3] = null;
            }
            giftFragment.drawableList = drawableArray;
            this.selectedPosition = this.getRouterViewModel().getLastGiftSelected();
            this.getRouterViewModel().setLastGiftSelected(-1);
            RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
            PageIndicator recyclerViewIndicator = (PageIndicator)view.findViewById(R.id.recyclerViewIndicator);
            this.giftAdapter = new GiftAdapter();
            if (DisplayUtils.isPad((Context)this.requireContext())) {
                recyclerView.setLayoutManager((RecyclerView.LayoutManager)new HorizontalPageLayoutManager(1, 8));
            } else {
                recyclerView.setLayoutManager((RecyclerView.LayoutManager)new HorizontalPageLayoutManager(2, 4));
            }
            PageScrollHelper scrollHelper = new PageScrollHelper();
            recyclerView.setAdapter((RecyclerView.Adapter)this.giftAdapter);
            scrollHelper.setUpRecycleView(recyclerView);
            Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"recyclerView");
            recyclerViewIndicator.attachToRecyclerView(recyclerView, scrollHelper);
            GiftAdapter giftAdapter = this.giftAdapter;
            if (giftAdapter != null) {
                giftAdapter.registerAdapterDataObserver(recyclerViewIndicator.getAdapterDataObserver());
            }
            GiftAdapter giftAdapter2 = this.giftAdapter;
            if (giftAdapter2 == null) break block4;
            giftAdapter2.setDatas(this.getRewardViewModel().getRouterViewModel().getGiftModels());
        }
    }

    protected void observeActions() {
        super.observeActions();
        this.getRewardViewModel().getRouterViewModel().getNotifyGiftConfigChange().observe((LifecycleOwner)this, arg_0 -> GiftFragment.observeActions$lambda$0((Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ GiftFragment this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Unit it) {
                block1: {
                    int n = 0;
                    int n2 = this.this$0.getRewardViewModel().getRouterViewModel().getGiftModels().size();
                    Drawable[] drawableArray = new Drawable[n2];
                    GiftFragment giftFragment = this.this$0;
                    while (n < n2) {
                        int n3 = n++;
                        drawableArray[n3] = null;
                    }
                    GiftFragment.access$setDrawableList$p(giftFragment, drawableArray);
                    GiftAdapter giftAdapter = GiftFragment.access$getGiftAdapter$p(this.this$0);
                    if (giftAdapter == null) break block1;
                    giftAdapter.setDatas(this.this$0.getRewardViewModel().getRouterViewModel().getGiftModels());
                }
            }
        }, arg_0));
    }

    @Override
    public void clickToStartReward(@Nullable Float price) {
        if (price == null || Intrinsics.areEqual((Float)price, (float)0.0f)) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - this.getRouterViewModel().getLastClickTimeMillis() < LiveSDK.LIVE_SHOW_GIFT_SEND_TIME_OUT) {
                this.showToastMessage("\u8bf7\u52ff\u9891\u7e41\u6253\u8d4f");
                return;
            }
            this.getRouterViewModel().setLastClickTimeMillis(currentTimeMillis);
            Object e = this.getRewardViewModel().getRouterViewModel().getGiftModels().get(this.selectedPosition);
            Intrinsics.checkNotNullExpressionValue(e, (String)"rewardViewModel.routerVi\u2026tModels[selectedPosition]");
            this.startReward((LPLiveRewardConfigModel)e);
        } else if (this.isNotBindPhone()) {
            this.getRewardViewModel().getNotifyPhoneBind().setValue((Object)Unit.INSTANCE);
            this.getRouterViewModel().setLastGiftSelected(this.selectedPosition);
        } else if (this.isNotEnoughBalance(price.floatValue())) {
            this.getRewardViewModel().getNotifyRecharge().setValue((Object)Unit.INSTANCE);
            this.getRouterViewModel().setLastGiftSelected(this.selectedPosition);
        } else {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - this.getRouterViewModel().getLastClickTimeMillis() < LiveSDK.LIVE_SHOW_GIFT_SEND_TIME_OUT) {
                this.showToastMessage("\u8bf7\u52ff\u9891\u7e41\u6253\u8d4f");
                return;
            }
            this.getRouterViewModel().setLastClickTimeMillis(currentTimeMillis);
            Object e = this.getRewardViewModel().getRouterViewModel().getGiftModels().get(this.selectedPosition);
            Intrinsics.checkNotNullExpressionValue(e, (String)"rewardViewModel.routerVi\u2026tModels[selectedPosition]");
            this.startReward((LPLiveRewardConfigModel)e);
        }
    }

    public int getLayoutId() {
        return R.layout.bjy_show_fragment_gift;
    }

    @Override
    public boolean isNotEnoughBalance(float price) {
        Object object = this.getRewardViewModel().getCoinBalance().getValue();
        Intrinsics.checkNotNull((Object)object);
        return ((Number)((Pair)object).getSecond()).floatValue() < price;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Override
    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2;
            View view3 = this.getView();
            if (view3 != null && (view2 = view3.findViewById(id2)) != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final void observeActions$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setDrawableList$p(GiftFragment $this, Drawable[] drawableArray) {
        $this.drawableList = drawableArray;
    }

    public static final /* synthetic */ GiftAdapter access$getGiftAdapter$p(GiftFragment $this) {
        return $this.giftAdapter;
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\tH\u0017J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0014\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u001a\u0010\u0013\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/GiftFragment$GiftAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/GiftFragment$GiftViewHolder;", "(Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/GiftFragment;)V", "items", "", "Lcom/baijiayun/livecore/models/livereward/LPLiveRewardConfigModel;", "lastSelectedViewHolder", "getItemCount", "", "onBindViewHolder", "", "viewHolder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setDatas", "updateViewNormal", "model", "updateViewSelected", "liveplayer-sdk-live-show_release"})
    public final class GiftAdapter
    extends RecyclerView.Adapter<GiftViewHolder> {
        @NotNull
        private List<? extends LPLiveRewardConfigModel> items = new ArrayList();
        @Nullable
        private GiftViewHolder lastSelectedViewHolder;

        @NotNull
        public GiftViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            View rootView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_show_item_gift, parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)rootView, (String)"rootView");
            return new GiftViewHolder(rootView);
        }

        public int getItemCount() {
            return this.items.size();
        }

        @SuppressLint(value={"RecyclerView"})
        public void onBindViewHolder(@NotNull GiftViewHolder viewHolder, int position) {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
            LPLiveRewardConfigModel gift = this.items.get(position);
            if (GiftFragment.this.selectedPosition == position) {
                GiftViewHolder giftViewHolder = this.lastSelectedViewHolder;
                Object object = giftViewHolder != null ? giftViewHolder.itemView : null;
                if (object != null) {
                    object.setSelected(false);
                }
                viewHolder.itemView.setSelected(true);
                this.lastSelectedViewHolder = viewHolder;
                this.updateViewSelected(viewHolder, gift);
            } else {
                viewHolder.itemView.setSelected(false);
                this.updateViewNormal(viewHolder, gift);
            }
            viewHolder.itemView.setOnClickListener(arg_0 -> GiftAdapter.onBindViewHolder$lambda$0(this, viewHolder, gift, GiftFragment.this, position, arg_0));
            Context context = GiftFragment.this.getContext();
            if (context != null) {
                Context context2 = context;
                GiftFragment giftFragment = GiftFragment.this;
                Context it = context2;
                boolean bl = false;
                Drawable[] drawableArray = giftFragment.drawableList;
                if (drawableArray == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"drawableList");
                    drawableArray = null;
                }
                if (drawableArray[position] != null) {
                    ImageView imageView = viewHolder.getIvGift();
                    Drawable[] drawableArray2 = giftFragment.drawableList;
                    if (drawableArray2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"drawableList");
                        drawableArray2 = null;
                    }
                    imageView.setImageDrawable(drawableArray2[position]);
                    unit = Unit.INSTANCE;
                } else {
                    Target target = Glide.with((Context)it).load(gift.imgUrl).apply(new RequestOptions().placeholder(R.drawable.bjy_show_ic_gift_placeholder)).into((Target)new SimpleTarget<Drawable>(giftFragment, position, viewHolder){
                        final /* synthetic */ GiftFragment this$0;
                        final /* synthetic */ int $position;
                        final /* synthetic */ GiftViewHolder $viewHolder;
                        {
                            this.this$0 = $receiver;
                            this.$position = $position;
                            this.$viewHolder = $viewHolder;
                        }

                        public void onResourceReady(@NotNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                            Drawable[] drawableArray = GiftFragment.access$getDrawableList$p(this.this$0);
                            if (drawableArray == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"drawableList");
                                drawableArray = null;
                            }
                            drawableArray[this.$position] = resource;
                            this.$viewHolder.getIvGift().setImageDrawable(resource);
                        }

                        public void onLoadFailed(@Nullable Drawable errorDrawable) {
                            this.$viewHolder.getIvGift().setImageResource(R.drawable.bjy_show_ic_gift_placeholder);
                        }
                    });
                    unit = target;
                    Intrinsics.checkNotNullExpressionValue((Object)target, (String)"onBindViewHolder$lambda$1");
                }
            } else {
                unit = null;
            }
            viewHolder.getIvSticky().setVisibility(gift.specialEffects != 0 ? 0 : 8);
        }

        public final void setDatas(@NotNull List<? extends LPLiveRewardConfigModel> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this.items = items;
            this.notifyDataSetChanged();
        }

        private final void updateViewSelected(GiftViewHolder viewHolder, LPLiveRewardConfigModel model) {
            CharSequence charSequence;
            viewHolder.getTvPrice().setVisibility(8);
            TextView textView = viewHolder.getTvGiftName();
            if (!(model.price == 0.0f)) {
                Object[] objectArray = new Object[]{Float.valueOf(model.price)};
                charSequence = GiftFragment.this.getString(R.string.bjy_show_reward_gift_price, objectArray);
            } else {
                charSequence = GiftFragment.this.getString(R.string.bjy_show_reward_free);
            }
            textView.setText(charSequence);
            viewHolder.getTvGiftSend().setVisibility(0);
            viewHolder.getTvGiftSend().setOnClickListener(arg_0 -> GiftAdapter.updateViewSelected$lambda$2(GiftFragment.this, model, arg_0));
        }

        private final void updateViewNormal(GiftViewHolder viewHolder, LPLiveRewardConfigModel model) {
            block2: {
                CharSequence charSequence;
                GiftViewHolder giftViewHolder = viewHolder;
                if (giftViewHolder == null) break block2;
                GiftViewHolder giftViewHolder2 = giftViewHolder;
                GiftFragment giftFragment = GiftFragment.this;
                GiftViewHolder $this$updateViewNormal_u24lambda_u243 = giftViewHolder2;
                boolean bl = false;
                TextView textView = $this$updateViewNormal_u24lambda_u243.getTvPrice();
                if (!(model.price == 0.0f)) {
                    Object[] objectArray = new Object[]{Float.valueOf(model.price)};
                    charSequence = giftFragment.getString(R.string.bjy_show_reward_gift_price, objectArray);
                } else {
                    charSequence = giftFragment.getString(R.string.bjy_show_reward_free);
                }
                textView.setText(charSequence);
                $this$updateViewNormal_u24lambda_u243.getTvPrice().setVisibility(0);
                $this$updateViewNormal_u24lambda_u243.getTvGiftName().setText((CharSequence)model.name);
                $this$updateViewNormal_u24lambda_u243.getTvGiftSend().setVisibility(8);
                $this$updateViewNormal_u24lambda_u243.getTvGiftSend().setOnClickListener(null);
            }
        }

        private static final void onBindViewHolder$lambda$0(GiftAdapter this$0, GiftViewHolder $viewHolder, LPLiveRewardConfigModel $gift, GiftFragment this$1, int $position, View it) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)$viewHolder), (String)"$viewHolder");
                Intrinsics.checkNotNullParameter((Object)$gift, (String)"$gift");
                Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
                it.setSelected(true);
                this$0.updateViewSelected($viewHolder, $gift);
                if (this$1.selectedPosition != -1 && this$1.selectedPosition < this$0.items.size()) {
                    GiftViewHolder giftViewHolder = this$0.lastSelectedViewHolder;
                    Object object = giftViewHolder != null ? giftViewHolder.itemView : null;
                    if (object != null) {
                        object.setSelected(false);
                    }
                    this$0.updateViewNormal(this$0.lastSelectedViewHolder, this$0.items.get(this$1.selectedPosition));
                }
                this$1.selectedPosition = $position;
                this$0.lastSelectedViewHolder = $viewHolder;
                LPLiveShowRoomListener.LPRoomGiftClickListener lPRoomGiftClickListener = CallbackManager.getInstance().getGiftClickListener();
                if (lPRoomGiftClickListener == null) break block2;
                lPRoomGiftClickListener.onClick($gift);
            }
        }

        private static final void updateViewSelected$lambda$2(GiftFragment this$0, LPLiveRewardConfigModel $model, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
            this$0.clickToStartReward(Float.valueOf($model.price));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/GiftFragment$GiftViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "ivGift", "Landroid/widget/ImageView;", "getIvGift", "()Landroid/widget/ImageView;", "ivSticky", "getIvSticky", "tvGiftName", "Landroid/widget/TextView;", "getTvGiftName", "()Landroid/widget/TextView;", "tvGiftSend", "getTvGiftSend", "tvPrice", "getTvPrice", "liveplayer-sdk-live-show_release"})
    public static final class GiftViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ImageView ivGift;
        @NotNull
        private final ImageView ivSticky;
        @NotNull
        private final TextView tvPrice;
        @NotNull
        private final TextView tvGiftName;
        @NotNull
        private final TextView tvGiftSend;

        public GiftViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.iv_gift);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.iv_gift)");
            this.ivGift = (ImageView)view;
            View view2 = itemView.findViewById(R.id.iv_sticky);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView.findViewById(R.id.iv_sticky)");
            this.ivSticky = (ImageView)view2;
            View view3 = itemView.findViewById(R.id.tv_gift_price);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"itemView.findViewById(R.id.tv_gift_price)");
            this.tvPrice = (TextView)view3;
            View view4 = itemView.findViewById(R.id.tv_gift_name);
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"itemView.findViewById(R.id.tv_gift_name)");
            this.tvGiftName = (TextView)view4;
            View view5 = itemView.findViewById(R.id.tv_gift_send);
            Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"itemView.findViewById(R.id.tv_gift_send)");
            this.tvGiftSend = (TextView)view5;
            itemView.setBackground(ContextCompat.getDrawable((Context)itemView.getContext(), (int)R.drawable.bjy_show_bg_reward_item));
        }

        @NotNull
        public final ImageView getIvGift() {
            return this.ivGift;
        }

        @NotNull
        public final ImageView getIvSticky() {
            return this.ivSticky;
        }

        @NotNull
        public final TextView getTvPrice() {
            return this.tvPrice;
        }

        @NotNull
        public final TextView getTvGiftName() {
            return this.tvGiftName;
        }

        @NotNull
        public final TextView getTvGiftSend() {
            return this.tvGiftSend;
        }
    }
}

