/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.toolbox.reward.fragment;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.livecore.models.livereward.LPLiveRewardConfigModel;
import com.baijiayun.liveshow.ui.R;
import com.baijiayun.liveshow.ui.toolbox.reward.RewardViewModel;
import com.baijiayun.liveshow.ui.toolbox.reward.dialog.CustomCashDialog;
import com.baijiayun.liveshow.ui.toolbox.reward.fragment.RewardBaseFragment;
import com.baijiayun.liveshow.ui.view.HorizontalPageLayoutManager;
import com.baijiayun.liveuibase.listeners.CallbackManager;
import com.baijiayun.liveuibase.listeners.LPLiveShowRoomListener;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\nH\u0014R\u0014\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/CashFragment;", "Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/RewardBaseFragment;", "rewardViewModel", "Lcom/baijiayun/liveshow/ui/toolbox/reward/RewardViewModel;", "(Lcom/baijiayun/liveshow/ui/toolbox/reward/RewardViewModel;)V", "cashAdapter", "Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/CashFragment$CashAdapter;", "selectedPosition", "", "clickToStartReward", "", "price", "", "(Ljava/lang/Float;)V", "getLayoutId", "init", "view", "Landroid/view/View;", "isNotEnoughBalance", "", "observeActions", "CashAdapter", "CashViewHolder", "liveplayer-sdk-live-show_release"})
public final class CashFragment
extends RewardBaseFragment {
    @Nullable
    private CashAdapter cashAdapter;
    private int selectedPosition;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    public CashFragment(@NotNull RewardViewModel rewardViewModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)rewardViewModel), (String)"rewardViewModel");
        this._$_findViewCache = new LinkedHashMap();
        super(rewardViewModel);
        this.selectedPosition = -1;
    }

    public int getLayoutId() {
        return R.layout.bjy_show_fragment_cash;
    }

    protected void init(@NotNull View view) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super.init(view);
            this.selectedPosition = this.getRouterViewModel().getLastCashSelected();
            this.getRouterViewModel().setLastCashSelected(-1);
            this.cashAdapter = new CashAdapter();
            RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.cash_recyclerView);
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new HorizontalPageLayoutManager(2, 3));
            recyclerView.setAdapter((RecyclerView.Adapter)this.cashAdapter);
            CashAdapter cashAdapter = this.cashAdapter;
            if (cashAdapter == null) break block0;
            cashAdapter.setDatas(this.getRewardViewModel().getRouterViewModel().getCashModels());
        }
    }

    protected void observeActions() {
        super.observeActions();
        this.getRewardViewModel().getRouterViewModel().getNotifyCashConfigChange().observe((LifecycleOwner)this, arg_0 -> CashFragment.observeActions$lambda$0((Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ CashFragment this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Unit it) {
                block0: {
                    CashAdapter cashAdapter = CashFragment.access$getCashAdapter$p(this.this$0);
                    if (cashAdapter == null) break block0;
                    cashAdapter.setDatas(this.this$0.getRewardViewModel().getRouterViewModel().getCashModels());
                }
            }
        }, arg_0));
    }

    @Override
    public void clickToStartReward(@Nullable Float price) {
        if (price == null || price.floatValue() <= 0.0f) {
            this.showToastMessage("\u8bf7\u9009\u62e9\u6253\u8d4f\u91d1\u989d");
            return;
        }
        if (price.floatValue() < this.getRouterViewModel().getMinSetupMoney()) {
            this.showToastMessage("\u81ea\u5b9a\u4e49\u91d1\u989d\u4f4e\u4e8e\u6700\u4f4e\u989d\u5ea6\u00a5" + this.getRouterViewModel().getMinSetupMoney());
            return;
        }
        if (this.isNotBindPhone()) {
            this.getRewardViewModel().getNotifyPhoneBind().setValue((Object)Unit.INSTANCE);
            this.getRouterViewModel().setLastCashSelected(this.selectedPosition);
        } else if (this.isNotEnoughBalance(price.floatValue())) {
            this.getRewardViewModel().getNotifyRecharge().setValue((Object)Unit.INSTANCE);
            this.getRouterViewModel().setLastCashSelected(this.selectedPosition);
        } else {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - this.getRouterViewModel().getLastClickTimeMillis() < LiveSDK.LIVE_SHOW_GIFT_SEND_TIME_OUT) {
                this.showToastMessage("\u8bf7\u52ff\u9891\u7e41\u6253\u8d4f");
                return;
            }
            this.getRouterViewModel().setLastClickTimeMillis(currentTimeMillis);
            LPLiveRewardConfigModel lpLiveRewardConfigModel = new LPLiveRewardConfigModel(null, null, 0);
            lpLiveRewardConfigModel.price = price.floatValue();
            this.startReward(lpLiveRewardConfigModel);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNotEnoughBalance(float price) {
        Object object = this.getRewardViewModel().getCoinBalance().getValue();
        Intrinsics.checkNotNull((Object)object);
        if (((Number)((Pair)object).getSecond()).floatValue() == 0.0f) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        Object object2 = this.getRewardViewModel().getCoinBalance().getValue();
        Intrinsics.checkNotNull((Object)object2);
        if (!(((Number)((Pair)object2).getSecond()).floatValue() < price)) return false;
        return true;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Override
    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2;
            View view3 = this.getView();
            if (view3 != null && (view2 = view3.findViewById(id2)) != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final void observeActions$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ CashAdapter access$getCashAdapter$p(CashFragment $this) {
        return $this.cashAdapter;
    }

    public static final /* synthetic */ RouterViewModel access$getRouterViewModel(CashFragment $this) {
        return $this.getRouterViewModel();
    }

    public static final /* synthetic */ void access$showToastMessage(CashFragment $this, String message) {
        $this.showToastMessage(message);
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\b\u0001\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0014\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ/\u0010\u0015\u001a\u00020\u000e2%\b\u0002\u0010\u0016\u001a\u001f\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0017H\u0002J\u0012\u0010\u001c\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0002J\u001f\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/CashFragment$CashAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/CashFragment$CashViewHolder;", "(Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/CashFragment;)V", "COMMON_CASH", "", "CUSTOM_CASH", "items", "", "", "getItemCount", "getItemViewType", "position", "onBindViewHolder", "", "viewHolder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setDatas", "showCustomCashDialog", "action", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "price", "updateViewNormal", "updateViewSelected", "cash", "(Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/CashFragment$CashViewHolder;Ljava/lang/Float;)V", "liveplayer-sdk-live-show_release"})
    public final class CashAdapter
    extends RecyclerView.Adapter<CashViewHolder> {
        private final int COMMON_CASH;
        private final int CUSTOM_CASH;
        @NotNull
        private List<String> items = new ArrayList();

        public CashAdapter() {
            this.CUSTOM_CASH = 1;
        }

        @NotNull
        public CashViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            View rootView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_show_item_cash, parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)rootView, (String)"rootView");
            return new CashViewHolder(rootView);
        }

        public int getItemCount() {
            return this.items.size();
        }

        public int getItemViewType(int position) {
            if (position == this.items.size() - 1) {
                return this.CUSTOM_CASH;
            }
            return this.COMMON_CASH;
        }

        public void onBindViewHolder(@NotNull CashViewHolder viewHolder, @SuppressLint(value={"RecyclerView"}) int position) {
            Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
            String cash = this.items.get(position);
            if (viewHolder.getItemViewType() == this.CUSTOM_CASH) {
                viewHolder.getTvPrice().setText((CharSequence)cash);
            } else {
                viewHolder.getTvPrice().setText((CharSequence)('\u00a5' + cash));
            }
            if (CashFragment.this.selectedPosition == position) {
                this.updateViewSelected(viewHolder, StringsKt.toFloatOrNull((String)cash));
            } else {
                this.updateViewNormal(viewHolder);
            }
            viewHolder.itemView.setOnClickListener(arg_0 -> CashAdapter.onBindViewHolder$lambda$0(viewHolder, this, cash, CashFragment.this, position, arg_0));
        }

        public final void setDatas(@NotNull List<String> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            ArrayList<String> temp = new ArrayList<String>((Collection)items);
            temp.add("\u81ea\u5b9a\u4e49");
            this.items = temp;
            this.notifyDataSetChanged();
        }

        private final void updateViewSelected(CashViewHolder viewHolder, Float cash) {
            viewHolder.itemView.setSelected(true);
            viewHolder.getTvGiftSend().setVisibility(0);
            viewHolder.getTvGiftSend().setOnClickListener(arg_0 -> CashAdapter.updateViewSelected$lambda$1(CashFragment.this, cash, arg_0));
        }

        private final void updateViewNormal(CashViewHolder viewHolder) {
            block0: {
                CashViewHolder cashViewHolder = viewHolder;
                if (cashViewHolder == null) break block0;
                CashViewHolder $this$updateViewNormal_u24lambda_u242 = cashViewHolder;
                boolean bl = false;
                $this$updateViewNormal_u24lambda_u242.itemView.setSelected(false);
                $this$updateViewNormal_u24lambda_u242.getTvGiftSend().setVisibility(8);
                $this$updateViewNormal_u24lambda_u242.getTvGiftSend().setOnClickListener(null);
            }
        }

        private final void showCustomCashDialog(Function1<? super Float, Unit> action) {
            block0: {
                Window $this$showCustomCashDialog_u24lambda_u243;
                block1: {
                    Context context = CashFragment.this.requireContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
                    CustomCashDialog customCashDialog2 = new CustomCashDialog(context, (Function2<? super Dialog, ? super Float, Unit>)((Function2)new Function2<Dialog, Float, Unit>(CashFragment.this, action){
                        final /* synthetic */ CashFragment this$0;
                        final /* synthetic */ Function1<Float, Unit> $action;
                        {
                            this.this$0 = $receiver;
                            this.$action = $action;
                            super(2);
                        }

                        public final void invoke(@NotNull Dialog dialog, float price) {
                            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
                            if (price < CashFragment.access$getRouterViewModel(this.this$0).getMinSetupMoney()) {
                                CashFragment.access$showToastMessage(this.this$0, "\u8f93\u5165\u91d1\u989d\u6700\u4f4e\u4e3a" + CashFragment.access$getRouterViewModel(this.this$0).getMinSetupMoney() + '\u5143');
                            } else {
                                Function1<Float, Unit> function1 = this.$action;
                                if (function1 != null) {
                                    function1.invoke((Object)Float.valueOf(price));
                                }
                                dialog.dismiss();
                            }
                        }
                    }));
                    customCashDialog2.show();
                    Window window = customCashDialog2.getWindow();
                    if (window == null) break block0;
                    $this$showCustomCashDialog_u24lambda_u243 = window;
                    boolean bl = false;
                    if (Build.VERSION.SDK_INT < 30) break block1;
                    WindowInsetsController windowInsetsController = $this$showCustomCashDialog_u24lambda_u243.getDecorView().getWindowInsetsController();
                    if (windowInsetsController == null) break block0;
                    windowInsetsController.show(WindowInsets.Type.systemBars());
                    break block0;
                }
                $this$showCustomCashDialog_u24lambda_u243.getDecorView().setSystemUiVisibility(256);
            }
        }

        static /* synthetic */ void showCustomCashDialog$default(CashAdapter cashAdapter, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = null;
            }
            cashAdapter.showCustomCashDialog((Function1<? super Float, Unit>)function1);
        }

        private static final void onBindViewHolder$lambda$0(CashViewHolder $viewHolder, CashAdapter this$0, String $cash, CashFragment this$1, int $position, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)$viewHolder), (String)"$viewHolder");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$cash, (String)"$cash");
            Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
            if ($viewHolder.getItemViewType() == this$0.CUSTOM_CASH) {
                this$0.showCustomCashDialog((Function1<? super Float, Unit>)((Function1)new Function1<Float, Unit>(this$1){
                    final /* synthetic */ CashFragment this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(float customCash) {
                        LPLiveShowRoomListener.LPRoomCashClickListener lPRoomCashClickListener = CallbackManager.getInstance().getCashClickListener();
                        if (lPRoomCashClickListener != null) {
                            lPRoomCashClickListener.onClick(String.valueOf(customCash));
                        }
                        this.this$0.clickToStartReward(Float.valueOf(customCash));
                    }
                }));
            } else {
                this$0.updateViewSelected($viewHolder, StringsKt.toFloatOrNull((String)$cash));
                this$1.selectedPosition = $position;
                LPLiveShowRoomListener.LPRoomCashClickListener lPRoomCashClickListener = CallbackManager.getInstance().getCashClickListener();
                if (lPRoomCashClickListener != null) {
                    lPRoomCashClickListener.onClick($cash);
                }
                this$0.notifyDataSetChanged();
            }
        }

        private static final void updateViewSelected$lambda$1(CashFragment this$0, Float $cash, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.clickToStartReward($cash);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/baijiayun/liveshow/ui/toolbox/reward/fragment/CashFragment$CashViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "tvGiftSend", "Landroid/widget/TextView;", "getTvGiftSend", "()Landroid/widget/TextView;", "tvPrice", "getTvPrice", "liveplayer-sdk-live-show_release"})
    public static final class CashViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final TextView tvPrice;
        @NotNull
        private final TextView tvGiftSend;

        public CashViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.tvCashPrice);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.tvCashPrice)");
            this.tvPrice = (TextView)view;
            View view2 = itemView.findViewById(R.id.tvCashSend);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView.findViewById(R.id.tvCashSend)");
            this.tvGiftSend = (TextView)view2;
            itemView.setBackground(ContextCompat.getDrawable((Context)itemView.getContext(), (int)R.drawable.bjy_show_bg_reward_item));
        }

        @NotNull
        public final TextView getTvPrice() {
            return this.tvPrice;
        }

        @NotNull
        public final TextView getTvGiftSend() {
            return this.tvGiftSend;
        }
    }
}

