/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.toolbox.reward;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;

public class KeyBoardObserver {
    private View contentView;
    private PopupWindow popupWindow;
    private int lastBottom;
    private int lastKeyboardHeight;
    private ViewTreeObserver.OnGlobalLayoutListener layoutListener;

    public void observe(View rootContentView, KeyboardListener keyboardListener) {
        this.popupWindow = new PopupWindow();
        this.contentView = new View(rootContentView.getContext());
        this.popupWindow.setContentView(this.contentView);
        this.popupWindow.setWidth(0);
        this.popupWindow.setHeight(-1);
        this.popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.popupWindow.setSoftInputMode(16);
        this.popupWindow.setInputMethodMode(1);
        this.layoutListener = () -> {
            int heightChange;
            boolean visible;
            Rect rect = new Rect();
            this.contentView.getWindowVisibleDisplayFrame(rect);
            if (rect.bottom > this.lastBottom) {
                this.lastBottom = rect.bottom;
            }
            boolean bl = visible = (heightChange = this.lastBottom - rect.bottom) > this.getStatusBarHeight(rootContentView.getContext());
            if (this.lastKeyboardHeight != 0 && this.lastKeyboardHeight * 2 == heightChange) {
                return;
            }
            if (this.lastKeyboardHeight == heightChange) {
                return;
            }
            this.lastKeyboardHeight = heightChange;
            if (visible) {
                keyboardListener.onOpened(heightChange);
            } else {
                keyboardListener.onClosed();
            }
        };
        this.contentView.getViewTreeObserver().addOnGlobalLayoutListener(this.layoutListener);
        rootContentView.postDelayed(() -> {
            if (rootContentView.getContext() instanceof Activity && !((Activity)rootContentView.getContext()).isFinishing()) {
                this.popupWindow.showAtLocation(rootContentView, 0, 0, 0);
            }
        }, 300L);
    }

    public void release() {
        if (this.popupWindow != null && this.popupWindow.isShowing()) {
            this.popupWindow.dismiss();
        }
        if (this.contentView != null && this.layoutListener != null) {
            this.contentView.getViewTreeObserver().removeOnGlobalLayoutListener(this.layoutListener);
        }
    }

    private int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static interface KeyboardListener {
        public void onOpened(int var1);

        public void onClosed();
    }
}

