/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.chat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.view.GestureDetectorCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.text.HyperLinkHelper;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.engine.DiskCacheStrategy;
import com.baijiayun.glide.load.resource.gif.GifDrawable;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.base.BaseViewModelFactory;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.AliCloudImageUtil;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.utils.URLImageParser;
import com.baijiayun.livebase.widgets.dialog.preview.ChatPictureViewFragment;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPMessageReferenceModel;
import com.baijiayun.livecore.models.imodels.IMessageModel;
import com.baijiayun.liveshow.ui.R;
import com.baijiayun.liveshow.ui.chat.ChatItemDecoration;
import com.baijiayun.liveshow.ui.chat.ChatViewModel;
import com.baijiayun.liveshow.ui.chat.LiveShowChatFragment;
import com.baijiayun.liveshow.ui.databinding.BjyShowItemChatImageContentBinding;
import com.baijiayun.liveshow.ui.databinding.BjyShowItemChatTextContentBinding;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BasePadFragment;
import com.baijiayun.liveuibase.utils.ExtensionKt;
import com.baijiayun.liveuibase.utils.LinearLayoutWrapManager;
import com.baijiayun.liveuibase.widgets.chat.BitmapCropTarget;
import com.baijiayun.liveuibase.widgets.chat.CenterImageSpan;
import com.baijiayun.liveuibase.widgets.chat.ChatImageUtil;
import com.baijiayun.liveuibase.widgets.chat.ControlClickSpanTextView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 52\u00020\u0001:\u00045678B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001c\u001a\u00020\u0004H\u0016J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 H\u0002J \u0010.\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020 2\u0006\u0010/\u001a\u00020\u0004H\u0002J\b\u00100\u001a\u00020)H\u0014J\b\u00101\u001a\u00020)H\u0016J\u0010\u00102\u001a\u00020)2\u0006\u0010-\u001a\u00020 H\u0002J\u0010\u00103\u001a\u00020)2\u0006\u00104\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000f\u001a\u00060\u0010R\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000b\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000b\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment;", "Lcom/baijiayun/liveuibase/base/BasePadFragment;", "()V", "MESSAGE_TYPE_IMAGE", "", "MESSAGE_TYPE_TEXT", "chatViewModel", "Lcom/baijiayun/liveshow/ui/chat/ChatViewModel;", "getChatViewModel", "()Lcom/baijiayun/liveshow/ui/chat/ChatViewModel;", "chatViewModel$delegate", "Lkotlin/Lazy;", "currentPosition", "isInit", "", "messageAdapter", "Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment$MessageAdapter;", "getMessageAdapter", "()Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment$MessageAdapter;", "messageAdapter$delegate", "navigateToMainObserver", "Landroidx/lifecycle/Observer;", "getNavigateToMainObserver", "()Landroidx/lifecycle/Observer;", "navigateToMainObserver$delegate", "pattern", "Ljava/util/regex/Pattern;", "tagKey", "getLayoutId", "getMixText", "Landroid/text/SpannableStringBuilder;", "srcContent", "", "textView", "Landroid/widget/TextView;", "textViewHolder", "Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment$TextViewHolder;", "getRewardText", "message", "Lcom/baijiayun/livecore/models/imodels/IMessageModel;", "initSuccess", "", "loadBitmap", "imageView", "Landroid/widget/ImageView;", "url", "loadGif", "position", "observeActions", "onDestroyView", "showBigChatPic", "showMessageReminder", "needShow", "Companion", "ImageViewHolder", "MessageAdapter", "TextViewHolder", "liveplayer-sdk-live-show_release"})
public final class LiveShowChatFragment
extends BasePadFragment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int currentPosition;
    private boolean isInit = true;
    @NotNull
    private final Pattern pattern;
    @NotNull
    private final Lazy navigateToMainObserver$delegate;
    @NotNull
    private final Lazy messageAdapter$delegate;
    @NotNull
    private final Lazy chatViewModel$delegate;
    private final int MESSAGE_TYPE_TEXT;
    private final int MESSAGE_TYPE_IMAGE;
    private final int tagKey;
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();

    public LiveShowChatFragment() {
        Pattern pattern = Pattern.compile("\\[[a-zA-Z\\d\u4e00-\u9fa5]+]");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"\\\\[[a-zA-Z\\\\d\\u4e00-\\u9fa5]+]\")");
        this.pattern = pattern;
        this.navigateToMainObserver$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Observer<Boolean>>(this){
            final /* synthetic */ LiveShowChatFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Observer<Boolean> invoke() {
                return arg_0 -> navigateToMainObserver.2.invoke$lambda$0(this.this$0, arg_0);
            }

            private static final void invoke$lambda$0(LiveShowChatFragment this$0, Boolean it) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                if (Intrinsics.areEqual((Object)it, (Object)true)) {
                    LiveShowChatFragment.access$initSuccess(this$0);
                }
            }
        }));
        this.messageAdapter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MessageAdapter>(this){
            final /* synthetic */ LiveShowChatFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final MessageAdapter invoke() {
                return this.this$0.new MessageAdapter();
            }
        }));
        this.chatViewModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ChatViewModel>(this){
            final /* synthetic */ LiveShowChatFragment this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ChatViewModel invoke() {
                void $this$getActivityViewModel$iv;
                Fragment fragment = (Fragment)this.this$0;
                Function0 creator$iv = (Function0)new Function0<ChatViewModel>(this.this$0){
                    final /* synthetic */ LiveShowChatFragment this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final ChatViewModel invoke() {
                        return new ChatViewModel(LiveShowChatFragment.access$getRouterViewModel(this.this$0));
                    }
                };
                boolean $i$f$getActivityViewModel = false;
                FragmentActivity fragmentActivity = $this$getActivityViewModel$iv.getActivity();
                Intrinsics.checkNotNull((Object)fragmentActivity);
                FragmentActivity it$iv = fragmentActivity;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it$iv, (String)"it");
                return (ChatViewModel)new ViewModelProvider((ViewModelStoreOwner)it$iv, (ViewModelProvider.Factory)new BaseViewModelFactory(creator$iv)).get(ChatViewModel.class);
            }
        }));
        this.MESSAGE_TYPE_IMAGE = 1;
        this.tagKey = R.id.bjy_show_item_tag_key;
    }

    private final Observer<Boolean> getNavigateToMainObserver() {
        Lazy lazy = this.navigateToMainObserver$delegate;
        return (Observer)lazy.getValue();
    }

    private final MessageAdapter getMessageAdapter() {
        Lazy lazy = this.messageAdapter$delegate;
        return (MessageAdapter)((Object)lazy.getValue());
    }

    private final ChatViewModel getChatViewModel() {
        Lazy lazy = this.chatViewModel$delegate;
        return (ChatViewModel)((Object)lazy.getValue());
    }

    public int getLayoutId() {
        return R.layout.bjy_show_fragment_chat;
    }

    protected void observeActions() {
        this.getRouterViewModel().getActionNavigateToMain().observeForever(this.getNavigateToMainObserver());
    }

    private final void initSuccess() {
        ((TextView)this._$_findCachedViewById(R.id.live_show_new_message_reminder)).setBackground(new DrawableBuilder().cornerRadius(UtilsKt.getDp((int)12)).solidColor(this.getResources().getColor(R.color.bjy_show_reminder_message_bg_color)).build());
        LinearLayoutWrapManager layoutWrapManager = new LinearLayoutWrapManager(this.getContext());
        layoutWrapManager.setStackFromEnd(true);
        ((RecyclerView)this._$_findCachedViewById(R.id.recyclerView)).setLayoutManager((RecyclerView.LayoutManager)layoutWrapManager);
        ((RecyclerView)this._$_findCachedViewById(R.id.recyclerView)).setAdapter((RecyclerView.Adapter)this.getMessageAdapter());
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.recyclerView);
        float f = UtilsKt.getDp((float)30.0f);
        RecyclerView recyclerView2 = (RecyclerView)this._$_findCachedViewById(R.id.recyclerView);
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"recyclerView");
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new ChatItemDecoration(f, recyclerView2));
        this.getChatViewModel().getNotifyDataSetChange().observe((LifecycleOwner)this, arg_0 -> LiveShowChatFragment.initSuccess$lambda$0((Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ LiveShowChatFragment this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Unit it) {
                boolean needScroll = false;
                if (LiveShowChatFragment.access$getChatViewModel(this.this$0).getReceiveMsgType() == ChatViewModel.MsgType.Me) {
                    needScroll = true;
                } else if (LiveShowChatFragment.access$getCurrentPosition$p(this.this$0) >= LiveShowChatFragment.access$getChatViewModel(this.this$0).getCount() - 2 && LiveShowChatFragment.access$getChatViewModel(this.this$0).getReceivedNewMsgNum() > 0) {
                    needScroll = true;
                }
                LiveShowChatFragment.access$getChatViewModel(this.this$0).setReceiveMsgType(ChatViewModel.MsgType.None);
                LiveShowChatFragment.access$getMessageAdapter(this.this$0).notifyDataSetChanged();
                if (!needScroll) {
                    LiveShowChatFragment.access$showMessageReminder(this.this$0, true);
                }
                if ((LiveShowChatFragment.access$isInit$p(this.this$0) || needScroll) && LiveShowChatFragment.access$getMessageAdapter(this.this$0).getItemCount() > 0) {
                    LiveShowChatFragment.access$setInit$p(this.this$0, false);
                    ((RecyclerView)this.this$0._$_findCachedViewById(R.id.recyclerView)).smoothScrollToPosition(LiveShowChatFragment.access$getMessageAdapter(this.this$0).getItemCount() - 1);
                }
            }
        }, arg_0));
        this.getChatViewModel().getNotifyItemInsert().observe((LifecycleOwner)this, arg_0 -> LiveShowChatFragment.initSuccess$lambda$1((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ LiveShowChatFragment this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Integer it) {
                block0: {
                    Integer n = it;
                    if (n == null) break block0;
                    Integer n2 = n;
                    LiveShowChatFragment liveShowChatFragment = this.this$0;
                    int $this$invoke_u24lambda_u240 = ((Number)n2).intValue();
                    boolean bl = false;
                    LiveShowChatFragment.access$getMessageAdapter(liveShowChatFragment).notifyItemInserted(it);
                }
            }
        }, arg_0));
        this.getChatViewModel().subscribe();
    }

    private final void showMessageReminder(boolean needShow) {
        TextView $this$showMessageReminder_u24lambda_u243 = (TextView)this._$_findCachedViewById(R.id.live_show_new_message_reminder);
        boolean bl = false;
        if (!needShow || this.getChatViewModel().getReceivedNewMsgNum() <= 0) {
            $this$showMessageReminder_u24lambda_u243.setVisibility(8);
            this.getChatViewModel().setReceivedNewMsgNum(0);
            return;
        }
        $this$showMessageReminder_u24lambda_u243.setVisibility(0);
        Object[] objectArray = new Object[]{this.getChatViewModel().getReceivedNewMsgNum()};
        $this$showMessageReminder_u24lambda_u243.setText((CharSequence)this.getString(R.string.live_room_new_chat_message, objectArray));
        $this$showMessageReminder_u24lambda_u243.setOnClickListener(arg_0 -> LiveShowChatFragment.showMessageReminder$lambda$3$lambda$2(this, arg_0));
    }

    private final SpannableStringBuilder getMixText(String srcContent, TextView textView, TextViewHolder textViewHolder) {
        SpannableStringBuilder ssb = SpannableStringBuilder.valueOf((CharSequence)srcContent);
        Matcher emojiMatcher = this.pattern.matcher(ssb.toString());
        List cacheDrawables = null;
        List imageParserList = null;
        while (emojiMatcher.find()) {
            String group = emojiMatcher.group();
            if (!this.getChatViewModel().getExpressions().containsKey(group)) continue;
            URLImageParser urlImageParser = new URLImageParser(textView, textView.getTextSize());
            Drawable drawable2 = urlImageParser.getDrawable(this.getChatViewModel().getExpressions().get(group));
            CenterImageSpan centerImageSpan = new CenterImageSpan(drawable2, 1);
            ssb.setSpan((Object)centerImageSpan, emojiMatcher.start(), emojiMatcher.end(), 34);
            ssb.removeSpan((Object)group);
            if (textViewHolder == null || !(drawable2 instanceof URLImageParser.GlideGifDrawable)) continue;
            if (cacheDrawables == null) {
                cacheDrawables = new ArrayList();
            }
            cacheDrawables.add(drawable2);
            if (imageParserList == null) {
                imageParserList = new ArrayList();
            }
            imageParserList.add(urlImageParser);
        }
        if (cacheDrawables != null && imageParserList != null && textViewHolder != null) {
            textViewHolder.setGifCache(cacheDrawables, imageParserList);
        }
        Intrinsics.checkNotNullExpressionValue((Object)ssb, (String)"ssb");
        return ssb;
    }

    static /* synthetic */ SpannableStringBuilder getMixText$default(LiveShowChatFragment liveShowChatFragment, String string2, TextView textView, TextViewHolder textViewHolder, int n, Object object) {
        if ((n & 4) != 0) {
            textViewHolder = null;
        }
        return liveShowChatFragment.getMixText(string2, textView, textViewHolder);
    }

    private final SpannableStringBuilder getRewardText(IMessageModel message, TextView textView) {
        SpannableStringBuilder ssb;
        block2: {
            ssb = new SpannableStringBuilder();
            Context context = this.getContext();
            if (context == null) break block2;
            Context $this$getRewardText_u24lambda_u244 = context;
            boolean bl = false;
            String string2 = $this$getRewardText_u24lambda_u244.getResources().getString(R.string.live_show_reward_gift_prefix);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026_show_reward_gift_prefix)");
            String giftPrefix = string2;
            if (TextUtils.isEmpty((CharSequence)message.getData().giftName)) {
                String string3 = $this$getRewardText_u24lambda_u244.getResources().getString(R.string.live_show_reward_cash_prefix);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resources.getString(R.st\u2026_show_reward_cash_prefix)");
                String cashPrefix = string3;
                String string4 = $this$getRewardText_u24lambda_u244.getResources().getString(R.string.live_show_reward_cash_suffix);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resources.getString(R.st\u2026_show_reward_cash_suffix)");
                String cashSuffix = string4;
                ssb.append((CharSequence)cashPrefix);
                ssb.append((CharSequence)" ");
                ssb.append((CharSequence)"\uffe5");
                ssb.append((CharSequence)message.getData().price);
                ssb.append((CharSequence)" ");
                ssb.append((CharSequence)cashSuffix);
                ssb.setSpan((Object)new StyleSpan(1), cashPrefix.length() + 1, cashPrefix.length() + message.getData().price.length() + 2, 34);
            } else {
                ssb.append((CharSequence)giftPrefix);
                ssb.append((CharSequence)message.getData().giftName);
                ssb.setSpan((Object)new StyleSpan(1), giftPrefix.length(), giftPrefix.length() + message.getData().giftName.length(), 34);
                ssb.append((CharSequence)" ");
                URLImageParser urlImageParser = new URLImageParser(textView, textView.getTextSize());
                Drawable drawable2 = urlImageParser.getDrawable(message.getData().giftImg);
                CenterImageSpan centerImageSpan = new CenterImageSpan(drawable2, 1);
                ssb.setSpan((Object)centerImageSpan, giftPrefix.length() + message.getData().giftName.length(), giftPrefix.length() + message.getData().giftName.length() + 1, 34);
            }
        }
        return ssb;
    }

    private final void showBigChatPic(String url) {
        Object[] objectArray = new String[]{url};
        ChatPictureViewFragment fragment = ChatPictureViewFragment.newInstance((ArrayList)CollectionsKt.arrayListOf((Object[])objectArray));
        fragment.setCallback((ChatPictureViewFragment.Callback)new ChatPictureViewFragment.SimpleChatPicCallback(this){
            final /* synthetic */ LiveShowChatFragment this$0;
            {
                this.this$0 = $receiver;
            }

            public void save(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                LiveShowChatFragment.access$getRouterViewModel(this.this$0).getShowSavePicDialog().setValue((Object)url);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragment");
        this.showDialogFragment((BaseDialogFragment)fragment);
    }

    private final void loadGif(ImageView imageView, String url, int position) {
        imageView.setTag(this.tagKey, (Object)position);
        ColorDrawable failedColorDrawable = new ColorDrawable(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.live_half_transparent));
        RequestOptions requestOptions = new RequestOptions();
        RequestOptions requestOptions2 = requestOptions.placeholder((Drawable)failedColorDrawable).error((Drawable)failedColorDrawable);
        Intrinsics.checkNotNullExpressionValue((Object)requestOptions2, (String)"requestOptions.placehold\u2026rror(failedColorDrawable)");
        requestOptions = requestOptions2;
        Glide.with((Context)this.requireContext()).asGif().apply(requestOptions.diskCacheStrategy(DiskCacheStrategy.RESOURCE)).load(url).into((Target)new SimpleTarget<GifDrawable>(position, imageView, this){
            final /* synthetic */ int $position;
            final /* synthetic */ ImageView $imageView;
            final /* synthetic */ LiveShowChatFragment this$0;
            {
                this.$position = $position;
                this.$imageView = $imageView;
                this.this$0 = $receiver;
            }

            public void onResourceReady(@NotNull GifDrawable resource, @Nullable Transition<? super GifDrawable> transition) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                Object object = this.$imageView.getTag(LiveShowChatFragment.access$getTagKey$p(this.this$0));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                if (this.$position != (Integer)object) {
                    return;
                }
                int[] nArray = new int[]{resource.getMinimumWidth(), resource.getMinimumHeight()};
                int[] gifSize = nArray;
                ChatImageUtil.calculateImageSize((int[])gifSize, (int)UtilsKt.getDp((int)100), (int)UtilsKt.getDp((int)50));
                ViewGroup.LayoutParams layoutParams = this.$imageView.getLayoutParams();
                Intrinsics.checkNotNullExpressionValue((Object)layoutParams, (String)"imageView.layoutParams");
                ViewGroup.LayoutParams layoutParams2 = layoutParams;
                layoutParams2.width = gifSize[0];
                layoutParams2.height = gifSize[1];
                this.$imageView.setLayoutParams(layoutParams2);
                this.$imageView.setImageDrawable((Drawable)resource);
                resource.start();
            }
        });
    }

    private final void loadBitmap(ImageView imageView, String url) {
        ColorDrawable failedColorDrawable = new ColorDrawable(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.live_half_transparent));
        RequestOptions requestOptions = new RequestOptions();
        RequestOptions requestOptions2 = requestOptions.placeholder((Drawable)failedColorDrawable).error((Drawable)failedColorDrawable);
        Intrinsics.checkNotNullExpressionValue((Object)requestOptions2, (String)"requestOptions.placehold\u2026rror(failedColorDrawable)");
        requestOptions = requestOptions2;
        Glide.with((Context)this.requireContext()).asBitmap().load(AliCloudImageUtil.getScaledUrl((String)url, (String)"m_mfit", (int)300, (int)300)).apply(requestOptions).into((Target)new BitmapCropTarget(imageView, 100, 50));
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.getRouterViewModel().getActionNavigateToMain().removeObserver(this.getNavigateToMainObserver());
        this._$_clearFindViewByIdCache();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2;
            View view3 = this.getView();
            if (view3 != null && (view2 = view3.findViewById(id2)) != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final void initSuccess$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void initSuccess$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void showMessageReminder$lambda$3$lambda$2(LiveShowChatFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.getMessageAdapter().getItemCount() > 0) {
            ((RecyclerView)this$0._$_findCachedViewById(R.id.recyclerView)).smoothScrollToPosition(this$0.getChatViewModel().getCount() - 1);
        }
        this$0.getChatViewModel().setReceivedNewMsgNum(0);
    }

    public static final /* synthetic */ int access$getCurrentPosition$p(LiveShowChatFragment $this) {
        return $this.currentPosition;
    }

    public static final /* synthetic */ MessageAdapter access$getMessageAdapter(LiveShowChatFragment $this) {
        return $this.getMessageAdapter();
    }

    public static final /* synthetic */ boolean access$isInit$p(LiveShowChatFragment $this) {
        return $this.isInit;
    }

    public static final /* synthetic */ void access$setInit$p(LiveShowChatFragment $this, boolean bl) {
        $this.isInit = bl;
    }

    public static final /* synthetic */ int access$getTagKey$p(LiveShowChatFragment $this) {
        return $this.tagKey;
    }

    public static final /* synthetic */ void access$initSuccess(LiveShowChatFragment $this) {
        $this.initSuccess();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0005H\u0017J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment$MessageAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "(Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment;)V", "referenceTvMaxLines", "", "getItemCount", "getItemViewType", "position", "onBindViewHolder", "", "viewHolder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewRecycled", "holder", "showMenu", "x", "y", "parentView", "Landroid/view/View;", "iMessageModel", "Lcom/baijiayun/livecore/models/imodels/IMessageModel;", "liveplayer-sdk-live-show_release"})
    public final class MessageAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private int referenceTvMaxLines = 3;

        @NotNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
            RecyclerView.ViewHolder viewHolder;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            if (viewType == LiveShowChatFragment.this.MESSAGE_TYPE_IMAGE) {
                View imageContainer = LayoutInflater.from((Context)LiveShowChatFragment.this.getContext()).inflate(R.layout.bjy_show_item_chat_image_content, null);
                View view = imageContainer.getRootView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"imageContainer.rootView");
                viewHolder = new ImageViewHolder(view);
            } else {
                View textContainer = LayoutInflater.from((Context)LiveShowChatFragment.this.getContext()).inflate(R.layout.bjy_show_item_chat_text_content, null);
                View view = textContainer.getRootView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"textContainer.rootView");
                viewHolder = new TextViewHolder(view);
            }
            return viewHolder;
        }

        public int getItemViewType(int position) {
            LPConstants.MessageType messageType = LiveShowChatFragment.this.getChatViewModel().getMessage(position).getMessageType();
            return (messageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) == 1 ? LiveShowChatFragment.this.MESSAGE_TYPE_IMAGE : LiveShowChatFragment.this.MESSAGE_TYPE_TEXT;
        }

        public int getItemCount() {
            return LiveShowChatFragment.this.getChatViewModel().getCount();
        }

        @SuppressLint(value={"RecyclerView", "SetTextI18n", "ClickableViewAccessibility"})
        public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            LiveShowChatFragment.this.currentPosition = position;
            if (position == LiveShowChatFragment.this.getChatViewModel().getCount() - 1) {
                LiveShowChatFragment.this.showMessageReminder(false);
            }
            IMessageModel message = LiveShowChatFragment.this.getChatViewModel().getMessage(position);
            DrawableBuilder drawableBuilder = new DrawableBuilder().cornerRadius(UtilsKt.getDp((int)12));
            LPConstants.LPUserType lPUserType = message.getFrom().getType();
            switch (lPUserType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[lPUserType.ordinal()]) {
                case 1: {
                    drawableBuilder.solidColor(LiveShowChatFragment.this.getResources().getColor(R.color.bjy_show_teacher_chat_bubble_color));
                    break;
                }
                case 2: {
                    DrawableBuilder.gradientColors$default((DrawableBuilder)drawableBuilder, (int)LiveShowChatFragment.this.getResources().getColor(R.color.bjy_show_assistant_chat_bubble_start_color), (int)LiveShowChatFragment.this.getResources().getColor(R.color.bjy_show_assistant_chat_bubble_end_color), null, (int)4, null).gradient(true).linearGradient().angle(180);
                    break;
                }
                default: {
                    drawableBuilder.solidColor(LiveShowChatFragment.this.getResources().getColor(R.color.bjy_show_student_chat_bubble_color));
                }
            }
            if (message.getMessageType() == LPConstants.MessageType.Reward) {
                DrawableBuilder.gradientColors$default((DrawableBuilder)drawableBuilder, (int)LiveShowChatFragment.this.getResources().getColor(R.color.bjy_show_gift_chat_bubble_start_color), (int)LiveShowChatFragment.this.getResources().getColor(R.color.bjy_show_gift_chat_bubble_end_color), null, (int)4, null).gradient(true).linearGradient().angle(180);
            }
            viewHolder.itemView.setBackground(drawableBuilder.build());
            String name = UtilsKt.getEncodePhoneNumber((String)message.getFrom().getName());
            if (Intrinsics.areEqual((Object)message.getFrom().getNumber(), (Object)LiveShowChatFragment.this.getRouterViewModel().getLiveRoom().getCurrentUser().getNumber())) {
                name = "\u6211";
            }
            if (name.length() > 16) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = name.substring(0, 16);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                name = stringBuilder.append(string2).append("...").toString();
            }
            SpannableStringBuilder spannableString = new SpannableStringBuilder((CharSequence)name);
            int colorResId = R.color.bjy_show_message_name_text_color_student;
            spannableString.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)viewHolder.itemView.getContext(), (int)colorResId)), 0, name.length(), 33);
            spannableString.append((CharSequence)" ");
            LPConstants.MessageType messageType = message.getMessageType();
            switch (messageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
                case 1: {
                    ImageViewHolder imageViewHolder = (ImageViewHolder)viewHolder;
                    imageViewHolder.getImageContentBinding().tvChatContent.setText((CharSequence)spannableString);
                    Context context = LiveShowChatFragment.this.getContext();
                    if (context != null) {
                        Context context2 = context;
                        LiveShowChatFragment liveShowChatFragment = LiveShowChatFragment.this;
                        Context it = context2;
                        boolean bl = false;
                        String string3 = message.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message.url");
                        if (StringsKt.endsWith$default((String)string3, (String)".gif", (boolean)false, (int)2, null)) {
                            ImageView imageView = imageViewHolder.getImageContentBinding().ivChatContent;
                            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imageViewHolder.imageContentBinding.ivChatContent");
                            String string4 = message.getUrl();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message.url");
                            liveShowChatFragment.loadGif(imageView, string4, position);
                        } else {
                            ImageView imageView = imageViewHolder.getImageContentBinding().ivChatContent;
                            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imageViewHolder.imageContentBinding.ivChatContent");
                            String string5 = message.getUrl();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message.url");
                            liveShowChatFragment.loadBitmap(imageView, string5);
                        }
                    }
                    imageViewHolder.getImageContentBinding().ivChatContent.setOnClickListener(arg_0 -> MessageAdapter.onBindViewHolder$lambda$1(LiveShowChatFragment.this, message, arg_0));
                    break;
                }
                case 2: {
                    TextViewHolder textViewHolder = (TextViewHolder)viewHolder;
                    Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
                    ControlClickSpanTextView controlClickSpanTextView = textViewHolder.getTextContentBinding().tvChatContent;
                    Intrinsics.checkNotNullExpressionValue((Object)controlClickSpanTextView, (String)"textViewHolder.textContentBinding.tvChatContent");
                    spannableString.append((CharSequence)LiveShowChatFragment.this.getRewardText(message, (TextView)controlClickSpanTextView));
                    ((TextViewHolder)viewHolder).getTextContentBinding().tvChatContent.setText((CharSequence)spannableString);
                    break;
                }
                default: {
                    TextViewHolder textViewHolder = (TextViewHolder)viewHolder;
                    String string6 = message.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message.content");
                    ControlClickSpanTextView controlClickSpanTextView = textViewHolder.getTextContentBinding().tvChatContent;
                    Intrinsics.checkNotNullExpressionValue((Object)controlClickSpanTextView, (String)"textViewHolder.textContentBinding.tvChatContent");
                    spannableString.append((CharSequence)LiveShowChatFragment.this.getMixText(string6, (TextView)controlClickSpanTextView, textViewHolder));
                    ((TextViewHolder)viewHolder).getTextContentBinding().tvChatContent.setText((CharSequence)spannableString);
                    if (message.getReference() != null) {
                        String referenceMessage = message.getReference().content;
                        SpannableStringBuilder referenceMessageSsb = new SpannableStringBuilder();
                        if (message.getReference().getMessageType() == LPConstants.MessageType.Reward) {
                            LPMessageReferenceModel lPMessageReferenceModel = message.getReference();
                            Intrinsics.checkNotNullExpressionValue((Object)lPMessageReferenceModel, (String)"message.reference");
                            IMessageModel iMessageModel = (IMessageModel)lPMessageReferenceModel;
                            TextView textView = ((TextViewHolder)viewHolder).getTextContentBinding().referenceTv;
                            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewHolder.textContentBinding.referenceTv");
                            referenceMessageSsb.append((CharSequence)LiveShowChatFragment.this.getRewardText(iMessageModel, textView));
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)referenceMessage, (String)"referenceMessage");
                            TextView textView = ((TextViewHolder)viewHolder).getTextContentBinding().referenceTv;
                            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewHolder.textContentBinding.referenceTv");
                            referenceMessageSsb.append((CharSequence)LiveShowChatFragment.this.getMixText(referenceMessage, textView, (TextViewHolder)viewHolder));
                        }
                        if (Intrinsics.areEqual((Object)message.getFrom().getNumber(), (Object)LiveShowChatFragment.this.getRouterViewModel().getLiveRoom().getCurrentUser().getNumber())) {
                            ((TextViewHolder)viewHolder).getTextContentBinding().referenceTv.setTextColor(ContextCompat.getColor((Context)((TextViewHolder)viewHolder).getTextContentBinding().referenceTv.getContext(), (int)R.color.bjy_base_assistant_reference_text_color_self));
                        } else {
                            ((TextViewHolder)viewHolder).getTextContentBinding().referenceTv.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)LiveShowChatFragment.this.getContext(), (int)R.attr.base_theme_window_assistant_text_color));
                        }
                        ((TextViewHolder)viewHolder).getTextContentBinding().referenceTv.setOnClickListener(arg_0 -> MessageAdapter.onBindViewHolder$lambda$2(viewHolder, this, arg_0));
                        ((TextViewHolder)viewHolder).getTextContentBinding().referenceTv.setVisibility(0);
                        ((TextViewHolder)viewHolder).getTextContentBinding().referenceTv.setText((CharSequence)referenceMessageSsb);
                    } else {
                        ((TextViewHolder)viewHolder).getTextContentBinding().referenceTv.setVisibility(8);
                    }
                    if (message.getFrom().getType() == LPConstants.LPUserType.Teacher || message.getFrom().getType() == LPConstants.LPUserType.Assistant) {
                        ControlClickSpanTextView controlClickSpanTextView2 = ((TextViewHolder)viewHolder).getTextContentBinding().tvChatContent;
                        Intrinsics.checkNotNullExpressionValue((Object)controlClickSpanTextView2, (String)"viewHolder.textContentBinding.tvChatContent");
                        HyperLinkHelper.INSTANCE.applyUrlSpan((TextView)controlClickSpanTextView2);
                        LiveRoom liveRoom2 = LiveShowChatFragment.this.getRouterViewModel().getLiveRoom();
                        ControlClickSpanTextView controlClickSpanTextView3 = ((TextViewHolder)viewHolder).getTextContentBinding().tvChatContent;
                        Intrinsics.checkNotNullExpressionValue((Object)controlClickSpanTextView3, (String)"viewHolder.textContentBinding.tvChatContent");
                        ExtensionKt.reportProductLinkEvent((LiveRoom)liveRoom2, (TextView)((TextView)controlClickSpanTextView3));
                        break;
                    }
                    ((TextViewHolder)viewHolder).getTextContentBinding().tvChatContent.setAutoLinkMask(0);
                }
            }
            GestureDetectorCompat gestureDetectorCompat2 = new GestureDetectorCompat(LiveShowChatFragment.this.getContextReference(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(message, this, viewHolder){
                final /* synthetic */ IMessageModel $message;
                final /* synthetic */ MessageAdapter this$0;
                final /* synthetic */ RecyclerView.ViewHolder $viewHolder;
                {
                    this.$message = $message;
                    this.this$0 = $receiver;
                    this.$viewHolder = $viewHolder;
                }

                public void onLongPress(@NotNull MotionEvent e) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        super.onLongPress(e);
                        IMessageModel iMessageModel = this.$message;
                        if (iMessageModel == null) break block0;
                        IMessageModel iMessageModel2 = iMessageModel;
                        MessageAdapter messageAdapter2 = this.this$0;
                        RecyclerView.ViewHolder viewHolder = this.$viewHolder;
                        IMessageModel iMessageModel3 = this.$message;
                        IMessageModel $this$onLongPress_u24lambda_u240 = iMessageModel2;
                        boolean bl = false;
                        int n = (int)e.getRawX();
                        int n2 = (int)e.getRawY();
                        View view = viewHolder.itemView;
                        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"viewHolder.itemView");
                        Intrinsics.checkNotNullExpressionValue((Object)iMessageModel3, (String)"message");
                        MessageAdapter.access$showMenu(messageAdapter2, n, n2, view, iMessageModel3);
                    }
                }
            });
            viewHolder.itemView.setOnTouchListener((arg_0, arg_1) -> MessageAdapter.onBindViewHolder$lambda$3(gestureDetectorCompat2, arg_0, arg_1));
            if (viewHolder instanceof TextViewHolder) {
                ((TextViewHolder)viewHolder).getTextContentBinding().tvChatContent.setOnTouchListener((arg_0, arg_1) -> MessageAdapter.onBindViewHolder$lambda$4(gestureDetectorCompat2, arg_0, arg_1));
            }
        }

        private final void showMenu(int x, int y, View parentView, IMessageModel iMessageModel) {
            ListView listView;
            Context context = LiveShowChatFragment.this.getContext();
            LiveShowChatFragment liveShowChatFragment = LiveShowChatFragment.this;
            Context $this$showMenu_u24lambda_u247 = context;
            boolean bl = false;
            PopupWindow popupWindow = new PopupWindow($this$showMenu_u24lambda_u247);
            popupWindow.setFocusable(true);
            popupWindow.setWidth(UtilsKt.getDp((int)80));
            popupWindow.setHeight(-2);
            popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            ArrayList<String> items = new ArrayList<String>();
            items.add(liveShowChatFragment.getString(R.string.live_chat_copy));
            IUserModel iUserModel = iMessageModel.getFrom();
            IUserModel iUserModel2 = liveShowChatFragment.getRouterViewModel().getLiveRoom().getCurrentUser();
            if (!Intrinsics.areEqual((Object)(iUserModel != null ? iUserModel.getNumber() : null), (Object)(iUserModel2 != null ? iUserModel2.getNumber() : null))) {
                items.add(liveShowChatFragment.getString(R.string.bjy_base_chat_report));
            }
            ListView $this$showMenu_u24lambda_u247_u24lambda_u246 = listView = new ListView(liveShowChatFragment.getContext());
            boolean bl2 = false;
            GradientDrawable bgDrawable = new GradientDrawable();
            bgDrawable.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)$this$showMenu_u24lambda_u247_u24lambda_u246.getContext(), (int)R.attr.base_theme_window_bg_color));
            bgDrawable.setStroke(1, ContextCompat.getColor((Context)$this$showMenu_u24lambda_u247_u24lambda_u246.getContext(), (int)R.color.base_bg_stroke));
            bgDrawable.setCornerRadius((float)$this$showMenu_u24lambda_u247_u24lambda_u246.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
            $this$showMenu_u24lambda_u247_u24lambda_u246.setBackground((Drawable)bgDrawable);
            Context context2 = $this$showMenu_u24lambda_u247_u24lambda_u246.getContext();
            Collection $this$toTypedArray$iv = items;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)objectArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            $this$showMenu_u24lambda_u247_u24lambda_u246.setAdapter((ListAdapter)new ArrayAdapter(context2, R.layout.bjy_menu_chat_message, objectArray));
            $this$showMenu_u24lambda_u247_u24lambda_u246.setDividerHeight(0);
            $this$showMenu_u24lambda_u247_u24lambda_u246.setPadding(0, UtilsKt.getDp((int)2), 0, UtilsKt.getDp((int)2));
            $this$showMenu_u24lambda_u247_u24lambda_u246.setOnItemClickListener((arg_0, arg_1, arg_2, arg_3) -> MessageAdapter.showMenu$lambda$7$lambda$6$lambda$5(items, $this$showMenu_u24lambda_u247_u24lambda_u246, iMessageModel, liveShowChatFragment, popupWindow, arg_0, arg_1, arg_2, arg_3));
            popupWindow.setContentView((View)listView);
            popupWindow.showAtLocation(parentView, 0, x - popupWindow.getWidth() / 2, y - popupWindow.getHeight());
        }

        public void onViewRecycled(@NotNull RecyclerView.ViewHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            if (holder instanceof ImageViewHolder) {
                Glide.with((Context)LiveShowChatFragment.this.requireContext()).clear((View)((ImageViewHolder)holder).getImageContentBinding().ivChatContent);
                Drawable drawable2 = ((ImageViewHolder)holder).getImageContentBinding().ivChatContent.getDrawable();
                if (drawable2 != null && drawable2 instanceof GifDrawable) {
                    ((GifDrawable)drawable2).setLoopCount(0);
                    ((GifDrawable)drawable2).stop();
                }
                ColorDrawable failedColorDrawable = new ColorDrawable(ContextCompat.getColor((Context)LiveShowChatFragment.this.requireContext(), (int)R.color.live_half_transparent));
                ((ImageViewHolder)holder).getImageContentBinding().ivChatContent.setImageDrawable((Drawable)failedColorDrawable);
            } else if (holder instanceof TextViewHolder) {
                ((TextViewHolder)holder).clearGifCache();
            }
            super.onViewRecycled(holder);
        }

        private static final void onBindViewHolder$lambda$1(LiveShowChatFragment this$0, IMessageModel $message, View it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            String string2 = $message.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message.url");
            this$0.showBigChatPic(string2);
        }

        private static final void onBindViewHolder$lambda$2(RecyclerView.ViewHolder $viewHolder, MessageAdapter this$0, View it) {
            Intrinsics.checkNotNullParameter((Object)$viewHolder, (String)"$viewHolder");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            ((TextViewHolder)$viewHolder).getTextContentBinding().referenceTv.setMaxLines(this$0.referenceTvMaxLines == 3 ? (this$0.referenceTvMaxLines = Integer.MAX_VALUE) : (this$0.referenceTvMaxLines = 3));
        }

        private static final boolean onBindViewHolder$lambda$3(GestureDetectorCompat $gestureDetectorCompat, View view, MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)$gestureDetectorCompat, (String)"$gestureDetectorCompat");
            $gestureDetectorCompat.onTouchEvent(event);
            return true;
        }

        private static final boolean onBindViewHolder$lambda$4(GestureDetectorCompat $gestureDetectorCompat, View view, MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)$gestureDetectorCompat, (String)"$gestureDetectorCompat");
            return $gestureDetectorCompat.onTouchEvent(event);
        }

        private static final void showMenu$lambda$7$lambda$6$lambda$5(ArrayList $items, ListView $this_with, IMessageModel $iMessageModel, LiveShowChatFragment this$0, PopupWindow $popupWindow, AdapterView adapterView, View view, int position, long l) {
            Intrinsics.checkNotNullParameter((Object)$items, (String)"$items");
            Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
            Intrinsics.checkNotNullParameter((Object)$iMessageModel, (String)"$iMessageModel");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$popupWindow, (String)"$popupWindow");
            String string2 = (String)$items.get(position);
            if (Intrinsics.areEqual((Object)string2, (Object)$this_with.getResources().getString(R.string.live_chat_copy))) {
                if ($iMessageModel.getMessageType() == LPConstants.MessageType.Image) {
                    Context context = $this_with.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    UtilsKt.copy((Context)context, (String)("[img:" + $iMessageModel.getUrl() + ']'));
                } else {
                    Context context = $this_with.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    String string3 = $iMessageModel.getContent();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"iMessageModel.content");
                    UtilsKt.copy((Context)context, (String)string3);
                }
            } else if (Intrinsics.areEqual((Object)string2, (Object)this$0.getString(R.string.bjy_base_chat_report))) {
                this$0.getRouterViewModel().getAction2Report().postValue((Object)$iMessageModel);
            }
            $popupWindow.dismiss();
        }

        public static final /* synthetic */ void access$showMenu(MessageAdapter $this, int x, int y, View parentView, IMessageModel iMessageModel) {
            $this.showMenu(x, y, parentView, iMessageModel);
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[LPConstants.MessageType.values().length];
                try {
                    nArray[LPConstants.MessageType.Image.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LPConstants.MessageType.Reward.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[LPConstants.LPUserType.values().length];
                try {
                    nArray[LPConstants.LPUserType.Teacher.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LPConstants.LPUserType.Assistant.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment$TextViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "contentView", "Landroid/view/View;", "(Landroid/view/View;)V", "gifDrawables", "", "Lcom/baijiayun/livebase/utils/URLImageParser$GlideGifDrawable;", "imageParserList", "Lcom/baijiayun/livebase/utils/URLImageParser;", "textContentBinding", "Lcom/baijiayun/liveshow/ui/databinding/BjyShowItemChatTextContentBinding;", "getTextContentBinding", "()Lcom/baijiayun/liveshow/ui/databinding/BjyShowItemChatTextContentBinding;", "clearGifCache", "", "setGifCache", "drawables", "liveplayer-sdk-live-show_release"})
    public static final class TextViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final BjyShowItemChatTextContentBinding textContentBinding;
        @Nullable
        private List<? extends URLImageParser.GlideGifDrawable> gifDrawables;
        @Nullable
        private List<? extends URLImageParser> imageParserList;

        public TextViewHolder(@NotNull View contentView) {
            Intrinsics.checkNotNullParameter((Object)contentView, (String)"contentView");
            super(contentView);
            BjyShowItemChatTextContentBinding bjyShowItemChatTextContentBinding = BjyShowItemChatTextContentBinding.bind(contentView);
            Intrinsics.checkNotNullExpressionValue((Object)bjyShowItemChatTextContentBinding, (String)"bind(contentView)");
            this.textContentBinding = bjyShowItemChatTextContentBinding;
        }

        @NotNull
        public final BjyShowItemChatTextContentBinding getTextContentBinding() {
            return this.textContentBinding;
        }

        public final void setGifCache(@NotNull List<? extends URLImageParser.GlideGifDrawable> drawables, @NotNull List<? extends URLImageParser> imageParserList) {
            Intrinsics.checkNotNullParameter(drawables, (String)"drawables");
            Intrinsics.checkNotNullParameter(imageParserList, (String)"imageParserList");
            this.gifDrawables = drawables;
            this.imageParserList = imageParserList;
        }

        public final void clearGifCache() {
            if (this.gifDrawables != null) {
                List<? extends URLImageParser.GlideGifDrawable> list = this.gifDrawables;
                Intrinsics.checkNotNull(list);
                for (URLImageParser.GlideGifDrawable glideGifDrawable : list) {
                    glideGifDrawable.onDestroy();
                }
            }
            if (this.imageParserList != null) {
                List<? extends URLImageParser> list = this.imageParserList;
                Intrinsics.checkNotNull(list);
                for (URLImageParser uRLImageParser : list) {
                    uRLImageParser.onDestroy();
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment$ImageViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "contentView", "Landroid/view/View;", "(Landroid/view/View;)V", "imageContentBinding", "Lcom/baijiayun/liveshow/ui/databinding/BjyShowItemChatImageContentBinding;", "getImageContentBinding", "()Lcom/baijiayun/liveshow/ui/databinding/BjyShowItemChatImageContentBinding;", "liveplayer-sdk-live-show_release"})
    public static final class ImageViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final BjyShowItemChatImageContentBinding imageContentBinding;

        public ImageViewHolder(@NotNull View contentView) {
            Intrinsics.checkNotNullParameter((Object)contentView, (String)"contentView");
            super(contentView);
            BjyShowItemChatImageContentBinding bjyShowItemChatImageContentBinding = BjyShowItemChatImageContentBinding.bind(contentView);
            Intrinsics.checkNotNullExpressionValue((Object)bjyShowItemChatImageContentBinding, (String)"bind(contentView)");
            this.imageContentBinding = bjyShowItemChatImageContentBinding;
        }

        @NotNull
        public final BjyShowItemChatImageContentBinding getImageContentBinding() {
            return this.imageContentBinding;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment$Companion;", "", "()V", "newInstance", "Lcom/baijiayun/liveshow/ui/chat/LiveShowChatFragment;", "liveplayer-sdk-live-show_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LiveShowChatFragment newInstance() {
            return new LiveShowChatFragment();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

