/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.chat;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.LPChatMessageParser;
import com.baijiayun.livebase.utils.URLImageParser;
import com.baijiayun.livecore.models.LPMessageModel;
import com.baijiayun.livecore.models.imodels.IMessageModel;
import com.baijiayun.liveshow.ui.R;
import com.baijiayun.liveshow.ui.chat.ChatViewModel;
import com.baijiayun.liveshow.ui.databinding.BjyShowItemChatBannerBinding;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.widgets.chat.CenterImageSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0018\u00010\u0002R\u00020\u0000H\u0002J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u001c\u0010\u001b\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\rH\u0016J\u0014\u0010\u001f\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u0002R\u00020\u0000H\u0016J\u0014\u0010 \u001a\u00020\u00182\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/baijiayun/liveshow/ui/chat/ChatBannerAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/baijiayun/liveshow/ui/chat/ChatBannerAdapter$BannerViewHolder;", "chatViewModel", "Lcom/baijiayun/liveshow/ui/chat/ChatViewModel;", "(Lcom/baijiayun/liveshow/ui/chat/ChatViewModel;)V", "emojiPattern", "Ljava/util/regex/Pattern;", "messages", "Ljava/util/ArrayList;", "Lcom/baijiayun/livecore/models/imodels/IMessageModel;", "Lkotlin/collections/ArrayList;", "getItemCount", "", "getMixText", "Landroid/text/SpannableStringBuilder;", "srcContent", "", "textView", "Landroid/widget/TextView;", "textViewHolder", "getRewardText", "message", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewRecycled", "setData", "", "BannerViewHolder", "liveplayer-sdk-live-show_release"})
public final class ChatBannerAdapter
extends RecyclerView.Adapter<BannerViewHolder> {
    @NotNull
    private final ChatViewModel chatViewModel;
    @NotNull
    private final Pattern emojiPattern;
    @NotNull
    private final ArrayList<IMessageModel> messages;

    public ChatBannerAdapter(@NotNull ChatViewModel chatViewModel2) {
        Intrinsics.checkNotNullParameter((Object)((Object)chatViewModel2), (String)"chatViewModel");
        this.chatViewModel = chatViewModel2;
        Pattern pattern = Pattern.compile("\\[[a-zA-Z0-9\u4e00-\u9fa5]+]");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"\\\\[[a-zA-Z0-9\\u4e00-\\u9fa5]+]\")");
        this.emojiPattern = pattern;
        this.messages = new ArrayList();
    }

    @NotNull
    public BannerViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_show_item_chat_banner, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        return new BannerViewHolder(view);
    }

    public void onBindViewHolder(@NotNull BannerViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        if (this.messages.size() == 0) {
            return;
        }
        IMessageModel iMessageModel = this.messages.get(position % this.messages.size());
        Intrinsics.checkNotNullExpressionValue((Object)iMessageModel, (String)"messages[position % messages.size]");
        IMessageModel messageModel = iMessageModel;
        if (messageModel instanceof LPMessageModel) {
            ((LPMessageModel)messageModel).parse(new LPChatMessageParser(this.chatViewModel.getExpressions()));
        }
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        LPConstants.MessageType messageType = messageModel.getMessageType();
        switch (messageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
            case 1: {
                TextView textView = holder.getBinding().contentTv;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"holder.binding.contentTv");
                ssb.append((CharSequence)this.getRewardText(messageModel, textView));
                break;
            }
            case 2: {
                ssb.append((CharSequence)holder.getBinding().getRoot().getContext().getString(R.string.live_chat_sticky_not_support_pic));
                break;
            }
            default: {
                String string2 = messageModel.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"messageModel.content");
                TextView textView = holder.getBinding().contentTv;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"holder.binding.contentTv");
                ssb.append((CharSequence)this.getMixText(string2, textView, holder));
            }
        }
        holder.getBinding().nameTv.setText((CharSequence)('@' + messageModel.getFrom().getName()));
        holder.getBinding().contentTv.setText((CharSequence)ssb);
    }

    public int getItemCount() {
        return this.messages.size();
    }

    public final void setData(@NotNull List<? extends IMessageModel> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        this.messages.clear();
        this.messages.addAll((Collection<IMessageModel>)messages);
        this.notifyDataSetChanged();
    }

    private final SpannableStringBuilder getMixText(String srcContent, TextView textView, BannerViewHolder textViewHolder) {
        SpannableStringBuilder ssb = SpannableStringBuilder.valueOf((CharSequence)srcContent);
        Matcher emojiMatcher = this.emojiPattern.matcher(ssb.toString());
        List cacheDrawables = null;
        List imageParserList = null;
        while (emojiMatcher.find()) {
            String group = emojiMatcher.group();
            if (!this.chatViewModel.getExpressions().containsKey(group)) continue;
            URLImageParser urlImageParser = new URLImageParser(textView, textView.getTextSize());
            Drawable drawable2 = urlImageParser.getDrawable(this.chatViewModel.getExpressions().get(group));
            CenterImageSpan centerImageSpan = new CenterImageSpan(drawable2, 1);
            ssb.setSpan((Object)centerImageSpan, emojiMatcher.start(), emojiMatcher.end(), 34);
            ssb.removeSpan((Object)group);
            if (textViewHolder == null || !(drawable2 instanceof URLImageParser.GlideGifDrawable)) continue;
            if (cacheDrawables == null) {
                cacheDrawables = new ArrayList();
            }
            cacheDrawables.add(drawable2);
            if (imageParserList == null) {
                imageParserList = new ArrayList();
            }
            imageParserList.add(urlImageParser);
        }
        if (cacheDrawables != null && imageParserList != null && textViewHolder != null) {
            textViewHolder.setGifCache(cacheDrawables, imageParserList);
        }
        Intrinsics.checkNotNullExpressionValue((Object)ssb, (String)"ssb");
        return ssb;
    }

    static /* synthetic */ SpannableStringBuilder getMixText$default(ChatBannerAdapter chatBannerAdapter, String string2, TextView textView, BannerViewHolder bannerViewHolder, int n, Object object) {
        if ((n & 4) != 0) {
            bannerViewHolder = null;
        }
        return chatBannerAdapter.getMixText(string2, textView, bannerViewHolder);
    }

    @NotNull
    public final SpannableStringBuilder getRewardText(@NotNull IMessageModel message, @NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        String string2 = textView.getContext().getString(R.string.bjy_live_reward_gift_prefix);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"textView.context.getStri\u2026_live_reward_gift_prefix)");
        String giftPrefix = string2;
        String string3 = textView.getContext().getString(R.string.bjy_live_reward_cash_prefix);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"textView.context.getStri\u2026_live_reward_cash_prefix)");
        String cashPrefix = string3;
        String string4 = textView.getContext().getResources().getString(R.string.bjy_live_reward_cash_suffix);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"textView.context.resourc\u2026_live_reward_cash_suffix)");
        String cashSuffix = string4;
        if (TextUtils.isEmpty((CharSequence)message.getData().giftName)) {
            ssb.append((CharSequence)cashPrefix).append((CharSequence)" ").append((CharSequence)"\uffe5").append((CharSequence)message.getData().price).append((CharSequence)" ").append((CharSequence)cashSuffix).setSpan((Object)new StyleSpan(1), cashPrefix.length() + 1, cashPrefix.length() + message.getData().price.length() + 2, 34);
        } else {
            ssb.append((CharSequence)giftPrefix).append((CharSequence)message.getData().giftName).setSpan((Object)new StyleSpan(1), giftPrefix.length(), giftPrefix.length() + message.getData().giftName.length(), 34);
            ssb.append((CharSequence)" ").append((CharSequence)cashSuffix);
            URLImageParser urlImageParser = new URLImageParser(textView, textView.getTextSize());
            Drawable drawable2 = urlImageParser.getDrawable(message.getData().giftImg);
            CenterImageSpan centerImageSpan = new CenterImageSpan(drawable2, 1);
            ssb.setSpan((Object)centerImageSpan, giftPrefix.length() + message.getData().giftName.length() + 1, giftPrefix.length() + message.getData().giftName.length() + cashSuffix.length() + 1, 34);
            ssb.removeSpan((Object)cashSuffix);
        }
        return ssb;
    }

    public void onViewRecycled(@NotNull BannerViewHolder holder) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.clearGifCache();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\"\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/baijiayun/liveshow/ui/chat/ChatBannerAdapter$BannerViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lcom/baijiayun/liveshow/ui/chat/ChatBannerAdapter;Landroid/view/View;)V", "binding", "Lcom/baijiayun/liveshow/ui/databinding/BjyShowItemChatBannerBinding;", "getBinding", "()Lcom/baijiayun/liveshow/ui/databinding/BjyShowItemChatBannerBinding;", "gifDrawables", "", "Lcom/baijiayun/livebase/utils/URLImageParser$GlideGifDrawable;", "imageParserList", "Lcom/baijiayun/livebase/utils/URLImageParser;", "clearGifCache", "", "setGifCache", "drawables", "liveplayer-sdk-live-show_release"})
    public final class BannerViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final BjyShowItemChatBannerBinding binding;
        @Nullable
        private List<? extends URLImageParser.GlideGifDrawable> gifDrawables;
        @Nullable
        private List<? extends URLImageParser> imageParserList;

        public BannerViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            BjyShowItemChatBannerBinding bjyShowItemChatBannerBinding = BjyShowItemChatBannerBinding.bind(itemView);
            Intrinsics.checkNotNullExpressionValue((Object)bjyShowItemChatBannerBinding, (String)"bind(itemView)");
            this.binding = bjyShowItemChatBannerBinding;
            this.binding.getRoot().setBackground(new DrawableBuilder().solidColor(Color.parseColor((String)"#B8FFFFFF")).cornerRadius(UtilsKt.getDp((int)4)).build());
        }

        @NotNull
        public final BjyShowItemChatBannerBinding getBinding() {
            return this.binding;
        }

        public final void setGifCache(@NotNull List<? extends URLImageParser.GlideGifDrawable> drawables, @NotNull List<? extends URLImageParser> imageParserList) {
            Intrinsics.checkNotNullParameter(drawables, (String)"drawables");
            Intrinsics.checkNotNullParameter(imageParserList, (String)"imageParserList");
            this.gifDrawables = drawables;
            this.imageParserList = imageParserList;
        }

        public final void clearGifCache() {
            if (this.gifDrawables != null) {
                List<? extends URLImageParser.GlideGifDrawable> list = this.gifDrawables;
                Intrinsics.checkNotNull(list);
                for (URLImageParser.GlideGifDrawable glideGifDrawable : list) {
                    glideGifDrawable.onDestroy();
                }
            }
            if (this.imageParserList != null) {
                List<? extends URLImageParser> list = this.imageParserList;
                Intrinsics.checkNotNull(list);
                for (URLImageParser uRLImageParser : list) {
                    uRLImageParser.onDestroy();
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LPConstants.MessageType.values().length];
            try {
                nArray[LPConstants.MessageType.Reward.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LPConstants.MessageType.Image.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

