/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui.view;

import android.graphics.Rect;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.liveshow.ui.view.IPageJudge;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00101\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020/H\u0002J\n\u00104\u001a\u0004\u0018\u000105H\u0016J\u0010\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0016J\b\u00108\u001a\u00020\u0004H\u0002J\b\u00109\u001a\u00020\u0004H\u0002J\u0010\u0010:\u001a\u00020,2\u0006\u00107\u001a\u00020\u0004H\u0016J\u0010\u0010;\u001a\u00020,2\u0006\u00107\u001a\u00020\u0004H\u0016J\u0010\u0010<\u001a\u00020,2\u0006\u0010=\u001a\u00020\u0004H\u0016J \u0010>\u001a\u0002032\b\u0010?\u001a\u0004\u0018\u00010@2\f\u0010A\u001a\b\u0018\u00010BR\u00020@H\u0016J\u001c\u0010C\u001a\u0002032\n\u0010A\u001a\u00060BR\u00020@2\u0006\u0010.\u001a\u00020/H\u0016J\u001c\u0010D\u001a\u0002032\n\u0010A\u001a\u00060BR\u00020@2\u0006\u0010.\u001a\u00020/H\u0002J$\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u00042\n\u0010A\u001a\u00060BR\u00020@2\u0006\u0010.\u001a\u00020/H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\rR\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000b\"\u0004\b\u0019\u0010\rR\u001a\u0010\u001a\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000b\"\u0004\b\u001c\u0010\rR\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000b\"\u0004\b\u001f\u0010\rR\u001a\u0010 \u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000b\"\u0004\b\"\u0010\rR\u001a\u0010#\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000b\"\u0004\b%\u0010\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000b\"\u0004\b'\u0010\rR\u001a\u0010(\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u000b\"\u0004\b*\u0010\r\u00a8\u0006G"}, d2={"Lcom/baijiayun/liveshow/ui/view/HorizontalPageLayoutManager;", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "Lcom/baijiayun/liveshow/ui/view/IPageJudge;", "rows", "", "columns", "(II)V", "allItemFrames", "Landroid/util/SparseArray;", "Landroid/graphics/Rect;", "getColumns", "()I", "setColumns", "(I)V", "itemHeight", "getItemHeight", "setItemHeight", "itemHeightUsed", "getItemHeightUsed", "setItemHeightUsed", "itemWidth", "getItemWidth", "setItemWidth", "itemWidthUsed", "getItemWidthUsed", "setItemWidthUsed", "offsetX", "getOffsetX", "setOffsetX", "offsetY", "getOffsetY", "setOffsetY", "onePageSize", "getOnePageSize", "setOnePageSize", "pageSize", "getPageSize", "setPageSize", "getRows", "setRows", "totalWidth", "getTotalWidth", "setTotalWidth", "canScrollHorizontally", "", "computeHorizontalScrollExtent", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "computeHorizontalScrollOffset", "computeHorizontalScrollRange", "computePageSize", "", "generateDefaultLayoutParams", "Landroidx/recyclerview/widget/RecyclerView$LayoutParams;", "getPageIndex", "position", "getUsableHeight", "getUsableWidth", "isLastColumn", "isLastPage", "isLastRow", "index", "onDetachedFromWindow", "view", "Landroidx/recyclerview/widget/RecyclerView;", "recycler", "Landroidx/recyclerview/widget/RecyclerView$Recycler;", "onLayoutChildren", "recycleAndFillItems", "scrollHorizontallyBy", "dx", "liveplayer-sdk-live-show_release"})
public final class HorizontalPageLayoutManager
extends RecyclerView.LayoutManager
implements IPageJudge {
    private int totalWidth;
    private int offsetY;
    private int offsetX;
    @NotNull
    private final SparseArray<Rect> allItemFrames = new SparseArray();
    private int rows;
    private int columns;
    private int pageSize;
    private int itemWidth;
    private int itemHeight;
    private int onePageSize;
    private int itemWidthUsed;
    private int itemHeightUsed;

    public HorizontalPageLayoutManager(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.onePageSize = rows * columns;
    }

    @Nullable
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public final int getTotalWidth() {
        return this.totalWidth;
    }

    public final void setTotalWidth(int n) {
        this.totalWidth = n;
    }

    public final int getOffsetY() {
        return this.offsetY;
    }

    public final void setOffsetY(int n) {
        this.offsetY = n;
    }

    public final int getOffsetX() {
        return this.offsetX;
    }

    public final void setOffsetX(int n) {
        this.offsetX = n;
    }

    public boolean canScrollHorizontally() {
        return true;
    }

    public int scrollHorizontallyBy(int dx, @NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.detachAndScrapAttachedViews(recycler);
        int newX = this.offsetX + dx;
        int result = dx;
        if (newX > this.totalWidth) {
            result = this.totalWidth - this.offsetX;
        } else if (newX < 0) {
            result = 0 - this.offsetX;
        }
        this.offsetX += result;
        this.offsetChildrenHorizontal(-result);
        this.recycleAndFillItems(recycler, state);
        return result;
    }

    private final int getUsableWidth() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private final int getUsableHeight() {
        return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    public final int getRows() {
        return this.rows;
    }

    public final void setRows(int n) {
        this.rows = n;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final void setColumns(int n) {
        this.columns = n;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final void setPageSize(int n) {
        this.pageSize = n;
    }

    public final int getItemWidth() {
        return this.itemWidth;
    }

    public final void setItemWidth(int n) {
        this.itemWidth = n;
    }

    public final int getItemHeight() {
        return this.itemHeight;
    }

    public final void setItemHeight(int n) {
        this.itemHeight = n;
    }

    public final int getOnePageSize() {
        return this.onePageSize;
    }

    public final void setOnePageSize(int n) {
        this.onePageSize = n;
    }

    public final int getItemWidthUsed() {
        return this.itemWidthUsed;
    }

    public final void setItemWidthUsed(int n) {
        this.itemWidthUsed = n;
    }

    public final int getItemHeightUsed() {
        return this.itemHeightUsed;
    }

    public final void setItemHeightUsed(int n) {
        this.itemHeightUsed = n;
    }

    public void onLayoutChildren(@NotNull RecyclerView.Recycler recycler, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)recycler, (String)"recycler");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.getItemCount() == 0) {
            this.removeAndRecycleAllViews(recycler);
            return;
        }
        if (state.isPreLayout()) {
            return;
        }
        this.itemWidth = this.getUsableWidth() / this.columns;
        this.itemHeight = this.getUsableHeight() / this.rows;
        this.itemWidthUsed = (this.columns - 1) * this.itemWidth;
        this.itemHeightUsed = (this.rows - 1) * this.itemHeight;
        this.computePageSize(state);
        Log.i((String)"wtf", (String)("itemCount=" + this.getItemCount() + " state itemCount=" + state.getItemCount() + " pageSize=" + this.pageSize));
        this.totalWidth = (this.pageSize - 1) * this.getWidth();
        this.detachAndScrapAttachedViews(recycler);
        int count = this.getItemCount();
        for (int p = 0; p < this.pageSize; ++p) {
            block1: for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.columns; ++c) {
                    View view;
                    int index = p * this.onePageSize + r * this.columns + c;
                    if (index == count) {
                        c = this.columns;
                        r = this.rows;
                        p = this.pageSize;
                        continue block1;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)recycler.getViewForPosition(index), (String)"recycler.getViewForPosition(index)");
                    this.addView(view);
                    this.measureChildWithMargins(view, this.itemWidthUsed, this.itemHeightUsed);
                    int width = this.getDecoratedMeasuredWidth(view);
                    int height = this.getDecoratedMeasuredHeight(view);
                    Rect rect = (Rect)this.allItemFrames.get(index);
                    if (rect == null) {
                        rect = new Rect();
                    }
                    int x = p * this.getUsableWidth() + c * this.itemWidth;
                    int y = r * this.itemHeight;
                    rect.set(x, y, width + x, height + y);
                    this.allItemFrames.put(index, (Object)rect);
                }
            }
            this.removeAndRecycleAllViews(recycler);
        }
        this.recycleAndFillItems(recycler, state);
    }

    private final void computePageSize(RecyclerView.State state) {
        this.pageSize = state.getItemCount() / this.onePageSize + (state.getItemCount() % this.onePageSize == 0 ? 0 : 1);
    }

    public void onDetachedFromWindow(@Nullable RecyclerView view, @Nullable RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        this.offsetX = 0;
        this.offsetY = 0;
    }

    private final void recycleAndFillItems(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int i;
        if (state.isPreLayout()) {
            return;
        }
        Rect displayRect = new Rect(this.getPaddingLeft() + this.offsetX, this.getPaddingTop(), this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() + this.offsetX, this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
        Rect childRect = new Rect();
        int n = this.getChildCount();
        for (i = 0; i < n; ++i) {
            View $this$recycleAndFillItems_u24lambda_u240;
            View child = this.getChildAt(i);
            if (child == null) continue;
            boolean bl = false;
            childRect.left = this.getDecoratedLeft($this$recycleAndFillItems_u24lambda_u240);
            childRect.top = this.getDecoratedTop($this$recycleAndFillItems_u24lambda_u240);
            childRect.right = this.getDecoratedRight($this$recycleAndFillItems_u24lambda_u240);
            childRect.bottom = this.getDecoratedBottom($this$recycleAndFillItems_u24lambda_u240);
            if (Rect.intersects((Rect)displayRect, (Rect)childRect)) continue;
            this.removeAndRecycleView($this$recycleAndFillItems_u24lambda_u240, recycler);
        }
        n = this.getItemCount();
        for (i = 0; i < n; ++i) {
            Rect $this$recycleAndFillItems_u24lambda_u241;
            View view;
            if (!Rect.intersects((Rect)displayRect, (Rect)((Rect)this.allItemFrames.get(i)))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)recycler.getViewForPosition(i), (String)"recycler.getViewForPosition(i)");
            this.addView(view);
            this.measureChildWithMargins(view, this.itemWidthUsed, this.itemHeightUsed);
            Rect rect = (Rect)this.allItemFrames.get(i);
            if (rect == null) continue;
            boolean bl = false;
            this.layoutDecorated(view, $this$recycleAndFillItems_u24lambda_u241.left - this.offsetX, $this$recycleAndFillItems_u24lambda_u241.top, $this$recycleAndFillItems_u24lambda_u241.right - this.offsetX, $this$recycleAndFillItems_u24lambda_u241.bottom);
        }
    }

    @Override
    public boolean isLastRow(int index) {
        boolean bl = 0 <= index ? index < this.getItemCount() : false;
        if (bl) {
            int indexOfPage = index % this.onePageSize;
            if (++indexOfPage > (this.rows - 1) * this.columns && indexOfPage <= this.onePageSize) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLastColumn(int position) {
        int position2 = position;
        return (0 <= position2 ? position2 < this.getItemCount() : false) && ++position2 % this.columns == 0;
    }

    @Override
    public boolean isLastPage(int position) {
        int position2 = position;
        return ++position2 % this.onePageSize == 0;
    }

    @Override
    public int getPageIndex(int position) {
        return position / this.onePageSize;
    }

    public int computeHorizontalScrollRange(@NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.computePageSize(state);
        return this.pageSize * this.getWidth();
    }

    public int computeHorizontalScrollOffset(@NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.offsetX;
    }

    public int computeHorizontalScrollExtent(@NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.getWidth();
    }
}

