/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.toolbar;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.ppt.util.ShapeUtils;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseUIConstant;
import com.baijiayun.liveuibase.utils.ShadowUtil;
import com.baijiayun.liveuibase.widgets.popupwindow.BaseAutoArrangePopupWindow;
import com.baijiayun.liveuibase.widgets.toolbar.ColorSelectData;
import java.util.HashMap;

public abstract class BaseDrawTextSettingWindow
extends BaseAutoArrangePopupWindow {
    private final View contentView;
    private boolean isTextStrength = false;
    private boolean isTextTilt = false;
    private final int colorsGroupId = 1;
    private TextView lastCheckedTv = null;
    private View textSizeContainer;
    private View textSettingContainer;
    private final ShadowUtil shadowUtil;

    public BaseDrawTextSettingWindow(Context context2) {
        super(context2);
        this.contentView = LayoutInflater.from((Context)context2).inflate(R.layout.uibase_window_draw_text_setting, null);
        this.init();
        this.setResSetsMergeColors(null, 1, color2 -> this.onChangeColor(new ColorSelectData(BaseUIConstant.SelectSrc.Text, color2)));
        this.generateView((LinearLayout)this.contentView.findViewById(R.id.base_toolbar_text_setting_color_container));
        this.setShowShadow(false);
        this.createView(this.contentView, false);
        this.shadowUtil = ShadowUtil.Create(UtilsKt.getDp((int)2), UtilsKt.getDp((int)24));
        ShadowUtil.setViewBoundShadow(this.textSizeContainer, this.shadowUtil);
        ShadowUtil.setViewBoundShadow(this.textSettingContainer);
    }

    private void init() {
        this.textSizeContainer = this.contentView.findViewById(R.id.base_toolbar_text_setting_sizes_container);
        this.textSettingContainer = this.contentView.findViewById(R.id.base_toolbar_text_setting_container);
        this.initViewDataHashMap();
        this.initDrawable();
        this.initView();
        this.textSizeContainer.setSelected(false);
        this.contentView.findViewById(R.id.base_toolbar_text_setting_text_size).setOnClickListener(v -> {
            this.textSizeContainer.setSelected(!this.textSizeContainer.isSelected());
            this.updateSizesContainerParams();
        });
        this.contentView.findViewById(R.id.base_toolbar_text_setting_bold).setOnClickListener(v -> {
            ShapeUtils.isFontWeight = this.isTextStrength = !this.isTextStrength;
            ((ImageView)this.contentView.findViewById(R.id.base_toolbar_text_setting_bold)).setImageDrawable(this.isTextStrength ? this.getDrawable(R.drawable.base_draw_text_strength_press, true) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.base_draw_text_strength));
        });
        this.contentView.findViewById(R.id.base_toolbar_text_setting_tilt).setOnClickListener(v -> {
            ShapeUtils.isFontItalic = this.isTextTilt = !this.isTextTilt;
            ((ImageView)this.contentView.findViewById(R.id.base_toolbar_text_setting_tilt)).setImageDrawable(this.isTextTilt ? this.getDrawable(R.drawable.base_draw_text_tilt_press, true) : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.base_draw_text_tilt));
        });
    }

    private void initDrawable() {
        GradientDrawable settingContainerDrawable = new GradientDrawable();
        settingContainerDrawable.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color));
        settingContainerDrawable.setCornerRadius((float)this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
        settingContainerDrawable.setStroke(UtilsKt.getDp((int)1), ContextCompat.getColor((Context)this.context, (int)R.color.base_bg_stroke_10));
        this.textSettingContainer.setBackground((Drawable)settingContainerDrawable);
        StateListDrawable sizeContainerDrawable = new StateListDrawable();
        GradientDrawable sizeContainerDrawableSel = new GradientDrawable();
        sizeContainerDrawableSel.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color));
        sizeContainerDrawableSel.setCornerRadius((float)this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
        sizeContainerDrawable.addState(new int[]{0x10100A1}, (Drawable)sizeContainerDrawableSel);
        sizeContainerDrawable.addState(new int[]{-16842913}, null);
        this.textSizeContainer.setBackground((Drawable)sizeContainerDrawable);
    }

    private void initView() {
        int[] textSizes = new int[]{12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 40, 60, 80};
        LinearLayout allContainer = (LinearLayout)this.contentView.findViewById(R.id.base_toolbar_text_setting_size_selector_sizes);
        for (int textSize : textSizes) {
            LinearLayout container2 = new LinearLayout(this.context);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(UtilsKt.getDp((int)32), -2);
            params.gravity = 0x800003;
            params.setMarginStart(UtilsKt.getDp((int)2));
            container2.setLayoutParams((ViewGroup.LayoutParams)params);
            container2.setGravity(0x800003);
            TextView textView = new TextView(this.context);
            textView.setLayoutParams((ViewGroup.LayoutParams)params);
            textView.setTextSize(20.0f);
            textView.setTextAlignment(4);
            textView.setTypeface(Typeface.MONOSPACE);
            textView.setText((CharSequence)String.valueOf(textSize));
            textView.setTextColor(textSize == 20 ? ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color) : this.getColor(R.color.base_assistant_text_color));
            container2.addView((View)textView);
            container2.setOnClickListener(v -> {
                if (this.lastCheckedTv != null) {
                    this.lastCheckedTv.setTextColor(this.getColor(R.color.base_assistant_text_color));
                }
                textView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color));
                this.onChangeTextSize(textSize);
                ((TextView)this.contentView.findViewById(R.id.base_toolbar_text_setting_size_selector_preview)).setText((CharSequence)String.valueOf(textSize));
                this.lastCheckedTv = textView;
            });
            allContainer.addView((View)container2);
        }
        this.updateSizesContainerParams();
    }

    protected abstract void onChangeColor(ColorSelectData var1);

    protected abstract void onChangeTextSize(int var1);

    private void updateSizesContainerParams() {
        this.contentView.findViewById(R.id.base_toolbar_text_setting_sizes).setVisibility(this.textSizeContainer.isSelected() ? 0 : 8);
        this.contentView.findViewById(R.id.base_toolbar_text_setting_sizes_divider_line).setVisibility(this.textSizeContainer.isSelected() ? 0 : 8);
        if (this.shadowUtil != null && this.shadowUtil.getShadowView() != null) {
            this.shadowUtil.getShadowView().setVisibility(this.textSizeContainer.isSelected() ? 0 : 8);
        }
    }

    @Override
    protected void initViewDataHashMap() {
        HashMap<Integer, BaseAutoArrangePopupWindow.GroupViewData> groupViewDataHashMap = new HashMap<Integer, BaseAutoArrangePopupWindow.GroupViewData>();
        groupViewDataHashMap.put(1, new BaseAutoArrangePopupWindow.GroupViewData(this.context, 130, 32, 24, 24, 4));
        this.viewDataHashMap = groupViewDataHashMap;
    }

    @Override
    public void show(View anchor) {
        this.textSizeContainer.setSelected(false);
        this.updateSizesContainerParams();
        ShadowUtil.reInit(this.shadowUtil);
        this.showWithViewOfDirection(anchor, -1);
    }
}

