/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentManager;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.widgets.view.webview.BJWebViewImpl;
import com.baijiayun.liveuibase.R;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebSettings;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;

public class QuestionDialogFragment
extends DialogFragment {
    public static final String BUNDLE_DATA_URL = "bundle_data_url";
    private static final int DIALOG_WIDTH_PX = 350;
    private static final int DIALOG_HEIGHT_PX = 500;
    private BJWebViewImpl webview;
    private ProgressBar progressBar;
    private float downY;
    public OnSubmitQuestionListener onSubmitQuestionListener;

    public static QuestionDialogFragment newInstance(String url) {
        Bundle args = new Bundle();
        args.putString(BUNDLE_DATA_URL, url);
        QuestionDialogFragment fragment = new QuestionDialogFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container2, @Nullable Bundle savedInstanceState) {
        this.getDialog().setCanceledOnTouchOutside(false);
        this.getDialog().setCancelable(false);
        return inflater.inflate(R.layout.bjy_base_fragment_dlg_webview, container2, false);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setStyle(0, R.style.BJYBaseDialogFullScreen);
    }

    private void keepAboveKeyboard(View root) {
        root.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
            Rect rect = new Rect();
            root.getWindowVisibleDisplayFrame(rect);
            int rootInvisibleHeight = root.getRootView().getBottom() - rect.bottom;
            if (rootInvisibleHeight > 150) {
                int srollHeight = (int)(this.downY + 80.0f - (float)rect.bottom);
                if (srollHeight > 0) {
                    root.scrollTo(0, srollHeight);
                } else {
                    root.scrollTo(0, 0);
                }
            } else {
                root.scrollTo(0, 0);
            }
        });
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView(view);
        this.keepAboveKeyboard(view);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initView(View view) {
        this.webview = (BJWebViewImpl)view.findViewById(R.id.webview);
        this.progressBar = (ProgressBar)view.findViewById(R.id.pb_webview);
        this.webview.setOnTouchListener((v, event) -> {
            this.downY = event.getRawY();
            return false;
        });
        String url = this.getArguments() == null ? "" : this.getArguments().getString(BUNDLE_DATA_URL, "");
        DisplayMetrics metrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int heightPixels = metrics.heightPixels;
        int widthPixels = metrics.widthPixels;
        float density = metrics.density;
        float maxScale = Math.min(1.0f * (float)heightPixels / 500.0f, 1.0f * (float)widthPixels / 350.0f);
        maxScale = DisplayUtils.isPad((Context)this.getContext()) ? ((double)density - 2.0 < 0.001 && (double)density - 2.0 > -0.001 ? (maxScale *= 78.0f) : (maxScale *= 70.0f)) : (maxScale *= 80.0f);
        WebSettings webSettings = this.webview.getSettings();
        webSettings.setBuiltInZoomControls(false);
        this.webview.setInitialScale((int)maxScale);
        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        this.webview.enableJavaScript((Object)new Jsobj(), "app");
        this.webview.setBackgroundColor(0);
        this.webview.setWebViewClient((WebViewClient)new BJWebViewImpl.BJWebViewClient(){

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                QuestionDialogFragment.this.webview.loadUrl("about:blank");
                QuestionDialogFragment.this.progressBar.setVisibility(8);
            }
        });
        this.webview.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                if (newProgress > 0 && newProgress != 100) {
                    QuestionDialogFragment.this.progressBar.setVisibility(0);
                    QuestionDialogFragment.this.progressBar.setProgress(newProgress);
                } else {
                    QuestionDialogFragment.this.progressBar.setVisibility(8);
                }
            }
        });
        this.webview.loadUrl(url);
    }

    public void dismiss() {
        if (this.getDialog() != null) {
            try {
                if (this.isAdded()) {
                    super.dismiss();
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    public void show(FragmentManager manager, String tag) {
        if (!(manager == null || this.getDialog() != null && this.getDialog().isShowing())) {
            try {
                if (!this.isAdded()) {
                    super.show(manager, tag);
                }
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.webview != null) {
            this.webview.destroy();
        }
    }

    public void setOnSubmitQuestionListener(OnSubmitQuestionListener onSubmitQuestionListener) {
        this.onSubmitQuestionListener = onSubmitQuestionListener;
    }

    class Jsobj {
        Jsobj() {
        }

        @JavascriptInterface
        public void close(boolean success) {
            if (QuestionDialogFragment.this.onSubmitQuestionListener != null) {
                QuestionDialogFragment.this.onSubmitQuestionListener.onSubmit(success);
            }
            QuestionDialogFragment.this.dismiss();
        }
    }

    public static interface OnSubmitQuestionListener {
        public void onSubmit(boolean var1);
    }
}

