/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;

public class ProgressCircleView
extends View {
    private int pathLength = 70;
    private static final int PER_STEP_LENGTH = 2;
    private Paint progressPaint;
    private int progressColorId = R.color.base_theme_live_product;
    private int progressBgColorId = R.color.base_transparent;
    private float viewportSize = 24.0f;
    private float ringWidth = 1.0f;
    private float ringRadius = 11.0f;
    private RectF oval;
    private boolean isLoop;

    public ProgressCircleView(Context context2) {
        super(context2);
        this.init();
    }

    public ProgressCircleView(Context context2, @Nullable AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public ProgressCircleView(Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        TypedArray typedArray = context2.obtainStyledAttributes(attrs, R.styleable.BJYProgressCircleView);
        this.progressColorId = typedArray.getResourceId(R.styleable.BJYProgressCircleView_bjlive_progressColor, this.progressColorId);
        this.progressBgColorId = typedArray.getResourceId(R.styleable.BJYProgressCircleView_bjlive_progressBgColor, this.progressBgColorId);
        this.viewportSize = typedArray.getFloat(R.styleable.BJYProgressCircleView_bjlive_viewportSize, this.viewportSize);
        this.ringWidth = typedArray.getFloat(R.styleable.BJYProgressCircleView_bjlive_ringWidth, this.ringWidth);
        this.ringRadius = typedArray.getFloat(R.styleable.BJYProgressCircleView_bjlive_ringRadius, this.ringRadius);
        typedArray.recycle();
        this.init();
    }

    private void init() {
        this.progressPaint = new Paint();
        this.progressPaint.setStyle(Paint.Style.STROKE);
        this.progressPaint.setAntiAlias(true);
        this.oval = new RectF();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int x = this.getWidth();
        int y = this.getHeight();
        float realRadius = this.ringRadius / this.viewportSize * (float)Math.min(x, y);
        float realRingWidth = this.ringWidth / this.viewportSize * (float)Math.min(x, y);
        this.progressPaint.setStrokeWidth(realRingWidth);
        this.oval.set((float)x / 2.0f - realRadius, (float)y / 2.0f - realRadius, (float)x / 2.0f + realRadius, (float)y / 2.0f + realRadius);
        this.progressPaint.setColor(ThemeDataUtil.getColorFromThemConfigByColorId((Context)this.getContext(), (int)this.progressBgColorId));
        canvas.drawOval(this.oval, this.progressPaint);
        this.progressPaint.setColor(ThemeDataUtil.getColorFromThemConfigByColorId((Context)this.getContext(), (int)this.progressColorId));
        canvas.drawArc(this.oval, -90.0f, 360.0f * (float)this.pathLength / 100.0f, false, this.progressPaint);
        if (this.isLoop) {
            if (this.pathLength >= 100) {
                this.pathLength = 0;
            }
            this.pathLength += 10;
            this.postInvalidateDelayed(150L);
        }
    }

    public void setLooping(boolean isLoop) {
        this.isLoop = isLoop;
        this.pathLength = 0;
        this.invalidate();
    }

    public void setRatio(float ratio) {
        int newPathLength = (int)(ratio * 100.0f);
        if (Math.abs(newPathLength - this.pathLength) > 2) {
            int step = (newPathLength - this.pathLength) / 2;
            this.pathLength += step * 2;
            this.invalidate();
        }
    }
}

