/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.livetimer;

import android.app.Activity;
import android.content.Context;
import android.media.SoundPool;
import android.text.TextUtils;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.TextView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.toolbox.livetimer.TimerContract;

public class TimerWindow
extends BaseWindow
implements TimerContract.View {
    private TimerContract.Presenter presenter;
    private Context context;
    private String timerState = "";
    private EditText etMin;
    private EditText etSecond;
    private EditText etMin1;
    private EditText etSecond1;
    private CheckedTextView tvPublish;
    private CheckedTextView tvCountDown;
    private CheckedTextView tvCountUp;
    private boolean canEditable = true;
    private long duration;
    private SoundPool soundPool;
    private View.OnFocusChangeListener focusChangeListener = (v, hasFocus) -> {
        if (v instanceof EditText) {
            EditText et = (EditText)v;
            if (!hasFocus) {
                int value = et.getText().length() > 0 ? Integer.parseInt(et.getText().toString()) : 0;
                et.setText((CharSequence)String.valueOf(value));
            } else {
                et.setSelection(et.getText().length());
            }
            if (v.getId() == R.id.dialog_timer_et_second_second && !hasFocus) {
                this.etSecond1.requestFocus();
                TimerWindow.showInput(this.context, (View)this.etSecond1);
            }
        }
    };
    TextView.OnEditorActionListener editorActionListener = (v, actionId, event) -> {
        v.clearFocus();
        return false;
    };

    public TimerWindow(Context context2) {
        super(context2);
        this.context = context2;
        this.init();
    }

    @Override
    protected View onCreateView(Context context2) {
        return View.inflate((Context)context2, (int)R.layout.bjy_base_fragment_timer, null);
    }

    public void setPresenter(TimerContract.Presenter presenter2) {
        this.presenter = presenter2;
        presenter2.subscribe();
        if (presenter2.isLiveEE()) {
            DrawableBuilder builder = new DrawableBuilder().rectangle().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_bg_color));
            if (this.context instanceof Activity && ((Activity)this.context).getRequestedOrientation() == 0) {
                builder.cornerRadii(UtilsKt.getDp((int)12), 0, 0, UtilsKt.getDp((int)12));
            } else {
                builder.cornerRadii(UtilsKt.getDp((int)12), UtilsKt.getDp((int)12), 0, 0);
            }
            this.view.setBackground(builder.build());
            this.allowTouch = false;
        } else {
            this.view.setBackground(ThemeDataUtil.getCommonWindowBg((Context)this.context));
            this.allowTouch = true;
        }
    }

    private void init() {
        LPLogger.d((String)"\u8ba1\u65f6\u5668");
        this.tvPublish = (CheckedTextView)this.$.id(R.id.tv_publish).view();
        this.etMin = (EditText)this.$.id(R.id.dialog_timer_et_min_first).view();
        this.etMin1 = (EditText)this.$.id(R.id.dialog_timer_et_min_second).view();
        this.etSecond = (EditText)this.$.id(R.id.dialog_timer_et_second_first).view();
        this.etSecond1 = (EditText)this.$.id(R.id.dialog_timer_et_second_second).view();
        this.etMin1.setTextColor(ThemeDataUtil.getColorSelectMainText2Warning((Context)this.context));
        this.etSecond1.setTextColor(ThemeDataUtil.getColorSelectMainText2Warning((Context)this.context));
        this.etMin1.setOnFocusChangeListener(this.focusChangeListener);
        this.etSecond1.setOnFocusChangeListener(this.focusChangeListener);
        this.etMin1.setOnEditorActionListener(this.editorActionListener);
        this.etSecond1.setOnEditorActionListener(this.editorActionListener);
        this.etMin.setTextColor(ThemeDataUtil.getColorSelectMainText2Warning((Context)this.context));
        this.etSecond.setTextColor(ThemeDataUtil.getColorSelectMainText2Warning((Context)this.context));
        this.tvCountDown = (CheckedTextView)this.$.id(R.id.dialog_timer_tv_count_down).view();
        this.tvCountUp = (CheckedTextView)this.$.id(R.id.dialog_timer_tv_count_up).view();
        this.etMin.setOnFocusChangeListener(this.focusChangeListener);
        this.etSecond.setOnFocusChangeListener(this.focusChangeListener);
        this.etMin.setOnEditorActionListener(this.editorActionListener);
        this.etSecond.setOnEditorActionListener(this.editorActionListener);
        this.$.id(R.id.tv_publish).clicked(v -> {
            if (this.timerState.equals("pause")) {
                this.pause();
                this.setTabClickable(this.canEditable);
            } else {
                this.publish(this.getTimerSeconds());
            }
        });
        ((CheckedTextView)this.$.id(R.id.tv_publish).view()).setTextColor(ThemeDataUtil.getColorCheckWhite2MainText((Context)this.context));
        this.$.id(R.id.dialog_end).clicked(v -> {
            this.presenter.requestTimerEnd();
            this.reset();
            this.$.id(R.id.dialog_end).gone();
        });
        this.$.id(R.id.dialog_timer_exit).clicked(v -> this.routerListener.onDismissAdminTimer());
        this.tvCountDown.setOnClickListener(v -> {
            this.tvCountUp.setChecked(false);
            this.tvCountDown.setChecked(true);
        });
        this.tvCountUp.setOnClickListener(v -> {
            this.tvCountUp.setChecked(true);
            this.tvCountDown.setChecked(false);
        });
    }

    private void reset() {
        this.setTimer(0L);
        this.setButtonState("start");
    }

    private boolean isCountDown() {
        CheckedTextView textView = (CheckedTextView)this.$.id(R.id.dialog_timer_tv_count_down).view();
        return textView.isChecked();
    }

    private void setTabClickable(boolean clickable) {
        this.$.id(R.id.dialog_timer_tv_count_down).view().setEnabled(clickable);
        this.$.id(R.id.dialog_timer_tv_count_up).view().setEnabled(clickable);
    }

    private void publish(long duration) {
        if (!this.isLegal()) {
            this.showToastMessage(this.getString(R.string.timer_error_tip, this.isCountDown() ? this.getString(R.string.timer_countdown) : this.getString(R.string.timer_countup)));
            return;
        }
        if (this.timerState.equals("start")) {
            this.duration = duration;
        }
        this.presenter.requestTimerStart(0L, this.duration, this.isCountDown());
        this.onDestroy();
    }

    private void pause() {
        this.setButtonState("continue");
        this.presenter.requestTimerPause(0L, this.duration, this.isCountDown());
    }

    private boolean isLegal() {
        return this.getTimerSeconds() > 0L;
    }

    private long getTimerSeconds() {
        long min = 0L;
        long second = 0L;
        long seconds = 0L;
        try {
            min = Long.parseLong(this.etMin.getText().toString()) * 10L + Long.parseLong(this.etMin1.getText().toString());
            second = Long.parseLong(this.etSecond.getText().toString()) * 10L + Long.parseLong(this.etSecond1.getText().toString());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        seconds = min * 60L + second;
        return seconds;
    }

    public static void showInput(Context context2, View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)context2.getSystemService("input_method");
        inputMethodManager.showSoftInputFromInputMethod(view.getWindowToken(), 0);
    }

    @Override
    public void setTimer(long remainSeconds) {
        long min = remainSeconds / 60L;
        long second = remainSeconds % 60L;
        this.etMin.setText((CharSequence)String.valueOf(min / 10L));
        this.etMin1.setText((CharSequence)String.valueOf(min % 10L));
        this.etSecond.setText((CharSequence)String.valueOf(second / 10L));
        this.etSecond1.setText((CharSequence)String.valueOf(second % 10L));
    }

    private void showEditable(boolean canEditable) {
        this.etMin.setEnabled(canEditable);
        this.etSecond.setEnabled(canEditable);
        this.etMin1.setEnabled(canEditable);
        this.etSecond1.setEnabled(canEditable);
        this.tvCountDown.setEnabled(canEditable);
        this.tvCountUp.setEnabled(canEditable);
        if (canEditable) {
            this.etMin.setSelected(false);
            this.etSecond.setSelected(false);
            this.etMin1.setSelected(false);
            this.etSecond1.setSelected(false);
        }
    }

    @Override
    public void showViewWarning(boolean enable) {
        this.etMin.setSelected(enable);
        this.etSecond.setSelected(enable);
        this.etMin1.setSelected(enable);
        this.etSecond1.setSelected(enable);
    }

    @Override
    public void showCountDown(boolean isCountDown) {
        this.tvCountDown.setChecked(isCountDown);
        this.tvCountUp.setChecked(!isCountDown);
    }

    @Override
    public void showTimerEnd() {
        if (this.soundPool != null) {
            this.soundPool.release();
        }
        this.soundPool = UtilsKt.playAudio((Context)this.context, (int)R.raw.timer_end);
        this.reset();
    }

    @Override
    public void showTimerPause(boolean isPause) {
        this.$.id(R.id.dialog_base_title).text((CharSequence)this.getString(isPause ? R.string.timer_pause_tip : R.string.timer));
    }

    @Override
    public void setButtonState(String state) {
        if (TextUtils.isEmpty((CharSequence)state)) {
            return;
        }
        switch (state) {
            case "pause": {
                this.canEditable = false;
                this.showTimerPause(false);
                this.tvPublish.setText((CharSequence)this.getString(R.string.live_timer_pause_count));
                this.$.id(R.id.dialog_end).visible();
                break;
            }
            case "continue": {
                this.canEditable = false;
                this.showTimerPause(true);
                this.tvPublish.setText((CharSequence)this.getString(R.string.timer_continue));
                this.$.id(R.id.dialog_end).visible();
                break;
            }
            case "start": {
                this.canEditable = true;
                this.showTimerPause(false);
                this.tvPublish.setText((CharSequence)this.getString(R.string.timer_start));
                this.$.id(R.id.dialog_end).gone();
                break;
            }
        }
        this.timerState = state;
        this.showEditable(this.canEditable);
    }

    public void setAllowMove(boolean allowMove) {
        this.allowTouch = allowMove;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.presenter.unSubscribe();
        if (this.soundPool != null) {
            this.soundPool.release();
        }
    }
}

