/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.text.Layout;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.liveuibase.R;
import java.util.ArrayList;
import java.util.List;

public class DirRecordTextView
extends AppCompatTextView {
    private static final int MAX_LENGTH_PER_ITEM = 8;
    private String dividerString = " / ";
    private List<String> mItems = new ArrayList<String>();
    private IOnItemClickListener mOnItemClickListener;
    private int showSize = 0;

    public DirRecordTextView(Context context2, @Nullable AttributeSet attrs) {
        super(context2, attrs);
        this.setSingleLine(true);
        this.setEllipsize(TextUtils.TruncateAt.END);
    }

    protected void onDraw(Canvas canvas) {
        double secPos;
        super.onDraw(canvas);
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return;
        }
        if (this.getText().length() < 2) {
            this.setScaleY(1.0f);
            return;
        }
        double lasPos = layout2.getSecondaryHorizontal(this.getText().length() - 1);
        if (lasPos == (secPos = (double)layout2.getPrimaryHorizontal(this.getText().length() - 2))) {
            --this.showSize;
            this.setText((CharSequence)this.generateShowText());
            this.invalidate();
        } else {
            this.setScaleY(1.0f);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 1) {
            Layout layout2 = this.getLayout();
            if (layout2 == null) {
                return false;
            }
            int nowInd = this.getText().length();
            for (int i = this.mItems.size() - 1; i >= this.mItems.size() - this.showSize; --i) {
                double right = layout2.getSecondaryHorizontal(nowInd);
                double left = (nowInd -= this.getNeedShowItem(this.mItems.get(i)).length()) < 0 ? 0.0 : (double)layout2.getPrimaryHorizontal(nowInd);
                if ((double)event.getX() >= left && (double)event.getX() <= right) {
                    if (this.mOnItemClickListener == null) break;
                    this.mOnItemClickListener.onItemClick(i);
                    break;
                }
                if ((nowInd -= this.dividerString.length()) < 0) break;
            }
        }
        this.performClick();
        return true;
    }

    public void updateItems(List<String> items) {
        this.setScaleY(0.0f);
        this.mItems = new ArrayList<String>(items);
        this.showSize = this.mItems.size();
        this.setText((CharSequence)this.generateShowText());
    }

    public void setOnItemClickListener(IOnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    private SpannableString generateShowText() {
        int i;
        if (this.showSize > this.mItems.size() || this.mItems.size() == 0) {
            return new SpannableString((CharSequence)"");
        }
        StringBuilder needShow = new StringBuilder();
        if (this.mItems.size() == this.showSize) {
            needShow.append(this.getNeedShowItem(this.mItems.get(0)));
            for (i = 1; i < this.mItems.size(); ++i) {
                needShow.append(this.dividerString).append(this.getNeedShowItem(this.mItems.get(i)));
            }
        } else {
            needShow.append("...");
            for (i = this.mItems.size() - this.showSize; i < this.mItems.size(); ++i) {
                needShow.append(this.dividerString).append(this.getNeedShowItem(this.mItems.get(i)));
            }
        }
        SpannableString spannableString = new SpannableString((CharSequence)needShow);
        spannableString.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)this.getContext(), (int)R.color.base_theme_live_product)), needShow.length() - this.getNeedShowItem(this.mItems.get(this.mItems.size() - 1)).length(), needShow.length(), 17);
        return spannableString;
    }

    private String getNeedShowItem(String item) {
        String needAppend = item != null && item.length() > 8 ? item.substring(0, 8) + "..." : (item == null ? "" : item);
        return needAppend;
    }

    public static interface IOnItemClickListener {
        public void onItemClick(int var1);
    }
}

