/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.redpacket;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.bjyutils.widgets.SimpleTextWatcher;
import com.baijiayun.livebase.context.LPException;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPRedPacketModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseTitleWindow;
import io.reactivex.disposables.Disposable;

public class RedPacketPublishWindow
extends BaseTitleWindow {
    private TextView tvNumSuggest;
    private EditText etNum;
    private TextView tvTime1;
    private TextView tvTime2;
    private TextView tvTime3;
    private TextView tvTime4;
    private TextView tvScoreSuggest;
    private EditText etScore;
    private TextView tvStart;
    private int nowSelectTime;
    private int maxRedPacketLimit;
    private Disposable disposableOfPublish;

    public RedPacketPublishWindow(Context context2) {
        super(context2);
        this.setTitle(this.getString(R.string.base_red_packet_title));
    }

    @Override
    @SuppressLint(value={"StringFormatInvalid"})
    protected void onCreateContentView(Context context2) {
        if (DisplayUtils.isPortrait((Context)context2)) {
            this.view.setBackground(new DrawableBuilder().rectangle().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_window_bg_color)).cornerRadii(UtilsKt.getDp((int)12), UtilsKt.getDp((int)12), 0, 0).build());
        }
        LayoutInflater.from((Context)context2).inflate(R.layout.uibase_window_red_packet_publish_layout, (ViewGroup)this.clContentContainer);
        this.tvNumSuggest = (TextView)this.clContentContainer.findViewById(R.id.base_red_packet_num_suggest);
        this.etNum = (EditText)this.clContentContainer.findViewById(R.id.base_red_packet_num_input);
        this.tvTime1 = (TextView)this.clContentContainer.findViewById(R.id.base_red_packet_num_time_1);
        this.initTimeSelView(this.tvTime1, 5);
        this.tvTime2 = (TextView)this.clContentContainer.findViewById(R.id.base_red_packet_num_time_2);
        this.initTimeSelView(this.tvTime2, 10);
        this.tvTime3 = (TextView)this.clContentContainer.findViewById(R.id.base_red_packet_num_time_3);
        this.initTimeSelView(this.tvTime3, 15);
        this.tvTime4 = (TextView)this.clContentContainer.findViewById(R.id.base_red_packet_num_time_4);
        this.initTimeSelView(this.tvTime4, 30);
        this.tvTime3.performClick();
        this.tvScoreSuggest = (TextView)this.clContentContainer.findViewById(R.id.base_red_packet_score_suggest);
        this.etScore = (EditText)this.clContentContainer.findViewById(R.id.base_red_packet_score_input);
        this.tvStart = (TextView)this.clContentContainer.findViewById(R.id.base_red_packet_bt_start);
        this.tvStart.setBackground(ThemeDataUtil.getEnableProductBgWithCorner((Context)context2));
        this.tvStart.setTextColor(ThemeDataUtil.getColorEnableWhite2NegativeText((Context)context2));
        this.tvStart.setEnabled(false);
        this.clearInput();
        SimpleTextWatcher textWatcher = new SimpleTextWatcher(){

            public void afterTextChanged(Editable s) {
                if (RedPacketPublishWindow.this.tvStart != null) {
                    RedPacketPublishWindow.this.tvStart.setEnabled(RedPacketPublishWindow.this.checkInput());
                }
            }
        };
        this.etScore.addTextChangedListener((TextWatcher)textWatcher);
        this.etNum.addTextChangedListener((TextWatcher)textWatcher);
        this.tvStart.setOnClickListener(v -> this.sendPublish());
        this.initRoomData();
    }

    protected Drawable getTimeSelBg() {
        return new StateListDrawableBuilder().selected(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build()).normal(new DrawableBuilder().cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_bg_stroke)).strokeWidth(UtilsKt.getDp((int)1)).build()).build();
    }

    protected ColorStateList getTimeSelTextBg() {
        return ThemeDataUtil.getColorSelectWhite2MainText((Context)this.context);
    }

    protected ViewGroup.LayoutParams getTimeSelLayoutParams(ViewGroup.LayoutParams oldLayoutParams) {
        return oldLayoutParams;
    }

    private void initRoomData() {
        if (this.routerListener.getLiveRoom() == null) {
            return;
        }
        this.maxRedPacketLimit = this.routerListener.getLiveRoom().getPartnerConfig().maxRedPacketCount;
        this.etNum.setHint((CharSequence)this.context.getString(R.string.base_red_packet_num_hint, new Object[]{String.valueOf(this.maxRedPacketLimit)}));
        this.etScore.setHint((CharSequence)this.context.getString(R.string.base_red_packet_score_hint, new Object[]{String.valueOf(this.maxRedPacketLimit)}));
        this.initSuggestViews();
    }

    private void sendPublish() {
        if (this.routerListener.getLiveRoom() == null || !this.checkInput()) {
            return;
        }
        DisplayUtils.hideKeyboard((View)this.etNum);
        RxUtils.dispose((Disposable)this.disposableOfPublish);
        this.disposableOfPublish = this.routerListener.getLiveRoom().requestPublishRedPacket(Integer.parseInt(this.etNum.getText().toString()), Integer.parseInt(this.etScore.getText().toString()), this.nowSelectTime).subscribe(publishRedPacketModel -> {
            if (publishRedPacketModel.status == 0 && this.routerListener != null) {
                this.routerListener.getLiveRoom().requestRedPacket(new LPRedPacketModel(String.valueOf(publishRedPacketModel.packageId), this.nowSelectTime));
                this.routerListener.onDismissRedPacketPublish();
            }
        }, throwable -> {
            if (throwable instanceof LPException) {
                ToastCompat.showToastCenter((Context)this.context, (CharSequence)throwable.getMessage(), (int)1);
            }
        });
        this.compositeDisposable.add(this.disposableOfPublish);
        this.clearInput();
    }

    @Override
    protected void onCloseWindow() {
        if (this.routerListener != null) {
            this.routerListener.onDismissRedPacketPublish();
        }
    }

    private void initTimeSelView(TextView tvTime, int second) {
        tvTime.setLayoutParams(this.getTimeSelLayoutParams(tvTime.getLayoutParams()));
        tvTime.setBackground(this.getTimeSelBg());
        tvTime.setTextColor(this.getTimeSelTextBg());
        tvTime.setOnClickListener(v -> {
            this.nowSelectTime = second;
            this.tvTime1.setSelected(false);
            this.tvTime2.setSelected(false);
            this.tvTime3.setSelected(false);
            this.tvTime4.setSelected(false);
            tvTime.setSelected(true);
        });
    }

    private void initSuggestViews() {
        if (this.routerListener.getLiveRoom() == null) {
            return;
        }
        this.tvNumSuggest.setText((CharSequence)this.initSuggestString(5, 20, this.maxRedPacketLimit, R.string.base_red_packet_num_suggest));
        this.tvScoreSuggest.setText((CharSequence)this.initSuggestString(10, 40, this.maxRedPacketLimit, R.string.base_red_packet_score_suggest));
    }

    private String initSuggestString(int minRatio, int maxRatio, int limit, int prefixStringId) {
        int max;
        if (this.routerListener == null || this.routerListener.getLiveRoom() == null) {
            return "";
        }
        int userCount = this.routerListener.getLiveRoom().getOnlineUserVM().getUserCount();
        int min = Math.min(userCount * minRatio, limit);
        if (min == (max = Math.min(userCount * maxRatio, limit))) {
            return this.context.getString(prefixStringId, new Object[]{max});
        }
        return this.context.getString(prefixStringId, new Object[]{min + "~" + max});
    }

    private boolean checkInput() {
        boolean validFlag = false;
        try {
            if (this.routerListener.getLiveRoom() == null) {
                return false;
            }
            int num = Integer.parseInt(this.etNum.getText().toString());
            int score = Integer.parseInt(this.etScore.getText().toString());
            validFlag = num > 0 && score >= num && num <= this.maxRedPacketLimit && score <= this.maxRedPacketLimit;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return validFlag;
    }

    private void clearInput() {
        this.etScore.setText((CharSequence)"");
        this.etNum.setText((CharSequence)"");
    }
}

