/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.AppCompatSeekBar;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.liveuibase.R;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0012\u0010!\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0012\u0010\"\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u001a\u0010#\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0018\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0014J\u000e\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\fJ\u000e\u0010*\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\fJ\u000e\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\fR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/baijiayun/liveuibase/widgets/common/IndicatorSeekBar;", "Landroidx/appcompat/widget/AppCompatSeekBar;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "maxHeightF", "", "maxTextSizePx", "maxWidthF", "minHeightF", "minTextSizePx", "minWidthF", "paint", "Landroid/graphics/Paint;", "getPaint", "()Landroid/graphics/Paint;", "paint$delegate", "Lkotlin/Lazy;", "progressText", "", "textRect", "Landroid/graphics/Rect;", "textSizePx", "drawText", "", "canvas", "Landroid/graphics/Canvas;", "drawThumb", "drawTrack", "init", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setMaxHeightF", "height", "setMinHeightF", "setTextSize", "sp", "liveuibase_release"})
public final class IndicatorSeekBar
extends AppCompatSeekBar {
    private float minHeightF;
    private float maxHeightF;
    private float maxWidthF;
    private float minWidthF;
    private float minTextSizePx;
    private float maxTextSizePx;
    @NotNull
    private String progressText;
    @NotNull
    private final Rect textRect;
    private float textSizePx;
    @NotNull
    private final Lazy paint$delegate;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    public IndicatorSeekBar(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, null);
    }

    public IndicatorSeekBar(@NotNull Context context2, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, attrs, 0);
    }

    public IndicatorSeekBar(@NotNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this._$_findViewCache = new LinkedHashMap();
        super(context2, attrs, defStyleAttr);
        this.minTextSizePx = 30.0f;
        this.maxTextSizePx = 100.0f;
        this.progressText = "0";
        this.textRect = new Rect();
        this.textSizePx = 30.0f;
        this.paint$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Paint>(this){
            final /* synthetic */ IndicatorSeekBar this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Paint invoke() {
                Paint paint2 = new Paint();
                paint2.setColor(ContextCompat.getColor((Context)this.this$0.getContext(), (int)R.color.bjy_live_product_blue));
                paint2.setTextSize(IndicatorSeekBar.access$getTextSizePx$p(this.this$0));
                paint2.setFakeBoldText(true);
                paint2.setAntiAlias(true);
                return paint2;
            }
        }));
        this.init(context2, attrs);
    }

    private final Paint getPaint() {
        Lazy lazy = this.paint$delegate;
        return (Paint)lazy.getValue();
    }

    private final void init(Context context2, AttributeSet attrs) {
        TypedArray typedArray = context2.obtainStyledAttributes(attrs, R.styleable.IndicatorSeekBar);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026yleable.IndicatorSeekBar)");
        TypedArray typedArray2 = typedArray;
        this.minWidthF = (float)typedArray2.getDimensionPixelSize(R.styleable.IndicatorSeekBar_android_minWidth, 24) * 1.0f;
        this.maxWidthF = (float)typedArray2.getDimensionPixelSize(R.styleable.IndicatorSeekBar_android_maxWidth, 48) * 1.0f;
        this.minHeightF = (float)typedArray2.getDimensionPixelSize(R.styleable.IndicatorSeekBar_android_minHeight, 24) * 1.0f;
        this.maxHeightF = (float)typedArray2.getDimensionPixelSize(R.styleable.IndicatorSeekBar_android_maxHeight, 48) * 1.0f;
        this.textSizePx = RangesKt.coerceAtLeast((float)this.minTextSizePx, (float)RangesKt.coerceAtMost((float)typedArray2.getDimension(R.styleable.IndicatorSeekBar_progress_text_size, 30.0f), (float)this.maxTextSizePx));
        typedArray2.recycle();
    }

    public final void setTextSize(float sp) {
        this.maxTextSizePx = (float)this.getThumb().getBounds().width() / 7.0f * (float)4;
        this.textSizePx = RangesKt.coerceAtLeast((float)this.minTextSizePx, (float)RangesKt.coerceAtMost((float)((float)DisplayUtils.sp2px((Context)this.getContext(), (float)sp) * 1.0f), (float)this.maxTextSizePx));
        this.getPaint().setTextSize(this.textSizePx);
        this.requestLayout();
    }

    public final void setMinHeightF(float height) {
        this.minHeightF = height;
    }

    public final void setMaxHeightF(float height) {
        this.maxHeightF = height;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.isEnabled()) {
            Drawable drawable2 = this.getProgressDrawable();
            if (drawable2 == null) {
                drawable2 = this.getIndeterminateDrawable();
            }
            Drawable d = drawable2;
            int thumbHeight = this.getThumb() == null ? 0 : this.getThumb().getIntrinsicHeight();
            int dw = 0;
            int dh = 0;
            if (d != null) {
                dw = (int)RangesKt.coerceAtLeast((float)this.minHeightF, (float)RangesKt.coerceAtMost((float)this.maxHeightF, (float)((float)d.getIntrinsicWidth() * 1.0f)));
                dh = (int)RangesKt.coerceAtLeast((float)this.minHeightF, (float)RangesKt.coerceAtMost((float)this.maxHeightF, (float)((float)d.getIntrinsicHeight() * 1.0f)));
                dh = RangesKt.coerceAtLeast((int)thumbHeight, (int)dh);
            }
            dh += this.getPaddingTop() + this.getPaddingBottom();
            this.progressText = String.valueOf(this.getProgress());
            this.getPaint().getTextBounds(this.progressText, 0, this.progressText.length(), this.textRect);
            this.setMeasuredDimension(View.resolveSizeAndState((int)(dw += this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec, (int)0), View.resolveSizeAndState((int)(dh += this.textRect.height()), (int)heightMeasureSpec, (int)0));
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.isEnabled()) {
            this.progressText = String.valueOf(this.getProgress());
            this.getPaint().getTextBounds(this.progressText, 0, this.progressText.length(), this.textRect);
            this.drawTrack(canvas);
            this.drawThumb(canvas);
            this.drawText(canvas);
        } else {
            super.onDraw(canvas);
        }
    }

    private final void drawTrack(Canvas canvas) {
        block1: {
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block1;
            Canvas $this$drawTrack_u24lambda_u240 = canvas2;
            boolean bl = false;
            canvas.save();
            Drawable drawable2 = this.getProgressDrawable();
            if (drawable2 == null) {
                drawable2 = this.getIndeterminateDrawable();
            }
            Drawable track = drawable2;
            Drawable thumb = this.getThumb();
            int trackHeight = RangesKt.coerceAtMost((int)((int)this.maxHeightF), (int)($this$drawTrack_u24lambda_u240.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.textRect.height()));
            int thumbHeight = thumb.getIntrinsicHeight();
            int thumbWidth = thumb.getIntrinsicWidth();
            int trackHeightOffset = thumbHeight > trackHeight ? (thumbHeight - trackHeight) / 2 + this.textRect.height() : this.textRect.height();
            int left = thumbWidth / 2 + this.getPaddingLeft();
            int trackWidth = $this$drawTrack_u24lambda_u240.getWidth() - this.getPaddingLeft() - this.getPaddingRight() - thumbWidth;
            int right = left + trackWidth;
            track.setBounds(left, trackHeightOffset, right, trackHeightOffset + trackHeight);
            track.draw(canvas);
            canvas.restore();
        }
    }

    private final void drawThumb(Canvas canvas) {
        block0: {
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block0;
            Canvas $this$drawThumb_u24lambda_u241 = canvas2;
            boolean bl = false;
            canvas.save();
            Drawable thumb = this.getThumb();
            int trackHeight = RangesKt.coerceAtMost((int)((int)this.maxHeightF), (int)($this$drawThumb_u24lambda_u241.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.textRect.height()));
            int thumbHeight = thumb.getIntrinsicHeight();
            int thumbHeightOffset = thumbHeight > trackHeight ? this.textRect.height() : (trackHeight - thumbHeight) / 2 + this.textRect.height();
            float progressRatio = (float)this.getProgress() * 1.0f / (float)this.getMax();
            float left = (float)$this$drawThumb_u24lambda_u241.getWidth() * progressRatio + (float)this.getPaddingLeft() - (float)thumb.getIntrinsicWidth() * progressRatio;
            thumb.setBounds((int)left, thumbHeightOffset, (int)(left + (float)thumb.getIntrinsicWidth()), thumbHeightOffset + thumbHeight);
            thumb.draw(canvas);
            canvas.restore();
        }
    }

    private final void drawText(Canvas canvas) {
        block0: {
            Canvas canvas2 = canvas;
            if (canvas2 == null) break block0;
            Canvas $this$drawText_u24lambda_u242 = canvas2;
            boolean bl = false;
            canvas.save();
            Drawable thumb = this.getThumb();
            int centerX = thumb.getBounds().centerX();
            int textWith = this.textRect.width();
            this.textRect.left = centerX - textWith / 2;
            this.textRect.right = centerX + textWith / 2;
            this.maxTextSizePx = (float)thumb.getBounds().width() / 7.0f * (float)4;
            this.getPaint().setTextSize(RangesKt.coerceAtLeast((float)this.minTextSizePx, (float)RangesKt.coerceAtMost((float)this.getPaint().getTextSize(), (float)this.maxTextSizePx)));
            canvas.drawText(this.progressText, (float)this.textRect.left * 1.0f, (float)this.textRect.height() * 1.0f, this.getPaint());
            canvas.restore();
        }
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    public static final /* synthetic */ float access$getTextSizePx$p(IndicatorSeekBar $this) {
        return $this.textSizePx;
    }
}

