/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.loading;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.livebase.base.BaseViewModelFactory;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.databinding.BjyBaseFragmentLoading2Binding;
import com.baijiayun.liveuibase.loading.ILoadingWindow;
import com.baijiayun.liveuibase.loading.LoadingWindow2;
import com.baijiayun.liveuibase.loading.ProgressBarWithNumber;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0012\u0010$\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010&H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR#\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Lcom/baijiayun/liveuibase/loading/LoadingWindow2;", "Lcom/baijiayun/liveuibase/loading/ILoadingWindow;", "activity", "Landroidx/fragment/app/FragmentActivity;", "(Landroidx/fragment/app/FragmentActivity;)V", "_binding", "Lcom/baijiayun/liveuibase/databinding/BjyBaseFragmentLoading2Binding;", "animator", "Landroid/animation/ObjectAnimator;", "binding", "getBinding", "()Lcom/baijiayun/liveuibase/databinding/BjyBaseFragmentLoading2Binding;", "rootView", "Landroid/view/View;", "kotlin.jvm.PlatformType", "getRootView", "()Landroid/view/View;", "rootView$delegate", "Lkotlin/Lazy;", "routerViewModel", "Lcom/baijiayun/liveuibase/viewmodel/RouterViewModel;", "getRouterViewModel", "()Lcom/baijiayun/liveuibase/viewmodel/RouterViewModel;", "routerViewModel$delegate", "checkDevice", "", "enterRoom", "Lkotlin/Function0;", "getView", "onLaunchError", "error", "Lcom/baijiayun/livebase/context/LPError;", "onLaunchSteps", "step", "", "totalStep", "onLaunchSuccess", "liveRoom", "Lcom/baijiayun/livecore/context/LiveRoom;", "liveuibase_release"})
public final class LoadingWindow2
implements ILoadingWindow {
    @NotNull
    private final FragmentActivity activity;
    @Nullable
    private BjyBaseFragmentLoading2Binding _binding;
    @NotNull
    private final Lazy rootView$delegate;
    @NotNull
    private final Lazy routerViewModel$delegate;
    @Nullable
    private ObjectAnimator animator;

    public LoadingWindow2(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        this.rootView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<View>(this){
            final /* synthetic */ LoadingWindow2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final View invoke() {
                return LayoutInflater.from((Context)((Context)LoadingWindow2.access$getActivity$p(this.this$0))).inflate(R.layout.bjy_base_fragment_loading2, null);
            }
        }));
        this.routerViewModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RouterViewModel>(this){
            final /* synthetic */ LoadingWindow2 this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final RouterViewModel invoke() {
                void $this$getViewModel$iv;
                FragmentActivity fragmentActivity = LoadingWindow2.access$getActivity$p(this.this$0);
                Function0 creator$iv = routerViewModel.1.INSTANCE;
                boolean $i$f$getViewModel = false;
                return (RouterViewModel)(creator$iv == null ? new ViewModelProvider((ViewModelStoreOwner)$this$getViewModel$iv).get(RouterViewModel.class) : new ViewModelProvider((ViewModelStoreOwner)$this$getViewModel$iv, (ViewModelProvider.Factory)new BaseViewModelFactory(creator$iv)).get(RouterViewModel.class));
            }
        }));
        this._binding = BjyBaseFragmentLoading2Binding.bind(this.getRootView());
        this.getRootView().addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(@NotNull View v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                _binding = BjyBaseFragmentLoading2Binding.bind(this.getRootView());
            }

            public void onViewDetachedFromWindow(@NotNull View v) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    _binding = null;
                    ObjectAnimator objectAnimator = animator;
                    if (objectAnimator == null) break block0;
                    objectAnimator.cancel();
                }
            }
        });
    }

    private final BjyBaseFragmentLoading2Binding getBinding() {
        BjyBaseFragmentLoading2Binding bjyBaseFragmentLoading2Binding = this._binding;
        Intrinsics.checkNotNull((Object)bjyBaseFragmentLoading2Binding);
        return bjyBaseFragmentLoading2Binding;
    }

    private final View getRootView() {
        Lazy lazy = this.rootView$delegate;
        return (View)lazy.getValue();
    }

    private final RouterViewModel getRouterViewModel() {
        Lazy lazy = this.routerViewModel$delegate;
        return (RouterViewModel)((Object)lazy.getValue());
    }

    @Override
    public void onLaunchSteps(int step, int totalStep) {
        int start2 = this.getBinding().windowLoadingProgressbar.getProgress();
        int end = step * 100 / totalStep;
        ObjectAnimator objectAnimator = this.animator;
        boolean bl = objectAnimator != null ? objectAnimator.isRunning() : false;
        if (bl) {
            ObjectAnimator objectAnimator2 = this.animator;
            if (objectAnimator2 != null) {
                objectAnimator2.cancel();
            }
        }
        ProgressBarWithNumber cfr_ignored_0 = this.getBinding().windowLoadingProgressbar;
        int[] nArray = new int[]{start2, end};
        ObjectAnimator objectAnimator3 = this.animator = ObjectAnimator.ofInt((Object)((Object)this.getBinding().windowLoadingProgressbar), (String)"progress", (int[])nArray);
        if (objectAnimator3 != null) {
            objectAnimator3.setDuration(200L);
        }
        ObjectAnimator objectAnimator4 = this.animator;
        if (objectAnimator4 != null) {
            objectAnimator4.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        }
        ObjectAnimator objectAnimator5 = this.animator;
        if (objectAnimator5 != null) {
            objectAnimator5.start();
        }
        LPLogger.d((String)"loadingWindow", (String)("onLaunchSteps: \u767e\u5206\u6bd4=" + step));
        if (this.getRouterViewModel().isLiveRoomInitialized() && this.getRouterViewModel().getLiveRoom().getPartnerConfig() != null && step == 2) {
            String customIconUrl = this.getRouterViewModel().getLiveRoom().getPartnerConfig().smallCourseLogo.loadingCustomIconUrl;
            String bgUrl = this.getRouterViewModel().getLiveRoom().getPartnerConfig().smallCourseLogo.loadingBgUrl;
            if (!TextUtils.isEmpty((CharSequence)bgUrl)) {
                Glide.with((FragmentActivity)this.activity).load(this.getRouterViewModel().getLiveRoom().getPartnerConfig().smallCourseLogo.loadingBgUrl).into(this.getBinding().windowLoadingBgIv);
            } else {
                this.getBinding().windowLoadingBgIv.setBackgroundColor(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.bjy_base_dark_loading_window_bg));
            }
            if (!TextUtils.isEmpty((CharSequence)customIconUrl)) {
                Glide.with((FragmentActivity)this.activity).load(customIconUrl).apply(new RequestOptions().error(R.drawable.base_ic_vector_logo_blue)).into(this.getBinding().windowLoadingLogoIv);
            } else {
                this.getBinding().windowLoadingLogoIv.setImageResource(R.drawable.base_ic_vector_logo_blue);
            }
            LPLogger.d((String)"LPLaunchListener", (String)("onLaunchSteps: text color=" + this.getRouterViewModel().getLiveRoom().getPartnerConfig().progressTextColor + ".....bar color=" + this.getRouterViewModel().getLiveRoom().getPartnerConfig().progressBarColor + "....step=" + step));
            this.getBinding().windowLoadingProgressbar.setDescColor(this.getRouterViewModel().getLiveRoom().getPartnerConfig().progressTextColor);
            this.getBinding().windowLoadingProgressbar.setProgressBarColor(this.getRouterViewModel().getLiveRoom().getPartnerConfig().progressBarColor);
        }
    }

    @Override
    public void onLaunchSuccess(@Nullable LiveRoom liveRoom2) {
    }

    @Override
    public void onLaunchError(@NotNull LPError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
    }

    @Override
    public void checkDevice(@NotNull Function0<Unit> enterRoom2) {
        Intrinsics.checkNotNullParameter(enterRoom2, (String)"enterRoom");
        enterRoom2.invoke();
    }

    @Override
    @NotNull
    public View getView() {
        View view = this.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootView");
        return view;
    }

    public static final /* synthetic */ FragmentActivity access$getActivity$p(LoadingWindow2 $this) {
        return $this.activity;
    }
}

