/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.liveshow.shop;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.MultiTransformation;
import com.baijiayun.glide.load.Transformation;
import com.baijiayun.glide.load.resource.bitmap.CenterCrop;
import com.baijiayun.glide.load.resource.bitmap.RoundedCorners;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPLiveProductInventoryModel;
import com.baijiayun.livecore.models.LPLiveProductModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.liveshow.shop.ProductAdapter;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 @2\u000e\u0012\n\u0012\b\u0018\u00010\u0002R\u00020\u00000\u0001:\u0003@ABB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u001c\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060\u0002R\u00020\u00002\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0014\u0010\"\u001a\u00020\u001f2\n\u0010 \u001a\u00060\u0002R\u00020\u0000H\u0002J\u001e\u0010#\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0016J\u0010\u0010)\u001a\u00020'2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bJ$\u0010+\u001a\u00020\u001f2\n\u0010 \u001a\u00060\u0002R\u00020\u00002\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0003J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020'H\u0002J\u0016\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020'J\u001c\u00101\u001a\u00020\u001f2\n\u0010 \u001a\u00060\u0002R\u00020\u00002\u0006\u0010&\u001a\u00020'H\u0016J\u001c\u00102\u001a\u00060\u0002R\u00020\u00002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020'H\u0016J\u0010\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u000208H\u0016J\u0018\u00109\u001a\u00020\u001f2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0007J\u001e\u0010:\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u001c2\b\b\u0002\u0010=\u001a\u00020\bJ\u0018\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020\u00192\b\b\u0002\u0010=\u001a\u00020\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/baijiayun/liveuibase/liveshow/shop/ProductAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/baijiayun/liveuibase/liveshow/shop/ProductAdapter$ViewHolder;", "context", "Landroid/content/Context;", "liveRoom", "Lcom/baijiayun/livecore/context/LiveRoom;", "isSorting", "", "callback", "Lcom/baijiayun/liveuibase/liveshow/shop/ProductAdapter$ProductCallback;", "isMultiClass", "(Landroid/content/Context;Lcom/baijiayun/livecore/context/LiveRoom;ZLcom/baijiayun/liveuibase/liveshow/shop/ProductAdapter$ProductCallback;Z)V", "getCallback", "()Lcom/baijiayun/liveuibase/liveshow/shop/ProductAdapter$ProductCallback;", "getContext", "()Landroid/content/Context;", "disposeMap", "Ljava/util/HashMap;", "", "Lio/reactivex/disposables/Disposable;", "Lkotlin/collections/HashMap;", "getLiveRoom", "()Lcom/baijiayun/livecore/context/LiveRoom;", "productInventoryModel", "Lcom/baijiayun/livecore/models/LPLiveProductInventoryModel;", "productList", "", "Lcom/baijiayun/livecore/models/LPLiveProductModel;", "productModel", "bindOnSale", "", "viewHolder", "product", "bindSortDrag", "downLast", "list", "Ljava/util/ArrayList;", "position", "", "getItemCount", "getItemViewType", "getProductList", "handleInventory", "initOrder", "order", "itemMove", "fromPosition", "toPosition", "onBindViewHolder", "onCreateViewHolder", "viewGroup", "Landroid/view/ViewGroup;", "viewType", "onDetachedFromRecyclerView", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "setData", "topFirst", "updateSoldCountChange", "liveProductModel", "notify", "updateSoldInventoryChange", "lpLiveProductInventoryModel", "Companion", "ProductCallback", "ViewHolder", "liveuibase_release"})
public final class ProductAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final LiveRoom liveRoom;
    private final boolean isSorting;
    @NotNull
    private final ProductCallback callback;
    private final boolean isMultiClass;
    @Nullable
    private List<? extends LPLiveProductModel> productList;
    @NotNull
    private final HashMap<String, Disposable> disposeMap;
    @Nullable
    private LPLiveProductInventoryModel productInventoryModel;
    @Nullable
    private LPLiveProductModel productModel;
    private static final int ON_SALE = 0;
    private static final int ON_SALE_STUDENT = 1;
    private static final int NO_SHELF = 2;
    private static final int SORT_DRAG = 3;

    public ProductAdapter(@NotNull Context context2, @NotNull LiveRoom liveRoom2, boolean isSorting, @NotNull ProductCallback callback, boolean isMultiClass) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)liveRoom2, (String)"liveRoom");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.context = context2;
        this.liveRoom = liveRoom2;
        this.isSorting = isSorting;
        this.callback = callback;
        this.isMultiClass = isMultiClass;
        this.disposeMap = new HashMap();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final LiveRoom getLiveRoom() {
        return this.liveRoom;
    }

    @NotNull
    public final ProductCallback getCallback() {
        return this.callback;
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int viewType) {
        Intrinsics.checkNotNullParameter((Object)viewGroup, (String)"viewGroup");
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.bjy_base_show_item_product, viewGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"from(viewGroup.context)\n\u2026roduct, viewGroup, false)");
        View view2 = view;
        ViewHolder viewHolder = new ViewHolder(view2);
        if (this.isMultiClass) {
            viewHolder.getContainer().setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)viewHolder.getContainer().getContext(), (int)R.attr.base_theme_window_bg_color)).build());
        }
        switch (viewType) {
            case 0: {
                viewHolder.getOptContainer().setVisibility(0);
                viewHolder.getTvBuy().setVisibility(8);
                viewHolder.getTvProductExplain().setVisibility(0);
                viewHolder.getTvDragTip().setVisibility(8);
                viewHolder.getTvChangeShelfStateOrTop().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_turn_to_not_on_sale));
                viewHolder.getTvChangeShelfStateOrTop().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_white));
                viewHolder.getTvChangeShelfStateOrTop().setBackgroundResource(R.drawable.live_sell_go2opt_bg);
                viewHolder.getTvDetailOrDown().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_turn_to_detail));
                break;
            }
            case 1: {
                viewHolder.getOptContainer().setVisibility(8);
                viewHolder.getTvBuy().setVisibility(0);
                break;
            }
            case 2: {
                viewHolder.getOptContainer().setVisibility(0);
                viewHolder.getTvBuy().setVisibility(8);
                viewHolder.getTvProductExplain().setVisibility(8);
                viewHolder.getTvDragTip().setVisibility(8);
                viewHolder.getTvChangeShelfStateOrTop().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_turn_to_on_sale));
                viewHolder.getTvChangeShelfStateOrTop().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_white));
                viewHolder.getTvChangeShelfStateOrTop().setBackgroundResource(R.drawable.bjy_show_bg_enable_on_sale);
                viewHolder.getTvChangeShelfStateOrTop().setEnabled(true);
                viewHolder.getTvDetailOrDown().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_turn_to_detail));
                break;
            }
            case 3: {
                viewHolder.getOptContainer().setVisibility(0);
                viewHolder.getTvBuy().setVisibility(8);
                viewHolder.getTvProductExplain().setVisibility(8);
                viewHolder.getTvDragTip().setVisibility(0);
                viewHolder.getTvChangeShelfStateOrTop().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_sort_top));
                viewHolder.getTvChangeShelfStateOrTop().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_white));
                viewHolder.getTvChangeShelfStateOrTop().setBackgroundResource(R.drawable.live_sell_go2opt_bg);
                viewHolder.getTvDetailOrDown().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_sort_bottom));
            }
        }
        return viewHolder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getItemViewType(int position) {
        if (this.isSorting) {
            return 3;
        }
        if (!this.liveRoom.isTeacherOrAssistant()) return 1;
        if (this.productList == null) return 2;
        List<? extends LPLiveProductModel> list = this.productList;
        Intrinsics.checkNotNull(list);
        if (!list.get((int)position).isOnShelf) return 2;
        return 0;
    }

    public void onBindViewHolder(@NotNull ViewHolder viewHolder, int position) {
        Object[] objectArray;
        Object[] objectArray2;
        Intrinsics.checkNotNullParameter((Object)((Object)viewHolder), (String)"viewHolder");
        List<? extends LPLiveProductModel> list = this.productList;
        Intrinsics.checkNotNull(list);
        LPLiveProductModel product = list.get(position);
        viewHolder.getTvProductName().setText((CharSequence)product.name);
        viewHolder.getTvOrder().setText((CharSequence)this.initOrder(product.serialNumber));
        if (this.liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            if (this.liveRoom.getLiveShowVM().isProductPriceVisible()) {
                viewHolder.getTvProductPrice().setVisibility(0);
                viewHolder.getTvRealPrice().setVisibility(0);
            } else {
                viewHolder.getTvProductPrice().setVisibility(8);
                viewHolder.getTvRealPrice().setVisibility(8);
            }
        }
        if (product.discountPrice <= 0.0) {
            viewHolder.getTvRealPrice().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_free));
        } else {
            TextView textView = viewHolder.getTvRealPrice();
            Object[] objectArray3 = this.context.getString(R.string.bjy_base_sell_price_prefix);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"context.getString(R.stri\u2026y_base_sell_price_prefix)");
            objectArray2 = objectArray3;
            objectArray = new Object[]{new DecimalFormat("0.00").format(product.discountPrice)};
            String string2 = String.format((String)objectArray2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            textView.setText((CharSequence)string2);
        }
        TextView textView = viewHolder.getTvProductPrice();
        String string3 = this.context.getString(R.string.bjy_base_sell_price_prefix);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026y_base_sell_price_prefix)");
        objectArray2 = string3;
        objectArray = new Object[]{new DecimalFormat("0.00").format(product.price)};
        String string4 = String.format((String)objectArray2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        textView.setText((CharSequence)string4);
        if (product.id.equals(this.liveRoom.getLiveShowVM().getExplainProduct().id)) {
            viewHolder.getTvExplainLabel().setVisibility(0);
            viewHolder.getExplainLayer().setVisibility(0);
        } else {
            viewHolder.getTvExplainLabel().setVisibility(8);
            viewHolder.getExplainLayer().setVisibility(8);
        }
        if (product.showSold) {
            int count = product.soldCountType == LPConstants.LiveSoldCountType.ROOM_SALE_COUNT ? product.roomSaleCount + product.virtualSaleCount : product.totalSaleCount + product.virtualSaleCount;
            viewHolder.getTvProductSellCount().setVisibility(0);
            objectArray2 = new Object[]{count};
            viewHolder.getTvProductSellCount().setText((CharSequence)viewHolder.getTvProductSellCount().getContext().getString(R.string.bjy_base_sold_count, objectArray2));
        } else {
            viewHolder.getTvProductSellCount().setVisibility(8);
        }
        objectArray = new Transformation[]{(Transformation)new CenterCrop(), (Transformation)new RoundedCorners(UtilsKt.getDp((int)4))};
        RequestOptions requestOptions = RequestOptions.bitmapTransform((Transformation)((Transformation)new MultiTransformation((Transformation[])objectArray))).placeholder(R.drawable.live_show_ic_empty_sell_list);
        Intrinsics.checkNotNullExpressionValue((Object)requestOptions, (String)"bitmapTransform(\n       \u2026_show_ic_empty_sell_list)");
        RequestOptions requestOptions2 = requestOptions;
        Glide.with((Context)this.context).asBitmap().load(product.imgUrl).apply(requestOptions2).into(viewHolder.getIvIcon());
        this.handleInventory(viewHolder, product, position);
        switch (viewHolder.getItemViewType()) {
            case 0: {
                this.bindOnSale(viewHolder, product);
                break;
            }
            case 1: {
                viewHolder.getTvBuy().setOnClickListener(arg_0 -> ProductAdapter.onBindViewHolder$lambda$0(this, product, arg_0));
                break;
            }
            case 2: {
                viewHolder.getTvChangeShelfStateOrTop().setOnClickListener(arg_0 -> ProductAdapter.onBindViewHolder$lambda$1(this, product, arg_0));
                viewHolder.getTvDetailOrDown().setOnClickListener(arg_0 -> ProductAdapter.onBindViewHolder$lambda$2(this, product, arg_0));
                break;
            }
            case 3: {
                this.bindSortDrag(viewHolder);
            }
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    private final void handleInventory(ViewHolder viewHolder, LPLiveProductModel product, int position) {
        block13: {
            block14: {
                Ref.LongRef virtualInventory;
                block12: {
                    viewHolder.getTvBuy().setEnabled(true);
                    if (product.isVirtualInventoryIsOpen()) {
                        if (product.virtualInventory == 0L) {
                            viewHolder.getTimerContainer().setVisibility(8);
                            viewHolder.getSoldOutContainer().setVisibility(0);
                            viewHolder.getTvBuy().setEnabled(false);
                            Disposable disposable2 = this.disposeMap.get(product.id);
                            if (disposable2 != null) {
                                disposable2.dispose();
                            }
                        } else {
                            viewHolder.getTimerContainer().setVisibility(0);
                            viewHolder.getSoldOutContainer().setVisibility(8);
                            viewHolder.getTimeTv().setText((CharSequence)("" + 'x' + product.virtualInventory));
                        }
                    } else {
                        Disposable disposable3 = this.disposeMap.get(product.id);
                        if (disposable3 != null) {
                            disposable3.dispose();
                        }
                        viewHolder.getTimerContainer().setVisibility(8);
                        viewHolder.getSoldOutContainer().setVisibility(8);
                    }
                    virtualInventory = new Ref.LongRef();
                    if (product.isStopTask || product.duration <= 0L || !(product.reducePercent > 0.0f)) break block12;
                    long leftDuration = product.beginTime + product.duration - System.currentTimeMillis() / (long)1000;
                    if (leftDuration < 0L) {
                        virtualInventory.element = (long)((float)product.virtualInventory * ((float)100 - product.reducePercent) / (float)100);
                        viewHolder.getTimeTv().setText((CharSequence)("" + 'x' + virtualInventory.element));
                    } else {
                        virtualInventory.element = MathKt.roundToLong((float)((float)product.virtualInventory - (float)product.virtualInventory * product.reducePercent / (float)100 / (float)product.duration * (float)(System.currentTimeMillis() / (long)1000 - product.beginTime)));
                        viewHolder.getTimeTv().setText((CharSequence)("" + 'x' + virtualInventory.element));
                        Disposable disposable4 = this.disposeMap.get(product.id);
                        if (disposable4 != null) {
                            disposable4.dispose();
                        }
                        Disposable disposable5 = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).take(leftDuration).observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> ProductAdapter.handleInventory$lambda$3((Function1)new Function1<Long, Unit>(virtualInventory, product, viewHolder){
                            final /* synthetic */ Ref.LongRef $virtualInventory;
                            final /* synthetic */ LPLiveProductModel $product;
                            final /* synthetic */ ViewHolder $viewHolder;
                            {
                                this.$virtualInventory = $virtualInventory;
                                this.$product = $product;
                                this.$viewHolder = $viewHolder;
                                super(1);
                            }

                            public final void invoke(Long it) {
                                long virtualInventoryOrigin = this.$virtualInventory.element;
                                this.$virtualInventory.element = MathKt.roundToLong((float)((float)this.$product.virtualInventory - (float)this.$product.virtualInventory * this.$product.reducePercent / (float)100 / (float)this.$product.duration * (float)(System.currentTimeMillis() / (long)1000 - this.$product.beginTime)));
                                if (this.$virtualInventory.element != virtualInventoryOrigin) {
                                    this.$viewHolder.getTimeTv().setText((CharSequence)("" + 'x' + this.$virtualInventory.element));
                                    this.$viewHolder.getTimeTv().animate().scaleX(1.2f).scaleY(1.2f).setDuration(300L).withEndAction(() -> handleInventory.disposable.1.invoke$lambda$0(this.$viewHolder));
                                }
                            }

                            private static final void invoke$lambda$0(ViewHolder $viewHolder) {
                                Intrinsics.checkNotNullParameter((Object)((Object)$viewHolder), (String)"$viewHolder");
                                $viewHolder.getTimeTv().animate().scaleX(1.0f).scaleY(1.0f).setDuration(200L);
                            }
                        }, arg_0));
                        Map map = this.disposeMap;
                        String string2 = product.id;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"product.id");
                        String string3 = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)disposable5, (String)"disposable");
                        Disposable disposable6 = disposable5;
                        map.put(string3, disposable6);
                    }
                    break block13;
                }
                if (product.isStopTask || product.cleaningSeconds <= 0) break block14;
                long leftDuration = product.beginTime + (long)product.cleaningSeconds - System.currentTimeMillis() / (long)1000;
                if (leftDuration < 0L) {
                    virtualInventory.element = 0L;
                    viewHolder.getTimeTv().setText((CharSequence)("" + 'x' + virtualInventory.element));
                } else {
                    virtualInventory.element = product.virtualInventory - (System.currentTimeMillis() / (long)1000 - product.beginTime) * product.virtualInventory / (long)product.cleaningSeconds;
                    viewHolder.getTimeTv().setText((CharSequence)("" + 'x' + virtualInventory.element));
                    Disposable disposable7 = this.disposeMap.get(product.id);
                    if (disposable7 != null) {
                        disposable7.dispose();
                    }
                    Disposable disposable8 = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).take(leftDuration).observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> ProductAdapter.handleInventory$lambda$4((Function1)new Function1<Long, Unit>(virtualInventory, product, viewHolder){
                        final /* synthetic */ Ref.LongRef $virtualInventory;
                        final /* synthetic */ LPLiveProductModel $product;
                        final /* synthetic */ ViewHolder $viewHolder;
                        {
                            this.$virtualInventory = $virtualInventory;
                            this.$product = $product;
                            this.$viewHolder = $viewHolder;
                            super(1);
                        }

                        public final void invoke(Long it) {
                            long virtualInventoryOrigin = this.$virtualInventory.element;
                            this.$virtualInventory.element = this.$product.virtualInventory - (System.currentTimeMillis() / (long)1000 - this.$product.beginTime) * this.$product.virtualInventory / (long)this.$product.cleaningSeconds;
                            if (this.$virtualInventory.element != virtualInventoryOrigin) {
                                this.$viewHolder.getTimeTv().setText((CharSequence)("" + 'x' + this.$virtualInventory.element));
                                this.$viewHolder.getTimeTv().animate().scaleX(1.2f).scaleY(1.2f).setDuration(300L).withEndAction(() -> handleInventory.disposable.2.invoke$lambda$0(this.$viewHolder));
                            }
                        }

                        private static final void invoke$lambda$0(ViewHolder $viewHolder) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$viewHolder), (String)"$viewHolder");
                            $viewHolder.getTimeTv().animate().scaleX(1.0f).scaleY(1.0f).setDuration(200L);
                        }
                    }, arg_0));
                    Map map = this.disposeMap;
                    String string4 = product.id;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"product.id");
                    String string5 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)disposable8, (String)"disposable");
                    Disposable disposable9 = disposable8;
                    map.put(string5, disposable9);
                }
                break block13;
            }
            Disposable disposable10 = this.disposeMap.get(product.id);
            if (disposable10 == null) break block13;
            disposable10.dispose();
        }
    }

    private final void bindOnSale(ViewHolder viewHolder, LPLiveProductModel product) {
        viewHolder.getTvChangeShelfStateOrTop().setEnabled(TextUtils.isEmpty((CharSequence)this.liveRoom.getLiveShowVM().getExplainProduct().id) || !Intrinsics.areEqual((Object)product.id, (Object)this.liveRoom.getLiveShowVM().getExplainProduct().id));
        viewHolder.getTvChangeShelfStateOrTop().setTextColor(ResourcesCompat.getColor((Resources)this.context.getResources(), (int)(TextUtils.isEmpty((CharSequence)this.liveRoom.getLiveShowVM().getExplainProduct().id) || !Intrinsics.areEqual((Object)product.id, (Object)this.liveRoom.getLiveShowVM().getExplainProduct().id) ? R.color.base_white : R.color.base_assistant_text_color), null));
        if (TextUtils.isEmpty((CharSequence)this.liveRoom.getLiveShowVM().getExplainProduct().id)) {
            Object[] objectArray = new Object[]{TextUtils.isEmpty((CharSequence)this.liveRoom.getPartnerConfig().productCustomRename) ? "\u5546\u54c1" : this.liveRoom.getPartnerConfig().productCustomRename};
            viewHolder.getTvProductExplain().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_explain, objectArray));
        } else if (Intrinsics.areEqual((Object)product.id, (Object)this.liveRoom.getLiveShowVM().getExplainProduct().id)) {
            viewHolder.getTvProductExplain().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_cancel_explain));
        } else {
            Object[] objectArray = new Object[]{TextUtils.isEmpty((CharSequence)this.liveRoom.getPartnerConfig().productCustomRename) ? "\u5546\u54c1" : this.liveRoom.getPartnerConfig().productCustomRename};
            viewHolder.getTvProductExplain().setText((CharSequence)this.context.getString(R.string.bjy_base_show_shop_explain, objectArray));
        }
        viewHolder.getTvChangeShelfStateOrTop().setOnClickListener(arg_0 -> ProductAdapter.bindOnSale$lambda$5(this, product, arg_0));
        viewHolder.getTvDetailOrDown().setOnClickListener(arg_0 -> ProductAdapter.bindOnSale$lambda$6(this, product, arg_0));
        viewHolder.getTvProductExplain().setOnClickListener(arg_0 -> ProductAdapter.bindOnSale$lambda$7(this, product, arg_0));
    }

    private final void bindSortDrag(ViewHolder viewHolder) {
        viewHolder.getTvChangeShelfStateOrTop().setOnClickListener(arg_0 -> ProductAdapter.bindSortDrag$lambda$8(this, viewHolder, arg_0));
        viewHolder.getTvDetailOrDown().setOnClickListener(arg_0 -> ProductAdapter.bindSortDrag$lambda$9(this, viewHolder, arg_0));
        if (this.getItemCount() == 1) {
            viewHolder.getTvChangeShelfStateOrTop().setEnabled(false);
            viewHolder.getTvChangeShelfStateOrTop().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_assistant_text_color));
            viewHolder.getTvDetailOrDown().setEnabled(false);
            viewHolder.getTvDetailOrDown().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_assistant_text_color));
        } else if (viewHolder.getBindingAdapterPosition() == 0) {
            viewHolder.getTvChangeShelfStateOrTop().setEnabled(false);
            viewHolder.getTvChangeShelfStateOrTop().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_assistant_text_color));
            viewHolder.getTvDetailOrDown().setEnabled(true);
            viewHolder.getTvDetailOrDown().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_white));
        } else if (viewHolder.getBindingAdapterPosition() == this.getItemCount() - 1) {
            viewHolder.getTvChangeShelfStateOrTop().setEnabled(true);
            viewHolder.getTvChangeShelfStateOrTop().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_white));
            viewHolder.getTvDetailOrDown().setEnabled(false);
            viewHolder.getTvDetailOrDown().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_assistant_text_color));
        } else {
            viewHolder.getTvChangeShelfStateOrTop().setEnabled(true);
            viewHolder.getTvChangeShelfStateOrTop().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_white));
            viewHolder.getTvDetailOrDown().setEnabled(true);
            viewHolder.getTvDetailOrDown().setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_white));
        }
    }

    private final void topFirst(ArrayList<LPLiveProductModel> list, int position) {
        list.add(0, list.remove(position));
    }

    private final void downLast(ArrayList<LPLiveProductModel> list, int position) {
        list.add(list.remove(position));
    }

    private final String initOrder(int order) {
        return order < 0 ? "0" : String.valueOf(order);
    }

    public final void updateSoldCountChange(@NotNull LPLiveProductModel liveProductModel, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)liveProductModel, (String)"liveProductModel");
        if (this.productList == null) {
            this.productModel = liveProductModel;
            return;
        }
        List<? extends LPLiveProductModel> list = this.productList;
        Intrinsics.checkNotNull(list);
        List<? extends LPLiveProductModel> $this$updateSoldCountChange_u24lambda_u2410 = list;
        boolean bl = false;
        Iterator<? extends LPLiveProductModel> iterator = $this$updateSoldCountChange_u24lambda_u2410.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            LPLiveProductModel productModel = iterator.next();
            if (!Intrinsics.areEqual((Object)productModel.id, (Object)liveProductModel.id)) continue;
            productModel.totalSaleCount = liveProductModel.totalSaleCount;
            productModel.virtualSaleCount = liveProductModel.virtualSaleCount;
            productModel.roomSaleCount = liveProductModel.roomSaleCount;
            if (!notify) break;
            this.notifyItemChanged(index);
            break;
        }
    }

    public static /* synthetic */ void updateSoldCountChange$default(ProductAdapter productAdapter, LPLiveProductModel lPLiveProductModel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        productAdapter.updateSoldCountChange(lPLiveProductModel, bl);
    }

    public final void updateSoldInventoryChange(@NotNull LPLiveProductInventoryModel lpLiveProductInventoryModel, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)lpLiveProductInventoryModel, (String)"lpLiveProductInventoryModel");
        if (this.productList == null) {
            this.productInventoryModel = lpLiveProductInventoryModel;
            return;
        }
        List<? extends LPLiveProductModel> list = this.productList;
        Intrinsics.checkNotNull(list);
        List<? extends LPLiveProductModel> $this$updateSoldInventoryChange_u24lambda_u2411 = list;
        boolean bl = false;
        Iterator<? extends LPLiveProductModel> iterator = $this$updateSoldInventoryChange_u24lambda_u2411.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            LPLiveProductModel productModel = iterator.next();
            if (!Intrinsics.areEqual((Object)productModel.id, (Object)String.valueOf(lpLiveProductInventoryModel.id))) continue;
            productModel.beginTime = lpLiveProductInventoryModel.beginTime;
            productModel.isStopTask = lpLiveProductInventoryModel.isStopTask;
            productModel.cleaningSeconds = lpLiveProductInventoryModel.cleaningSeconds;
            productModel.duration = lpLiveProductInventoryModel.duration;
            productModel.reducePercent = lpLiveProductInventoryModel.reducePercent;
            productModel.virtualInventory = lpLiveProductInventoryModel.virtualInventory;
            productModel.setVirtualInventoryIsOpen(lpLiveProductInventoryModel.virtualInventoryIsOpen());
            if (!notify) break;
            this.notifyItemChanged(index);
            break;
        }
    }

    public static /* synthetic */ void updateSoldInventoryChange$default(ProductAdapter productAdapter, LPLiveProductInventoryModel lPLiveProductInventoryModel, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        productAdapter.updateSoldInventoryChange(lPLiveProductInventoryModel, bl);
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    public final void setData(@Nullable List<? extends LPLiveProductModel> productList) {
        this.productList = productList;
        if (this.productModel != null) {
            LPLiveProductModel lPLiveProductModel = this.productModel;
            Intrinsics.checkNotNull((Object)lPLiveProductModel);
            ProductAdapter.updateSoldCountChange$default(this, lPLiveProductModel, false, 2, null);
            this.productModel = null;
        }
        if (this.productInventoryModel != null) {
            LPLiveProductInventoryModel lPLiveProductInventoryModel = this.productInventoryModel;
            Intrinsics.checkNotNull((Object)lPLiveProductInventoryModel);
            this.updateSoldInventoryChange(lPLiveProductInventoryModel, false);
            this.productInventoryModel = null;
        }
        this.notifyDataSetChanged();
    }

    @Nullable
    public final List<LPLiveProductModel> getProductList() {
        return this.productList;
    }

    public final void itemMove(int fromPosition, int toPosition) {
        block0: {
            List<? extends LPLiveProductModel> list = this.productList;
            if (list == null) break block0;
            List<? extends LPLiveProductModel> it = list;
            boolean bl = false;
            Collections.swap(it, fromPosition, toPosition);
            this.notifyItemMoved(fromPosition, toPosition);
        }
    }

    public void onDetachedFromRecyclerView(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        super.onDetachedFromRecyclerView(recyclerView);
        Map $this$forEach$iv = this.disposeMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String t = (String)entry.getKey();
            Disposable u = (Disposable)entry.getValue();
            u.dispose();
        }
        this.disposeMap.clear();
    }

    public int getItemCount() {
        int n;
        if (this.productList == null) {
            n = 0;
        } else {
            List<? extends LPLiveProductModel> list = this.productList;
            Intrinsics.checkNotNull(list);
            n = list.size();
        }
        return n;
    }

    private static final void onBindViewHolder$lambda$0(ProductAdapter this$0, LPLiveProductModel $product, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$product, (String)"$product");
        this$0.callback.onOpenBrowserToBuy($product);
    }

    private static final void onBindViewHolder$lambda$1(ProductAdapter this$0, LPLiveProductModel $product, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$product, (String)"$product");
        this$0.liveRoom.getLiveShowVM().requestChangeSaleState($product.id, true);
        this$0.callback.onProductShelfStateChanged($product, true);
    }

    private static final void onBindViewHolder$lambda$2(ProductAdapter this$0, LPLiveProductModel $product, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$product, (String)"$product");
        this$0.callback.onOpenProductDetail($product);
    }

    private static final void handleInventory$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void handleInventory$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void bindOnSale$lambda$5(ProductAdapter this$0, LPLiveProductModel $product, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$product, (String)"$product");
        this$0.liveRoom.getLiveShowVM().requestChangeSaleState($product.id, false);
        this$0.callback.onProductShelfStateChanged($product, false);
    }

    private static final void bindOnSale$lambda$6(ProductAdapter this$0, LPLiveProductModel $product, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$product, (String)"$product");
        this$0.callback.onOpenProductDetail($product);
    }

    private static final void bindOnSale$lambda$7(ProductAdapter this$0, LPLiveProductModel $product, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$product, (String)"$product");
        if (!this$0.liveRoom.getLiveShowVM().isProductVisible()) {
            ToastCompat.showToast((Context)this$0.context, (CharSequence)this$0.context.getString(R.string.bjy_base_show_shop_explain_before), (int)0);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this$0.liveRoom.getLiveShowVM().getExplainProduct().id) || !TextUtils.equals((CharSequence)$product.id, (CharSequence)this$0.liveRoom.getLiveShowVM().getExplainProduct().id)) {
            this$0.liveRoom.getLiveShowVM().requestExplainProduct($product.id);
        } else {
            this$0.liveRoom.getLiveShowVM().requestExplainProduct("");
        }
    }

    private static final void bindSortDrag$lambda$8(ProductAdapter this$0, ViewHolder $viewHolder, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$viewHolder), (String)"$viewHolder");
        List<? extends LPLiveProductModel> list = this$0.productList;
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type java.util.ArrayList<com.baijiayun.livecore.models.LPLiveProductModel>");
        this$0.topFirst((ArrayList)list, $viewHolder.getBindingAdapterPosition());
        this$0.notifyDataSetChanged();
    }

    private static final void bindSortDrag$lambda$9(ProductAdapter this$0, ViewHolder $viewHolder, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$viewHolder), (String)"$viewHolder");
        List<? extends LPLiveProductModel> list = this$0.productList;
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type java.util.ArrayList<com.baijiayun.livecore.models.LPLiveProductModel>");
        this$0.downLast((ArrayList)list, $viewHolder.getBindingAdapterPosition());
        this$0.notifyDataSetChanged();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b)\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\tR\u001a\u0010%\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010(\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R\u001a\u0010+\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001f\"\u0004\b-\u0010!R\u001a\u0010.\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001f\"\u0004\b0\u0010!R\u001a\u00101\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001f\"\u0004\b3\u0010!R\u001a\u00104\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001f\"\u0004\b6\u0010!R\u001a\u00107\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001f\"\u0004\b9\u0010!R\u001a\u0010:\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u001f\"\u0004\b<\u0010!R\u001a\u0010=\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u001f\"\u0004\b?\u0010!R\u001a\u0010@\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u001f\"\u0004\bB\u0010!R\u001a\u0010C\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u001f\"\u0004\bE\u0010!\u00a8\u0006F"}, d2={"Lcom/baijiayun/liveuibase/liveshow/shop/ProductAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Lcom/baijiayun/liveuibase/liveshow/shop/ProductAdapter;Landroid/view/View;)V", "container", "getContainer", "()Landroid/view/View;", "setContainer", "(Landroid/view/View;)V", "explainLayer", "getExplainLayer", "setExplainLayer", "ivIcon", "Landroid/widget/ImageView;", "getIvIcon", "()Landroid/widget/ImageView;", "setIvIcon", "(Landroid/widget/ImageView;)V", "optContainer", "Landroid/widget/RelativeLayout;", "getOptContainer", "()Landroid/widget/RelativeLayout;", "setOptContainer", "(Landroid/widget/RelativeLayout;)V", "soldOutContainer", "getSoldOutContainer", "setSoldOutContainer", "timeTv", "Landroid/widget/TextView;", "getTimeTv", "()Landroid/widget/TextView;", "setTimeTv", "(Landroid/widget/TextView;)V", "timerContainer", "getTimerContainer", "setTimerContainer", "tvBuy", "getTvBuy", "setTvBuy", "tvChangeShelfStateOrTop", "getTvChangeShelfStateOrTop", "setTvChangeShelfStateOrTop", "tvDetailOrDown", "getTvDetailOrDown", "setTvDetailOrDown", "tvDragTip", "getTvDragTip", "setTvDragTip", "tvExplainLabel", "getTvExplainLabel", "setTvExplainLabel", "tvOrder", "getTvOrder", "setTvOrder", "tvProductExplain", "getTvProductExplain", "setTvProductExplain", "tvProductName", "getTvProductName", "setTvProductName", "tvProductPrice", "getTvProductPrice", "setTvProductPrice", "tvProductSellCount", "getTvProductSellCount", "setTvProductSellCount", "tvRealPrice", "getTvRealPrice", "setTvRealPrice", "liveuibase_release"})
    public final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private TextView tvProductName;
        @NotNull
        private TextView tvBuy;
        @NotNull
        private TextView tvProductSellCount;
        @NotNull
        private TextView tvRealPrice;
        @NotNull
        private TextView tvProductPrice;
        @NotNull
        private ImageView ivIcon;
        @NotNull
        private RelativeLayout optContainer;
        @NotNull
        private TextView tvDetailOrDown;
        @NotNull
        private TextView tvChangeShelfStateOrTop;
        @NotNull
        private TextView tvOrder;
        @NotNull
        private TextView tvProductExplain;
        @NotNull
        private TextView tvDragTip;
        @NotNull
        private TextView tvExplainLabel;
        @NotNull
        private View explainLayer;
        @NotNull
        private View container;
        @NotNull
        private View timerContainer;
        @NotNull
        private View soldOutContainer;
        @NotNull
        private TextView timeTv;

        public ViewHolder(View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.live_show_product_icon);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.live_show_product_icon)");
            this.ivIcon = (ImageView)view;
            View view2 = itemView.findViewById(R.id.live_show_product_order);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView.findViewById(R.\u2026.live_show_product_order)");
            this.tvOrder = (TextView)view2;
            View view3 = itemView.findViewById(R.id.live_show_product_name);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"itemView.findViewById(R.id.live_show_product_name)");
            this.tvProductName = (TextView)view3;
            View view4 = itemView.findViewById(R.id.live_show_product_sell_count);
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"itemView.findViewById(R.\u2026_show_product_sell_count)");
            this.tvProductSellCount = (TextView)view4;
            View view5 = itemView.findViewById(R.id.live_show_product_buy);
            Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"itemView.findViewById(R.id.live_show_product_buy)");
            this.tvBuy = (TextView)view5;
            View view6 = itemView.findViewById(R.id.live_show_product_real_price);
            Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"itemView.findViewById(R.\u2026_show_product_real_price)");
            this.tvRealPrice = (TextView)view6;
            View view7 = itemView.findViewById(R.id.live_show_product_price);
            Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"itemView.findViewById(R.\u2026.live_show_product_price)");
            this.tvProductPrice = (TextView)view7;
            this.tvProductPrice.getPaint().setFlags(16);
            View view8 = itemView.findViewById(R.id.live_show_product_opt_container);
            Intrinsics.checkNotNullExpressionValue((Object)view8, (String)"itemView.findViewById(R.\u2026ow_product_opt_container)");
            this.optContainer = (RelativeLayout)view8;
            View view9 = itemView.findViewById(R.id.live_show_product_check_detail_or_down);
            Intrinsics.checkNotNullExpressionValue((Object)view9, (String)"itemView.findViewById(R.\u2026uct_check_detail_or_down)");
            this.tvDetailOrDown = (TextView)view9;
            View view10 = itemView.findViewById(R.id.live_show_product_change_shelf_state_or_top);
            Intrinsics.checkNotNullExpressionValue((Object)view10, (String)"itemView.findViewById(R.\u2026hange_shelf_state_or_top)");
            this.tvChangeShelfStateOrTop = (TextView)view10;
            View view11 = itemView.findViewById(R.id.live_show_product_explain);
            Intrinsics.checkNotNullExpressionValue((Object)view11, (String)"itemView.findViewById(R.\u2026ive_show_product_explain)");
            this.tvProductExplain = (TextView)view11;
            View view12 = itemView.findViewById(R.id.tv_drag_tip);
            Intrinsics.checkNotNullExpressionValue((Object)view12, (String)"itemView.findViewById(R.id.tv_drag_tip)");
            this.tvDragTip = (TextView)view12;
            View view13 = itemView.findViewById(R.id.live_show_explain_label);
            Intrinsics.checkNotNullExpressionValue((Object)view13, (String)"itemView.findViewById(R.\u2026.live_show_explain_label)");
            this.tvExplainLabel = (TextView)view13;
            View view14 = itemView.findViewById(R.id.live_show_explain_layer);
            Intrinsics.checkNotNullExpressionValue((Object)view14, (String)"itemView.findViewById(R.\u2026.live_show_explain_layer)");
            this.explainLayer = view14;
            View view15 = itemView.findViewById(R.id.container);
            Intrinsics.checkNotNullExpressionValue((Object)view15, (String)"itemView.findViewById(R.id.container)");
            this.container = view15;
            View view16 = itemView.findViewById(R.id.live_show_sold_time_container);
            Intrinsics.checkNotNullExpressionValue((Object)view16, (String)"itemView.findViewById(R.\u2026show_sold_time_container)");
            this.timerContainer = view16;
            View view17 = itemView.findViewById(R.id.live_show_sold_out_container);
            Intrinsics.checkNotNullExpressionValue((Object)view17, (String)"itemView.findViewById(R.\u2026_show_sold_out_container)");
            this.soldOutContainer = view17;
            View view18 = itemView.findViewById(R.id.live_show_sold_time_tv);
            Intrinsics.checkNotNullExpressionValue((Object)view18, (String)"itemView.findViewById(R.id.live_show_sold_time_tv)");
            this.timeTv = (TextView)view18;
        }

        @NotNull
        public final TextView getTvProductName() {
            return this.tvProductName;
        }

        public final void setTvProductName(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvProductName = textView;
        }

        @NotNull
        public final TextView getTvBuy() {
            return this.tvBuy;
        }

        public final void setTvBuy(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvBuy = textView;
        }

        @NotNull
        public final TextView getTvProductSellCount() {
            return this.tvProductSellCount;
        }

        public final void setTvProductSellCount(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvProductSellCount = textView;
        }

        @NotNull
        public final TextView getTvRealPrice() {
            return this.tvRealPrice;
        }

        public final void setTvRealPrice(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvRealPrice = textView;
        }

        @NotNull
        public final TextView getTvProductPrice() {
            return this.tvProductPrice;
        }

        public final void setTvProductPrice(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvProductPrice = textView;
        }

        @NotNull
        public final ImageView getIvIcon() {
            return this.ivIcon;
        }

        public final void setIvIcon(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.ivIcon = imageView;
        }

        @NotNull
        public final RelativeLayout getOptContainer() {
            return this.optContainer;
        }

        public final void setOptContainer(@NotNull RelativeLayout relativeLayout) {
            Intrinsics.checkNotNullParameter((Object)relativeLayout, (String)"<set-?>");
            this.optContainer = relativeLayout;
        }

        @NotNull
        public final TextView getTvDetailOrDown() {
            return this.tvDetailOrDown;
        }

        public final void setTvDetailOrDown(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvDetailOrDown = textView;
        }

        @NotNull
        public final TextView getTvChangeShelfStateOrTop() {
            return this.tvChangeShelfStateOrTop;
        }

        public final void setTvChangeShelfStateOrTop(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvChangeShelfStateOrTop = textView;
        }

        @NotNull
        public final TextView getTvOrder() {
            return this.tvOrder;
        }

        public final void setTvOrder(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvOrder = textView;
        }

        @NotNull
        public final TextView getTvProductExplain() {
            return this.tvProductExplain;
        }

        public final void setTvProductExplain(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvProductExplain = textView;
        }

        @NotNull
        public final TextView getTvDragTip() {
            return this.tvDragTip;
        }

        public final void setTvDragTip(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvDragTip = textView;
        }

        @NotNull
        public final TextView getTvExplainLabel() {
            return this.tvExplainLabel;
        }

        public final void setTvExplainLabel(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.tvExplainLabel = textView;
        }

        @NotNull
        public final View getExplainLayer() {
            return this.explainLayer;
        }

        public final void setExplainLayer(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
            this.explainLayer = view;
        }

        @NotNull
        public final View getContainer() {
            return this.container;
        }

        public final void setContainer(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
            this.container = view;
        }

        @NotNull
        public final View getTimerContainer() {
            return this.timerContainer;
        }

        public final void setTimerContainer(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
            this.timerContainer = view;
        }

        @NotNull
        public final View getSoldOutContainer() {
            return this.soldOutContainer;
        }

        public final void setSoldOutContainer(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
            this.soldOutContainer = view;
        }

        @NotNull
        public final TextView getTimeTv() {
            return this.timeTv;
        }

        public final void setTimeTv(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.timeTv = textView;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&J\u0012\u0010\t\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&J\u0012\u0010\n\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&J\u001a\u0010\u000b\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lcom/baijiayun/liveuibase/liveshow/shop/ProductAdapter$ProductCallback;", "", "onBackToShop", "", "fragment", "Landroidx/fragment/app/Fragment;", "onExplainProduct", "productModel", "Lcom/baijiayun/livecore/models/LPLiveProductModel;", "onOpenBrowserToBuy", "onOpenProductDetail", "onProductShelfStateChanged", "onShelf", "", "liveuibase_release"})
    public static interface ProductCallback {
        public void onOpenBrowserToBuy(@Nullable LPLiveProductModel var1);

        public void onOpenProductDetail(@Nullable LPLiveProductModel var1);

        public void onExplainProduct(@Nullable LPLiveProductModel var1);

        public void onProductShelfStateChanged(@Nullable LPLiveProductModel var1, boolean var2);

        public void onBackToShop(@NotNull Fragment var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/baijiayun/liveuibase/liveshow/shop/ProductAdapter$Companion;", "", "()V", "NO_SHELF", "", "ON_SALE", "ON_SALE_STUDENT", "SORT_DRAG", "liveuibase_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

