/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.utils.ShadowUtil;

public class ToastUtil {
    private Context context;
    private String mainText;
    private Drawable icon;
    private int duration = 0;
    private Toast toast;

    public ToastUtil(Context context2) {
        this.context = context2;
    }

    public ToastUtil setText(String text) {
        this.mainText = text;
        return this;
    }

    public ToastUtil setIcon(Drawable icon) {
        this.icon = icon;
        return this;
    }

    public ToastUtil setDuration(int duration) {
        this.duration = duration == 1 || duration == 0 ? duration : 0;
        return this;
    }

    public void show() {
        View contentView = LayoutInflater.from((Context)this.context).inflate(R.layout.uibase_common_toast_layout, null);
        ImageView ivIcon = (ImageView)contentView.findViewById(R.id.base_common_toast_icon);
        ivIcon.setVisibility(this.icon == null ? 8 : 0);
        ivIcon.setImageDrawable(this.icon);
        TextView tvText = (TextView)contentView.findViewById(R.id.base_common_toast_text);
        tvText.setText((CharSequence)this.mainText);
        View container2 = contentView.findViewById(R.id.base_common_toast_main_container);
        container2.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        ShadowUtil.setViewBoundShadow(contentView.findViewById(R.id.base_common_toast_shadow_container));
        ToastCompat.showCustomToast((Context)this.context, (View)contentView, (int)17, (int)0, (int)0, (int)this.duration);
    }
}

