/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.zxing;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.journeyapps.barcodescanner.ViewfinderView;

public class CustomViewfinderView
extends ViewfinderView {
    private static final long CUSTOME_ANIMATION_DELAY = 10L;
    public float mLineRate = 0.1f;
    public float mLineDepth = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    public int mLineColor = -1118482;
    public float mScanLinePosition = 0.0f;
    public float mScanLineDepth = TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    public float mScanLineDy = TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    public LinearGradient mLinearGradient;
    public int mScanLineColor = -14786817;
    public int[] mScanLineColors = new int[]{1990399, -14786817, -14786817, 1990399};
    public float[] mPosition = new float[]{0.0f, 0.25f, 0.75f, 1.0f};
    public int mScaneGridColor = 857628415;
    public float mGriddingLineWidth = 2.0f;
    public int mGriddingDensity = 25;
    public LinearGradient mLinearGradientGridding;
    public Paint mGriddingPaint;
    public Matrix mScanMatrix;
    public Path mGriddingPath;
    public int mFrameHeight;
    public Paint mFramePaint;

    public CustomViewfinderView(Context context2, AttributeSet attrs) {
        super(context2, attrs);
        this.init();
    }

    private void init() {
        this.mScanMatrix = new Matrix();
        this.mGriddingPaint = new Paint(1);
        this.mGriddingPaint.setStyle(Paint.Style.STROKE);
        this.mGriddingPaint.setStrokeWidth(this.mGriddingLineWidth);
        this.mFramePaint = new Paint(1);
        this.mFramePaint.setStyle(Paint.Style.STROKE);
        this.mFramePaint.setStrokeWidth(this.mGriddingLineWidth);
        this.mFramePaint.setColor(this.mScaneGridColor);
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(Canvas canvas) {
        this.refreshSizes();
        if (this.framingRect == null || this.previewFramingRect == null) {
            return;
        }
        this.initGridPath(this.framingRect);
        Rect frame = this.framingRect;
        this.paint.setColor(this.mLineColor);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)frame.left + (float)frame.width() * this.mLineRate, (float)frame.top + this.mLineDepth, this.paint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)frame.left + this.mLineDepth, (float)frame.top + (float)frame.height() * this.mLineRate, this.paint);
        canvas.drawRect((float)frame.right - (float)frame.width() * this.mLineRate, (float)frame.top, (float)frame.right, (float)frame.top + this.mLineDepth, this.paint);
        canvas.drawRect((float)frame.right - this.mLineDepth, (float)frame.top, (float)frame.right, (float)frame.top + (float)frame.height() * this.mLineRate, this.paint);
        canvas.drawRect((float)frame.left, (float)frame.bottom - this.mLineDepth, (float)frame.left + (float)frame.width() * this.mLineRate, (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.left, (float)frame.bottom - (float)frame.height() * this.mLineRate, (float)frame.left + this.mLineDepth, (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.right - (float)frame.width() * this.mLineRate, (float)frame.bottom - this.mLineDepth, (float)frame.right, (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.right - this.mLineDepth, (float)frame.bottom - (float)frame.height() * this.mLineRate, (float)frame.right, (float)frame.bottom, this.paint);
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.paint.setColor(this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)frame.bottom, this.paint);
        canvas.drawRect((float)frame.right, (float)frame.top, (float)width, (float)frame.bottom, this.paint);
        canvas.drawRect(0.0f, (float)frame.bottom, (float)width, (float)height, this.paint);
        this.mScanLinePosition += this.mScanLineDy;
        if (this.mScanLinePosition > (float)frame.height() - this.mScanLineDepth) {
            this.mScanLinePosition = 0.0f;
        }
        this.paint.setColor(this.mScanLineColor);
        this.mLinearGradient = new LinearGradient((float)frame.left, (float)frame.top + this.mScanLinePosition, (float)frame.right, (float)frame.top + this.mScanLinePosition + this.mScanLineDepth, this.mScanLineColors, this.mPosition, Shader.TileMode.CLAMP);
        this.paint.setShader((Shader)this.mLinearGradient);
        canvas.drawRect((float)frame.left, (float)frame.top + this.mScanLinePosition, (float)frame.right, (float)frame.top + this.mScanLinePosition + this.mScanLineDepth, this.paint);
        this.paint.setShader(null);
        this.mScanMatrix.setTranslate(0.0f, (float)(-this.mFrameHeight) + this.mScanLinePosition);
        this.mLinearGradientGridding.setLocalMatrix(this.mScanMatrix);
        canvas.drawPath(this.mGriddingPath, this.mGriddingPaint);
        canvas.drawRect((float)frame.left, (float)frame.top, (float)frame.right, (float)frame.bottom, this.mFramePaint);
        this.postInvalidateDelayed(10L, frame.left, frame.top, frame.right, frame.bottom);
    }

    private void initGridPath(Rect framingRect) {
        if (this.mGriddingPath == null) {
            int i;
            this.mGriddingPath = new Path();
            float wUnit = (float)framingRect.width() / ((float)this.mGriddingDensity + 0.0f);
            float hUnit = (float)framingRect.height() / ((float)this.mGriddingDensity + 0.0f);
            for (i = 0; i <= this.mGriddingDensity; ++i) {
                this.mGriddingPath.moveTo((float)framingRect.left + (float)i * wUnit, (float)framingRect.top);
                this.mGriddingPath.lineTo((float)framingRect.left + (float)i * wUnit, (float)framingRect.bottom);
            }
            for (i = 0; i <= this.mGriddingDensity; ++i) {
                this.mGriddingPath.moveTo((float)framingRect.left, (float)framingRect.top + (float)i * hUnit);
                this.mGriddingPath.lineTo((float)framingRect.right, (float)framingRect.top + (float)i * hUnit);
            }
            this.mFrameHeight = framingRect.bottom - framingRect.top;
        }
        if (this.mLinearGradientGridding == null) {
            this.mLinearGradientGridding = new LinearGradient(0.0f, (float)framingRect.top, 0.0f, (float)framingRect.bottom, new int[]{this.mScaneGridColor, this.mScaneGridColor, 0}, new float[]{0.0f, 0.99f, 1.0f}, Shader.TileMode.CLAMP);
            this.mScanMatrix.setTranslate(0.0f, (float)(-this.mFrameHeight));
            this.mLinearGradientGridding.setLocalMatrix(this.mScanMatrix);
            this.mGriddingPaint.setShader((Shader)this.mLinearGradientGridding);
        }
    }
}

