/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.user;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.GroupItem;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPAwardUserInfo;
import com.baijiayun.livecore.models.LPGroupItem;
import com.baijiayun.livecore.models.launch.LPAwardConfig;
import com.baijiayun.livecore.models.launch.LPEnterRoomNative;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import com.baijiayun.liveuibase.widgets.CircleTextView;
import com.baijiayun.liveuibase.widgets.dialog.AwardPopupWindow;
import de.hdodenhof.circleimageview.CircleImageView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupExtendableListViewAdapter
extends BaseExpandableListAdapter {
    private List<LPGroupItem> lpGroupItems;
    private OnUpdateListener mOnUpdateListener;
    private IEnterSubRoomListener mEnterSubRoomListener;
    private String mAssistantLabel;
    private int mGroupId = -1;
    private RouterViewModel routerViewModel;
    private Map<Integer, String> subRoomMap;
    private final String[] color = new String[]{"#FF607D", "#BE21E9", "#35CD3B", "#EE87FF", "#775FCF", "#AB8678", "#3D5AFE", "#03A9F4", "#C3FFA6", "#F44336", "#7ED321", "#FB9D3E", "#795548", "#FFEB3B", "#FFAE8E", "#E91E63"};
    private AwardPopupWindow awardPopupWindow;
    private LPAwardConfig availableAward = null;

    public GroupExtendableListViewAdapter(@NotNull RouterViewModel routerViewModel2, @Nullable String assistantLabel, int groupId) {
        this.routerViewModel = routerViewModel2;
        this.mAssistantLabel = assistantLabel;
        this.mGroupId = groupId;
        this.subRoomMap = new HashMap<Integer, String>();
        if (routerViewModel2.liveRoom.getSubRoomList() != null) {
            for (LPEnterRoomNative.LPSubRoomModel subRoomModel : routerViewModel2.liveRoom.getSubRoomList()) {
                this.subRoomMap.put(subRoomModel.groupId, subRoomModel.enterUrl);
            }
        }
    }

    public int getGroupCount() {
        if (this.lpGroupItems == null) {
            return 0;
        }
        return this.lpGroupItems.size();
    }

    public int getChildrenCount(int groupPosition) {
        LPGroupItem group = (LPGroupItem)this.getGroup(groupPosition);
        if (group == null) {
            return 0;
        }
        return group.userModelList.size();
    }

    public Object getGroup(int groupPosition) {
        if (this.lpGroupItems == null || groupPosition >= this.lpGroupItems.size()) {
            return null;
        }
        return this.lpGroupItems.get(groupPosition);
    }

    public Object getChild(int groupPosition, int childPosition) {
        LPGroupItem group = (LPGroupItem)this.getGroup(groupPosition);
        if (group == null) {
            return null;
        }
        if (!group.userModelList.isEmpty() && group.userModelList.size() <= childPosition) {
            return null;
        }
        return group.userModelList.get(childPosition);
    }

    public long getGroupId(int groupPosition) {
        return 0L;
    }

    public long getChildId(int groupPosition, int childPosition) {
        return 0L;
    }

    public boolean hasStableIds() {
        return false;
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        GroupHolder groupHolder;
        if (convertView == null) {
            groupHolder = new GroupHolder();
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_item_online_group_parent, parent, false);
            groupHolder.mIvItemOnlineParentState = (ImageView)convertView.findViewById(R.id.iv_item_online_parent_state);
            groupHolder.mTvItemOnlineParentTitle = (TextView)convertView.findViewById(R.id.tv_item_online_parent_title);
            groupHolder.mTvItemOnlineParentNumber = (TextView)convertView.findViewById(R.id.tv_item_online_parent_number);
            groupHolder.mCtvItemOnlineParent = (CircleTextView)convertView.findViewById(R.id.ctv_item_online_parent);
            groupHolder.mIvEnterSubRoom = (ImageView)convertView.findViewById(R.id.item_online_parent_enter_sub_room_iv);
            convertView.setTag((Object)groupHolder);
        } else {
            groupHolder = (GroupHolder)convertView.getTag();
        }
        LPGroupItem item = (LPGroupItem)this.getGroup(groupPosition);
        GroupItem groupItem = item.groupItemModel;
        groupHolder.mTvItemOnlineParentTitle.setText((CharSequence)(groupItem != null && !TextUtils.isEmpty((CharSequence)groupItem.name) ? groupItem.name : "\u5206\u7ec4" + ++groupPosition));
        groupHolder.mCtvItemOnlineParent.setCircleBackgroundColor(Color.parseColor((String)this.color[((groupItem != null ? groupItem.id : 1) - 1) % 16]));
        groupHolder.mTvItemOnlineParentNumber.setText((CharSequence)parent.getContext().getString(R.string.bjy_base_content_with_bracket, new Object[]{item.count}));
        boolean showItem = this.routerViewModel.liveRoom.getRoomInfo().isDiscussLive && this.routerViewModel.liveRoom.isTeacher() && item.count == 0;
        groupHolder.mIvEnterSubRoom.setVisibility(showItem && !this.routerViewModel.isLiveEE() ? 0 : 8);
        groupHolder.mIvEnterSubRoom.setOnClickListener(v -> {
            if (this.mEnterSubRoomListener != null) {
                this.mEnterSubRoomListener.enterSubRoom(this.subRoomMap.get(item.id));
            }
        });
        if (isExpanded) {
            groupHolder.mIvItemOnlineParentState.setImageDrawable(AppCompatResources.getDrawable((Context)parent.getContext(), (int)R.drawable.iv_lp_ui_down));
        } else {
            groupHolder.mIvItemOnlineParentState.setImageDrawable(AppCompatResources.getDrawable((Context)parent.getContext(), (int)R.drawable.iv_lp_ui_group_close));
        }
        if (groupItem != null && groupItem.id == this.mGroupId) {
            groupHolder.mCtvItemOnlineParent.setText("\u221a");
        } else {
            groupHolder.mCtvItemOnlineParent.setText("");
        }
        return convertView;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        String avatar;
        GroupChildHolder groupChildHolder;
        if (convertView == null) {
            groupChildHolder = new GroupChildHolder();
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_item_online_user, parent, false);
            groupChildHolder.mItemOnlineUserAvatar = (CircleImageView)convertView.findViewById(R.id.item_online_user_avatar);
            groupChildHolder.mItemOnlineUserName = (TextView)convertView.findViewById(R.id.item_online_user_name);
            groupChildHolder.mItemOnlineUserTeacherTag = (TextView)convertView.findViewById(R.id.item_online_user_teacher_tag);
            groupChildHolder.mItemOnlineUserTeacherTag.setBackground(ThemeDataUtil.getUserTagBg((Context)parent.getContext()));
            groupChildHolder.mItemOnlineUserAssistTag = (TextView)convertView.findViewById(R.id.item_online_user_assist_tag);
            groupChildHolder.awardContainer = convertView.findViewById(R.id.item_award_container);
            groupChildHolder.awardCount = (TextView)convertView.findViewById(R.id.item_award_count);
            groupChildHolder.awardIcon = (ImageView)convertView.findViewById(R.id.item_award_icon);
            groupChildHolder.mItemOnlineUserAssistTag.setBackground(ThemeDataUtil.getUserTagBg((Context)parent.getContext()));
            groupChildHolder.mItemOnlineUserPresenterTag = (TextView)convertView.findViewById(R.id.item_online_user_presenter_tag);
            groupChildHolder.mItemOnlineUserPresenterTag.setBackground(ThemeDataUtil.getUserTagBg((Context)parent.getContext()));
            groupChildHolder.awardContainer.setBackground(new DrawableBuilder().cornerRadius(UtilsKt.getDp((int)60)).solidColor(ContextCompat.getColor((Context)parent.getContext(), (int)R.color.base_main_color_layer_20)).build());
            convertView.setTag((Object)groupChildHolder);
        } else {
            groupChildHolder = (GroupChildHolder)convertView.getTag();
        }
        LPUserModel userModel = (LPUserModel)this.getChild(groupPosition, childPosition);
        String string2 = avatar = userModel.getAvatar().startsWith("//") ? "https:" + userModel.getAvatar() : userModel.getAvatar();
        if (!TextUtils.isEmpty((CharSequence)avatar)) {
            Glide.with((Context)parent.getContext()).load(avatar).into((ImageView)groupChildHolder.mItemOnlineUserAvatar);
        }
        groupChildHolder.mItemOnlineUserName.setText((CharSequence)userModel.name);
        groupChildHolder.mItemOnlineUserName.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)convertView.getContext(), (int)R.attr.base_theme_window_main_text_color));
        if (userModel.getType() == LPConstants.LPUserType.Assistant) {
            groupChildHolder.mItemOnlineUserAssistTag.setVisibility(0);
            groupChildHolder.mItemOnlineUserAssistTag.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mAssistantLabel) ? parent.getContext().getResources().getString(R.string.live_assistant) : this.mAssistantLabel));
        } else {
            groupChildHolder.mItemOnlineUserAssistTag.setVisibility(8);
        }
        groupChildHolder.mItemOnlineUserPresenterTag.setVisibility(4);
        groupChildHolder.mItemOnlineUserTeacherTag.setVisibility(4);
        if (childPosition == this.getChildrenCount(groupPosition) - 1 && this.mOnUpdateListener != null) {
            this.mOnUpdateListener.onUpdate(userModel.groupId);
        }
        this.initAward(convertView.getContext(), groupChildHolder, userModel);
        LPAwardUserInfo lpAwardUserInfo = this.routerViewModel.getAwardRecord().get(userModel.number);
        if (lpAwardUserInfo != null && lpAwardUserInfo.count > 0) {
            groupChildHolder.awardCount.setText((CharSequence)String.valueOf(lpAwardUserInfo.count));
        } else {
            groupChildHolder.awardCount.setText((CharSequence)"");
        }
        if (BaseUtilsKt.isUserAdmin((IUserModel)userModel)) {
            groupChildHolder.awardContainer.setVisibility(8);
        } else if (this.routerViewModel.liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            if (lpAwardUserInfo != null && lpAwardUserInfo.count > 0) {
                groupChildHolder.awardContainer.setVisibility(0);
            } else {
                groupChildHolder.awardContainer.setVisibility(8);
            }
        } else {
            groupChildHolder.awardContainer.setVisibility(0);
        }
        groupChildHolder.awardContainer.setOnClickListener(v -> {
            if (this.availableAward == null) {
                if (this.awardPopupWindow == null) {
                    this.awardPopupWindow = new AwardPopupWindow(parent.getContext(), (user, awardKey) -> {
                        if (this.routerViewModel == null) {
                            return;
                        }
                        this.routerViewModel.requestAward(user, awardKey);
                    });
                }
                this.awardPopupWindow.setUserModel((IUserModel)userModel);
                this.awardPopupWindow.show(v);
            } else {
                if (this.routerViewModel == null) {
                    return;
                }
                this.routerViewModel.requestAward((IUserModel)userModel, this.availableAward.key);
            }
        });
        return convertView;
    }

    private void initAward(Context context2, GroupChildHolder groupChildHolder, LPUserModel userModel) {
        LPAwardConfig[] awardConfigs = this.routerViewModel.getLiveRoom().getToolBoxVM().getAwardConfigs();
        if (awardConfigs == null) {
            return;
        }
        int enableAwardTypeCount = 0;
        LPAwardConfig availableAward = null;
        for (LPAwardConfig lpAwardConfig : awardConfigs) {
            if (lpAwardConfig.isEnable != 1) continue;
            availableAward = lpAwardConfig;
            ++enableAwardTypeCount;
        }
        if (enableAwardTypeCount <= 1 && availableAward != null) {
            groupChildHolder.awardIcon.setImageDrawable(ContextCompat.getDrawable((Context)context2, (int)R.drawable.base_ic_award_like));
            this.availableAward = availableAward;
        } else {
            groupChildHolder.awardIcon.setImageResource(R.drawable.base_ic_video_award_default);
            this.availableAward = null;
        }
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return false;
    }

    public void setData(List<LPGroupItem> lpGroupItems) {
        this.lpGroupItems = lpGroupItems;
    }

    public void setOnUpdateListener(OnUpdateListener listener2) {
        this.mOnUpdateListener = listener2;
    }

    public void setEnterSubRoomListener(IEnterSubRoomListener mEnterSubRoomListener) {
        this.mEnterSubRoomListener = mEnterSubRoomListener;
    }

    static class GroupHolder {
        ImageView mIvItemOnlineParentState;
        TextView mTvItemOnlineParentTitle;
        TextView mTvItemOnlineParentNumber;
        CircleTextView mCtvItemOnlineParent;
        ImageView mIvEnterSubRoom;

        GroupHolder() {
        }
    }

    static class GroupChildHolder {
        CircleImageView mItemOnlineUserAvatar;
        TextView mItemOnlineUserName;
        TextView mItemOnlineUserTeacherTag;
        TextView mItemOnlineUserAssistTag;
        TextView mItemOnlineUserPresenterTag;
        View awardContainer;
        TextView awardCount;
        ImageView awardIcon;

        GroupChildHolder() {
        }
    }

    public static interface OnUpdateListener {
        public void onUpdate(int var1);
    }

    public static interface IEnterSubRoomListener {
        public void enterSubRoom(String var1);
    }
}

