/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.redpacket;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Bundle;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPRedPacketModel;
import com.baijiayun.livecore.models.RedPacketTopModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.toolbox.redpacket.RedPacketContract;
import com.baijiayun.liveuibase.toolbox.redpacket.RedPacketTopAdapter;
import com.baijiayun.liveuibase.toolbox.redpacket.widget.TransparentSurfaceView;
import java.io.Serializable;

public class RedPacketFragment
extends BaseDialogFragment
implements RedPacketContract.View {
    private RedPacketContract.Presenter mPresenter;
    private TransparentSurfaceView mTsf;
    private ListView mLvJignxiTop;
    private RedPacketTopAdapter mTopAdapter;
    private int mCurrStateType;
    private ValueAnimator redPocketScaleInAnimator;
    private LPRedPacketModel redPacketModel;

    public static RedPacketFragment newInstance(LPRedPacketModel redPacketModel) {
        Bundle args = new Bundle();
        args.putSerializable("redPacketModel", (Serializable)redPacketModel);
        RedPacketFragment fragment = new RedPacketFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public int getLayoutId() {
        return R.layout.bjy_base_fragment_red_packet;
    }

    public void onStart() {
        this.contentBackgroundColor(17170445);
        super.onStart();
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        this.hideTitleBar();
        if (this.getArguments() != null) {
            this.redPacketModel = (LPRedPacketModel)this.getArguments().getSerializable("redPacketModel");
        }
        this.mTsf = (TransparentSurfaceView)this.$.id(R.id.tsf_red_packet).view();
        this.mLvJignxiTop = (ListView)this.$.id(R.id.lv_fragment_top).view();
        this.mTopAdapter = new RedPacketTopAdapter(this.contextReference);
        this.mLvJignxiTop.setAdapter((ListAdapter)this.mTopAdapter);
        this.$.id(R.id.rl_red_packet).view().setOnClickListener(v -> {});
        this.$.id(R.id.btn_reb_phb_close).view().setOnClickListener(v -> this.mPresenter.exit(false));
        this.$.id(R.id.tv_red_not_next).clicked(v -> {
            if (this.mTopAdapter.getCount() > 0) {
                this.mPresenter.switchState(3);
            }
        });
        this.$.id(R.id.tv_red_have_button).clicked(v -> {
            if (this.mTopAdapter.getCount() > 0) {
                this.mPresenter.switchState(3);
            }
        });
        this.$.id(R.id.bjy_red_packet_result_container).background(ThemeDataUtil.getCommonWindowBg((Context)this.contextReference));
        this.$.id(R.id.base_red_packet_result_title_tv).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.contextReference, (int)R.attr.base_theme_window_main_text_color));
        this.$.id(R.id.bjy_red_packet_result_message).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.contextReference, (int)R.attr.base_theme_window_main_text_color));
        this.$.id(R.id.base_window_title_name).text((CharSequence)this.contextReference.getString(R.string.base_red_packet_title));
        this.$.id(R.id.base_window_title_close).clicked(v -> this.mPresenter.exit(false));
        if (DisplayUtils.isPortrait((Context)this.contextReference)) {
            this.$.id(R.id.base_red_packet_result_title_tv).text((CharSequence)this.contextReference.getString(R.string.base_red_packet_title));
            this.$.id(R.id.base_red_packet_result_close_iv).clicked(v -> this.mPresenter.exit(false));
        }
        this.$.id(R.id.bjy_red_packet_result_republish).clicked(v -> this.mPresenter.exit(true));
        this.$.id(R.id.bjy_red_packet_result_republish).background(ThemeDataUtil.getDrawableNegativeButtonBg((Context)this.contextReference));
        ((TextView)this.$.id(R.id.bjy_red_packet_result_republish).view()).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.contextReference, (int)R.attr.base_theme_dialog_negative_text_color));
        this.$.id(R.id.bjy_red_packet_result_watch).clicked(v -> this.mPresenter.showResultList());
        this.$.id(R.id.bjy_red_packet_result_watch).background(ThemeDataUtil.getDrawableProductButtonBg((Context)this.contextReference));
        this.$.id(R.id.bjy_red_packet_result_watch).textColor(R.color.base_white);
        this.switchRedPacketStart(1);
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.width = -1;
        windowParams.height = -1;
        windowParams.gravity = 17;
        windowParams.x = 0;
        windowParams.y = 0;
        windowParams.windowAnimations = R.style.BJYBaseDialogFullScreen;
    }

    public void setPresenter(RedPacketContract.Presenter presenter2) {
        this.mPresenter = presenter2;
        this.setBasePresenter(presenter2);
    }

    @Override
    public void updateRedPacketTime(long timeStart) {
        this.$.id(R.id.tv_red_packet_time_start).text((CharSequence)String.valueOf(timeStart));
        if (timeStart == 0L) {
            PropertyValuesHolder alphaProper = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f});
            PropertyValuesHolder scaleXProper = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 2.0f});
            PropertyValuesHolder scaleYProper = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 2.0f});
            ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)this.$.id(R.id.red_pocket_go_tv).view(), (PropertyValuesHolder[])new PropertyValuesHolder[]{alphaProper, scaleXProper, scaleYProper});
            animator.setDuration(166L);
            animator.start();
            this.$.id(R.id.red_pocket_go_tv).visible();
        }
    }

    @Override
    public void switchRedPacketRankingList(RedPacketTopModel[] list) {
        this.switchRedPacketStart(3);
        if (list == null || list.length == 0) {
            this.$.id(R.id.rl_lp_ui_redpack_none).visibility(0);
            this.$.id(R.id.lv_fragment_top).visibility(4);
        } else {
            this.$.id(R.id.rl_lp_ui_redpack_none).visibility(8);
            this.$.id(R.id.lv_fragment_top).visibility(0);
        }
        this.mTopAdapter.setData(list);
    }

    @Override
    public void switchRedPacketStart(int type) {
        switch (type) {
            case 1: {
                if (this.redPocketScaleInAnimator != null) {
                    this.redPocketScaleInAnimator.removeAllListeners();
                }
                PropertyValuesHolder alphaProper = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.5f, 1.0f});
                PropertyValuesHolder scaleXProper = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.5f, 1.0f});
                PropertyValuesHolder scaleYProper = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.5f, 1.0f});
                this.redPocketScaleInAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)this.$.id(R.id.rl_fragment_redpacket_time).view(), (PropertyValuesHolder[])new PropertyValuesHolder[]{alphaProper, scaleXProper, scaleYProper});
                this.redPocketScaleInAnimator.setDuration(166L);
                this.redPocketScaleInAnimator.start();
                this.redPocketScaleInAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        RedPacketFragment.this.mPresenter.startRedPacket();
                    }
                });
                this.$.id(R.id.rl_red_packet).visibility(0);
                this.showContainer(R.id.rl_fragment_redpacket_time);
                break;
            }
            case 2: {
                this.showContainer(R.id.tsf_red_packet);
                this.mTsf.setOnClickRedPacketListener(model -> this.mPresenter.robRedPacket(model));
                this.mTsf.start(this.redPacketModel);
                break;
            }
            case 3: {
                this.mTsf.pause();
                this.showContainer(R.id.rl_fragment_redpacket_phb);
                break;
            }
            case 4: {
                this.mPresenter.exit(false);
                break;
            }
            case 5: {
                if (this.mCurrStateType == 3) {
                    return;
                }
                this.mTsf.pause();
                ScaleAnimation animation = new ScaleAnimation(0.4f, 1.0f, 0.4f, 1.0f, 1, 0.5f, 1, 0.5f);
                animation.setDuration(800L);
                this.$.id(R.id.rl_not_red).view().setAnimation((Animation)animation);
                animation.startNow();
                this.showContainer(R.id.rl_not_red);
                break;
            }
            case 6: {
                if (this.mCurrStateType == 3) {
                    return;
                }
                LPLogger.d((String)"RedPacketPresenter", (String)("\u663e\u793a\u6211\u62a2\u7ea2\u5305\u7684\u6570\u91cf " + this.mPresenter.getScoreAmount()));
                this.mTsf.pause();
                ScaleAnimation animation = new ScaleAnimation(0.4f, 1.0f, 0.4f, 1.0f, 1, 0.5f, 1, 0.5f);
                animation.setDuration(800L);
                this.$.id(R.id.rl_red_rob).view().setAnimation((Animation)animation);
                animation.startNow();
                this.showContainer(R.id.rl_red_rob);
                this.$.id(R.id.tv_red_rob_credit).text((CharSequence)String.valueOf(this.mPresenter.getScoreAmount()));
                break;
            }
            case 7: {
                this.mTsf.pause();
                this.showContainer(R.id.bjy_red_packet_result_container);
                this.$.id(R.id.bjy_red_packet_result_republish).visibility(this.mPresenter.isTeacher() ? 0 : 8);
                break;
            }
        }
        this.mCurrStateType = type;
    }

    private void showContainer(int id2) {
        this.$.id(R.id.bjy_red_packet_result_container).visibility(id2 == R.id.bjy_red_packet_result_container ? 0 : 8);
        this.$.id(R.id.rl_red_rob).visibility(id2 == R.id.rl_red_rob ? 0 : 8);
        this.$.id(R.id.rl_not_red).visibility(id2 == R.id.rl_not_red ? 0 : 8);
        this.$.id(R.id.rl_fragment_redpacket_phb).visibility(id2 == R.id.rl_fragment_redpacket_phb ? 0 : 8);
        this.$.id(R.id.tsf_red_packet).visibility(id2 == R.id.tsf_red_packet ? 0 : 8);
        this.$.id(R.id.rl_fragment_redpacket_time).visibility(id2 == R.id.rl_fragment_redpacket_time ? 0 : 8);
    }

    @Override
    public void setRobEnable(boolean robEnable) {
        if (this.mTsf == null) {
            return;
        }
        this.mTsf.setRobEnable(robEnable);
    }

    public void onDestroy() {
        if (this.mPresenter != null) {
            this.mPresenter.release();
        }
        super.onDestroy();
        if (this.mTsf != null) {
            this.mTsf.pause();
            this.mTsf.destroy();
            this.mTsf = null;
        }
        if (this.redPocketScaleInAnimator != null) {
            this.redPocketScaleInAnimator.removeAllListeners();
        }
    }
}

