/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.quiz;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;
import android.widget.ProgressBar;
import androidx.appcompat.app.AlertDialog;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.base.BasePresenter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPJsonModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.view.webview.BJWebViewImpl;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.livecore.utils.CommonUtils;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.toolbox.quiz.QuizDialogContract;
import com.baijiayun.liveuibase.utils.JsonObjectUtil;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class QuizDialogFragment
extends BaseDialogFragment
implements QuizDialogContract.View {
    public static final String KEY_FORCE_JOIN = "key_force_join";
    private static final String ARGS_TYPE = "1";
    private static final String WINDOW_NAME = "bjlapp";
    private QuizDialogContract.Presenter presenter;
    private IUserModel currentUserInfo;
    private String quizId;
    private String roomId;
    private String roomToken;
    private List<LPJsonModel> signalList = new ArrayList<LPJsonModel>();
    private boolean forceJoin;
    private boolean isUrlLoaded;
    private boolean isLoadFailed = false;
    private boolean isDestroyed = false;
    private BJWebViewImpl mWebView;

    protected int getLayoutId() {
        return R.layout.bjy_fragment_quiz;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        if (DisplayUtils.isPortrait((Context)this.requireContext())) {
            this.hideTitleBar();
        } else {
            this.title(this.getString(R.string.live_quiz_title));
        }
        Bundle args = this.getArguments();
        this.forceJoin = args.getBoolean(KEY_FORCE_JOIN);
        this.initWebClient();
        this.loadUrl();
    }

    public void setCloseBtnStatus(boolean forceJoin) {
        if (this.presenter == null) {
            return;
        }
        if (DisplayUtils.isPortrait((Context)this.requireContext())) {
            if (!forceJoin) {
                if (this.isQueryPlusNull()) {
                    return;
                }
                this.$.id(R.id.quiz_ic_close).visible();
                this.$.id(R.id.quiz_ic_close).clicked(v -> this.showCloseDlg());
            } else {
                this.$.id(R.id.quiz_ic_close).invisible();
            }
        } else if (!forceJoin) {
            if (this.isQueryPlusNull()) {
                return;
            }
            this.editable(true);
            this.editText(this.getString(R.string.live_quiz_close));
            this.editClick(v -> this.showCloseDlg());
        } else {
            this.editable(false);
        }
    }

    private void showCloseDlg() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        AlertDialog dialog = builder.setMessage(R.string.live_quiz_dialog_tip).setPositiveButton(R.string.live_quiz_dialog_confirm, (dialog12, which) -> {
            dialog12.dismiss();
            if (this.presenter != null) {
                this.presenter.dismissDlg();
            }
        }).setNegativeButton(R.string.live_quiz_dialog_cancel, (dialog1, which) -> dialog1.dismiss()).create();
        dialog.show();
        dialog.getButton(-1).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color));
        dialog.getButton(-2).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initWebClient() {
        this.mWebView = (BJWebViewImpl)this.$.id(R.id.wv_quiz_main).view();
        this.mWebView.enableJavaScript((Object)this, WINDOW_NAME);
        this.mWebView.enableCache();
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                ((ProgressBar)QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).view()).setProgress(newProgress);
                super.onProgressChanged(view, newProgress);
            }
        });
        this.mWebView.setWebViewClient((WebViewClient)new BJWebViewImpl.BJWebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).visible();
                QuizDialogFragment.this.setCloseBtnStatus(QuizDialogFragment.this.forceJoin);
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (QuizDialogFragment.this.isDestroyed) {
                    return;
                }
                QuizDialogFragment.this.isUrlLoaded = true;
                QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).gone();
                if (!QuizDialogFragment.this.isLoadFailed) {
                    QuizDialogFragment.this.setCloseBtnStatus(QuizDialogFragment.this.forceJoin);
                }
                QuizDialogFragment.this.isLoadFailed = false;
                QuizDialogFragment.this.callJsInQueue();
            }

            @TargetApi(value=23)
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                if (error.getErrorCode() != -11) {
                    QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).gone();
                    QuizDialogFragment.this.setCloseBtnStatus(QuizDialogFragment.this.forceJoin);
                    QuizDialogFragment.this.isLoadFailed = true;
                }
                LPLogger.e((String)"quiz", (String)("error:" + error.getDescription()));
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                if (errorCode != -11) {
                    QuizDialogFragment.this.$.id(R.id.pb_web_view_quiz).gone();
                    QuizDialogFragment.this.setCloseBtnStatus(QuizDialogFragment.this.forceJoin);
                    QuizDialogFragment.this.isLoadFailed = true;
                }
                LPLogger.e((String)"quiz", (String)("error:" + description));
            }
        });
    }

    private void loadUrl() {
        try {
            this.roomToken = URLEncoder.encode(this.roomToken, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String params = "?userNumber=" + this.currentUserInfo.getNumber() + "&userName=" + CommonUtils.encodeUTF8((String)this.currentUserInfo.getName()) + "&quizId=" + this.quizId + "&roomId=" + this.roomId + "&token=" + this.roomToken + "&argType=" + ARGS_TYPE + "&userGroup=" + this.currentUserInfo.getGroup();
        String host = LPConstants.HOSTS_WEB[LiveSDK.getDeployType().getType()];
        String url = host.concat("m/quiz/student").concat(params);
        LPLogger.i((String)(this.getClass().getSimpleName() + " : " + url));
        ((WebView)this.$.id(R.id.wv_quiz_main).view()).loadUrl(url);
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.width = -1;
        windowParams.height = -1;
        windowParams.gravity = 17;
        windowParams.x = 0;
        windowParams.y = 0;
        windowParams.windowAnimations = R.style.BJYBaseSendMsgDialogAnim;
    }

    public void setPresenter(QuizDialogContract.Presenter presenter2) {
        super.setBasePresenter((BasePresenter)presenter2);
        this.presenter = presenter2;
        presenter2.getCurrentUser();
        this.roomToken = TextUtils.isEmpty((CharSequence)presenter2.getRoomToken()) ? "" : presenter2.getRoomToken();
    }

    @Override
    public void onStartArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        if (!"quiz_start".equals(key)) {
            return;
        }
        this.quizId = JsonObjectUtil.isJsonNull(jsonModel.data, "quiz_id") ? "" : jsonModel.data.get("quiz_id").getAsString();
        this.roomId = JsonObjectUtil.isJsonNull(jsonModel.data, "class_id") ? "" : jsonModel.data.get("class_id").getAsString();
        this.signalList.add(jsonModel);
    }

    @Override
    public void onEndArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        if (!"quiz_end".equals(key)) {
            return;
        }
        this.signalList.add(jsonModel);
        if (this.isUrlLoaded) {
            this.callJs(jsonModel.data.toString());
        }
    }

    @Override
    public void onSolutionArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        if (!"quiz_solution".equals(key)) {
            return;
        }
        this.quizId = JsonObjectUtil.isJsonNull(jsonModel.data, "quiz_id") ? "" : jsonModel.data.get("quiz_id").getAsString();
        this.roomId = JsonObjectUtil.isJsonNull(jsonModel.data, "class_id") ? "" : jsonModel.data.get("class_id").getAsString();
        this.signalList.add(jsonModel);
    }

    @Override
    public void onQuizResArrived(LPJsonModel jsonModel) {
        String key = jsonModel.data.get("message_type").getAsString();
        if (!"quiz_res".equals(key)) {
            return;
        }
        this.quizId = JsonObjectUtil.isJsonNull(jsonModel.data, "quiz_id") ? "" : jsonModel.data.get("quiz_id").getAsString();
        this.roomId = JsonObjectUtil.isJsonNull(jsonModel.data, "class_id") ? "" : jsonModel.data.get("class_id").getAsString();
        this.signalList.add(jsonModel);
    }

    @Override
    public void onGetCurrentUser(IUserModel userModel) {
        this.currentUserInfo = userModel;
    }

    private void callJsInQueue() {
        if (this.signalList != null && this.signalList.size() > 0) {
            for (LPJsonModel jsonModel : this.signalList) {
                this.callJs(jsonModel.data.toString());
            }
        }
    }

    public void onDestroy() {
        this.mWebView.destroy();
        super.onDestroy();
        this.isDestroyed = true;
        this.presenter = null;
        if (this.signalList != null) {
            this.signalList.clear();
        }
    }

    @JavascriptInterface
    public void close() {
        LPLogger.d((String)"quiz", (String)("close:" + this.presenter.checkRouterNull()));
        if (this.presenter.checkRouterNull()) {
            return;
        }
        this.presenter.dismissDlg();
    }

    @JavascriptInterface
    public void sendMessage(String json) {
        LPLogger.d((String)"quiz", (String)("sendMessage:" + json));
        if (!TextUtils.isEmpty((CharSequence)json)) {
            this.presenter.submitAnswer(json);
        }
    }

    private void callJs(String json) {
        ((WebView)this.$.id(R.id.wv_quiz_main).view()).loadUrl("javascript:bjlapp.receivedMessage(" + json + ")");
    }
}

