/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.answerer;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiahulian.common.cropperv2.uikit.CircleColorView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livecore.models.LPUserAnswerDetail;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseAdapter;
import com.baijiayun.liveuibase.base.ViewHolder;
import java.util.List;

public class RecordAdapter
extends BaseAdapter<LPUserAnswerDetail> {
    private final String[] colors = new String[]{"#FF607D", "#BE21E9", "#35CD3B", "#EE87FF", "#775FCF", "#AB8678", "#3D5AFE", "#03A9F4", "#C3FFA6", "#F44336", "#7ED321", "#FB9D3E", "#795548", "#FFEB3B", "#FFAE8E", "#E91E63"};

    public RecordAdapter(Context context2, List<LPUserAnswerDetail> mDatas) {
        super(context2, R.layout.uibase_item_answerer_record, mDatas);
    }

    @Override
    public void convert(ViewHolder helper, LPUserAnswerDetail item, int position) {
        TextView tvTitle = (TextView)helper.getView(R.id.uibase_item_answerer_record_tv_title);
        TextView tvTime = (TextView)helper.getView(R.id.uibase_item_answerer_record_tv_time);
        TextView tvSelected = (TextView)helper.getView(R.id.uibase_item_answerer_record_tv_selected);
        Object view = helper.getView(R.id.rl_layout_group);
        TextView tvGroupName = (TextView)helper.getView(R.id.tv_group_name);
        CircleColorView circleColorView = (CircleColorView)helper.getView(R.id.view_group_color);
        ImageView ivState = (ImageView)helper.getView(R.id.item_answerer_record_iv_state);
        view.findViewById(R.id.view_space_active).setVisibility(8);
        if (item.user.groupItem != null && item.user.groupId != 0) {
            view.setVisibility(0);
            tvGroupName.setText((CharSequence)item.user.groupItem.name);
            if (TextUtils.isEmpty((CharSequence)item.user.groupItem.color)) {
                int index = item.user.groupItem.id == 0 ? 0 : item.user.groupItem.id - 1;
                circleColorView.setColor(Color.parseColor((String)this.colors[index % 16]));
            } else {
                circleColorView.setColor(Color.parseColor((String)item.user.groupItem.color));
            }
        } else {
            view.setVisibility(8);
        }
        tvTitle.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)item.user.name));
        tvTime.setText((CharSequence)this.getTimeString(item.timeUsed, item.choices));
        tvSelected.setText((CharSequence)this.getChoices(item.choices));
        ivState.setImageResource(item.isCorrect ? R.drawable.base_ic_right : R.drawable.base_ic_wrong);
        if (position == 0 && item.isCorrect) {
            Drawable drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.base_ic_crown);
            if (drawable2 != null) {
                int size = UtilsKt.getDp((int)24);
                drawable2.setBounds(0, 0, size, size);
                tvTitle.setCompoundDrawables(drawable2, null, null, null);
            }
        } else {
            tvTitle.setCompoundDrawables(null, null, null, null);
        }
    }

    private String getTimeString(long seconds, String[] choice) {
        boolean showTime;
        StringBuilder sb = new StringBuilder();
        long min = seconds / 60L;
        long second = seconds % 60L;
        boolean bl = showTime = seconds != 0L || choice != null && choice.length != 0;
        if (showTime) {
            sb.append(this.mContext.getString(R.string.base_answer_record_use_time));
            sb.append(min > 9L ? "" : "0").append(min).append(":").append(second > 9L ? "" : "0").append(second);
        }
        return sb.toString();
    }

    private String getChoices(String[] choices) {
        if (choices == null || choices.length == 0) {
            return this.mContext.getString(R.string.base_answer_record_not_choices);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : choices) {
            sb.append(s).append(" ");
        }
        return sb.toString();
    }
}

