/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.base;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.ContextThemeWrapper;
import android.view.FocusFinder;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.UiThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.ILayer;
import com.baijiayun.liveuibase.base.IWindow;
import com.baijiayun.liveuibase.base.RouterListener;
import com.baijiayun.liveuibase.utils.ShadowUtil;
import com.baijiayun.liveuibase.utils.ToastUtil;
import io.reactivex.disposables.CompositeDisposable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseWindow
implements IWindow,
LifecycleObserver {
    protected View view;
    private boolean controllable = true;
    private boolean needShowShadow = false;
    protected ShadowUtil boundView;
    private int z = 0;
    protected GestureDetector gestureDetector;
    private OnSingleTapListener onSingleTapListener;
    private OnDoubleTapListener onDoubleTapListener;
    protected OnWindowRepositionListener onWindowRepositionListener;
    protected boolean allowTouch;
    protected Context context;
    private Lifecycle lifecycle;
    protected QueryPlus $;
    protected RouterListener routerListener;
    private boolean isDestroy = false;
    protected CompositeDisposable compositeDisposable = new CompositeDisposable();
    private boolean isTvMode;
    private ValueAnimator animatorX;
    private int lastLeft;
    private int lastTop;
    private int lastX;
    private int lastY;
    private int measuredParentWidth;
    private int measuredParentHeight;
    private int offXAll;
    private int offYAll;
    public static final Map<Integer, KeyEventSymbolize> KEY_EVENT_ACTIONS = new HashMap<Integer, KeyEventSymbolize>();

    @UiThread
    public BaseWindow(Context context2) {
        if (!(context2 instanceof RouterListener)) {
            throw new RuntimeException("context not extend RouterListener");
        }
        this.routerListener = (RouterListener)context2;
        this.context = this.isThemeContext() ? new ContextThemeWrapper(context2, this.getTheme()) : context2;
        this.lifecycle = this.routerListener.getLifecycle();
        this.allowTouch = this.routerListener.getLiveRoom() != null && this.hasTeacherOrAssistantAuth();
        this.lifecycle.addObserver((LifecycleObserver)this);
        this.doOnCreateView(this.context);
        this.view = this.onCreateView(this.context);
        this.$ = QueryPlus.with((View)this.view);
        if (this.needShowShadow) {
            this.boundView = ShadowUtil.setViewBoundShadow(this.view);
        }
        this.view.setOnTouchListener((View.OnTouchListener)new WindowOnTouchListener());
        this.gestureDetector = new GestureDetector(this.view.getContext(), (GestureDetector.OnGestureListener)new WindowGestureDetector());
        this.view.setTag((Object)this);
        this.setTvMode(this.routerListener.isTvModel());
        this.onViewCreated(context2);
    }

    protected boolean isThemeContext() {
        return false;
    }

    @StyleRes
    protected int getTheme() {
        return R.style.BJYBaseLiveTheme;
    }

    protected boolean hasTeacherOrAssistantAuth() {
        return this.routerListener.getLiveRoom().isTeacherOrAssistant() || this.routerListener.getLiveRoom().isGroupTeacherOrAssistant();
    }

    protected void doOnCreateView(Context context2) {
    }

    protected void onViewCreated(Context context2) {
    }

    protected abstract View onCreateView(Context var1);

    protected void showToastMessage(String msg) {
        if (this.view != null && this.view.getContext() != null) {
            new ToastUtil(this.view.getContext()).setText(msg).show();
        }
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public int getOrderInLayer() {
        ViewGroup viewGroup = this.getParentViewGroup();
        if (viewGroup == null) {
            return this.z;
        }
        return this.z == 0 ? viewGroup.indexOfChild(this.view) : this.z;
    }

    @Override
    public void maximize() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        this.view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public boolean controllable() {
        return this.controllable;
    }

    private void animateMoveTo(int x, int y) {
        if (this.view == null) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.view.getLayoutParams();
        if (this.animatorX != null && this.animatorX.isRunning()) {
            layoutParams.leftMargin = this.lastLeft;
            layoutParams.topMargin = this.lastTop;
            this.animatorX.cancel();
            this.view.requestLayout();
        }
        this.lastLeft = x;
        this.lastTop = y;
        int originY = layoutParams.topMargin;
        int offsetY = y - originY;
        this.animatorX = ValueAnimator.ofInt((int[])new int[]{layoutParams.leftMargin, x});
        this.animatorX.addUpdateListener(animation -> {
            layoutParams.leftMargin = (Integer)animation.getAnimatedValue();
            layoutParams.topMargin = (int)((float)originY + animation.getAnimatedFraction() * (float)offsetY);
            if (this.view == null) {
                animation.cancel();
            } else {
                this.view.requestLayout();
            }
        });
        this.animatorX.setDuration(400L);
        this.animatorX.start();
    }

    @Override
    public void moveTo(int x, int y) {
        this.moveTo(x, y, this.z);
    }

    @Override
    public void moveTo(ILayer layer) {
        ViewGroup viewGroup = this.getParentViewGroup();
        if (viewGroup != null) {
            viewGroup.removeView(this.view);
        }
        layer.addWindow(this);
    }

    @Override
    public void moveTo(int x, int y, int z) {
        this.animateMoveTo(x, y);
        if (this.z == z) {
            return;
        }
        ViewGroup layer = this.getParentViewGroup();
        if (layer != null) {
            layer.removeView(this.view);
            layer.addView(this.view, z);
        }
    }

    @Override
    public void moveTo(ILayer layer, int x, int y) {
        if (layer == this.getParentViewGroup()) {
            this.moveTo(x, y);
            return;
        }
        ViewGroup originLayer = this.getParentViewGroup();
        if (originLayer != null) {
            originLayer.removeView(this.view);
        }
        layer.addWindow(this);
    }

    @Override
    public void scaleTo(int width, int height) {
        ViewGroup.LayoutParams lp = this.view.getLayoutParams();
        lp.width = width;
        lp.height = height;
        this.view.setLayoutParams(lp);
    }

    @Nullable
    public final ViewGroup getParentViewGroup() {
        if (this.view != null && this.view.getParent() != null && this.view.getParent() instanceof ViewGroup) {
            return (ViewGroup)this.view.getParent();
        }
        return null;
    }

    protected boolean onTouchEvent(View v, MotionEvent event) {
        if (this.gestureDetector.onTouchEvent(event)) {
            return true;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        switch (event.getAction()) {
            case 0: {
                this.lastX = x;
                this.lastY = y;
                if (v.getParent() != null && v.getParent() instanceof ViewGroup) {
                    ViewGroup viewGroup = (ViewGroup)v.getParent();
                    this.measuredParentHeight = viewGroup.getMeasuredHeight();
                    this.measuredParentWidth = viewGroup.getMeasuredWidth();
                }
                this.offXAll = 0;
                this.offYAll = 0;
                break;
            }
            case 2: {
                ViewGroup.LayoutParams params;
                int offX = x - this.lastX;
                int offY = y - this.lastY;
                if (this.offXAll < 50 && this.offYAll < 50) {
                    this.offXAll += offX;
                    this.offYAll += offY;
                    break;
                }
                if (v.getLeft() + offX < 0) {
                    offX = -v.getLeft();
                } else if (v.getRight() + offX > this.measuredParentWidth) {
                    offX = this.measuredParentWidth - v.getRight();
                }
                if (v.getTop() < 0 || v.getBottom() > this.measuredParentHeight) {
                    if (v.getTop() + offY > 0) {
                        offY = -v.getTop();
                    } else if (v.getBottom() + offY < this.measuredParentHeight) {
                        offY = this.measuredParentHeight - v.getBottom();
                    }
                } else if (v.getTop() + offY < 0) {
                    offY = -v.getTop();
                } else if (v.getBottom() + offY > this.measuredParentHeight) {
                    offY = this.measuredParentHeight - v.getBottom();
                }
                if (!this.allowTouch || !((params = this.view.getLayoutParams()) instanceof FrameLayout.LayoutParams)) break;
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.view.getLayoutParams();
                layoutParams.gravity = 0x800033;
                layoutParams.rightMargin = 0;
                layoutParams.leftMargin += offX;
                layoutParams.topMargin += offY;
                this.view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (this.onWindowRepositionListener == null) break;
                this.onWindowRepositionListener.onWindowMove(layoutParams.leftMargin, layoutParams.topMargin);
                break;
            }
            case 1: {
                break;
            }
        }
        return true;
    }

    protected String getString(@StringRes int id2) {
        return this.view.getContext().getString(id2);
    }

    protected String getString(@StringRes int id2, Object ... formatArgs) {
        return this.view.getContext().getString(id2, formatArgs);
    }

    public void setNeedShowShadow(boolean isNeedShowShadow) {
        this.needShowShadow = isNeedShowShadow;
    }

    protected boolean isAdmin() {
        return false;
    }

    protected boolean canBringToForeground() {
        return false;
    }

    public void bringToForeground() {
        if (this.view != null) {
            this.view.bringToFront();
        }
    }

    public void setOnSingleTapListener(OnSingleTapListener onSingleTapListener) {
        this.onSingleTapListener = onSingleTapListener;
    }

    public void setOnDoubleTapListener(OnDoubleTapListener onDoubleTapListener) {
        this.onDoubleTapListener = onDoubleTapListener;
    }

    protected void setOnWindowRepositionListener(OnWindowRepositionListener onWindowRepositionListener) {
        this.onWindowRepositionListener = onWindowRepositionListener;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        this.isDestroy = true;
        this.compositeDisposable.dispose();
        if (this.onWindowRepositionListener != null) {
            this.onWindowRepositionListener = null;
        }
        this.view.setOnKeyListener(null);
        ViewGroup viewGroup = this.getParentViewGroup();
        if (viewGroup != null) {
            viewGroup.removeView(this.view);
        }
        this.lifecycle.removeObserver((LifecycleObserver)this);
        this.$ = null;
    }

    public boolean isDestroy() {
        return this.isDestroy;
    }

    protected void unSubscribe() {
        this.compositeDisposable.clear();
    }

    protected Drawable getCommonFocusableDrawable(int solidColor) {
        return new DrawableBuilder().strokeColorStateList(new ColorStateList((int[][])new int[][]{{16842908}, {-16842908}}, new int[]{ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color), 0})).strokeWidth(UtilsKt.getDp((int)2)).solidColor(solidColor).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
    }

    public boolean handleKeyEvent(View v, int keyCode, KeyEvent keyEvent) {
        KeyEventSymbolize action;
        if (keyEvent.getAction() == 0 && (action = KEY_EVENT_ACTIONS.get(keyCode)) != null) {
            switch (action) {
                case BACK: {
                    this.handleBackKey();
                    return true;
                }
                case SELECT: 
                case NAVIGATION: {
                    return this.handleNavigationKey(v);
                }
            }
        }
        return false;
    }

    protected void handleBackKey() {
    }

    private boolean handleNavigationKey(View view) {
        View child = FocusFinder.getInstance().findNextFocus((ViewGroup)view, view, 2);
        if (child == null) {
            ArrayList list = new ArrayList();
            view.addFocusables(list, 2);
            if (list.size() > 1) {
                child = (View)list.get(1);
                return child.requestFocus(2);
            }
        } else {
            return child.requestFocus(2);
        }
        return false;
    }

    public boolean handleChildBackKey() {
        return this.view.requestFocus(1);
    }

    public void setAllowTouch(boolean allowTouch) {
        this.allowTouch = allowTouch;
    }

    public void setTvMode(boolean isTvModel) {
        this.isTvMode = isTvModel;
        if (isTvModel) {
            this.view.setId(View.generateViewId());
            this.view.setFocusableInTouchMode(false);
            this.view.setFocusable(true);
            this.view.setNextFocusUpId(this.view.getId());
            this.view.setNextFocusRightId(this.view.getId());
            this.view.setNextFocusLeftId(this.view.getId());
            this.view.setNextFocusDownId(this.view.getId());
            this.view.setOnKeyListener(this::handleKeyEvent);
        }
    }

    public boolean isTvMode() {
        return this.isTvMode;
    }

    public boolean requestFocus() {
        return this.view.requestFocus(2);
    }

    static {
        KEY_EVENT_ACTIONS.put(4, KeyEventSymbolize.BACK);
        KEY_EVENT_ACTIONS.put(97, KeyEventSymbolize.BACK);
        KEY_EVENT_ACTIONS.put(66, KeyEventSymbolize.SELECT);
        KEY_EVENT_ACTIONS.put(109, KeyEventSymbolize.SELECT);
        KEY_EVENT_ACTIONS.put(96, KeyEventSymbolize.SELECT);
        KEY_EVENT_ACTIONS.put(23, KeyEventSymbolize.SELECT);
        KEY_EVENT_ACTIONS.put(160, KeyEventSymbolize.SELECT);
        KEY_EVENT_ACTIONS.put(21, KeyEventSymbolize.NAVIGATION);
        KEY_EVENT_ACTIONS.put(22, KeyEventSymbolize.NAVIGATION);
        KEY_EVENT_ACTIONS.put(20, KeyEventSymbolize.NAVIGATION);
        KEY_EVENT_ACTIONS.put(19, KeyEventSymbolize.NAVIGATION);
    }

    public static interface OnDoubleTapListener {
        public void onDoubleTap(MotionEvent var1);
    }

    public static interface OnSingleTapListener {
        public void onSingleTapUp(MotionEvent var1);
    }

    private class WindowOnTouchListener
    implements View.OnTouchListener {
        private WindowOnTouchListener() {
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouch(View v, MotionEvent event) {
            return BaseWindow.this.onTouchEvent(v, event);
        }
    }

    private class WindowGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        private WindowGestureDetector() {
        }

        public boolean onDown(MotionEvent event) {
            if (BaseWindow.this.isDestroy) {
                return false;
            }
            if (BaseWindow.this.canBringToForeground()) {
                BaseWindow.this.bringToForeground();
            }
            return super.onDown(event);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (BaseWindow.this.isDestroy) {
                return false;
            }
            if (BaseWindow.this.onSingleTapListener != null) {
                BaseWindow.this.onSingleTapListener.onSingleTapUp(e);
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (BaseWindow.this.onDoubleTapListener != null) {
                BaseWindow.this.onDoubleTapListener.onDoubleTap(e);
            }
            return true;
        }
    }

    public static interface OnWindowRepositionListener {
        public void onWindowMove(int var1, int var2);

        public void OnWindowScale(int var1, int var2);
    }

    public static enum KeyEventSymbolize {
        BACK,
        SELECT,
        NAVIGATION;

    }
}

