/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbar;

import android.content.Context;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.liveuibase.widgets.toolbar.BaseGraphMenuWindow;
import com.baijiayun.liveuibase.widgets.toolbar.ColorSelectData;
import com.baijiayun.liveuibase.widgets.toolbar.WidthSelectData;
import io.reactivex.disposables.Disposable;

public class GraphMenuWindow
extends BaseGraphMenuWindow {
    private Disposable disposableOfColorAllChange;
    private IRouter iRouter;
    private BaseGraphMenuWindow.OnShapeChangeModel defaultModel;

    public GraphMenuWindow(Context context, IRouter iRouter) {
        super(context);
        this.iRouter = iRouter;
        if (this.defaultModel != null) {
            this.onChangeShape(this.defaultModel);
        }
    }

    protected boolean initColorsSelect() {
        boolean rst = super.initColorsSelect();
        if (rst) {
            if (this.disposableOfColorAllChange != null) {
                this.disposableOfColorAllChange.dispose();
            }
            this.disposableOfColorAllChange = this.iRouter.getSubjectByKey(EventKey.DrawColorAllChange).ofType(String.class).subscribe(arg_0 -> ((GraphMenuWindow)this).handleColorAllChangeRst(arg_0));
        }
        return rst;
    }

    protected void initDefaultDrawable(BaseGraphMenuWindow.OnShapeChangeModel initShapeModel) {
        this.defaultModel = initShapeModel;
    }

    protected void onChangeShape(BaseGraphMenuWindow.OnShapeChangeModel onShapeChangeModel) {
        this.iRouter.getSubjectByKey(EventKey.GraphDrawEnable).onNext((Object)onShapeChangeModel);
    }

    protected void onChangeWidth(WidthSelectData widthSelectData) {
        this.iRouter.getSubjectByKey(EventKey.CustomGraphWidthChange).onNext((Object)widthSelectData);
    }

    protected void onChangeColor(ColorSelectData colorSelectData) {
        this.iRouter.setObjectByKey(EventKey.IsChangedPaintColor, true);
        this.iRouter.getSubjectByKey(EventKey.DrawColorChange).onNext((Object)colorSelectData);
    }

    public void onDestroy() {
        if (this.disposableOfColorAllChange != null) {
            this.disposableOfColorAllChange.dispose();
            this.disposableOfColorAllChange = null;
        }
    }
}

