/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.ppt;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android_serialport_api.XYDataPacket;
import androidx.appcompat.app.AppCompatActivity;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.container.ShapePaint;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.FullScreenLayer;
import com.baijiayun.groupclassui.util.InteractiveUtils;
import com.baijiayun.groupclassui.window.BaseFixedRatioTitledWindow;
import com.baijiayun.groupclassui.window.ppt.PPTTabLayer;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livebase.utils.FileUtils;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livecore.models.LPDocViewElementModel;
import com.baijiayun.livecore.models.LPDocViewUpdateModel;
import com.baijiayun.livecore.models.LPDocumentModel;
import com.baijiayun.livecore.models.LPH5DocPlayModeModel;
import com.baijiayun.livecore.models.LPMotionEvent;
import com.baijiayun.livecore.models.animppt.LPAnimPPTPageChangeEndModel;
import com.baijiayun.livecore.ppt.PPTView;
import com.baijiayun.livecore.ppt.listener.PPTStatusListener;
import com.baijiayun.livecore.ppt.listener.SimplePPTStatusListener;
import com.baijiayun.livecore.ppt.whiteboard.LaserShapeLayer;
import com.baijiayun.livecore.ppt.whiteboard.OnDoubleTapListener2;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.TextShape;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.toolbox.browser.Tuple;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.List;

public class PPTWindow
extends BaseFixedRatioTitledWindow
implements ShapePaint.IShapePaintListener {
    private final String docId;
    private String docName = "";
    private PPTView pptView;
    private CommonDialog pptErrorDialog;
    private TextView pptPage;
    private ImageView ivPrevPage;
    private ImageView ivNextPage;
    private ImageView mWindowPptRemarks;
    private TextView mPlayMode;
    private TextView tvPreview;
    private boolean mRemarksEnable = true;
    public static final String PPT_WINDOW_MOVE = "move";
    public static final String PPT_WINDOW_SCALE = "scale";
    private final ShapePaint shapePaint;
    private final LPConstants.LPUserType mUserType;
    private boolean hasPageCountChangeCallback;
    private boolean shouldHidePageView;
    private Disposable disposableOfDocAllRes;
    private final LPMotionEvent lpMotionEvent = new LPMotionEvent();
    private boolean isCacheStateFull;
    private boolean isCacheStateMax;
    private int currentPage = 1;

    public PPTWindow(Context context, String docId, ShapePaint shapePaint, LPConstants.LPUserType userType) {
        super(context);
        this.docId = docId;
        this.shapePaint = shapePaint;
        this.mUserType = userType;
        shapePaint.registerShapePaintListener(this);
        this.initPPTDoc();
        this.initRemarks();
        this.isPPTWindow = true;
    }

    @Override
    public void setWindowLayoutParams(ViewGroup.LayoutParams layoutParams) {
        super.setWindowLayoutParams(layoutParams);
        this.layoutParamsSmall = layoutParams;
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        boolean isWindowInit = super.onRoomStatusChange(isActive);
        if (isWindowInit && isActive) {
            this.subscribe();
        }
        return true;
    }

    private void subscribe() {
        this.compositeDisposable.add(this.iRouter.getLiveRoom().getObservableOfH5PlayModeChange().filter(playModeChangeModel -> playModeChangeModel.getPlayModeModels() != null).observeOn(AndroidSchedulers.mainThread()).subscribe(playModeChangeModel -> {
            for (LPH5DocPlayModeModel playMode : playModeChangeModel.getPlayModeModels()) {
                if (!TextUtils.equals((CharSequence)playMode.getDocId(), (CharSequence)this.getRealDocId())) continue;
                this.pptView.setH5PlayMode(playMode.getPlayMode());
                this.mPlayMode.setVisibility(playMode.getPlayMode() == LPConstants.H5PlayMode.Practice ? 0 : 8);
                break;
            }
        }));
    }

    public void setOnTouchEvent(XYDataPacket xyDataPacket) {
        if (this.pptView != null) {
            if (xyDataPacket.tx <= (float)this.view.getLeft()) {
                xyDataPacket.tx = this.view.getLeft();
            } else if (xyDataPacket.tx > (float)this.view.getRight()) {
                xyDataPacket.tx = this.view.getRight();
            }
            if (xyDataPacket.ty <= (float)this.view.getTop()) {
                xyDataPacket.ty = this.view.getTop();
            } else if (xyDataPacket.ty > (float)this.view.getBottom()) {
                xyDataPacket.ty = this.view.getBottom();
            }
            LaserShapeLayer.PositionInfo positionInfo = new LaserShapeLayer.PositionInfo();
            this.pptView.getPPTPagePositionInfo(positionInfo);
            xyDataPacket.tx = xyDataPacket.tx - (float)this.view.getLeft() + (float)positionInfo.offsetWidth;
            xyDataPacket.ty = xyDataPacket.ty - (float)this.view.getTop() + (float)positionInfo.offsetHeight;
            this.lpMotionEvent.setXyDataPacket(xyDataPacket);
            this.pptView.onZXYBMotionEvent(this.lpMotionEvent);
        }
    }

    public boolean contains(float x, float y) {
        return x >= (float)this.view.getLeft() && x <= (float)this.view.getRight() && y >= (float)this.view.getTop() && y <= (float)this.view.getBottom();
    }

    public void gotoPrevPage() {
        if (this.pptView != null && this.pptView.getPPTAuth()) {
            this.pptView.gotoPrevPage();
        }
    }

    public void gotoNextPage() {
        if (this.pptView != null && this.pptView.getPPTAuth()) {
            this.pptView.gotoNextPage();
        }
    }

    private void initRemarks() {
        if (this.mUserType == LPConstants.LPUserType.Teacher || this.mUserType == LPConstants.LPUserType.Assistant) {
            this.mWindowPptRemarks.setVisibility(0);
            this.pptView.setRemarksEnable(true);
            this.mWindowPptRemarks.setSelected(this.mRemarksEnable);
        } else {
            this.mWindowPptRemarks.setVisibility(4);
        }
        this.mWindowPptRemarks.setOnClickListener(v -> {
            this.mRemarksEnable = !this.mRemarksEnable;
            this.pptView.setRemarksEnable(this.mRemarksEnable);
            this.mWindowPptRemarks.setSelected(this.mRemarksEnable);
        });
    }

    @Override
    protected void initDrawableIds() {
        this.maxDrawableId = R.drawable.ic_title_max_in_sync_layer;
        this.maxResetDrawableId = R.drawable.ic_title_max_reset_to_sync_layer;
        this.fullDrawableId = R.drawable.ic_title_full_to_full_layer;
        this.fullResetDrawableId = R.drawable.ic_title_full_reset_to_sync_layer;
    }

    @Override
    protected void onCreateContentView(final Context context) {
        this.pptView = new PPTView(context);
        this.pptView.addLifecycle(((AppCompatActivity)context).getLifecycle());
        this.pptView.setPPTBackground((Drawable)new ColorDrawable(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_window_bg_color)));
        this.pptView.hidePageView();
        this.pptView.setShowPaintOwnerEnable(true);
        this.pptView.setOnViewTapListener((view, x, y) -> {
            if (this.iRouter != null) {
                this.iRouter.getSubjectByKey(EventKey.BgSingleTapConfirmed).onNext((Object)true);
            }
        });
        this.pptView.setPPTStatusListener((PPTStatusListener)new SimplePPTStatusListener(){

            public void onPPTViewAttached() {
                PPTWindow.this.pptView.setCustomShapeStrokeWidth(PPTWindow.this.shapePaint.getCustomStrokeWidth());
                PPTWindow.this.pptView.setShapeStrokeWidth(PPTWindow.this.shapePaint.getDoodleStrokeWidth());
                PPTWindow.this.pptView.setPaintColor(PPTWindow.this.shapePaint.getShapeColor());
                PPTWindow.this.pptView.setPaintTextSize(PPTWindow.this.shapePaint.getTextSize());
                PPTWindow.this.pptView.setShapeType(PPTWindow.this.shapePaint.getShapeType());
                PPTWindow.this.pptView.setPPTEditMode(PPTWindow.this.shapePaint.getPPtEditMode());
                if (PPTWindow.this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
                    PPTWindow.this.pptView.setFlingEnable(false);
                    PPTWindow.this.pptView.changeTouchAble(InteractiveUtils.hasDrawingAuth(PPTWindow.this.iRouter.getLiveRoom(), PPTWindow.this.iRouter.getLiveRoom().getCurrentUser()));
                }
                PPTWindow.this.setPPTAuthView(PPTWindow.this.iRouter.getLiveRoom().getDocListVM().hasPPTAuth());
            }

            public void onPageChange(LPAnimPPTPageChangeEndModel pageChangeEndModel, String remarkInfo) {
                PPTWindow.this.currentPage = pageChangeEndModel.page;
                PPTWindow.this.updatePageInfo(PPTWindow.this.currentPage, PPTWindow.this.pptView.getTotalPageNumber());
            }

            public void onH5PageCountChange(String docId, int pageCount) {
                PPTWindow.this.hasPageCountChangeCallback = true;
                PPTWindow.this.updatePageInfo(PPTWindow.this.currentPage, pageCount);
            }

            public void onPPTError(LPError lpError) {
                super.onPPTError(lpError);
                if (lpError.getCode() == -2007) {
                    if (PPTWindow.this.pptErrorDialog == null) {
                        PPTWindow.this.pptErrorDialog = new CommonDialog(context, CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(lpError.getMessage() + "\n" + PPTWindow.this.getString(R.string.anim_ppt_error_suggestion_over_time)).setNegative(PPTWindow.this.getString(R.string.anim_ppt_error_skip_anim), (dialog, which) -> {
                            if (PPTWindow.this.pptView != null) {
                                PPTWindow.this.pptView.setAnimPPTEnable(false);
                            }
                            dialog.dismiss();
                        }).setPositive(PPTWindow.this.getString(R.string.anim_ppt_error_reload), (dialog, which) -> {
                            if (PPTWindow.this.pptView != null) {
                                PPTWindow.this.pptView.reloadAnimPPT();
                            }
                            dialog.dismiss();
                        });
                    }
                    PPTWindow.this.pptErrorDialog.show();
                }
            }

            public void onAnimPPTLoadFinish() {
                super.onAnimPPTLoadFinish();
                if (PPTWindow.this.pptErrorDialog != null && PPTWindow.this.pptErrorDialog.isShowing()) {
                    PPTWindow.this.pptErrorDialog.dismiss();
                }
            }
        });
        this.pptView.setOnDoubleTapListener(new OnDoubleTapListener2(){

            public void onDoubleTapConfirmed() {
            }

            public void onDoubleTapOnShape(Shape shape) {
                PPTWindow.this.iRouter.getSubjectByKey(EventKey.EditTextShape).onNext((Object)((TextShape)shape).getText());
            }
        });
        this.pptView.setOnShapeSelectedListener(selected -> this.iRouter.getSubjectByKey(EventKey.Action2ShapeSelected).onNext((Object)selected));
        this.rlContentContainer.addView((View)this.pptView);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.contentOuterContainer.getLayoutParams();
        layoutParams.removeRule(2);
        layoutParams.removeRule(3);
    }

    @Override
    protected void onCreateFooterView(Context context) {
        View footerContainer = LayoutInflater.from((Context)context).inflate(R.layout.layout_ppt_window_footer, (ViewGroup)this.rlFooterContainer);
        this.pptPage = (TextView)footerContainer.findViewById(R.id.window_center_pageNumber);
        this.ivPrevPage = (ImageView)footerContainer.findViewById(R.id.window_titled_prev_page);
        this.ivNextPage = (ImageView)footerContainer.findViewById(R.id.window_titled_next_page);
        this.mWindowPptRemarks = (ImageView)footerContainer.findViewById(R.id.window_ppt_remarks);
        this.tvPreview = (TextView)footerContainer.findViewById(R.id.window_ppt_preview);
        this.mPlayMode = (TextView)footerContainer.findViewById(R.id.window_h5_play_mode);
    }

    @Override
    protected void onCreateTopView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_ppt_window_top, (ViewGroup)this.rlTitleContainer);
    }

    private void updatePageInfo(int page, int totalPage) {
        if (this.iRouter.getLiveRoom().getDocListVM().isContainH5PPTDoc(this.getRealDocId()) && !this.hasPageCountChangeCallback) {
            this.shouldHidePageView = true;
            this.pptPage.setVisibility(8);
        } else {
            this.shouldHidePageView = false;
            this.pptPage.setVisibility(0);
        }
        String str = ++page + "/" + totalPage;
        this.pptPage.setText((CharSequence)str);
    }

    public void hideTitleFooter() {
        if (this.isAdmin()) {
            this.rlTitleContainer.setVisibility(8);
            this.rlFooterContainer.setVisibility(8);
        }
    }

    public void showTitleFooter() {
        if (this.isAdmin()) {
            this.rlTitleContainer.setVisibility(0);
            this.rlFooterContainer.setVisibility(0);
        }
    }

    public void hideTitle() {
        if (this.isAdmin()) {
            this.rlTitleContainer.setVisibility(8);
        }
    }

    public void showTitle() {
        if (this.isAdmin()) {
            this.rlTitleContainer.setVisibility(0);
        }
    }

    private void initPPTDoc() {
        this.pptView.setDocId(this.getRealDocId());
        this.pptView.setPreviewDoc(this.docId.contains("_preview"));
        this.tvPreview.setVisibility(this.docId.contains("_preview") ? 0 : 8);
        this.pptView.attachLiveRoom(this.iRouter.getLiveRoom());
        if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            this.ivClose.setVisibility(8);
            this.ivMaxFull.setVisibility(8);
            this.ivMaxSync.setVisibility(8);
            this.rlFooterContainer.setVisibility(0);
        } else {
            if (this.shapePaint.getPPtEditMode() == LPConstants.PPTEditMode.Normal || this.shapePaint.getPPtEditMode() == LPConstants.PPTEditMode.PPTTouchMode) {
                this.showTitleFooter();
            } else {
                this.hideTitleFooter();
            }
            this.ivClose.setOnClickListener(v -> this.iRouter.getSubjectByKey(EventKey.ClosePPTWindow).onNext((Object)new Tuple(this.getId())));
            this.setOnSingleTapListener(event -> {
                if (this.iRouter == null) {
                    return;
                }
                this.iRouter.getSubjectByKey(EventKey.PPTWindowBringToFront).onNext((Object)this.getId());
            });
            this.setOnWindowRepositionListener(new BaseWindow.OnWindowRepositionListener(){

                public void onWindowMove(int x, int y) {
                    if (PPTWindow.this.getParentViewGroup() instanceof FullScreenLayer || !PPTWindow.this.isAdmin()) {
                        return;
                    }
                    PPTWindow.this.iRouter.getSubjectByKey(EventKey.RepositionPPTWindow).onNext((Object)new Tuple(PPTWindow.PPT_WINDOW_MOVE, PPTWindow.this.getId(), x, y));
                }

                public void OnWindowScale(int newWidth, int newHeight) {
                    if (PPTWindow.this.getParentViewGroup() instanceof FullScreenLayer || !PPTWindow.this.isAdmin()) {
                        return;
                    }
                    PPTWindow.this.iRouter.getSubjectByKey(EventKey.RepositionPPTWindow).onNext((Object)new Tuple(PPTWindow.PPT_WINDOW_SCALE, PPTWindow.this.getId(), newWidth, newHeight));
                }
            });
            if (this.shapePaint.getPPtEditMode() == LPConstants.PPTEditMode.Normal) {
                this.rlFooterContainer.setVisibility(0);
            }
        }
        this.ivNextPage.setOnClickListener(v -> this.pptView.gotoNextPage());
        this.ivPrevPage.setOnClickListener(v -> this.pptView.gotoPrevPage());
        this.disposableOfDocAllRes = this.iRouter.getLiveRoom().getDocListVM().getObservableOfDocAll().observeOn(AndroidSchedulers.mainThread()).subscribe(lpResRoomDocAllModel -> {
            for (LPDocumentModel lpDocumentModel : lpResRoomDocAllModel.docList) {
                if (!TextUtils.equals((CharSequence)lpDocumentModel.id, (CharSequence)this.getRealDocId())) continue;
                if (FileUtils.isImageFile((String)lpDocumentModel.ext) && this.rlFooterContainer != null) {
                    if (this.isPreviewPPT()) {
                        this.pptPage.setVisibility(4);
                        this.ivPrevPage.setVisibility(4);
                        this.ivNextPage.setVisibility(4);
                        this.mWindowPptRemarks.setVisibility(4);
                        this.tvPreview.setVisibility(0);
                        this.mPlayMode.setVisibility(4);
                    } else {
                        this.rlFooterContainer.setVisibility(4);
                    }
                }
                this.docName = lpDocumentModel.name;
                if (this.isPreviewPPT()) {
                    this.docName = this.context.getString(R.string.bjy_group_doc_preview_title_prefix) + lpDocumentModel.name;
                }
                this.tvTitle.setText((CharSequence)this.docName);
                PPTTabLayer pptTabLayer = this.iRouter.getValueByKey(EventKey.PPTTabLayer, PPTTabLayer.class);
                if (pptTabLayer == null || !this.isAdmin()) break;
                pptTabLayer.refreshTabs();
                break;
            }
        });
    }

    public void switchTab(PPTWindow destWindow) {
        if (destWindow == this) {
            return;
        }
        this.isReceiveOrder = false;
        if (this.isMaxInSync) {
            this.sendCompatSignal(false, true);
            destWindow.maxInSync(false);
            this.isCacheStateMax = true;
        }
        if (this.isMaxInFull) {
            this.sendCompatSignal(true, true);
            destWindow.maxInFull(false);
            this.sendCompatSignal(false, false);
            this.isCacheStateFull = true;
        }
    }

    private void sendCompatSignal(boolean isFull, boolean hasNextAction) {
        if (!this.isAdmin() || this.getId().contains("_preview")) {
            return;
        }
        String docId = this.getId();
        List<LPDocViewElementModel> allDocList = this.iRouter.getListByKey(EventKey.AllDocViewList, LPDocViewElementModel.class);
        LPDocViewUpdateModel lpDocViewUpdateModel = new LPDocViewUpdateModel();
        lpDocViewUpdateModel.docId = docId;
        lpDocViewUpdateModel.action = "normal";
        if (hasNextAction) {
            String string2 = lpDocViewUpdateModel.nextAction = isFull ? "full" : "max";
        }
        if (allDocList == null || allDocList.isEmpty()) {
            return;
        }
        for (LPDocViewElementModel elementModel : allDocList) {
            if (!elementModel.docId.equals(lpDocViewUpdateModel.docId)) continue;
            elementModel.max = 0;
            elementModel.full = 0;
            lpDocViewUpdateModel.all = allDocList;
            this.iRouter.getLiveRoom().getDocListVM().requestDocViewUpdate(lpDocViewUpdateModel);
            break;
        }
    }

    public void bringToForeground() {
        super.bringToForeground();
        ViewGroup parentViewGroup = this.getParentViewGroup();
        if (parentViewGroup == null) {
            return;
        }
        if (this.iRouter == null) {
            return;
        }
        PPTTabLayer pptTabLayer = this.iRouter.getValueByKey(EventKey.PPTTabLayer, PPTTabLayer.class);
        if (pptTabLayer != null && parentViewGroup.indexOfChild((View)pptTabLayer) != -1) {
            pptTabLayer.bringToFront();
        }
        this.iRouter.getSubjectByKey(EventKey.PPTWindowBringToFrontLocal).onNext((Object)this.getId());
    }

    public void maxInFull(boolean isReceiverOrder) {
        this.setReceiveOrder(isReceiverOrder);
        this.maxInFull();
        if (this.boundView != null && this.boundView.getShadowView() != null) {
            this.boundView.getShadowView().setVisibility(8);
        }
        if (!this.isAdmin()) {
            this.ivMaxFull.setVisibility(8);
        }
    }

    public void maxInFullCache(boolean isReceiverOrder) {
        this.setReceiveOrder(isReceiverOrder);
        this.iRouter.setObjectByKey(EventKey.MaxScreenPPTWindow, null);
        this.isCacheStateFull = true;
        this.isCacheStateMax = false;
        super.maxInFull();
        this.setCanScale(false);
        if (this.boundView != null && this.boundView.getShadowView() != null) {
            this.boundView.getShadowView().setVisibility(8);
        }
        if (!this.isAdmin()) {
            this.ivMaxFull.setVisibility(8);
        }
    }

    @Override
    public void maxInFull() {
        this.iRouter.setObjectByKey(EventKey.FullScreenPPTWindow, this);
        this.iRouter.setObjectByKey(EventKey.MaxScreenPPTWindow, null);
        if (this.isCacheStateFull) {
            this.dragScaleRelativeLayout.bringToFront();
            this.iRouter.getSubjectByKey(EventKey.SetFullScreenWindowOn).onNext((Object)this);
        } else {
            super.maxInFull();
            this.setCanScale(false);
            this.isCacheStateFull = true;
            this.isCacheStateMax = false;
        }
    }

    public void maxInSync(boolean isReceiverOrder) {
        this.setReceiveOrder(isReceiverOrder);
        this.maxInSync();
        if (this.boundView != null && this.boundView.getShadowView() != null) {
            this.boundView.getShadowView().setVisibility(8);
        }
        if (!this.isAdmin()) {
            this.ivMaxSync.setVisibility(8);
        }
    }

    public void maxInSyncCache(boolean isReceiverOrder) {
        this.isCacheStateMax = true;
        this.setReceiveOrder(isReceiverOrder);
        super.maxInSync();
        this.setCanScale(false);
        if (this.boundView != null && this.boundView.getShadowView() != null) {
            this.boundView.getShadowView().setVisibility(8);
        }
        if (!this.isAdmin()) {
            this.ivMaxSync.setVisibility(8);
        }
    }

    @Override
    public void maxInSync() {
        if (this.checkNotTopPPTWindow(EventKey.FullScreenPPTWindow)) {
            return;
        }
        this.iRouter.setObjectByKey(EventKey.MaxScreenPPTWindow, this);
        if (this.isCacheStateMax) {
            this.dragScaleRelativeLayout.bringToFront();
            this.iRouter.getSubjectByKey(EventKey.SetMaximumWindowOn).onNext((Object)this);
        } else {
            super.maxInSync();
            this.setCanScale(false);
            this.isCacheStateMax = true;
        }
    }

    public void resetInFull(boolean isReceiverOrder) {
        this.setReceiveOrder(isReceiverOrder);
        this.resetInFull();
        if (this.boundView != null && this.boundView.getShadowView() != null) {
            this.boundView.getShadowView().setVisibility(0);
        }
        if (!this.isAdmin()) {
            this.ivMaxFull.setVisibility(8);
            this.ivMaxSync.setVisibility(8);
        }
    }

    @Override
    public void resetInFull() {
        if (this.isMaxInFull && this.checkNotTopPPTWindow(EventKey.FullScreenPPTWindow)) {
            this.isCacheStateFull = true;
        } else {
            this.isCacheStateFull = false;
            if (this.checkTopPPTWindow(EventKey.FullScreenPPTWindow)) {
                this.iRouter.setObjectByKey(EventKey.FullScreenPPTWindow, null);
            }
            super.resetInFull();
            this.setCanScale(true);
        }
    }

    public void resetInSync(boolean isReceiverOrder) {
        this.setReceiveOrder(isReceiverOrder);
        this.resetInSync();
        if (this.boundView != null && this.boundView.getShadowView() != null) {
            this.boundView.getShadowView().setVisibility(0);
        }
        if (!this.isAdmin()) {
            this.ivMaxSync.setVisibility(8);
            this.ivMaxFull.setVisibility(8);
        }
    }

    @Override
    public void resetInSync() {
        if (this.isMaxInSync && this.checkNotTopPPTWindow(EventKey.MaxScreenPPTWindow)) {
            this.isCacheStateMax = true;
        } else {
            this.isCacheStateMax = false;
            this.iRouter.setObjectByKey(EventKey.MaxScreenPPTWindow, null);
            super.resetInSync();
            this.setCanScale(true);
        }
    }

    private boolean checkNotTopPPTWindow(EventKey eventKey) {
        PPTWindow pptWindow = this.iRouter.getValueByKey(eventKey, PPTWindow.class);
        return pptWindow != null && pptWindow != this;
    }

    private boolean checkTopPPTWindow(EventKey eventKey) {
        PPTWindow pptWindow = this.iRouter.getValueByKey(eventKey, PPTWindow.class);
        return pptWindow == this;
    }

    public void setPPTAuthView(boolean isPPTAuth) {
        boolean realPPTAuth;
        boolean bl = realPPTAuth = isPPTAuth || this.docId.contains("_preview");
        if (realPPTAuth && !this.shouldHidePageView) {
            this.ivPrevPage.setVisibility(0);
            this.ivNextPage.setVisibility(0);
        } else {
            this.ivPrevPage.setVisibility(8);
            this.ivNextPage.setVisibility(8);
        }
        if (!this.isAdmin() && !this.iRouter.getLiveRoom().getPartnerConfig().enableH5PPTPageDown && this.pptView.isH5PPT(this.getRealDocId())) {
            this.ivPrevPage.setVisibility(8);
            this.ivNextPage.setVisibility(8);
        }
        this.pptView.setAnimPPTAuth(realPPTAuth);
    }

    public boolean isCacheStateFull() {
        return this.isCacheStateFull;
    }

    public boolean isCacheStateMax() {
        return this.isCacheStateMax;
    }

    @Override
    public boolean isMaxInFull() {
        return super.isMaxInFull() && this.checkTopPPTWindow(EventKey.FullScreenPPTWindow);
    }

    @Override
    public boolean isMaxInSync() {
        return super.isMaxInSync() && this.checkTopPPTWindow(EventKey.MaxScreenPPTWindow);
    }

    public PPTView getPPTView() {
        return this.pptView;
    }

    public long getRealDocIdWithNum() {
        long id2 = 0L;
        try {
            id2 = Long.parseLong(this.getRealDocId());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return id2;
    }

    public String getRealDocId() {
        return this.docId.replace("_preview", "");
    }

    public boolean isPreviewPPT() {
        return this.docId.contains("_preview");
    }

    public String getDocName() {
        return this.docName;
    }

    @Override
    public void onShapeCustomStrokeWidthChange(float strokeWidth) {
        this.pptView.setCustomShapeStrokeWidth(strokeWidth);
    }

    @Override
    public void onShapeDoodleStrokeWidthChange(float strokeWidth) {
        this.pptView.setShapeStrokeWidth(strokeWidth);
    }

    @Override
    public void onShapeColorChange(int shapeColor) {
        this.pptView.setPaintColor(shapeColor);
    }

    @Override
    public void onShapeTypeChange(LPConstants.ShapeType shapeType) {
        this.pptView.setShapeType(shapeType);
    }

    @Override
    public void onShapeEditModeChange(LPConstants.PPTEditMode pptEditMode) {
        this.dragScaleRelativeLayout.setCanScaleOrDrag(pptEditMode == LPConstants.PPTEditMode.Normal);
        this.dragScaleRelativeLayout.setForceNotConsume(pptEditMode == LPConstants.PPTEditMode.PPTTouchMode);
        this.pptView.setPPTEditMode(pptEditMode);
    }

    @Override
    public void onShapeTextSizeChange(int textSize) {
        this.pptView.setPaintTextSize(textSize);
    }

    @Override
    public void onSendDrawTextConfirmed(String beforeText, String content) {
        this.pptView.sendDrawTextConfirmed(beforeText, content);
    }

    @Override
    public String getId() {
        return this.docId;
    }

    @Override
    public void onDestroy() {
        if (this.shapePaint != null) {
            this.shapePaint.unregisterShapePaintListener(this);
        }
        RxUtils.dispose((Disposable)this.disposableOfDocAllRes);
        super.onDestroy();
    }
}

