/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.user;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.user.ReplacePresenter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPMediaModel;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import com.baijiayun.livecore.wrapper.LPPlayer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0014\u0010$\u001a\u00020\u00192\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0018\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0016H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0016H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/baijiayun/groupclassui/user/ReplaceListRecyclerViewAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/baijiayun/groupclassui/user/ReplaceListRecyclerViewAdapter$ViewHolder;", "activeUserListCur", "", "Lcom/baijiayun/livebase/models/imodels/IUserModel;", "context", "Landroid/content/Context;", "presenter", "Lcom/baijiayun/groupclassui/user/ReplacePresenter;", "(Ljava/util/List;Landroid/content/Context;Lcom/baijiayun/groupclassui/user/ReplacePresenter;)V", "getActiveUserListCur", "()Ljava/util/List;", "setActiveUserListCur", "(Ljava/util/List;)V", "activeUserListWithStatus", "Lcom/baijiayun/livecore/models/imodels/IMediaModel;", "getContext", "()Landroid/content/Context;", "getPresenter", "()Lcom/baijiayun/groupclassui/user/ReplacePresenter;", "selectedUserOldPosition", "", "selectedUserPosition", "filterTeacherFromSpeakUserList", "", "getItemCount", "getMediaModel", "Lcom/baijiayun/livecore/models/LPMediaModel;", "userModel", "getMediaModelFromSpeakList", "useId", "", "getSelectedUserPosition", "isSelf", "", "notifyCurrentActiveUserChange", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "ViewHolder", "group-class_release"})
public final class ReplaceListRecyclerViewAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    private List<IUserModel> activeUserListCur;
    @NotNull
    private final Context context;
    @NotNull
    private final ReplacePresenter presenter;
    @Nullable
    private List<IMediaModel> activeUserListWithStatus;
    private int selectedUserPosition;
    private int selectedUserOldPosition;

    public ReplaceListRecyclerViewAdapter(@NotNull List<IUserModel> activeUserListCur, @NotNull Context context, @NotNull ReplacePresenter presenter2) {
        Intrinsics.checkNotNullParameter(activeUserListCur, (String)"activeUserListCur");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)presenter2, (String)"presenter");
        this.activeUserListCur = activeUserListCur;
        this.context = context;
        this.presenter = presenter2;
        this.selectedUserPosition = -1;
        this.selectedUserOldPosition = -1;
        this.filterTeacherFromSpeakUserList();
    }

    @NotNull
    public final List<IUserModel> getActiveUserListCur() {
        return this.activeUserListCur;
    }

    public final void setActiveUserListCur(@NotNull List<IUserModel> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.activeUserListCur = list;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final ReplacePresenter getPresenter() {
        return this.presenter;
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_group_item_replace_user, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"from(parent.context).inf\u2026lace_user, parent, false)");
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        int positionSelected = position;
        if (positionSelected == this.selectedUserPosition) {
            holder.getReplaceIv().setImageResource(R.drawable.bjy_group_replace_shape_rb_bg_selected);
        } else {
            holder.getReplaceIv().setImageResource(R.drawable.bjy_group_replace_shape_rb_bg_normal);
        }
        List<IUserModel> it = this.activeUserListCur;
        boolean bl = false;
        holder.itemView.setOnClickListener(arg_0 -> ReplaceListRecyclerViewAdapter.onBindViewHolder$lambda$1$lambda$0(this, holder, positionSelected, arg_0));
        if (it.isEmpty()) {
            holder.getReplaceUserNameTv().setText((CharSequence)this.context.getResources().getString(R.string.bjy_group_activeuser_dialog_vacancy));
            holder.getReplaceIconContainer().setVisibility(8);
            holder.getReplaceUserLabelTv().setVisibility(8);
        } else if (positionSelected <= it.size() - 1) {
            IUserModel iUserModel = it.get(positionSelected);
            holder.getReplaceUserNameTv().setText((CharSequence)iUserModel.getName());
            holder.getReplaceIconContainer().setVisibility(0);
            List<IMediaModel> list = this.activeUserListWithStatus;
            boolean bl2 = list != null ? list.size() == it.size() : false;
            if (bl2) {
                String string2 = iUserModel.getUserId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"iUserModel.userId");
                IMediaModel mediaModel = this.getMediaModelFromSpeakList(string2);
                if (mediaModel != null) {
                    holder.getReplaceUserCameraIv().setSelected(!mediaModel.isVideoOn());
                    holder.getReplaceUserMicIv().setSelected(!mediaModel.isAudioOn());
                } else if (this.isSelf(iUserModel)) {
                    holder.getReplaceUserCameraIv().setSelected(!this.presenter.isSelfVideoOn());
                    holder.getReplaceUserMicIv().setSelected(!this.presenter.isSelfAudioOn());
                } else {
                    holder.getReplaceUserCameraIv().setSelected(true);
                    holder.getReplaceUserMicIv().setSelected(true);
                }
            } else {
                boolean isVideoOn = false;
                boolean isAudioOn = false;
                if (this.isSelf(iUserModel)) {
                    isAudioOn = this.presenter.isSelfAudioOn();
                    isVideoOn = this.presenter.isSelfVideoOn();
                } else {
                    LPMediaModel mediaModel = this.getMediaModel(iUserModel);
                    if (mediaModel != null) {
                        isVideoOn = mediaModel.videoOn;
                        isAudioOn = mediaModel.audioOn;
                    }
                }
                holder.getReplaceUserCameraIv().setSelected(!isVideoOn);
                holder.getReplaceUserMicIv().setSelected(!isAudioOn);
            }
            if (iUserModel.getType() == LPConstants.LPUserType.Assistant) {
                holder.getReplaceUserLabelTv().setText((CharSequence)this.presenter.getAssistantCustomLabelText());
                holder.getReplaceUserLabelTv().setBackground(ThemeDataUtil.getCustomLabelBg((Context)this.context, (int)ThemeDataUtil.getColorFromThemConfigByColorId((Context)this.context, (int)R.color.bjy_base_assistant_custom_label_bg_color)));
                holder.getReplaceUserLabelTv().setVisibility(0);
            } else {
                holder.getReplaceUserLabelTv().setVisibility(8);
            }
        } else {
            holder.getReplaceUserNameTv().setText((CharSequence)this.context.getResources().getString(R.string.bjy_group_activeuser_dialog_vacancy));
            holder.getReplaceIconContainer().setVisibility(8);
            holder.getReplaceUserLabelTv().setVisibility(8);
        }
    }

    public final int getSelectedUserPosition() {
        return this.selectedUserPosition;
    }

    private final boolean isSelf(IUserModel userModel) {
        return TextUtils.equals((CharSequence)userModel.getUserId(), (CharSequence)this.presenter.getRouter().getLiveRoom().getCurrentUser().getUserId());
    }

    public final void notifyCurrentActiveUserChange(@NotNull List<IUserModel> activeUserListCur) {
        Intrinsics.checkNotNullParameter(activeUserListCur, (String)"activeUserListCur");
        this.activeUserListCur = activeUserListCur;
        this.filterTeacherFromSpeakUserList();
        this.notifyDataSetChanged();
    }

    private final void filterTeacherFromSpeakUserList() {
        List speakLists = this.presenter.getRouter().getLiveRoom().getSpeakQueueVM().getActiveUserList();
        ArrayList<IMediaModel> speakUsers = new ArrayList<IMediaModel>();
        List list = speakLists;
        if (list != null) {
            List it = list;
            boolean bl = false;
            for (IMediaModel iUserModel : it) {
                if (iUserModel.getUser().getType() == LPConstants.LPUserType.Teacher) continue;
                speakUsers.add(iUserModel);
            }
        }
        this.activeUserListWithStatus = speakUsers;
    }

    private final IMediaModel getMediaModelFromSpeakList(String useId) {
        List<IMediaModel> list = this.activeUserListWithStatus;
        Intrinsics.checkNotNull(list);
        for (IMediaModel mediaModel : list) {
            if (!Intrinsics.areEqual((Object)useId, (Object)mediaModel.getUser().getUserId())) continue;
            return mediaModel;
        }
        return null;
    }

    private final LPMediaModel getMediaModel(IUserModel userModel) {
        LPPlayer lPPlayer = this.presenter.getRouter().getLiveRoom().getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)lPPlayer, (String)"presenter.router.liveRoom.player");
        LPPlayer player = lPPlayer;
        return (LPMediaModel)player.getChmUserMediaModel().get(userModel.getUserId());
    }

    public int getItemCount() {
        return Math.min(this.presenter.getRouter().getLiveRoom().getOnlineUserVM().enable1v1TeacherOffStage() ? this.presenter.getRouter().getLiveRoom().getMaxActiveUsers() + 1 : this.presenter.getRouter().getLiveRoom().getMaxActiveUsers(), this.activeUserListCur.size());
    }

    private static final void onBindViewHolder$lambda$1$lambda$0(ReplaceListRecyclerViewAdapter this$0, ViewHolder $holder, int $positionSelected, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$holder), (String)"$holder");
        this$0.selectedUserOldPosition = this$0.selectedUserPosition;
        $holder.getReplaceIv().setImageResource(R.drawable.bjy_group_replace_shape_rb_bg_selected);
        this$0.selectedUserPosition = $positionSelected;
        this$0.notifyItemChanged($positionSelected);
        this$0.notifyItemChanged(this$0.selectedUserOldPosition);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/baijiayun/groupclassui/user/ReplaceListRecyclerViewAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "replaceIconContainer", "Landroid/widget/LinearLayout;", "getReplaceIconContainer", "()Landroid/widget/LinearLayout;", "setReplaceIconContainer", "(Landroid/widget/LinearLayout;)V", "replaceIv", "Landroid/widget/ImageView;", "getReplaceIv", "()Landroid/widget/ImageView;", "setReplaceIv", "(Landroid/widget/ImageView;)V", "replaceUserCameraIv", "getReplaceUserCameraIv", "setReplaceUserCameraIv", "replaceUserLabelTv", "Landroid/widget/TextView;", "getReplaceUserLabelTv", "()Landroid/widget/TextView;", "setReplaceUserLabelTv", "(Landroid/widget/TextView;)V", "replaceUserMicIv", "getReplaceUserMicIv", "setReplaceUserMicIv", "replaceUserNameTv", "getReplaceUserNameTv", "setReplaceUserNameTv", "group-class_release"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private ImageView replaceIv;
        @NotNull
        private TextView replaceUserNameTv;
        @NotNull
        private TextView replaceUserLabelTv;
        @NotNull
        private LinearLayout replaceIconContainer;
        @NotNull
        private ImageView replaceUserCameraIv;
        @NotNull
        private ImageView replaceUserMicIv;

        public ViewHolder(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            super(view);
            View view2 = view.findViewById(R.id.replace_iv);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view.findViewById(R.id.replace_iv)");
            this.replaceIv = (ImageView)view2;
            View view3 = view.findViewById(R.id.replace_user_name_tv);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view.findViewById(R.id.replace_user_name_tv)");
            this.replaceUserNameTv = (TextView)view3;
            View view4 = view.findViewById(R.id.replace_user_label_tv);
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"view.findViewById(R.id.replace_user_label_tv)");
            this.replaceUserLabelTv = (TextView)view4;
            View view5 = view.findViewById(R.id.replace_icon_container);
            Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"view.findViewById(R.id.replace_icon_container)");
            this.replaceIconContainer = (LinearLayout)view5;
            View view6 = view.findViewById(R.id.replace_user_camera_iv);
            Intrinsics.checkNotNullExpressionValue((Object)view6, (String)"view.findViewById(R.id.replace_user_camera_iv)");
            this.replaceUserCameraIv = (ImageView)view6;
            View view7 = view.findViewById(R.id.replace_user_mic_iv);
            Intrinsics.checkNotNullExpressionValue((Object)view7, (String)"view.findViewById(R.id.replace_user_mic_iv)");
            this.replaceUserMicIv = (ImageView)view7;
        }

        @NotNull
        public final ImageView getReplaceIv() {
            return this.replaceIv;
        }

        public final void setReplaceIv(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.replaceIv = imageView;
        }

        @NotNull
        public final TextView getReplaceUserNameTv() {
            return this.replaceUserNameTv;
        }

        public final void setReplaceUserNameTv(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.replaceUserNameTv = textView;
        }

        @NotNull
        public final TextView getReplaceUserLabelTv() {
            return this.replaceUserLabelTv;
        }

        public final void setReplaceUserLabelTv(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.replaceUserLabelTv = textView;
        }

        @NotNull
        public final LinearLayout getReplaceIconContainer() {
            return this.replaceIconContainer;
        }

        public final void setReplaceIconContainer(@NotNull LinearLayout linearLayout) {
            Intrinsics.checkNotNullParameter((Object)linearLayout, (String)"<set-?>");
            this.replaceIconContainer = linearLayout;
        }

        @NotNull
        public final ImageView getReplaceUserCameraIv() {
            return this.replaceUserCameraIv;
        }

        public final void setReplaceUserCameraIv(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.replaceUserCameraIv = imageView;
        }

        @NotNull
        public final ImageView getReplaceUserMicIv() {
            return this.replaceUserMicIv;
        }

        public final void setReplaceUserMicIv(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.replaceUserMicIv = imageView;
        }
    }
}

