/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.chat;

import android.annotation.SuppressLint;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Looper;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.util.Linkify;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.view.GestureDetectorCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiahulian.common.cropperv2.BJCommonImageCropHelper;
import com.baijiahulian.common.cropperv2.ThemeConfig;
import com.baijiahulian.common.cropperv2.model.PhotoInfo;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.keyboard.KeyboardUtils;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.Transformation;
import com.baijiayun.glide.load.engine.DiskCacheStrategy;
import com.baijiayun.glide.load.resource.bitmap.RoundedCorners;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.chat.ChatPresenter;
import com.baijiayun.groupclassui.chat.IChatContract;
import com.baijiayun.groupclassui.chat.OnChatFilterListener;
import com.baijiayun.groupclassui.chat.preview.IChatMessageCallback;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.util.KUtilsKt;
import com.baijiayun.groupclassui.util.LinearLayoutWrapManager;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPExpressionModel;
import com.baijiayun.livebase.utils.AliCloudImageUtil;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.utils.URLImageParser;
import com.baijiayun.livebase.widgets.emoji.EmojiContract;
import com.baijiayun.livebase.widgets.emoji.EmojiFragment;
import com.baijiayun.livebase.widgets.emoji.EmojiPresenter;
import com.baijiayun.livecore.models.LPGroupItem;
import com.baijiayun.livecore.models.LPMessageModel;
import com.baijiayun.livecore.models.LPMessageTranslateModel;
import com.baijiayun.livecore.models.imodels.IMessageModel;
import com.baijiayun.liveuibase.utils.ShadowUtil;
import com.baijiayun.liveuibase.widgets.chat.BitmapCropTarget;
import com.baijiayun.liveuibase.widgets.chat.CenterImageSpan;
import com.baijiayun.liveuibase.widgets.chat.ChatImageUtil;
import com.baijiayun.liveuibase.widgets.chat.ChatMessageView;
import com.baijiayun.liveuibase.widgets.chat.GifCropTarget;
import com.baijiayun.liveuibase.widgets.common.CheckImageView;
import com.baijiayun.liveuibase.widgets.courseware.models.UploadingImageModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ChatWindow
extends InteractiveBaseWindow
implements IChatContract.View,
ChatMessageView.IChatMessageListener {
    public static final String MESSAGE_USER_IN = "fake_message_user_in";
    public static final String MESSAGE_USER_OUT = "fake_message_user_out";
    private static final int INPUT_TYPE_IMAGE = 0;
    private static final int INPUT_TYPE_TEXT = 1;
    private static final int MAX_MESSAGE_LENGTH = 400;
    private RecyclerView chatRv;
    private CheckBox forbiddenCheckBox;
    private TextView msgSendTv;
    private ImageView msgSendIv;
    private ImageView emojiSendIv;
    private ImageView closeIv;
    private TextView chatUserCountTv;
    private TextView newMessageTv;
    private FrameLayout emojiContainer;
    private ImageView floatWindowIv;
    private ImageView languageSelectBtn;
    private ChatMessageAdapter messageAdapter;
    private ChatPresenter chatPresenter;
    private boolean isHideBubbleBg = false;
    EmojiFragment emojiFragment;
    Context context;
    private boolean isShowEmoji;
    private IChatMessageCallback callback;
    private int inputType = 0;
    private Map<String, LPExpressionModel> emojiMap;
    private String languageTranslateTo;
    private boolean enableChatTranslation;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm", Locale.getDefault());
    private final Pattern pattern = Pattern.compile("\\[[a-zA-Z0-9\u4e00-\u9fa5]+]");
    private String messageText = "";
    private List<String> quickReplyList = null;

    public ChatWindow(Context context) {
        super(context);
        this.callback = (IChatMessageCallback)context;
        this.initEmoji();
    }

    private void initEmoji() {
        this.emojiMap = new HashMap<String, LPExpressionModel>();
        List expressions = this.iRouter.getLiveRoom().getExpressions();
        for (LPExpressionModel lpExpressionModel : expressions) {
            this.emojiMap.put(lpExpressionModel.getBoxName(), lpExpressionModel);
        }
        this.$.id(R.id.dialog_back_rl).clicked(v -> this.chatPresenter.closeChatWindow());
    }

    protected View onCreateView(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_dialog_chat_layout, null);
        this.setNeedShowShadow(this.routerListener.getLiveRoom() == null || !this.routerListener.getLiveRoom().enableFixChatPanel1v1() || !DisplayUtils.isPad((Context)context));
        this.initView(context, view);
        return view;
    }

    private void initView(Context context, View view) {
        this.chatUserCountTv = (TextView)view.findViewById(R.id.chat_user_count_tv);
        this.chatRv = (RecyclerView)view.findViewById(R.id.chat_rv);
        this.forbiddenCheckBox = (CheckBox)view.findViewById(R.id.chat_forbidden_cb);
        this.msgSendTv = (TextView)view.findViewById(R.id.chat_messageText);
        this.msgSendIv = (ImageView)view.findViewById(R.id.text_send_iv);
        this.emojiSendIv = (ImageView)view.findViewById(R.id.dialog_message_emoji);
        this.emojiContainer = (FrameLayout)view.findViewById(R.id.dialog_message_send_emoji);
        this.newMessageTv = (TextView)view.findViewById(R.id.new_message_tips_tv);
        this.floatWindowIv = (ImageView)view.findViewById(R.id.chat_float_window_iv);
        this.languageSelectBtn = (ImageView)view.findViewById(R.id.language_select_button);
        this.msgSendTv.setHint((CharSequence)context.getString(R.string.chat_enter_editText_hint, new Object[]{400}));
        this.messageAdapter = new ChatMessageAdapter();
        this.chatRv.getRecycledViewPool().setMaxRecycledViews(0, 0);
        this.chatRv.getRecycledViewPool().setMaxRecycledViews(1, 0);
        this.chatRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutWrapManager(context));
        this.chatRv.setAdapter((RecyclerView.Adapter)this.messageAdapter);
        this.closeIv = (ImageView)view.findViewById(R.id.chat_close_iv);
        this.chatPresenter = new ChatPresenter(this, context);
        this.languageTranslateTo = this.isAdmin() ? this.iRouter.getLiveRoom().getPartnerConfig().defaultTranslateLanguage : this.iRouter.getLiveRoom().getPartnerConfig().defaultTranslateLanguageStu;
        this.initListener();
    }

    @Override
    public boolean onRoomStatusChange(boolean isActive) {
        boolean isWindowInit = super.onRoomStatusChange(isActive);
        if (isWindowInit) {
            if (isActive) {
                this.chatPresenter.setRouter(this.iRouter);
                this.chatPresenter.subscribe();
                this.updateView();
            } else {
                this.chatPresenter.unSubscribe();
            }
        }
        return true;
    }

    private void updateView() {
        this.msgSendIv.setVisibility(this.iRouter.getLiveRoom().getPartnerConfig().disableLiveChatImage ? 8 : 0);
        this.enableChatTranslation = this.iRouter.getLiveRoom().getPartnerConfig().isEnableChatTranslation();
        if (this.enableChatTranslation) {
            this.languageSelectBtn.setVisibility(0);
        } else {
            this.languageSelectBtn.setVisibility(8);
        }
        if (!this.iRouter.getLiveRoom().getPartnerConfig().hideChatUserCount) {
            this.chatUserCountTv.setText((CharSequence)this.context.getString(R.string.chat_user_count, new Object[]{this.chatPresenter.getOnlineUserCount()}));
        } else {
            this.chatUserCountTv.setText((CharSequence)this.context.getString(R.string.bjysc_chat));
        }
        this.chatRv.smoothScrollToPosition(this.messageAdapter.getItemCount());
        this.notifyForbidStatus(this.chatPresenter.getForbidAllChatStatus());
        if (this.chatPresenter.enableFixChatPanel1v1()) {
            this.$.id(R.id.chat_window_top_ll).gone();
            this.$.id(R.id.chat_forbidden_cb).gone();
            if (!DisplayUtils.isPad((Context)this.context)) {
                this.$.id(R.id.dialog_back_rl).visible();
            }
            this.msgSendTv.setHint((CharSequence)this.getString(R.string.bjysc_input_chat_hint));
            this.msgSendTv.setMaxLines(1);
            this.msgSendTv.setEllipsize(TextUtils.TruncateAt.END);
            this.view.setBackgroundColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_bg_color));
        }
        if (!this.isAdmin()) {
            this.forbiddenCheckBox.setVisibility(8);
        } else {
            this.forbiddenCheckBox.setChecked(this.chatPresenter.getForbidAllChatStatus());
        }
        this.chatPresenter.getQuickReplyList();
    }

    private void initListener() {
        this.forbiddenCheckBox.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (!this.forbiddenCheckBox.isPressed()) {
                return;
            }
            this.chatPresenter.forbidChat(isChecked);
        });
        this.msgSendTv.setOnClickListener(v -> {
            this.chatPresenter.showMessageSendFragment(this.messageText);
            this.removeEmojiFragment();
        });
        this.msgSendIv.setOnClickListener(v -> {
            if (this.inputType == 1) {
                String toSendMsg = this.msgSendTv.getText().toString().trim();
                if (!TextUtils.isEmpty((CharSequence)toSendMsg)) {
                    this.sendTextMessage(this.messageText);
                }
                this.messageText = "";
                this.msgSendTv.setText((CharSequence)this.messageText);
                this.msgSendIv.setImageResource(R.drawable.bg_chat_send_img_selector);
                int _2dp = UtilsKt.getDp((int)2);
                this.msgSendIv.setPadding(_2dp, _2dp, _2dp, _2dp);
                this.inputType = 0;
                this.removeEmojiFragment();
                KeyboardUtils.hideSoftInput((View)this.msgSendTv);
            } else {
                this.showPictureSelect();
            }
        });
        this.emojiSendIv.setOnClickListener(v -> {
            KeyboardUtils.hideSoftInput((View)this.msgSendTv);
            boolean bl = this.isShowEmoji = !this.isShowEmoji;
            if (!this.isShowEmoji) {
                this.removeEmojiFragment();
                return;
            }
            this.showEmojiMenu();
        });
        this.closeIv.setOnClickListener(v -> this.chatPresenter.closeChatWindow());
        this.newMessageTv.setOnClickListener(v -> this.chatRv.smoothScrollToPosition(this.messageAdapter.getItemCount()));
        this.chatRv.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (Math.abs(dy) > 0 && ChatWindow.this.newMessageTv.getVisibility() == 0) {
                    ChatWindow.this.newMessageTv.setVisibility(8);
                }
            }
        });
        this.floatWindowIv.setSelected(this.routerListener.getLiveRoom().getPartnerConfig().enableFloatChatPanel);
        this.floatWindowIv.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)(this.floatWindowIv.isSelected() ? R.drawable.bjy_group_float_chat_window : R.drawable.bjy_group_float_chat_window_hide), null));
        this.floatWindowIv.setOnClickListener(v -> {
            this.floatWindowIv.setSelected(!this.floatWindowIv.isSelected());
            this.floatWindowIv.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)(this.floatWindowIv.isSelected() ? R.drawable.bjy_group_float_chat_window : R.drawable.bjy_group_float_chat_window_hide), null));
            this.iRouter.getSubjectByKey(EventKey.DisplayFloatChat).onNext((Object)this.floatWindowIv.isSelected());
        });
        this.languageSelectBtn.setOnClickListener(v -> {
            int position;
            PopupWindow popupWindow = new PopupWindow(this.context);
            popupWindow.setFocusable(true);
            popupWindow.setWidth(UtilsKt.getDp((int)100));
            popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.context.getString(R.string.bjy_live_translate_language_cambodian));
            items.add(this.context.getString(R.string.bjysc_translate_language_english));
            items.add(this.context.getString(R.string.bjysc_translate_language_japanese));
            items.add(this.context.getString(R.string.bjysc_translate_language_vietnamese));
            items.add(this.context.getString(R.string.bjysc_translate_language_indonesian));
            items.add(this.context.getString(R.string.bjysc_translate_language_simplified_chinese));
            items.add(this.context.getString(R.string.bjysc_translate_language_traditional_chinese));
            popupWindow.setHeight(-2);
            switch (this.languageTranslateTo) {
                case "hkm": {
                    position = 0;
                    break;
                }
                case "jp": {
                    position = 2;
                    break;
                }
                case "vie": {
                    position = 3;
                    break;
                }
                case "id": {
                    position = 4;
                    break;
                }
                case "zh": {
                    position = 5;
                    break;
                }
                case "cht": {
                    position = 6;
                    break;
                }
                default: {
                    position = 1;
                }
            }
            LanguageSelectMenuAdapter adapter = new LanguageSelectMenuAdapter(items, position);
            ListView listView = new ListView(this.context);
            ShadowUtil.ShadowGroup shadowGroup = ShadowUtil.initShadowView((Context)this.context, (View)listView);
            if (shadowGroup == null) {
                return;
            }
            if (shadowGroup.getContentView() != null) {
                ShadowUtil.setViewBoundShadow((View)shadowGroup.getShadowContainer());
            }
            GradientDrawable bgDrawable = new GradientDrawable();
            bgDrawable.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color));
            bgDrawable.setCornerRadius((float)UtilsKt.getDp((int)4));
            listView.setBackground((Drawable)bgDrawable);
            listView.setAdapter((ListAdapter)adapter);
            listView.setDividerHeight(0);
            listView.setPadding(0, UtilsKt.getDp((int)2), 0, UtilsKt.getDp((int)2));
            listView.setOnItemClickListener((parent, view, positions, id2) -> {
                this.setLanguageSelect(listView, positions, items.size());
                popupWindow.dismiss();
            });
            popupWindow.setContentView(shadowGroup.getContentView());
            int[] location = new int[2];
            this.languageSelectBtn.getLocationOnScreen(location);
            int measuredHeight = KUtilsKt.atMostViewSize(shadowGroup.getContentView())[1];
            popupWindow.showAtLocation((View)this.languageSelectBtn, 0, location[0] - UtilsKt.getDp((int)100), location[1] - measuredHeight);
        });
    }

    private void setLanguageSelect(ListView listView, int position, int size) {
        for (int i = 0; i < size; ++i) {
            TextView languageTv = (TextView)listView.getChildAt(i).findViewById(R.id.tv_language);
            if (i == position) {
                listView.getChildAt(i).findViewById(R.id.ic_language_is_selected).setVisibility(0);
                languageTv.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_theme_live_product));
                switch (i) {
                    case 0: {
                        this.languageTranslateTo = "hkm";
                        break;
                    }
                    case 2: {
                        this.languageTranslateTo = "jp";
                        break;
                    }
                    case 3: {
                        this.languageTranslateTo = "vie";
                        break;
                    }
                    case 4: {
                        this.languageTranslateTo = "id";
                        break;
                    }
                    case 5: {
                        this.languageTranslateTo = "zh";
                        break;
                    }
                    case 6: {
                        this.languageTranslateTo = "cht";
                        break;
                    }
                    default: {
                        this.languageTranslateTo = "en";
                        break;
                    }
                }
                continue;
            }
            listView.getChildAt(i).findViewById(R.id.ic_language_is_selected).setVisibility(4);
            languageTv.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
        }
    }

    public void sendTextMessage(String messageText) {
        LPExpressionModel singleEmoji = this.emojiMap.get(messageText);
        if (singleEmoji != null) {
            this.chatPresenter.sendEmojiMessage("[" + singleEmoji.getKey() + "]");
        } else {
            this.chatPresenter.sendTextMessage(messageText);
        }
    }

    private void removeEmojiFragment() {
        if (this.emojiFragment != null) {
            this.emojiContainer.setVisibility(8);
            this.emojiSendIv.setSelected(false);
            FragmentTransaction transaction = ((AppCompatActivity)this.context).getSupportFragmentManager().beginTransaction();
            transaction.remove((Fragment)this.emojiFragment);
            transaction.commitAllowingStateLoss();
        }
    }

    @Override
    public void notifyOnlineUserCountChange() {
        if (!this.iRouter.getLiveRoom().getPartnerConfig().hideChatUserCount) {
            this.chatUserCountTv.setText((CharSequence)this.context.getString(R.string.chat_user_count, new Object[]{this.chatPresenter.getOnlineUserCount()}));
        } else {
            this.chatUserCountTv.setText((CharSequence)this.context.getString(R.string.bjysc_chat));
        }
    }

    @Override
    public void notifyMessageDataSetChange() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            if (this.context instanceof AppCompatActivity) {
                ((AppCompatActivity)this.context).runOnUiThread(() -> {
                    this.messageAdapter.notifyDataSetChanged();
                    this.chatRv.smoothScrollToPosition(this.messageAdapter.getItemCount());
                });
            }
        } else {
            this.messageAdapter.notifyDataSetChanged();
            this.chatRv.smoothScrollToPosition(this.messageAdapter.getItemCount());
        }
    }

    @Override
    public void notifyMessageItemInsert(int position, boolean isSendByMyself) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            if (this.context instanceof AppCompatActivity) {
                ((AppCompatActivity)this.context).runOnUiThread(() -> this.onMessageArrived(position, isSendByMyself));
            }
        } else {
            this.onMessageArrived(position, isSendByMyself);
        }
    }

    @Override
    public void notifyMessageItemRemove(int index) {
        this.messageAdapter.notifyItemRemoved(index);
    }

    @Override
    public void notifyForbidStatus(boolean isForbid) {
        if (!this.isAdmin()) {
            this.msgSendTv.setHint((CharSequence)(isForbid ? this.context.getString(R.string.chat_forbidden) : this.context.getString(R.string.chat_enter_editText_hint, new Object[]{400})));
            this.emojiSendIv.setClickable(!isForbid);
            this.msgSendIv.setClickable(!isForbid);
        }
        this.forbiddenCheckBox.setChecked(this.chatPresenter.getForbidAllChatStatus());
    }

    @Override
    public void notifyTranslateMessage(LPMessageTranslateModel translateModel) {
        int pos = this.chatPresenter.translateMessage(translateModel);
        if (Looper.myLooper() != Looper.getMainLooper()) {
            if (this.context instanceof AppCompatActivity) {
                ((AppCompatActivity)this.context).runOnUiThread(() -> this.onTranslateMessageArrived(pos));
            }
        } else {
            this.onTranslateMessageArrived(pos);
        }
    }

    @Override
    public void notifyQuickReplyList(List<String> quickReplyList) {
        this.quickReplyList = quickReplyList;
    }

    public List<String> getQuickReplyList() {
        return this.quickReplyList;
    }

    private void onMessageArrived(int position, boolean isSendByMyself) {
        this.messageAdapter.notifyItemInserted(position);
        if (this.isChatRVAtBottom() || isSendByMyself) {
            this.newMessageTv.setVisibility(8);
            this.chatRv.smoothScrollToPosition(this.messageAdapter.getItemCount());
        } else {
            this.newMessageTv.setVisibility(0);
        }
    }

    private void onTranslateMessageArrived(int position) {
        this.messageAdapter.notifyItemChanged(position);
    }

    public void setMessageText(String message) {
        this.messageText = message;
        this.msgSendTv.setText((CharSequence)message);
        if (!TextUtils.isEmpty((CharSequence)this.messageText)) {
            this.msgSendIv.setImageResource(R.drawable.ic_chat_send);
            this.msgSendIv.setPadding(0, 0, 0, 0);
            this.inputType = 1;
        } else {
            this.msgSendIv.setImageResource(R.drawable.bg_chat_send_img_selector);
            int _2dp = UtilsKt.getDp((int)2);
            this.msgSendIv.setPadding(_2dp, _2dp, _2dp, _2dp);
            this.inputType = 0;
        }
    }

    public void showEmojiMenu() {
        this.isShowEmoji = true;
        this.emojiContainer.postDelayed(() -> {
            this.emojiContainer.setVisibility(0);
            this.emojiSendIv.setSelected(true);
            this.emojiFragment = EmojiFragment.newInstance();
            if (this.routerListener.getLiveRoom() != null && this.routerListener.getLiveRoom().enableFixChatPanel1v1()) {
                this.emojiFragment.setItemSize(UtilsKt.getDp((int)48));
                this.emojiFragment.setMaxWidth(this.view.getMeasuredWidth() == 0 ? UtilsKt.getDp((int)330) : this.view.getMeasuredWidth());
                this.emojiFragment.setCount(7, 5);
                if (DisplayUtils.isPad((Context)this.context)) {
                    ViewGroup.LayoutParams layoutParams = this.emojiContainer.getLayoutParams();
                    layoutParams.height = this.view.getMeasuredHeight() - this.$.id(R.id.chat_enter_rl).view().getMeasuredHeight() - 20;
                    this.emojiFragment.setMaxHeight(layoutParams.height);
                }
            } else {
                this.emojiFragment.setCount(6, 5);
                this.emojiFragment.setMaxWidth(this.view.getMeasuredWidth() == 0 ? UtilsKt.getDp((int)330) : this.view.getMeasuredWidth());
            }
            EmojiPresenter presenter2 = new EmojiPresenter((EmojiContract.View)this.emojiFragment, this.iRouter.getLiveRoom().getChatVM().getExpressions());
            this.emojiFragment.setPresenter((EmojiContract.Presenter)presenter2);
            this.emojiFragment.setCallBack(emoji -> {
                if (this.messageText.length() > 400) {
                    ToastCompat.showToast((Context)this.context, (CharSequence)this.context.getString(R.string.chat_input_text_beyond_tips, new Object[]{400}), (int)0);
                    return;
                }
                this.messageText = this.messageText + emoji.getBoxName();
                this.msgSendTv.setText((CharSequence)this.messageText);
                if (!TextUtils.isEmpty((CharSequence)this.messageText)) {
                    this.msgSendIv.setImageResource(R.drawable.ic_chat_send);
                    this.msgSendIv.setPadding(0, 0, 0, 0);
                    this.inputType = 1;
                } else {
                    this.msgSendIv.setImageResource(R.drawable.bg_chat_send_img_selector);
                    int _2dp = UtilsKt.getDp((int)2);
                    this.msgSendIv.setPadding(_2dp, _2dp, _2dp, _2dp);
                    this.inputType = 0;
                }
            });
            FragmentTransaction transaction = ((AppCompatActivity)this.context).getSupportFragmentManager().beginTransaction();
            transaction.add(R.id.dialog_message_send_emoji, (Fragment)this.emojiFragment);
            transaction.commitAllowingStateLoss();
        }, 100L);
    }

    public void showPictureSelect() {
        if (this.context == null) {
            return;
        }
        ThemeConfig.Builder builder = new ThemeConfig.Builder();
        builder.setScreenOrientation(0).setMainElementsColor(ContextCompat.getColor((Context)this.context, (int)R.color.bjysc_live_blue));
        BJCommonImageCropHelper.openImageSingleAblum((Context)this.context, (BJCommonImageCropHelper.PhotoCropType)BJCommonImageCropHelper.PhotoCropType.None, (ThemeConfig)builder.build(), (BJCommonImageCropHelper.OnHandlerResultCallback)new BJCommonImageCropHelper.OnHandlerResultCallback(){

            public void onHandlerSuccess(List<PhotoInfo> list) {
                if (list.size() == 1) {
                    ChatWindow.this.chatPresenter.sendImageMessage(list.get(0).getPhotoPath());
                }
            }

            public void onHandlerFailure(String s) {
                ChatWindow.this.showToastMessage(s);
            }
        });
        this.removeEmojiFragment();
        KeyboardUtils.hideSoftInput((View)this.msgSendTv);
    }

    private Drawable getMultiTextStateDrawable() {
        int dp_16 = UtilsKt.getDp((int)16);
        Drawable mySelfDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)).cornerRadii(dp_16, 0, dp_16, dp_16).build();
        Drawable otherTeacherDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadii(0, dp_16, dp_16, dp_16).build();
        Drawable otherDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadii(0, dp_16, dp_16, dp_16).build();
        return new StateListDrawableBuilder().multiState((int[][])new int[][]{{0x10100A1, R.attr.state_checked}, {-16842913, R.attr.state_checked}, {-16842913, -R.attr.state_checked}}, new Drawable[]{mySelfDrawable, otherTeacherDrawable, otherDrawable}).multiBuild();
    }

    private Drawable getMultiImgStateDrawable() {
        int dp_16 = UtilsKt.getDp((int)16);
        Drawable mySelfDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)).cornerRadii(dp_16, 0, dp_16, dp_16).build();
        Drawable otherTeacherDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadii(0, dp_16, dp_16, dp_16).build();
        Drawable otherDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadii(0, dp_16, dp_16, dp_16).build();
        return new StateListDrawableBuilder().multiState((int[][])new int[][]{{0x10100A1, R.attr.bjlive_state_checked_img}, {-16842913, R.attr.bjlive_state_checked_img}, {-16842913, -R.attr.bjlive_state_checked_img}}, new Drawable[]{mySelfDrawable, otherTeacherDrawable, otherDrawable}).multiBuild();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.chatPresenter.destroy();
        this.callback = null;
        this.context = null;
    }

    private boolean isChatRVAtBottom() {
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)this.chatRv.getLayoutManager();
        int lastVisibleItemPosition = linearLayoutManager.findLastVisibleItemPosition();
        int visibleItemCount = linearLayoutManager.getChildCount();
        int totalItemCount = linearLayoutManager.getItemCount();
        int state = this.chatRv.getScrollState();
        return visibleItemCount == 0 || visibleItemCount > 0 && lastVisibleItemPosition == totalItemCount - 2 && state == 0;
    }

    public void setOnChatFilterListener(OnChatFilterListener listener) {
        this.chatPresenter.setOnChatFilterListener(listener);
    }

    public void showMenu(int x, int y, View parentView, IMessageModel messageModel, boolean isImage) {
        PopupWindow popupWindow = new PopupWindow(this.context);
        popupWindow.setFocusable(true);
        popupWindow.setWidth(UtilsKt.getDp((int)64));
        popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        popupWindow.setHeight(-2);
        ArrayList<String> items = new ArrayList<String>();
        int recallStatus = this.chatPresenter.getRecallStatus(messageModel);
        if (recallStatus == 1) {
            items.add(this.getString(R.string.bjy_base_chat_revoke));
        }
        if (recallStatus == 2) {
            items.add(this.getString(R.string.bjy_base_chat_delete));
        }
        items.add(this.getString(R.string.bjy_base_chat_copy));
        if (messageModel.getFrom() != null && this.routerListener.getLiveRoom() != null && this.routerListener.getLiveRoom().getCurrentUser() != null && !messageModel.getFrom().getNumber().equals(this.routerListener.getLiveRoom().getCurrentUser().getNumber())) {
            items.add(this.getString(R.string.bjy_base_chat_report));
        }
        ArrayAdapter adapter = new ArrayAdapter(this.context, R.layout.bjy_group_menu_chat_message, (Object[])items.toArray(new String[0]));
        GradientDrawable bgDrawable = new GradientDrawable();
        bgDrawable.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color));
        bgDrawable.setCornerRadius((float)UtilsKt.getDp((int)4));
        ListView listView = new ListView(this.context);
        listView.setBackground((Drawable)bgDrawable);
        listView.setAdapter((ListAdapter)adapter);
        listView.setDividerHeight(0);
        listView.setPadding(0, UtilsKt.getDp((int)2), 0, UtilsKt.getDp((int)2));
        listView.setOnItemClickListener((parent, view, position, id2) -> {
            String item = (String)items.get(position);
            if (this.getString(R.string.bjy_base_chat_copy).equals(item)) {
                if (isImage) {
                    this.copy("[img:" + messageModel.getUrl() + "]");
                } else {
                    this.copy(messageModel.getContent());
                }
            } else if (this.getString(R.string.bjy_base_chat_revoke).equals(item)) {
                this.chatPresenter.reCallMessage(messageModel);
            } else if (this.getString(R.string.bjy_base_chat_report).equals(item)) {
                this.iRouter.getSubjectByKey(EventKey.ReportDialog).onNext((Object)messageModel);
            }
            popupWindow.dismiss();
        });
        popupWindow.setContentView((View)listView);
        popupWindow.showAtLocation(parentView, 0, x - popupWindow.getWidth() / 2, y - popupWindow.getHeight());
    }

    private void copy(String copyStr) {
        try {
            ClipboardManager cm = (ClipboardManager)this.context.getSystemService("clipboard");
            ClipData mClipData = ClipData.newPlainText((CharSequence)"Label", (CharSequence)copyStr);
            cm.setPrimaryClip(mClipData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class PressListener
    extends GestureDetector.SimpleOnGestureListener {
        private IMessageModel iMessageModel;
        private View parent;

        public PressListener(IMessageModel iMessageModel, RecyclerView.ViewHolder holder) {
            this.iMessageModel = iMessageModel;
            this.parent = holder.itemView;
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
            ChatWindow.this.showMenu((int)e.getRawX(), (int)e.getRawY(), this.parent, this.iMessageModel, true);
        }

        public boolean onSingleTapUp(MotionEvent e) {
            ChatWindow.this.callback.displayImage(ChatWindow.this.chatPresenter.getChatImageUrls(), ChatWindow.this.chatPresenter.getIndexOfChatImage(this.iMessageModel.getUrl()));
            return true;
        }
    }

    private class LanguageSelectMenuAdapter
    extends BaseAdapter {
        private List<String> mData;
        private int selectPosition;

        LanguageSelectMenuAdapter(List<String> list, int position) {
            this.mData = list;
            this.selectPosition = position;
        }

        public int getCount() {
            return this.mData.size();
        }

        public Object getItem(int position) {
            return this.mData.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View view = LayoutInflater.from((Context)ChatWindow.this.context).inflate(R.layout.bjysc_language_select_menu, null);
            TextView languageTv = (TextView)view.findViewById(R.id.tv_language);
            languageTv.setText((CharSequence)this.mData.get(position));
            languageTv.setTextColor(-7829368);
            if (position == this.selectPosition) {
                languageTv.setTextColor(ContextCompat.getColor((Context)ChatWindow.this.context, (int)R.color.base_theme_live_product));
                view.findViewById(R.id.ic_language_is_selected).setVisibility(0);
            }
            return view;
        }
    }

    class ChatMessageAdapter
    extends RecyclerView.Adapter<BaseViewHolder> {
        private static final int MESSAGE_TYPE_TEXT_MINE = 0;
        private static final int MESSAGE_TYPE_TEXT_OTHERS = 1;
        private static final int MESSAGE_TYPE_IMAGE_MINE = 4;
        private static final int MESSAGE_TYPE_IMAGE_OTHERS = 5;
        private static final int MESSAGE_TYPE_USER_IN_USER_OUT = 6;

        ChatMessageAdapter() {
        }

        public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
            if (viewType == 0) {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_chat_text_msg_myself, viewGroup, false);
                return new TextViewHolder(view);
            }
            if (viewType == 1) {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_chat_text_msg_others, viewGroup, false);
                return new TextViewHolder(view);
            }
            if (viewType == 4) {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_chat_img_msg_myself, viewGroup, false);
                return new ImageViewHolder(view);
            }
            if (viewType == 5) {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_chat_img_msg_others, viewGroup, false);
                return new ImageViewHolder(view);
            }
            if (viewType == 6) {
                View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.item_chat_user_in_user_out, viewGroup, false);
                return new UserInUserOutViewHolder(view);
            }
            return null;
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public void onBindViewHolder(@NonNull BaseViewHolder baseViewHolder, int position) {
            boolean showGroupLabel;
            IMessageModel messageModel = ChatWindow.this.chatPresenter.getMessage(position);
            if (ChatWindow.this.context == null || messageModel == null) {
                return;
            }
            if (baseViewHolder instanceof UserInUserOutViewHolder) {
                UserInUserOutViewHolder userInUserOutViewHolder = (UserInUserOutViewHolder)baseViewHolder;
                userInUserOutViewHolder.nameTv.setText((CharSequence)messageModel.getContent());
                if (messageModel.getTimestamp() != null) {
                    userInUserOutViewHolder.timeTv.setVisibility(0);
                    userInUserOutViewHolder.timeTv.setText((CharSequence)ChatWindow.this.simpleDateFormat.format(messageModel.getTimestamp()));
                } else {
                    userInUserOutViewHolder.timeTv.setVisibility(8);
                }
                return;
            }
            LPGroupItem groupItem = (LPGroupItem)ChatWindow.this.iRouter.getLiveRoom().getOnlineUserVM().getGroupMap().get(messageModel.getFrom().getGroup());
            SpannableStringBuilder ssbName = new SpannableStringBuilder();
            boolean isGroupValid = messageModel.getFrom().getGroup() != 0 && groupItem != null && groupItem.groupItemModel != null;
            boolean bl = showGroupLabel = ((ChatWindow)ChatWindow.this).iRouter.getLiveRoom().getRoomInfo().newGroupLive != 1 || ChatWindow.this.iRouter.getLiveRoom().getCurrentUser().getType() != LPConstants.LPUserType.Student;
            if (isGroupValid && showGroupLabel) {
                String str = "\u300c" + groupItem.groupItemModel.name + "\u300d";
                ForegroundColorSpan colorSpan = new ForegroundColorSpan(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)ChatWindow.this.context, (int)R.attr.base_theme_window_assistant_text_color));
                if (this.isMyself(messageModel)) {
                    ssbName.append((CharSequence)str);
                    ssbName.append((CharSequence)UtilsKt.getEncodePhoneNumber((String)messageModel.getFrom().getName()));
                    ssbName.setSpan((Object)colorSpan, 0, str.length(), 18);
                } else {
                    ssbName.append((CharSequence)UtilsKt.getEncodePhoneNumber((String)messageModel.getFrom().getName()));
                    ssbName.append((CharSequence)str);
                    int start = UtilsKt.getEncodePhoneNumber((String)messageModel.getFrom().getName()).length();
                    ssbName.setSpan((Object)colorSpan, start, str.length() + start, 18);
                }
            } else {
                ssbName.append((CharSequence)UtilsKt.getEncodePhoneNumber((String)messageModel.getFrom().getName()));
            }
            baseViewHolder.chatNameTv.setText((CharSequence)ssbName);
            baseViewHolder.chatTimeTv.setText((CharSequence)ChatWindow.this.simpleDateFormat.format(messageModel.getTimestamp()));
            if (baseViewHolder instanceof TextViewHolder) {
                TextViewHolder textViewHolder = (TextViewHolder)baseViewHolder;
                textViewHolder.chatMessageView.setMessage(messageModel.getContent());
                textViewHolder.chatMessageView.setMessageModel(messageModel);
                textViewHolder.chatMessageView.setChatMessageListener((ChatMessageView.IChatMessageListener)ChatWindow.this);
                if (ChatWindow.this.enableChatTranslation && messageModel.getMessageType() != LPConstants.MessageType.EmojiWithName && messageModel.getMessageType() != LPConstants.MessageType.Emoji) {
                    textViewHolder.chatTranslateBtn.setVisibility(0);
                } else {
                    textViewHolder.chatTranslateBtn.setVisibility(8);
                }
                SpannableStringBuilder ssb = new SpannableStringBuilder();
                String contentMessage = messageModel.getContent();
                if (contentMessage.contains("-@translate@-")) {
                    contentMessage = contentMessage.split("-@translate@-")[0];
                }
                ssb.append((CharSequence)this.replaceWithEmoji(contentMessage, textViewHolder.chatMessageView.getTextView(), textViewHolder));
                ssb.setSpan((Object)textViewHolder.chatMessageView.getLineHeightSpan(), 0, ssb.length() - 1, 34);
                textViewHolder.chatMessageView.getTextView().setText((CharSequence)ssb);
                textViewHolder.chatMessageView.removeReference();
                if (messageModel.getReference() != null) {
                    textViewHolder.chatMessageView.addReferenceMessage();
                    String referenceMessage = messageModel.getReference().content;
                    SpannableStringBuilder referenceMessageSsb = new SpannableStringBuilder();
                    referenceMessageSsb.append((CharSequence)this.replaceWithEmoji(referenceMessage, textViewHolder.chatMessageView.getTvReference(), textViewHolder));
                    referenceMessageSsb.setSpan((Object)textViewHolder.chatMessageView.getLineHeightSpan(), 0, referenceMessage.length() - 1, 34);
                    textViewHolder.chatMessageView.getTvReference().setText((CharSequence)referenceMessageSsb);
                }
                textViewHolder.chatTranslateBtn.setOnClickListener(v -> {
                    String toLanguage;
                    String string2 = toLanguage = TextUtils.isEmpty((CharSequence)ChatWindow.this.languageTranslateTo) ? "en" : ChatWindow.this.languageTranslateTo;
                    if (TextUtils.equals((CharSequence)toLanguage, (CharSequence)((LPMessageModel)messageModel).translateLanguage) && textViewHolder.chatMessageView.isTranslate()) {
                        textViewHolder.chatMessageView.removeTranslate();
                    } else {
                        textViewHolder.chatMessageView.translateMessage();
                        String message = this.getTranslateText(messageModel.getContent());
                        String fromLanguage = "auto";
                        ((LPMessageModel)messageModel).translateLanguage = toLanguage;
                        ChatWindow.this.chatPresenter.sendTranslateMessage(message, messageModel.getFrom().getUserId() + messageModel.getTimestamp().getTime(), String.valueOf(((ChatWindow)ChatWindow.this).iRouter.getLiveRoom().getRoomInfo().roomId), ChatWindow.this.iRouter.getLiveRoom().getCurrentUser().getUserId(), fromLanguage, toLanguage);
                    }
                });
                if (messageModel.getFrom().getType() == LPConstants.LPUserType.Teacher || messageModel.getFrom().getType() == LPConstants.LPUserType.Assistant) {
                    Linkify.addLinks((TextView)textViewHolder.chatMessageView.getTextView(), (int)3);
                } else {
                    textViewHolder.chatMessageView.getTextView().setAutoLinkMask(0);
                }
                if (this.isMyself(messageModel)) {
                    textViewHolder.chatMessageView.setMessageColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)ChatWindow.this.context, (int)R.attr.base_theme_dialog_positive_text_color));
                    textViewHolder.chatMessageView.setDividerLineColor(ContextCompat.getColor((Context)ChatWindow.this.context, (int)R.color.bjysc_divider_line_white));
                    textViewHolder.chatMessageView.setLinkTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)ChatWindow.this.context, (int)R.attr.base_theme_dialog_positive_text_color));
                } else {
                    textViewHolder.chatMessageView.setMessageColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)ChatWindow.this.context, (int)R.attr.base_theme_dialog_negative_text_color));
                    textViewHolder.chatMessageView.setDividerLineColor(ContextCompat.getColor((Context)ChatWindow.this.context, (int)R.color.bjysc_divider_line_black));
                    textViewHolder.chatMessageView.setLinkTextColor(ContextCompat.getColor((Context)ChatWindow.this.context, (int)R.color.bjlive_link_text));
                }
                if (ChatWindow.this.isHideBubbleBg) {
                    textViewHolder.chatMessageView.setBackgroundResource(0);
                } else {
                    this.setMultiState(textViewHolder.chatMessageView, messageModel);
                }
            } else if (baseViewHolder instanceof ImageViewHolder) {
                ImageViewHolder imageViewHolder = (ImageViewHolder)baseViewHolder;
                if (ChatWindow.this.isHideBubbleBg) {
                    imageViewHolder.chatImageView.setBackgroundResource(0);
                } else {
                    this.setMultiCheckedState(imageViewHolder.chatImageView, messageModel);
                }
                if (messageModel instanceof UploadingImageModel) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile((String)messageModel.getUrl(), (BitmapFactory.Options)options);
                    int[] size = new int[]{options.outWidth, options.outHeight};
                    ChatImageUtil.calculateImageSize((int[])size, (int)UtilsKt.getDp((int)100), (int)UtilsKt.getDp((int)50));
                    Glide.with((Context)ChatWindow.this.context).load(messageModel.getUrl()).apply(new RequestOptions().override(size[0], size[1]).transform((Transformation)new RoundedCorners(UtilsKt.getDp((int)10)))).into((ImageView)imageViewHolder.chatImageView);
                    if (((UploadingImageModel)messageModel).getStatus() == 0) {
                        imageViewHolder.exclamationTv.setVisibility(8);
                    } else if (((UploadingImageModel)messageModel).getStatus() == 1) {
                        imageViewHolder.exclamationTv.setVisibility(0);
                        imageViewHolder.chatImageView.setOnClickListener(v -> ChatWindow.this.chatPresenter.reUploadImage());
                    }
                } else {
                    RequestOptions requestOptions = new RequestOptions().transform((Transformation)new RoundedCorners(UtilsKt.getDp((int)10)));
                    if (messageModel.getUrl().endsWith(".gif")) {
                        Glide.with((Context)ChatWindow.this.context).asGif().apply(requestOptions.diskCacheStrategy(DiskCacheStrategy.RESOURCE)).load(messageModel.getUrl()).into((Target)new GifCropTarget((ImageView)imageViewHolder.chatImageView, 180, 135));
                    } else {
                        Glide.with((Context)ChatWindow.this.context).asBitmap().apply(requestOptions).load(AliCloudImageUtil.getScaledUrl((String)messageModel.getUrl(), (String)"m_mfit", (int)300, (int)300)).into((Target)new BitmapCropTarget((ImageView)imageViewHolder.chatImageView, 180, 135));
                    }
                    GestureDetectorCompat gestureDetectorCompat = new GestureDetectorCompat(ChatWindow.this.context, (GestureDetector.OnGestureListener)new PressListener(messageModel, imageViewHolder));
                    imageViewHolder.chatImageView.setOnTouchListener((v, event) -> {
                        gestureDetectorCompat.onTouchEvent(event);
                        return true;
                    });
                }
            }
        }

        public void onViewRecycled(@NonNull BaseViewHolder holder) {
            super.onViewRecycled((RecyclerView.ViewHolder)holder);
            if (holder instanceof TextViewHolder) {
                ((TextViewHolder)holder).clearGifCache();
            }
        }

        public int getItemViewType(int position) {
            IMessageModel messageModel = ChatWindow.this.chatPresenter.getMessage(position);
            boolean isMineMessage = false;
            if (messageModel.getFrom() != null) {
                isMineMessage = messageModel.getFrom().getNumber().equals(ChatWindow.this.chatPresenter.getCurrentUser().getNumber());
            }
            if (ChatWindow.MESSAGE_USER_IN.equals(messageModel.getId()) || ChatWindow.MESSAGE_USER_OUT.equals(messageModel.getId())) {
                return 6;
            }
            switch (messageModel.getMessageType()) {
                case Text: 
                case Emoji: 
                case EmojiWithName: {
                    return isMineMessage ? 0 : 1;
                }
                case Image: {
                    return isMineMessage ? 4 : 5;
                }
            }
            return 0;
        }

        public int getItemCount() {
            return ChatWindow.this.chatPresenter.getMessageCount();
        }

        private void setMultiState(ChatMessageView view, IMessageModel messageModel) {
            if (messageModel.getFrom().getType() == LPConstants.LPUserType.Teacher) {
                view.setSelected(messageModel.getFrom().getNumber().equals(ChatWindow.this.chatPresenter.getCurrentUser().getNumber()));
                view.setStateChecked(true);
            } else if (messageModel.getFrom().getNumber().equals(ChatWindow.this.chatPresenter.getCurrentUser().getNumber())) {
                view.setSelected(true);
                view.setStateChecked(true);
            } else {
                view.setSelected(false);
                view.setStateChecked(false);
            }
        }

        private void setMultiCheckedState(CheckImageView view, IMessageModel messageModel) {
            if (messageModel.getFrom().getType() == LPConstants.LPUserType.Teacher) {
                view.setSelected(messageModel.getFrom().getNumber().equals(ChatWindow.this.chatPresenter.getCurrentUser().getNumber()));
                view.setStateChecked(true);
            } else if (messageModel.getFrom().getNumber().equals(ChatWindow.this.chatPresenter.getCurrentUser().getNumber())) {
                view.setSelected(true);
                view.setStateChecked(true);
            } else {
                view.setSelected(false);
                view.setStateChecked(false);
            }
        }

        private boolean isMyself(IMessageModel messageModel) {
            return messageModel.getFrom().getNumber().equals(ChatWindow.this.chatPresenter.getCurrentUser().getNumber());
        }

        private SpannableStringBuilder replaceWithEmoji(String content, TextView textView, TextViewHolder textViewHolder) {
            Matcher matcher = ChatWindow.this.pattern.matcher(content);
            SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)content);
            ArrayList<URLImageParser.GlideGifDrawable> cacheDrawables = null;
            ArrayList<URLImageParser> imageParserList = null;
            while (matcher.find()) {
                String group = matcher.group();
                if (!ChatWindow.this.chatPresenter.getExpressions().containsKey(group)) continue;
                URLImageParser urlImageParser = new URLImageParser(textView, textView.getTextSize());
                Drawable drawable2 = urlImageParser.getDrawable(ChatWindow.this.chatPresenter.getExpressions().get(group));
                CenterImageSpan centerImageSpan = new CenterImageSpan(drawable2, 1);
                ssb.setSpan((Object)centerImageSpan, matcher.start(), matcher.end(), 34);
                ssb.removeSpan((Object)group);
                if (!(drawable2 instanceof URLImageParser.GlideGifDrawable)) continue;
                if (cacheDrawables == null) {
                    cacheDrawables = new ArrayList<URLImageParser.GlideGifDrawable>();
                }
                cacheDrawables.add((URLImageParser.GlideGifDrawable)drawable2);
                if (imageParserList == null) {
                    imageParserList = new ArrayList<URLImageParser>();
                }
                imageParserList.add(urlImageParser);
            }
            if (cacheDrawables != null) {
                textViewHolder.setGifCache(cacheDrawables, imageParserList);
            }
            return ssb;
        }

        private String getTranslateText(String content) {
            content = content.split("-@translate@-")[0];
            Matcher m = ChatWindow.this.pattern.matcher(content);
            while (m.find()) {
                String group = m.group();
                if (!ChatWindow.this.chatPresenter.getExpressions().containsKey(group)) continue;
                content = content.replace(group, "");
            }
            return content;
        }

        class UserInUserOutViewHolder
        extends BaseViewHolder {
            TextView nameTv;
            TextView timeTv;

            UserInUserOutViewHolder(View itemView) {
                super(itemView);
                this.nameTv = (TextView)itemView.findViewById(R.id.tv_user_name);
                this.timeTv = (TextView)itemView.findViewById(R.id.user_in_time);
            }
        }

        class ImageViewHolder
        extends BaseViewHolder {
            CheckImageView chatImageView;
            TextView exclamationTv;

            ImageViewHolder(View itemView) {
                super(itemView);
                this.chatImageView = (CheckImageView)itemView.findViewById(R.id.img_msg_iv);
                this.exclamationTv = (TextView)itemView.findViewById(R.id.item_chat_image_exclamation);
                this.chatImageView.setBackground(ChatWindow.this.getMultiImgStateDrawable());
            }
        }

        class TextViewHolder
        extends BaseViewHolder {
            ChatMessageView chatMessageView;
            ImageView chatTranslateBtn;
            private List<URLImageParser.GlideGifDrawable> gifDrawables;
            private List<URLImageParser> imageParserList;

            TextViewHolder(View itemView) {
                super(itemView);
                this.chatMessageView = (ChatMessageView)itemView.findViewById(R.id.chat_message_view);
                this.chatMessageView.setBackground(ChatWindow.this.getMultiTextStateDrawable());
                this.chatTranslateBtn = (ImageView)itemView.findViewById(R.id.translate_btn);
                this.chatMessageView.enableTranslation(false);
            }

            public void setGifCache(List<URLImageParser.GlideGifDrawable> drawables, List<URLImageParser> imageParserList) {
                this.gifDrawables = drawables;
                this.imageParserList = imageParserList;
            }

            public void clearGifCache() {
                if (this.gifDrawables != null) {
                    for (URLImageParser.GlideGifDrawable drawable2 : this.gifDrawables) {
                        drawable2.onDestroy();
                    }
                }
                if (this.imageParserList != null) {
                    for (URLImageParser urlImageParser : this.imageParserList) {
                        urlImageParser.onDestroy();
                    }
                }
            }
        }

        class BaseViewHolder
        extends RecyclerView.ViewHolder {
            TextView chatTimeTv;
            TextView chatNameTv;

            BaseViewHolder(View itemView) {
                super(itemView);
                this.chatTimeTv = (TextView)itemView.findViewById(R.id.chat_time_tv);
                this.chatNameTv = (TextView)itemView.findViewById(R.id.chat_user_tv);
            }
        }
    }
}

