/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbar;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import com.baijiayun.bjyutils.widgets.SimpleTextWatcher;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.window.toolbar.ToolbarBaseWindow;
import java.util.HashMap;

public class TextEditWindow
extends ToolbarBaseWindow {
    private EditText editText;
    private String beforeText;
    private TextWatcher textWatcher;

    public TextEditWindow(Context context) {
        super(context);
        this.init();
    }

    @Override
    protected View onCreateView(Context context) {
        this.view = LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_window_text_edit, null);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        layoutParams.gravity = 80;
        this.view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return this.view;
    }

    private void init() {
        this.editText = (EditText)this.$.id(R.id.window_message_send_et).view();
        this.view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                TextEditWindow.this.$.id(R.id.window_message_send_et).view().setFocusable(true);
                TextEditWindow.this.$.id(R.id.window_message_send_et).view().setFocusableInTouchMode(true);
                TextEditWindow.this.$.id(R.id.window_message_send_et).view().requestFocus();
                v.postDelayed(() -> {
                    InputMethodManager imm = (InputMethodManager)TextEditWindow.this.context.getSystemService("input_method");
                    if (imm == null) {
                        return;
                    }
                    imm.showSoftInput(TextEditWindow.this.$.id(R.id.window_message_send_et).view(), 0);
                }, 100L);
            }

            public void onViewDetachedFromWindow(View v) {
                if (TextEditWindow.this.context == null) {
                    return;
                }
                InputMethodManager imm = (InputMethodManager)TextEditWindow.this.context.getSystemService("input_method");
                if (imm == null) {
                    return;
                }
                if (imm.isActive()) {
                    imm.hideSoftInputFromWindow(TextEditWindow.this.$.id(R.id.window_message_send_et).view().getWindowToken(), 0);
                }
            }
        });
        this.textWatcher = new SimpleTextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                TextEditWindow.this.beforeText = s.toString();
            }

            public void afterTextChanged(Editable s) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("beforeText", TextEditWindow.this.beforeText);
                map.put("afterText", TextEditWindow.this.editText.getEditableText().toString());
                TextEditWindow.this.iRouter.getSubjectByKey(EventKey.DrawTextSend).onNext(map);
            }
        };
        this.editText.addTextChangedListener(this.textWatcher);
        this.$.id(R.id.window_message_send_btn).clicked(v -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("beforeText", this.beforeText);
            map.put("afterText", this.editText.getEditableText().toString());
            map.put("end", "true");
            this.iRouter.getSubjectByKey(EventKey.DrawTextSend).onNext(map);
            this.setEditText("");
            InputMethodManager imm = (InputMethodManager)this.context.getSystemService("input_method");
            if (imm == null) {
                return;
            }
            if (imm.isActive()) {
                imm.hideSoftInputFromWindow(this.$.id(R.id.window_message_send_et).view().getWindowToken(), 0);
            }
        });
    }

    public void setEditText(String text) {
        this.editText.removeTextChangedListener(this.textWatcher);
        this.editText.setText((CharSequence)text);
        this.editText.setSelection(this.editText.getText().length());
        this.editText.addTextChangedListener(this.textWatcher);
    }
}

