/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.group;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.viewpager.widget.ViewPager;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.widgets.SimpleTextWatcher;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.base.BaseRecyclerAdapter;
import com.baijiayun.groupclassui.base.BaseViewHolder;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.widget.CircleIndicator;
import com.baijiayun.groupclassui.window.group.GroupManagePagerAdapter;
import com.baijiayun.groupclassui.window.group.GroupedBean;
import com.baijiayun.livebase.models.imodels.IUserModel;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroupedUserAdapter
extends BaseRecyclerAdapter<GroupedBean> {
    private String[] colors = new String[]{"#F44336", "#E91E63", "#D500F9", "#3D5AFE", "#775FCF", "#03A9F4", "#00BCD4", "#51B155", "#8BC34A", "#50E3C2", "#FFEB3B", "#FFC107", "#FF9800", "#795548", "#A47564"};
    private SparseArray<String> groupColorSparseArray;
    private SparseArray<String> groupNameSparseArray;
    private OnEventListener onEventListener;
    private IRouter iRouter;
    private List<IUserModel> ungroupSelectedUsers;
    private List<IUserModel> groupedSelectedUsers;
    private List<GroupManagePagerAdapter> pagerAdapters;
    private Disposable disposable;
    private int maxLen = 24;
    private InputFilter lengthFilter = (source, start, end, dest, dstart, dend) -> {
        int dindex = 0;
        int count = 0;
        while (count <= this.maxLen && dindex < dest.length()) {
            char c;
            if ((c = dest.charAt(dindex++)) < '\u0080') {
                ++count;
                continue;
            }
            count += 2;
        }
        if (count > this.maxLen) {
            return dest.subSequence(0, dindex - 1);
        }
        int sindex = 0;
        while (count <= this.maxLen && sindex < source.length()) {
            char c;
            if ((c = source.charAt(sindex++)) < '\u0080') {
                ++count;
                continue;
            }
            count += 2;
        }
        if (count > this.maxLen) {
            --sindex;
        }
        return source.subSequence(0, sindex);
    };
    private InputFilter charFilter = (source, start, end, dest, dstart, dend) -> {
        String specialChar = "[`~!@#$%^&*()+=|{}':;',\\\\[\\\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern pattern = Pattern.compile(specialChar);
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return "";
        }
        return source;
    };

    GroupedUserAdapter(Context context, IRouter iRouter) {
        super(context, R.layout.item_group_manage_window_grouped);
        this.iRouter = iRouter;
        this.pagerAdapters = new ArrayList<GroupManagePagerAdapter>();
        this.groupColorSparseArray = new SparseArray();
        this.groupNameSparseArray = new SparseArray();
        this.disposable = iRouter.getSubjectByKey(EventKey.UngroupSelectedList).ofType(List.class).subscribe(list -> {
            this.ungroupSelectedUsers = list;
        });
    }

    @Override
    protected void convert(BaseViewHolder holder, GroupedBean groupedBean) {
        this.setBgBorderColor(holder);
        this.setInputFilter(holder);
        GroupManagePagerAdapter groupManagePagerAdapter = this.createViewPagerAndAdapter(holder, groupedBean);
        this.listenButton(holder, groupManagePagerAdapter);
        this.pagerAdapters.add(groupManagePagerAdapter);
    }

    @Override
    public void removeData(int position) {
        super.removeData(position);
        this.pagerAdapters.remove(position);
    }

    private void setBgBorderColor(BaseViewHolder holder) {
        ConstraintLayout clBorder = (ConstraintLayout)holder.getView(R.id.group_manage_window_item_cl_border);
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setCornerRadius((float)UtilsKt.getDp((int)4));
        drawable2.setColor(0);
        int position = holder.getAdapterPosition();
        if (this.groupColorSparseArray.get(position) == null) {
            this.groupColorSparseArray.put(position, (Object)this.generateRandomColor());
        }
        drawable2.setStroke(UtilsKt.getDp((int)2), Color.parseColor((String)((String)this.groupColorSparseArray.get(position))));
        clBorder.setBackgroundDrawable((Drawable)drawable2);
    }

    private void setInputFilter(BaseViewHolder holder) {
        final int position = holder.getAdapterPosition();
        EditText editText = (EditText)holder.getView(R.id.group_manage_window_item_et);
        editText.setFilters(new InputFilter[]{this.charFilter, this.lengthFilter});
        editText.addTextChangedListener((TextWatcher)new SimpleTextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                GroupedUserAdapter.this.groupNameSparseArray.put(position, (Object)s.toString());
            }
        });
        if (this.groupNameSparseArray.get(position) != null) {
            editText.setText((CharSequence)this.groupNameSparseArray.get(position));
        }
    }

    @NonNull
    private GroupManagePagerAdapter createViewPagerAndAdapter(BaseViewHolder holder, GroupedBean groupedBean) {
        ViewPager viewPager = (ViewPager)holder.getView(R.id.group_manage_window_item_vp);
        GroupManagePagerAdapter groupManagePagerAdapter = new GroupManagePagerAdapter(this.mContext, groupedBean.getGroupUsers());
        groupManagePagerAdapter.setOnSelectedListener(selectUsers -> {
            this.groupedSelectedUsers = selectUsers;
            holder.setText(R.id.group_manage_window_item_btn, selectUsers.size() > 0 ? R.string.bjysc_group_manage_disjoint : R.string.bjysc_group_manage_join_group);
        });
        groupManagePagerAdapter.bindToViewPager(viewPager);
        viewPager.setOffscreenPageLimit(2);
        CircleIndicator indicator = (CircleIndicator)((Object)holder.getView(R.id.group_manage_window_item_indicator));
        indicator.setViewPager(viewPager);
        return groupManagePagerAdapter;
    }

    private void listenButton(BaseViewHolder holder, GroupManagePagerAdapter groupManagePagerAdapter) {
        holder.getView(R.id.group_manage_window_item_iv_close).setOnClickListener(v -> {
            this.groupColorSparseArray.removeAt(holder.getAdapterPosition());
            if (this.onEventListener != null) {
                this.onEventListener.closeGroup(holder.getAdapterPosition(), groupManagePagerAdapter.getGroupUsers());
            }
        });
        holder.click(R.id.group_manage_window_item_btn, v -> {
            if (holder.getText(R.id.group_manage_window_item_btn).equals(this.mContext.getString(R.string.bjysc_group_manage_join_group))) {
                if (this.ungroupSelectedUsers != null && this.ungroupSelectedUsers.size() > 0) {
                    groupManagePagerAdapter.addData(this.ungroupSelectedUsers);
                    this.iRouter.getSubjectByKey(EventKey.JoiningGroupList).onNext(this.ungroupSelectedUsers);
                }
            } else if (this.groupedSelectedUsers != null) {
                if (this.onEventListener != null) {
                    this.onEventListener.onUserExitGroup(this.groupedSelectedUsers);
                }
                groupManagePagerAdapter.removeData(this.groupedSelectedUsers);
                holder.setText(R.id.group_manage_window_item_btn, R.string.bjysc_group_manage_join_group);
            }
        });
    }

    @Override
    protected boolean isEnableListener() {
        return false;
    }

    public void updateViewPager(int position, IUserModel groupUser) {
        this.pagerAdapters.get(position).addData(groupUser);
    }

    private String generateRandomColor() {
        if (this.getItemCount() == 15) {
            return this.colors[0];
        }
        Random random = new Random();
        int index = random.nextInt(this.colors.length);
        if (this.groupColorSparseArray.indexOfValue((Object)this.colors[index]) == -1) {
            return this.colors[index];
        }
        return this.generateRandomColor();
    }

    public String getBgColor(int position) {
        return (String)this.groupColorSparseArray.get(position);
    }

    public String getGroupName(int position) {
        return this.groupNameSparseArray.get(position) != null ? (String)this.groupNameSparseArray.get(position) : "";
    }

    public void setOnEventListener(OnEventListener onEventListener) {
        this.onEventListener = onEventListener;
    }

    public void destroy() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
        this.iRouter = null;
        if (this.groupColorSparseArray != null) {
            this.groupColorSparseArray.clear();
        }
        if (this.ungroupSelectedUsers != null) {
            this.ungroupSelectedUsers.clear();
        }
        if (this.groupedSelectedUsers != null) {
            this.groupedSelectedUsers.clear();
        }
        if (this.pagerAdapters != null) {
            this.pagerAdapters.clear();
        }
    }

    static interface OnEventListener {
        public void closeGroup(int var1, List<IUserModel> var2);

        public void onUserExitGroup(List<IUserModel> var1);
    }
}

