/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.user;

import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.global.RouterListener;
import com.baijiayun.groupclassui.user.ActiveGroupExpandAdapter;
import com.baijiayun.groupclassui.user.BlockListRecyclerViewAdapter;
import com.baijiayun.groupclassui.user.IUserContract;
import com.baijiayun.groupclassui.user.IUserInteractionListener;
import com.baijiayun.groupclassui.user.OnlineUserPresenter;
import com.baijiayun.groupclassui.user.UnActiveGroupExpandAdapter;
import com.baijiayun.groupclassui.util.LinearLayoutWrapManager;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livecore.models.LPGroupItem;

public class AllOnlineUserListFragment
extends Fragment
implements IUserContract,
IUserInteractionListener {
    private OnlineUserPresenter onlineUserPresenter;
    private RecyclerView mRlvInteractiveClassBlacklist;
    private ExpandableListView activeListView;
    private ExpandableListView unActiveListView;
    private TextView activeUserTextView;
    private TextView unActiveUserTextView;
    private TextView mTvInteractiveOnlineTitsle;
    private LinearLayout activeUserLayout;
    private LinearLayout unActiveUserLayout;
    private RelativeLayout mRlClassBlacklist;
    private View mIvInteractiveClassUpIcon;
    private View mIvInteractiveClassDownIcon;
    private View mIvInteractiveClassBlacklistIcon;
    private View mIvFreeBlockAll;
    private RelativeLayout mRlInteractiveClassBlacklist;
    private LinearLayout activeUserContainer;
    private LinearLayout unActiveUserContainer;
    private View viewActiveDiv;
    private View viewUnActiveDiv;
    private View viewKickoutDiv;
    private BlockListRecyclerViewAdapter blockListRecyclerViewAdapter;
    private ActiveGroupExpandAdapter activeGroupExpandAdapter;
    private UnActiveGroupExpandAdapter unActiveGroupExpandAdapter;
    private IRouter iRouter;
    private int expandType = 0;
    public static final int EXPAND_ACTIVE = 0;
    public static final int EXPAND_UNACTIVE = 1;
    public static final int EXPAND_KICKOUT = 2;

    public static AllOnlineUserListFragment newInstance() {
        return new AllOnlineUserListFragment();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof RouterListener) {
            this.iRouter = ((RouterListener)context).getRouter();
        }
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container2, Bundle savedInstanceState) {
        View localView = inflater.inflate(R.layout.bjysc_fragment_online_list, container2, false);
        Context context = localView.getContext();
        this.setPresenter(new OnlineUserPresenter(this));
        this.blockListRecyclerViewAdapter = new BlockListRecyclerViewAdapter(this.onlineUserPresenter, this);
        this.activeGroupExpandAdapter = new ActiveGroupExpandAdapter(this.onlineUserPresenter, this);
        this.unActiveGroupExpandAdapter = new UnActiveGroupExpandAdapter(this.onlineUserPresenter, this);
        this.mIvInteractiveClassUpIcon = localView.findViewById(R.id.bjysc_ic_expand_online_up);
        this.mIvInteractiveClassDownIcon = localView.findViewById(R.id.bjysc_ic_expand_online_down);
        this.mIvInteractiveClassBlacklistIcon = localView.findViewById(R.id.bjysc_ic_expand_online_kickout);
        this.activeUserTextView = (TextView)localView.findViewById(R.id.bjysc_online_up_text);
        this.unActiveUserTextView = (TextView)localView.findViewById(R.id.bjysc_online_down_text);
        this.activeListView = (ExpandableListView)localView.findViewById(R.id.active_listview);
        this.activeUserContainer = (LinearLayout)localView.findViewById(R.id.bjysc_user_container_online_up);
        this.unActiveUserContainer = (LinearLayout)localView.findViewById(R.id.bjysc_user_container_online_down);
        this.viewActiveDiv = localView.findViewById(R.id.view_space_active);
        this.viewUnActiveDiv = localView.findViewById(R.id.view_space_unactive);
        this.viewKickoutDiv = localView.findViewById(R.id.view_space_kick_out);
        this.mIvFreeBlockAll = localView.findViewById(R.id.bjysc_iv_remove_block_list);
        this.activeListView.setAdapter((ExpandableListAdapter)this.activeGroupExpandAdapter);
        this.activeUserLayout = (LinearLayout)localView.findViewById(R.id.bjysc_active_user_button);
        this.unActiveUserLayout = (LinearLayout)localView.findViewById(R.id.bjysc_un_active_user_button);
        this.unActiveListView = (ExpandableListView)localView.findViewById(R.id.unactive_listview);
        this.unActiveListView.setAdapter((ExpandableListAdapter)this.unActiveGroupExpandAdapter);
        this.unActiveUserContainer.findViewById(R.id.tv_user_camera).setVisibility(8);
        this.unActiveUserContainer.findViewById(R.id.tv_user_mic).setVisibility(8);
        this.showStudyRoomItems();
        this.activeListView.setOnGroupExpandListener(groupPosition -> {
            Object group = this.activeGroupExpandAdapter.getGroup(groupPosition);
            if (group == null) {
                return;
            }
            LPGroupItem lpGroupItem = (LPGroupItem)group;
            if (lpGroupItem.id == 0) {
                return;
            }
            for (int i = 0; i < this.activeGroupExpandAdapter.getGroupCount(); ++i) {
                LPGroupItem item = (LPGroupItem)this.activeGroupExpandAdapter.getGroup(i);
                if (i == groupPosition || item == null || item.id == 0) continue;
                this.activeListView.collapseGroup(i);
            }
            this.onlineUserPresenter.updateGroupInfo(lpGroupItem.id);
        });
        this.unActiveListView.setOnGroupExpandListener(groupPosition -> {
            Object group = this.unActiveGroupExpandAdapter.getGroup(groupPosition);
            if (group == null) {
                return;
            }
            LPGroupItem lpGroupItem = (LPGroupItem)group;
            if (lpGroupItem.id == 0) {
                return;
            }
            for (int i = 0; i < this.unActiveGroupExpandAdapter.getGroupCount(); ++i) {
                LPGroupItem item = (LPGroupItem)this.unActiveGroupExpandAdapter.getGroup(i);
                if (i == groupPosition || item == null || item.id == 0) continue;
                this.unActiveListView.collapseGroup(i);
            }
            this.onlineUserPresenter.updateGroupInfo(lpGroupItem.id);
        });
        this.activeListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0 && view.getLastVisiblePosition() == AllOnlineUserListFragment.this.activeListView.getCount() - 1 && AllOnlineUserListFragment.this.activeListView.getCount() > 10) {
                    AllOnlineUserListFragment.this.onlineUserPresenter.loadMore();
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.unActiveListView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (scrollState == 0 && view.getLastVisiblePosition() == AllOnlineUserListFragment.this.unActiveListView.getCount() - 1 && AllOnlineUserListFragment.this.unActiveListView.getCount() > 10) {
                    AllOnlineUserListFragment.this.onlineUserPresenter.loadMore();
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        this.mIvFreeBlockAll.setOnClickListener(v -> this.showConfirmFreeAll());
        this.mRlClassBlacklist = (RelativeLayout)localView.findViewById(R.id.ll_interactive_class_blacklist);
        this.mTvInteractiveOnlineTitsle = (TextView)localView.findViewById(R.id.tv_interactive_online_title);
        this.mRlvInteractiveClassBlacklist = (RecyclerView)localView.findViewById(R.id.rlv_interactive_class_blacklist);
        this.mRlInteractiveClassBlacklist = (RelativeLayout)localView.findViewById(R.id.rl_interactive_class_blacklist);
        this.mRlvInteractiveClassBlacklist.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutWrapManager(context));
        this.mRlvInteractiveClassBlacklist.setAdapter((RecyclerView.Adapter)this.blockListRecyclerViewAdapter);
        if (!this.onlineUserPresenter.isAdmin()) {
            this.mRlClassBlacklist.setVisibility(8);
        }
        this.activeUserLayout.setOnClickListener(view -> this.expandLayout(0));
        this.unActiveUserLayout.setOnClickListener(view -> this.expandLayout(1));
        this.mRlClassBlacklist.setOnClickListener(view -> this.expandLayout(2));
        this.expandLayout(0);
        this.notifyDataChange();
        return localView;
    }

    private void showStudyRoomItems() {
        if (this.activeUserContainer == null) {
            return;
        }
        int visibility = this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout() ? 8 : 0;
        this.activeUserContainer.findViewById(R.id.tv_user_ppt_auth).setVisibility(visibility);
        this.activeUserContainer.findViewById(R.id.tv_user_ppt_paint).setVisibility(visibility);
        this.activeUserContainer.findViewById(R.id.tv_user_screen_share).setVisibility(visibility);
        this.unActiveUserContainer.findViewById(R.id.tv_user_ppt_auth).setVisibility(visibility);
        this.unActiveUserContainer.findViewById(R.id.tv_user_ppt_paint).setVisibility(visibility);
        this.unActiveUserContainer.findViewById(R.id.tv_user_screen_share).setVisibility(visibility);
        if (!this.onlineUserPresenter.isAdmin()) {
            this.activeUserContainer.setVisibility(8);
            this.unActiveUserContainer.setVisibility(8);
        }
    }

    private void showConfirmFreeAll() {
        if (this.getContext() instanceof Activity) {
            Activity activity = (Activity)this.getContext();
            if (activity.isDestroyed() || activity.isFinishing()) {
                return;
            }
        } else {
            return;
        }
        new CommonDialog(this.getContext(), CommonDialog.ChoiceMode.Double_Blue).setMainDisplayText(this.getString(R.string.bjysc_blocked_user_free_all)).setNegative(this.getString(R.string.bjysc_about_cancel), (dialog, which) -> dialog.dismiss()).setPositive(this.getString(R.string.bjysc_all_lift), (dialog, which) -> {
            if (this.onlineUserPresenter != null) {
                this.onlineUserPresenter.setBlockedUserFreeAll();
            }
            dialog.dismiss();
        }).show();
    }

    private void expandLayout(int expandType) {
        this.expandType = expandType;
        boolean isActive = expandType == 0;
        boolean isUnActive = expandType == 1;
        boolean isKickout = expandType == 2;
        this.activeListView.setVisibility(isActive ? 0 : 8);
        this.unActiveListView.setVisibility(isUnActive ? 0 : 8);
        this.mRlInteractiveClassBlacklist.setVisibility(isKickout ? 0 : 8);
        this.mIvInteractiveClassUpIcon.setVisibility(isActive ? 8 : 0);
        this.mIvInteractiveClassDownIcon.setVisibility(isUnActive ? 8 : 0);
        this.mIvInteractiveClassBlacklistIcon.setVisibility(isKickout ? 8 : 0);
        this.zoomTextWidth(this.activeUserTextView, isActive);
        this.zoomTextWidth(this.unActiveUserTextView, isUnActive);
        if (this.onlineUserPresenter.isAdmin()) {
            this.activeUserContainer.setVisibility(isActive ? 0 : 8);
            this.unActiveUserContainer.setVisibility(isUnActive ? 0 : 8);
        }
        this.viewActiveDiv.setVisibility(isActive ? 0 : 8);
        this.viewUnActiveDiv.setVisibility(isUnActive ? 0 : 8);
        this.viewKickoutDiv.setVisibility(isKickout ? 0 : 8);
        this.mIvFreeBlockAll.setVisibility(isKickout && this.onlineUserPresenter.getBlockedUserListCount() > 0 ? 0 : 8);
        this.activeUserTextView.setTypeface(isActive ? Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
        this.unActiveUserTextView.setTypeface(isUnActive ? Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
        this.mTvInteractiveOnlineTitsle.setTypeface(isKickout ? Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
    }

    private void zoomTextWidth(TextView textView, boolean zoom) {
        if (this.getContext() == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = textView.getLayoutParams();
        if (layoutParams instanceof LinearLayout.LayoutParams) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)layoutParams;
            params.width = zoom ? this.getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_window_user_title_width) : this.getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_window_user_title_width_normal);
        }
    }

    private void setPresenter(OnlineUserPresenter presenter2) {
        this.onlineUserPresenter = presenter2;
        this.onlineUserPresenter.setRouter(this.iRouter);
        this.onlineUserPresenter.subscribe();
    }

    private void notifyDataChange() {
        LPGroupItem lpGroupItem;
        if (this.activeUserTextView == null) {
            return;
        }
        this.activeUserTextView.setText((CharSequence)this.getString(R.string.active_user, new Object[]{this.onlineUserPresenter.getUpUserCount()}));
        this.unActiveUserTextView.setText((CharSequence)this.getString(R.string.un_active_user, new Object[]{this.onlineUserPresenter.getDownUserCount()}));
        this.mTvInteractiveOnlineTitsle.setText((CharSequence)this.getString(R.string.string_blacklist, new Object[]{this.onlineUserPresenter.getBlockedUserListCount()}));
        this.activeGroupExpandAdapter.setDatas(this.onlineUserPresenter.getActiveGroupList());
        this.unActiveGroupExpandAdapter.setDatas(this.onlineUserPresenter.getUnActiveGroupList());
        LPGroupItem item = (LPGroupItem)this.activeGroupExpandAdapter.getGroup(0);
        if (item != null && item.id == 0) {
            this.activeListView.expandGroup(0);
        }
        if ((lpGroupItem = (LPGroupItem)this.unActiveGroupExpandAdapter.getGroup(0)) != null && lpGroupItem.id == 0) {
            this.unActiveListView.expandGroup(0);
        }
        this.blockListRecyclerViewAdapter.notifyDataSetChanged();
        this.mIvFreeBlockAll.setVisibility(this.expandType == 2 && this.onlineUserPresenter.getBlockedUserListCount() > 0 ? 0 : 8);
    }

    @Override
    public void upOrDownSeatContainer(IUserModel userModel, boolean isShowOnSeatContainer) {
        this.onlineUserPresenter.upOrDownFromSeatContainer(userModel, isShowOnSeatContainer);
    }

    @Override
    public void forbidChat(IUserModel userModel) {
        this.onlineUserPresenter.forbidChat(userModel);
    }

    @Override
    public void unForbidChat(IUserModel userModel) {
        this.onlineUserPresenter.unForbidChat(userModel);
    }

    @Override
    public void kickUserOut(IUserModel userModel) {
        this.onlineUserPresenter.kickOutUser(userModel);
    }

    public void showActiveUser() {
        if (this.activeListView != null && this.unActiveListView != null) {
            this.expandLayout(0);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.onlineUserPresenter != null) {
            this.onlineUserPresenter.destroy();
        }
    }

    @Override
    public void notifyOnlineUserDataSetChange() {
        this.notifyDataChange();
    }

    @Override
    public void notifyOnlineUserCountChange() {
    }

    @Override
    public void notifyHandsUpUserDataSetChange() {
    }

    @Override
    public void notifyActiveUserDataChange() {
    }

    @Override
    public void notifySpeakApplyResult() {
    }

    @Override
    public void notifyForbidStatus() {
        this.notifyDataChange();
    }

    @Override
    public void notifyUserDataChange() {
        this.notifyDataChange();
    }

    @Override
    public void notifyForbidHandUp(boolean isForbid) {
    }

    @Override
    public void notifyCurrentSeatFull() {
        if (this.iRouter != null) {
            this.iRouter.getPublishSubjectByKey(EventCode.NotifyCurrentSeatFull).onNext((Object)true);
        }
    }

    @Override
    public void showBlockedUserFreeAllUI() {
    }

    @Override
    public void notifyStudyRoomSwitch() {
        this.showStudyRoomItems();
    }
}

