/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.video;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.GestureDetectorCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.OnLifecycleEvent;
import com.baijiahulian.common.permission.AppPermissions;
import com.baijiahulian.common.permission.PermissionTipsView;
import com.baijiayun.bjyrtcengine.Defines.BJYRtcCommon;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.global.EventCode;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.global.IRouter;
import com.baijiayun.groupclassui.model.VideoMenuControlModel;
import com.baijiayun.groupclassui.window.InteractiveBaseWindow;
import com.baijiayun.groupclassui.window.video.StudyVideoWindow;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.GroupItem;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.LimitedQueue;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.dialog.CommonDialog;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPVideoSizeModel;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import com.baijiayun.livecore.models.launch.LPAwardConfig;
import com.baijiayun.livecore.viewmodels.debug.IDebugLink;
import com.baijiayun.livecore.wrapper.LPPlayer;
import com.baijiayun.livecore.wrapper.LPRecorder;
import com.baijiayun.livecore.wrapper.impl.LPCameraView;
import com.baijiayun.livecore.wrapper.impl.LPVideoView;
import com.baijiayun.livecore.wrapper.listener.LPPlayerListener;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.utils.PermissionTipBuilderFactory;
import com.baijiayun.liveuibase.widgets.dialog.AwardPopupWindow;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kotlin.Pair;

public class VideoWindow
extends InteractiveBaseWindow
implements Cloneable {
    private final String TAG = VideoWindow.class.getCanonicalName();
    protected LPPlayer mPlayer;
    protected LPRecorder mRecorder;
    protected AppCompatImageView ivPlaceholder;
    protected AppCompatImageView ivPlaceholderOnlyAudio;
    protected AppCompatImageView ivMenu;
    protected AppCompatImageView ivSpeak;
    protected AppCompatImageView ivSignal;
    protected AppCompatImageView ivHandsUp;
    protected AppCompatImageView ivDrawAuth;
    protected AppCompatImageView ivPPTAuth;
    protected LPCameraView cameraView;
    protected LPVideoView videoView;
    private View llHandsUpControl;
    private LinearLayout awardContainer;
    private ImageView awardIcon;
    private TextView awardCount;
    protected ViewGroup placeHolderContainer;
    private ViewGroup clBottom;
    private TextView resolutionTest;
    private ViewStub screenShareStub;
    private View screenShareContainer;
    private ImageView screenShareIv;
    protected IMediaModel mediaModel;
    protected CompositeDisposable disposables;
    private boolean isJoinBlackboard;
    private boolean isLocalVideo;
    private boolean isOverlay = false;
    protected boolean isAudioOn = false;
    protected boolean isVideoOn = false;
    private boolean isDrawAuthOn = false;
    private boolean isPPTAuthOn = false;
    private boolean isAssistCameraOn = false;
    private boolean isScreenShareOn = false;
    private boolean isShowMenu;
    private String videoCloseBackGroundUrl;
    public int currentX;
    public int currentY;
    private LimitedQueue<Double> upLossRateQueue;
    private LimitedQueue<Double> downLinkLossRateQueue;
    private double recorderAverageUpLinkLossRate;
    private List<Integer> packetLossRateLevel;
    private LoadingListener loadingListener;
    private Disposable timer;
    private boolean isActive;
    private int videoFit;
    protected boolean isAudioOnLast;
    protected boolean isVideoOnLast;
    public static final int REMOTE_VIDEO_AUTO_OPEN = 0;
    public static final int REMOTE_VIDEO_AUTO_CLOSE = 1;
    public static final int REMOTE_VIDEO_HAND_OPEN = 2;
    public static final int REMOTE_VIDEO_HAND_CLOSE = 3;
    public static final int REMOTE_VIDEO_AUDIO_CLOSE = 4;
    protected int remoteVideoStatus;
    private boolean enablePullAudioOnly = false;
    protected LPConstants.MediaState videoState = LPConstants.MediaState.Normal;
    protected LPConstants.MediaState audioState = LPConstants.MediaState.Normal;
    private boolean disablePullStream;
    private boolean showWindow = true;
    private GroupItem groupItemModel;
    private ImageView ivShadow;
    private boolean isOnlyInBlackboard = true;
    private final String[] colors = new String[]{"#FF607D", "#BE21E9", "#35CD3B", "#EE87FF", "#775FCF", "#AB8678", "#3D5AFE", "#03A9F4", "#C3FFA6", "#F44336", "#7ED321", "#FB9D3E", "#795548", "#FFEB3B", "#FFAE8E", "#E91E63"};
    private Target<Drawable> simpleTarget;
    private BJYRtcCommon.DualStreamType defaultRemoteStreamType = BJYRtcCommon.DualStreamType.VIDEO_STREAM_LOW;
    private ConstraintLayout.LayoutParams videoCloseImageOriginParams;
    private AwardPopupWindow awardPopupWindow;
    private LPAwardConfig availableAward = null;
    private int[] loadingImgGroup = new int[]{R.id.item_speak_speaker_loading_img1, R.id.item_speak_speaker_loading_img2, R.id.item_speak_speaker_loading_img3, R.id.item_speak_speaker_loading_img4, R.id.item_speak_speaker_loading_img5};
    private ValueAnimator animator;

    public static VideoWindow newInstance(Context context, IRouter router) {
        if (router.getLiveRoom().getStudyRoomVM().isStudyRoom()) {
            return new StudyVideoWindow(context);
        }
        return new VideoWindow(context);
    }

    protected VideoWindow(Context context) {
        super(context);
        this.mPlayer = this.iRouter.getLiveRoom().getPlayer();
        this.mRecorder = this.iRouter.getLiveRoom().getRecorder();
        this.view.setOnTouchListener(null);
        this.cameraView = (LPCameraView)this.$.id(R.id.window_video_camera_view).view();
        this.cameraView.setAspectRatio(LPConstants.LPAspectRatio.Fill);
        this.videoView = (LPVideoView)this.$.id(R.id.window_video_video_view).view();
        this.videoView.setAspectRatio(LPConstants.LPAspectRatio.Fill);
        this.placeHolderContainer = (ViewGroup)this.$.id(R.id.window_video_placerHolder_container).view();
        this.ivMenu = (AppCompatImageView)this.$.id(R.id.window_video_menu).view();
        this.ivPlaceholder = (AppCompatImageView)this.$.id(R.id.iv_video_placeholder).view();
        this.ivPlaceholderOnlyAudio = (AppCompatImageView)this.$.id(R.id.iv_video_placeholder_only_audio).view();
        this.ivSpeak = (AppCompatImageView)this.$.id(R.id.window_video_mic).view();
        this.ivSignal = (AppCompatImageView)this.$.id(R.id.window_video_signal).view();
        this.ivHandsUp = (AppCompatImageView)this.$.id(R.id.window_video_hands_up).view();
        this.llHandsUpControl = this.$.id(R.id.window_video_hands_up_control).view();
        this.ivDrawAuth = (AppCompatImageView)this.$.id(R.id.window_video_draw_auth).view();
        this.ivPPTAuth = (AppCompatImageView)this.$.id(R.id.window_video_ppt_auth).view();
        this.awardContainer = (LinearLayout)this.$.id(R.id.window_video_awards).view();
        this.awardIcon = (ImageView)this.$.id(R.id.window_video_awards_icon).view();
        this.awardCount = (TextView)this.$.id(R.id.window_video_awards_count).view();
        this.clBottom = (ViewGroup)this.$.id(R.id.cl_bottom).view();
        this.resolutionTest = (TextView)this.$.id(R.id.tv_test_resolution).view();
        this.screenShareStub = (ViewStub)this.$.id(R.id.screen_share_stub).view();
        this.ivShadow = (ImageView)this.$.id(R.id.iv_shadow).view();
        this.ivShadow.setVisibility(this.iRouter.getLiveRoom().getPartnerConfig().enableStrengthenSpeakingStyle ? 0 : 8);
        this.resolutionTest.setVisibility(8);
        this.changePlaceholderState(false);
        this.setAudioChange(false);
        this.ivSignal.setImageLevel(0);
        this.isActive = true;
        this.$.id(R.id.window_video_agree).view().setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context, (int)R.attr.base_theme_live_product_color)).cornerRadius(UtilsKt.getDp((int)2)).build());
        this.initListener();
        this.subscribe();
    }

    @SuppressLint(value={"InflateParams"})
    protected View onCreateView(Context context) {
        if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE && !this.iRouter.getLiveRoom().enableFixChatPanel1v1() && !this.iRouter.getLiveRoom().enableVideoFillMode1v1()) {
            return LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_window_video_one, null);
        }
        return LayoutInflater.from((Context)context).inflate(R.layout.bjy_group_window_video, null);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    protected void onResume() {
        this.isActive = true;
        if (!this.isLocalVideo() || this.mRecorder == null) {
            return;
        }
        this.timer = Observable.timer((long)300L, (TimeUnit)TimeUnit.MILLISECONDS).filter(aLong -> this.mRecorder != null).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (this.isVideoOnLast && this.isAudioOnLast) {
                this.attachAVideo();
            } else if (this.isVideoOnLast) {
                this.attachVideo();
            } else if (this.isAudioOnLast) {
                this.attachAudio();
            }
            this.isAudioOnLast = false;
            this.isVideoOnLast = false;
        }, throwable -> {});
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    protected void onStop() {
        this.isActive = false;
        if (!this.isLocalVideo() || this.mRecorder == null) {
            return;
        }
        boolean doOnStartScreenShare = this.iRouter.getValueByKey(EventKey.doOnStartScreenShare, Boolean.class, false);
        if (this.mRecorder.isScreenSharing() || doOnStartScreenShare) {
            return;
        }
        LPLogger.d((String)this.TAG, (String)"onStop() \u505c\u6b62\u63a8\u6d41");
        if (this.mRecorder.isVideoAttached()) {
            this.isVideoOnLast = true;
        }
        if (this.mRecorder.isAudioAttached()) {
            this.isAudioOnLast = true;
        }
        this.mRecorder.stopPublishing();
    }

    public int[] getWindowPosition() {
        int[] locations = new int[2];
        if (this.getView() != null) {
            this.getView().getLocationOnScreen(locations);
        }
        return locations;
    }

    void showMenu(int currX, int currY) {
        if (this.ivMenu.isSelected()) {
            this.iRouter.getSubjectByKey(EventKey.ShowVideoMenu).onNext((Object)new VideoMenuControlModel());
            this.setMenuState(false);
        } else {
            this.currentX = currX - this.getWindowPosition()[0];
            this.currentY = currY - this.getWindowPosition()[1];
            this.iRouter.getSubjectByKey(EventKey.ShowVideoMenu).onNext((Object)new VideoMenuControlModel(this, currX, currY, true));
            this.setMenuState(true);
        }
    }

    public boolean isGalleryLayout() {
        return this.iRouter.getLiveRoom().getCurrentRoomLayout() == LPConstants.RoomLayoutMode.GALLERY;
    }

    public boolean isTouchAble() {
        return this.iRouter.getLiveRoom().getCurrentRoomLayout() == LPConstants.RoomLayoutMode.GALLERY;
    }

    public boolean isSingleTutorHelping() {
        return false;
    }

    public boolean isSelfSingleTutorHelping() {
        return false;
    }

    public boolean isShowSingleTutorMenu() {
        return this.isSelfSingleTutorHelping() && this.isSingleTutorHelping() || !this.isSelfSingleTutorHelping() && !this.isSingleTutorHelping();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void initListener() {
        GestureDetectorCompat gestureDetector = new GestureDetectorCompat(this.getView().getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (VideoWindow.this.isShowMenu()) {
                    VideoWindow.this.showMenu((int)e.getRawX() + UtilsKt.getDp((int)40), (int)e.getRawY() + UtilsKt.getDp((int)2));
                }
                return super.onSingleTapConfirmed(e);
            }
        });
        this.getView().setOnTouchListener((v, event) -> {
            gestureDetector.onTouchEvent(event);
            return this.isTouchAble();
        });
        this.$.id(R.id.window_video_hands_up).clicked(v -> {
            this.llHandsUpControl.setVisibility(0);
            this.ivHandsUp.setVisibility(8);
        }).id(R.id.window_video_agree).clicked(v -> this.controlHansUp(this.getUserId(), true)).id(R.id.window_video_disagree).clicked(v -> this.controlHansUp(this.getUserId(), false)).id(R.id.window_video_mic).clicked(v -> {
            if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
                return;
            }
            if (this.isLocalVideo()) {
                if (this.isAudioOn() && this.mRecorder.isAudioAttached()) {
                    this.iRouter.getLiveRoom().getRecorder().detachAudio();
                } else {
                    this.iRouter.getLiveRoom().getRecorder().attachAudio();
                }
            } else {
                if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant && this.getUserModel().getType() == LPConstants.LPUserType.Teacher) {
                    return;
                }
                this.iRouter.getLiveRoom().getSpeakQueueVM().controlRemoteUser(this.getUserId(), this.isVideoOn(), !this.isAudioOn());
            }
        });
    }

    protected void subscribe() {
        this.packetLossRateLevel = this.iRouter.getLiveRoom().getPartnerConfig().packetLossRate.packetLossRateLevel;
        int packetLossDuration = this.iRouter.getLiveRoom().getPartnerConfig().packetLossDuration;
        this.upLossRateQueue = new LimitedQueue(packetLossDuration);
        this.downLinkLossRateQueue = new LimitedQueue(packetLossDuration);
        this.disposables = new CompositeDisposable();
        this.disposables.add(this.iRouter.getLiveRoom().getObservableOfClassStart().filter(integer -> this.enablePullAudioOnly).subscribe(integer -> {
            this.remoteVideoStatus = 1;
        }));
        this.disposables.add(this.iRouter.getLiveRoom().getSpeakQueueVM().getObservableOfSpeakResponse().observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
            if (!this.mediaModel.getUser().getUserId().equals(iMediaControlModel.getUser().getUserId())) {
                return;
            }
            this.showHandsUpIcon(false);
            this.showHandsUpControl(false);
            this.changeMicLevel(LPConstants.VolumeLevel.NONE);
        }));
        this.disposables.add(((IDebugLink)this.mRecorder).getObservableDebugStateUI().observeOn(AndroidSchedulers.mainThread()).subscribe(isShowLocalVideo -> {
            if (isShowLocalVideo.booleanValue()) {
                this.mRecorder.attachVideo();
            } else {
                this.mRecorder.detachVideo();
            }
        }));
        this.disposables.add(this.iRouter.getPublishSubjectByKey(EventCode.AttachVideo).ofType(Boolean.class).filter(o -> this.isLocalVideo).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.attachVideo();
            } else {
                this.detachVideo();
            }
        }));
        this.disposables.add(this.iRouter.getPublishSubjectByKey(EventCode.AttachAudio).ofType(Boolean.class).filter(o -> this.isLocalVideo).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (aBoolean.booleanValue() && this.canAttachAudio()) {
                this.attachAudio();
            } else {
                this.detachAudio();
            }
        }));
        this.disposables.add(this.iRouter.getLiveRoom().getSpeakQueueVM().getObservableOfMediaControl().filter(iMediaControlModel -> this.isLocalVideo && this.isActive).observeOn(AndroidSchedulers.mainThread()).subscribe(iMediaControlModel -> {
            if (iMediaControlModel.isVideoOn() && !this.mRecorder.isVideoAttached()) {
                this.attachVideo();
            } else if (!iMediaControlModel.isVideoOn() && this.mRecorder.isVideoAttached()) {
                if (this.mRecorder.isScreenSharing()) {
                    this.mRecorder.stopScreenCapture(false);
                }
                this.detachVideo();
            }
            if (iMediaControlModel.isAudioOn() && !this.mRecorder.isAudioAttached()) {
                this.attachAudio();
            } else if (!iMediaControlModel.isAudioOn() && this.mRecorder.isAudioAttached()) {
                this.detachAudio();
            }
        }));
        this.disposables.add(this.iRouter.getSubjectByKey(EventKey.ScreenShare).ofType(Boolean.class).filter(aBoolean -> this.isLocalVideo).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.ivShadow.setImageDrawable(null);
                if (this.screenShareContainer == null) {
                    this.screenShareContainer = this.screenShareStub.inflate();
                    this.screenShareIv = (ImageView)this.screenShareContainer.findViewById(R.id.iv);
                    TextView screenShareTv = (TextView)this.screenShareContainer.findViewById(R.id.tv);
                    screenShareTv.setTextSize(10.0f);
                }
                this.screenShareContainer.setVisibility(0);
                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.screenShareIv.getLayoutParams();
                if (this.view.getWidth() > this.view.getHeight()) {
                    layoutParams.matchConstraintPercentWidth = 1.0f;
                    layoutParams.matchConstraintPercentHeight = 0.5f;
                } else {
                    layoutParams.matchConstraintPercentWidth = 0.5f;
                    layoutParams.matchConstraintPercentHeight = 1.0f;
                }
                if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
                    this.iRouter.getSubjectByKey(EventKey.VideoWindowToBlackboardAndMax).onNext((Object)this);
                }
            } else {
                if (this.mRecorder.isAudioAttached()) {
                    this.ivShadow.setImageResource(R.drawable.bjy_base_inner_shadow_1);
                }
                if (this.screenShareContainer != null) {
                    this.screenShareContainer.setVisibility(8);
                }
                if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
                    this.iRouter.getSubjectByKey(EventKey.CloseVideoWindow).onNext((Object)this.getMediaId());
                }
            }
            if (!aBoolean.booleanValue() && !UtilsKt.isAppForeground((Context)this.context)) {
                this.onStop();
                this.isVideoOnLast = true;
                this.iRouter.getLiveRoom().getOnlineUserVM().updateMediaState();
            }
        }));
    }

    public void attachAVideo() {
        this.disposables.add(BaseUtilsKt.getBluetoothObservable((Activity)((Activity)this.context), (int)this.iRouter.getLiveRoom().getRoomInfo().webRTCType).flatMap(aBoolean -> {
            if (Build.VERSION.SDK_INT > 33) {
                return AppPermissions.newPermissions((Activity)((Activity)this.context)).request(PermissionTipBuilderFactory.createPermissionTipsView((Context)this.context, (String)"android.permission.POST_NOTIFICATIONS"), new String[]{"android.permission.POST_NOTIFICATIONS"});
            }
            return Observable.just((Object)aBoolean);
        }).flatMap(aBoolean -> AppPermissions.newPermissions((Activity)((Activity)this.context)).request(PermissionTipBuilderFactory.createPermissionTipsView((Context)this.context, (String)"android.permission.CAMERA"), new String[]{"android.permission.CAMERA"})).flatMap(cameraPermitted -> AppPermissions.newPermissions((Activity)((Activity)this.context)).request(PermissionTipBuilderFactory.createPermissionTipsView((Context)this.context, (String)"android.permission.RECORD_AUDIO"), new String[]{"android.permission.RECORD_AUDIO"}).flatMap(audioPermitted -> Observable.just((Object)new Pair(cameraPermitted, audioPermitted)))).subscribe(pair -> {
            if (((Boolean)pair.getFirst()).booleanValue() && ((Boolean)pair.getSecond()).booleanValue()) {
                if (this.cameraView != null) {
                    this.cameraView.setVisibility(0);
                    this.mRecorder.setPreview(this.cameraView);
                }
                this.mRecorder.publish();
                this.mRecorder.attachAVideo();
                this.isVideoOn = true;
                this.isAudioOn = true;
            } else if (((Boolean)pair.getFirst()).booleanValue()) {
                this.mRecorder.publish();
                if (this.cameraView != null) {
                    this.cameraView.setVisibility(0);
                    this.mRecorder.setPreview(this.cameraView);
                }
                this.mRecorder.attachVideo();
                this.isVideoOn = true;
            } else if (((Boolean)pair.getSecond()).booleanValue()) {
                this.mRecorder.publish();
                this.mRecorder.attachAudio();
                this.isAudioOn = true;
            } else {
                this.showPermissionNotGrantedDialog(this.context.getResources().getString(R.string.live_no_media_permission));
            }
            this.iRouter.getLiveRoom().getOnlineUserVM().updateMediaState();
        }));
    }

    public void attachVideo() {
        PermissionTipsView permissionTipsView = PermissionTipBuilderFactory.createPermissionTipsView((Context)this.context, (String)"android.permission.CAMERA");
        this.disposables.add(BaseUtilsKt.getBluetoothObservable((Activity)((Activity)this.context), (int)this.iRouter.getLiveRoom().getRoomInfo().webRTCType).flatMap(aBoolean -> {
            if (Build.VERSION.SDK_INT > 33) {
                return AppPermissions.newPermissions((Activity)((Activity)this.context)).request(PermissionTipBuilderFactory.createPermissionTipsView((Context)this.context, (String)"android.permission.POST_NOTIFICATIONS"), new String[]{"android.permission.POST_NOTIFICATIONS"});
            }
            return Observable.just((Object)aBoolean);
        }).flatMap(aBoolean -> AppPermissions.newPermissions((Activity)((Activity)this.context)).request(permissionTipsView, new String[]{"android.permission.CAMERA"})).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.mRecorder.publish();
                if (this.cameraView != null) {
                    this.cameraView.setVisibility(0);
                    this.mRecorder.setPreview(this.cameraView);
                }
                this.mRecorder.attachVideo();
                this.isVideoOn = true;
            } else {
                this.showPermissionNotGrantedDialog(this.context.getResources().getStringArray(R.array.live_no_permission)[1]);
            }
            this.iRouter.getLiveRoom().getOnlineUserVM().updateMediaState();
        }));
    }

    public void detachVideo() {
        this.mRecorder.detachVideo();
        if (!this.mRecorder.isAudioAttached()) {
            this.mRecorder.stopPublishing();
        }
    }

    public void attachAudio() {
        String[] permissions = new String[]{"android.permission.RECORD_AUDIO"};
        PermissionTipsView permissionTipsView = PermissionTipBuilderFactory.createPermissionTipsView((Context)this.context, (String)"android.permission.RECORD_AUDIO");
        this.disposables.add(BaseUtilsKt.getBluetoothObservable((Activity)((Activity)this.context), (int)this.iRouter.getLiveRoom().getRoomInfo().webRTCType).flatMap(aBoolean -> {
            if (Build.VERSION.SDK_INT > 33) {
                return AppPermissions.newPermissions((Activity)((Activity)this.context)).request(PermissionTipBuilderFactory.createPermissionTipsView((Context)this.context, (String)"android.permission.POST_NOTIFICATIONS"), new String[]{"android.permission.POST_NOTIFICATIONS"});
            }
            return Observable.just((Object)aBoolean);
        }).flatMap(aBoolean -> AppPermissions.newPermissions((Activity)((Activity)this.context)).request(permissionTipsView, permissions)).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.mRecorder.publish();
                this.mRecorder.attachAudio();
                this.isAudioOn = true;
            } else {
                this.showPermissionNotGrantedDialog(this.context.getResources().getString(R.string.live_no_media_permission));
            }
            this.iRouter.getLiveRoom().getOnlineUserVM().updateMediaState();
        }));
    }

    public void detachAudio() {
        this.mRecorder.detachAudio();
        if (!this.mRecorder.isVideoAttached()) {
            this.mRecorder.stopPublishing();
        }
    }

    public void detachAVideo() {
        this.mRecorder.detachAVideo();
        this.mRecorder.stopPublishing();
    }

    protected boolean canAttachAudio() {
        return true;
    }

    private void initMediaState(IMediaModel iMediaModel) {
        IUserModel userModel = iMediaModel.getUser();
        if (userModel instanceof LPUserModel) {
            LPUserModel lpUserModel = (LPUserModel)userModel;
            if (this.groupItemModel != null) {
                lpUserModel.groupId = this.groupItemModel.id;
            }
            if (lpUserModel.audioState != null) {
                this.audioState = lpUserModel.audioState;
            }
            if (lpUserModel.videoState != null) {
                this.videoState = lpUserModel.videoState;
            }
        }
    }

    public void setMediaModel(IMediaModel iMediaModel) {
        boolean isStudent;
        this.mediaModel = iMediaModel;
        this.initMediaState(iMediaModel);
        this.ivPlaceholderOnlyAudio.setImageResource(this.isAudioOn ? R.drawable.ic_only_audio_normal : R.drawable.ic_only_audio_none);
        IUserModel iUserModel = iMediaModel.getUser();
        if (iUserModel instanceof LPUserModel) {
            this.videoCloseBackGroundUrl = ((LPUserModel)iUserModel).cameraCover;
        }
        this.setName(UtilsKt.getEncodePhoneNumber((String)iMediaModel.getUser().getName()));
        this.isLocalVideo = iUserModel.getUserId().equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId());
        if (!this.isLocalVideo) {
            this.setAudioOn(iMediaModel.isAudioOn());
            this.setVideoOn(iMediaModel.isVideoOn());
            if (this.isGalleryLayout()) {
                this.setRemoteVideoStreamType(BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH);
            }
            if (BaseUtilsKt.isAdmin((LiveRoom)this.iRouter.getLiveRoom()) && iUserModel.getType() == LPConstants.LPUserType.Student) {
                this.setAwardTvVisibility(0);
            }
        } else {
            this.disposables.add(this.iRouter.getLiveRoom().getRecorder().getObservableOfCameraOn().filter(aBoolean -> this.iRouter.getLiveRoom() != null).observeOn(AndroidSchedulers.mainThread()).subscribe(videoOn -> {
                this.setVideoOn((boolean)videoOn);
                if (this.videoView.getVisibility() == 0) {
                    this.videoView.setVisibility(8);
                }
                this.changePlaceHolder();
            }));
            this.disposables.add(this.iRouter.getLiveRoom().getRecorder().getObservableOfMicOn().observeOn(AndroidSchedulers.mainThread()).subscribe(this::setAudioOn));
        }
        this.disposables.add(this.iRouter.getLiveRoom().getOnlineUserVM().getObservableOfUserUpdate().observeOn(AndroidSchedulers.mainThread()).filter(lpUserModel -> TextUtils.equals((CharSequence)lpUserModel.userId, (CharSequence)iMediaModel.getUser().getUserId()) && !TextUtils.equals((CharSequence)lpUserModel.userId, (CharSequence)this.iRouter.getLiveRoom().getCurrentUser().getUserId())).subscribe(lpUserModel -> {
            if (lpUserModel.audioState != null) {
                this.audioState = lpUserModel.audioState;
            }
            if (lpUserModel.videoState != null) {
                this.videoState = lpUserModel.videoState;
            }
            this.videoCloseBackGroundUrl = lpUserModel.cameraCover;
            this.changePlaceholderState(this.ivPlaceholder.getVisibility() != 0);
        }));
        Disposable upPacketLossRateDisposable = this.iRouter.getLiveRoom().getRecorder().getObservableOfUpPacketLossRate().observeOn(AndroidSchedulers.mainThread()).subscribe(localStreamStats -> {
            double average;
            double lossRate = this.isVideoOn() ? localStreamStats.videoPacketsLostRateSent : localStreamStats.audioPacketsLostRateSent;
            this.upLossRateQueue.add((Object)lossRate);
            this.recorderAverageUpLinkLossRate = average = this.upLossRateQueue.getAverage();
        });
        Disposable disposableOfDownLinkLossRate = this.iRouter.getLiveRoom().getPlayer().getObservableOfDownLinkLossRate().filter(stringMap -> !this.isLocalVideo).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(stats -> {
            if (this.getUserId().equals(stats.uid)) {
                this.downLinkLossRateQueue.add((Object)(this.isVideoOn() ? stats.receivedVideoLostRate : stats.receivedAudioLossRate));
                double average = this.downLinkLossRateQueue.getAverage();
                if (this.getUserModel().equals(this.iRouter.getLiveRoom().getPresenterUser())) {
                    this.handlerNetworkUI(average, false);
                } else if (average > this.recorderAverageUpLinkLossRate * 2.0) {
                    this.handlerNetworkUI(average, false);
                } else {
                    this.iRouter.getSubjectByKey(EventKey.NetWorkLossRateNotify).onNext((Object)average);
                }
            }
        });
        Disposable disposableOfLocalWindow = this.iRouter.getSubjectByKey(EventKey.NetWorkLossRateNotify).ofType(Double.class).filter(aDouble -> this.isLocalVideo).subscribe(aDouble -> this.handlerNetworkUI((double)aDouble, false));
        this.disposables.add(this.iRouter.getLiveRoom().getObservableOfRoomLayoutSwitch().observeOn(AndroidSchedulers.mainThread()).subscribe(layoutMode -> {
            if (layoutMode == LPConstants.RoomLayoutMode.BOARD) {
                this.setRemoteVideoStreamType(BJYRtcCommon.DualStreamType.VIDEO_STREAM_LOW);
            } else {
                this.setRemoteVideoStreamType(BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH);
            }
            this.setJoinBlackboard(this.isJoinBlackboard);
        }));
        this.disposables.add(this.iRouter.getSubjectByKey(EventKey.StudyRoomSwitch).ofType(LPConstants.StudyRoomMode.class).subscribe(studyRoomMode -> {
            if (studyRoomMode.isGalleryLayout()) {
                this.setRemoteVideoStreamType(BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH);
            } else {
                this.setRemoteVideoStreamType(BJYRtcCommon.DualStreamType.VIDEO_STREAM_LOW);
            }
        }));
        boolean bl = isStudent = iMediaModel.getUser().getType() != LPConstants.LPUserType.Teacher && iMediaModel.getUser().getType() != LPConstants.LPUserType.Assistant;
        if (!this.isLocalVideo && isStudent && !BaseUtilsKt.isAdmin((LiveRoom)this.iRouter.getLiveRoom())) {
            this.disposables.add(this.iRouter.getLiveRoom().getObservableOfDisableOtherStudentVideo().observeOn(AndroidSchedulers.mainThread()).subscribe(model -> {
                boolean hideOtherStudentVideo = this.initEnablePullAudioOnly(model.isDisable() || this.iRouter.getSubjectValueByKey(EventKey.HideOtherStudentVideo, Boolean.class, false) != false);
                if (hideOtherStudentVideo == this.enablePullAudioOnly) {
                    return;
                }
                this.enablePullAudioOnly = hideOtherStudentVideo;
                if (this.enablePullAudioOnly) {
                    if (!this.isJoinBlackboard) {
                        this.remoteVideoStatus = 1;
                    }
                } else {
                    this.remoteVideoStatus = 0;
                }
                if (!this.disablePullStream) {
                    this.changeVideoState(this.mediaModel, true);
                    this.setVideoOn(this.isVideoOn());
                    this.setAudioOn(this.isAudioOn());
                } else {
                    this.remoteVideoStatus = 4;
                }
            }));
            this.disposables.add(this.iRouter.getSubjectByKey(EventKey.HideOtherStudentVideo).ofType(Boolean.class).filter(aBoolean -> !this.iRouter.getLiveRoom().getDisableOtherStudentVideoData().isDisable()).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
                this.enablePullAudioOnly = this.initEnablePullAudioOnly((boolean)aBoolean);
                if (this.enablePullAudioOnly) {
                    if (!this.isJoinBlackboard) {
                        this.remoteVideoStatus = 1;
                    }
                } else {
                    this.remoteVideoStatus = 0;
                }
                if (!this.disablePullStream) {
                    this.changeVideoState(this.mediaModel, true);
                    this.setVideoOn(this.isVideoOn());
                    this.setAudioOn(this.isAudioOn());
                } else {
                    this.remoteVideoStatus = 4;
                }
            }));
            this.enablePullAudioOnly = this.initEnablePullAudioOnly(this.iRouter.getLiveRoom().getDisableOtherStudentVideoData().isDisable());
            if (this.enablePullAudioOnly) {
                if (!this.isJoinBlackboard) {
                    this.remoteVideoStatus = 1;
                }
            } else {
                this.remoteVideoStatus = 0;
            }
            this.setJoinBlackboard(this.isJoinBlackboard);
        }
        this.disposables.add(upPacketLossRateDisposable);
        this.disposables.add(disposableOfDownLinkLossRate);
        this.disposables.add(disposableOfLocalWindow);
        if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            this.setRemoteVideoStreamType(BJYRtcCommon.DualStreamType.VIDEO_STREAM_HIGH);
        }
    }

    private void handlerNetworkUI(double lossRate, boolean showStrongTip) {
        if (lossRate <= (double)this.packetLossRateLevel.get(0).intValue()) {
            this.$.id(R.id.window_video_network_tips).text((CharSequence)"");
            this.ivSignal.setImageLevel(0);
        } else if (lossRate <= (double)this.packetLossRateLevel.get(1).intValue()) {
            this.$.id(R.id.window_video_network_tips).text((CharSequence)this.getView().getContext().getString(R.string.bjysc_network_tips_level_1)).textColor(R.color.bjysc_low_network_tips_middle);
            this.ivSignal.setImageLevel(1);
        } else if (lossRate <= (double)this.packetLossRateLevel.get(2).intValue()) {
            this.$.id(R.id.window_video_network_tips).text((CharSequence)this.getView().getContext().getString(R.string.bjysc_network_tips_level_2)).textColor(R.color.bjysc_low_network_tips_middle);
            this.ivSignal.setImageLevel(1);
        } else if (lossRate <= (double)this.packetLossRateLevel.get(3).intValue() || lossRate <= (double)this.packetLossRateLevel.get(4).intValue()) {
            this.$.id(R.id.window_video_network_tips).text((CharSequence)this.getView().getContext().getString(R.string.bjysc_network_tips_level_3)).textColor(R.color.bjysc_low_network_tips_terrible);
            this.ivSignal.setImageLevel(2);
        } else if (showStrongTip) {
            this.iRouter.getSubjectByKey(EventKey.NetworkTipsDialog).onNext((Object)this.getView().getContext().getString(R.string.bjysc_network_tips_level_5));
        } else {
            this.$.id(R.id.window_video_network_tips).text((CharSequence)this.getView().getContext().getString(R.string.bjysc_network_tips_level_3)).textColor(R.color.bjysc_low_network_tips_terrible);
            this.ivSignal.setImageLevel(2);
        }
    }

    public IUserModel getUserModel() {
        return this.mediaModel.getUser();
    }

    public void publishLocalStream() {
        this.publishLocalStream(false);
    }

    public void publishLocalStream(boolean forceAudioOn) {
        this.videoView.setVisibility(8);
        if (this.iRouter.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE) {
            if (this.getUserModel().getType() == LPConstants.LPUserType.Assistant) {
                if (this.iRouter.getLiveRoom().getOnlineUserVM().enable1v1TeacherOffStage()) {
                    this.attachAVideo();
                }
            } else if (this.isAppForeground()) {
                this.attachAVideo();
            } else {
                this.isVideoOnLast = true;
                this.isAudioOnLast = true;
            }
        } else if (this.getUserModel().getType() == LPConstants.LPUserType.Teacher) {
            if (this.isAppForeground()) {
                this.attachAVideo();
            } else {
                this.isAudioOnLast = true;
                this.isVideoOnLast = true;
            }
        } else if (this.isAppForeground()) {
            if (this.iRouter.getLiveRoom().isClassStarted() && this.iRouter.getLiveRoom().getPartnerConfig().liveStudentDefaultAudioOn == 1 || forceAudioOn) {
                this.attachAVideo();
            } else {
                this.attachVideo();
            }
        } else {
            this.isVideoOnLast = true;
            this.isAudioOnLast = this.iRouter.getLiveRoom().isClassStarted() && this.iRouter.getLiveRoom().getPartnerConfig().liveStudentDefaultAudioOn == 1;
        }
    }

    protected boolean isAppForeground() {
        return UtilsKt.isAppForeground((Context)this.view.getContext());
    }

    public void changeVideoState(IMediaModel iMediaModel) {
        this.changeVideoState(iMediaModel, false);
    }

    private void changeVideoState(IMediaModel iMediaModel, boolean isFromEnablePullOnlyAudioSignal) {
        this.mediaModel = iMediaModel;
        this.initMediaState(iMediaModel);
        if (iMediaModel.getUser() instanceof LPUserModel) {
            this.videoCloseBackGroundUrl = ((LPUserModel)iMediaModel.getUser()).cameraCover;
            int aspectRatio = ((LPUserModel)iMediaModel.getUser()).videoFit;
            if (this.videoFit != aspectRatio) {
                if (aspectRatio == 0) {
                    this.videoView.setAspectRatio(LPConstants.LPAspectRatio.Fill);
                    if (this.mediaModel.isAudioOn() && this.mediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainCamera) {
                        this.ivShadow.setImageResource(R.drawable.bjy_base_inner_shadow_1);
                    }
                } else {
                    this.videoView.setAspectRatio(LPConstants.LPAspectRatio.Fit);
                    this.ivShadow.setImageDrawable(null);
                }
                this.stopStreaming(this.mediaModel.getMediaId());
                this.videoFit = aspectRatio;
            }
        }
        this.setRemoteVideoStatus(this.remoteVideoStatus);
        if (this.isRemoteAVideoClose()) {
            this.stopStreaming(this.getMediaId());
            return;
        }
        boolean isReplacedByCamera = false;
        IUserModel replacedUser = this.iRouter.getLiveRoom().getSpeakQueueVM().getReplacedUser();
        if (this.iRouter.getLiveRoom().getSpeakQueueVM().hasAsCameraUser()) {
            isReplacedByCamera = this.getMediaId().equals(replacedUser.getUserId());
        }
        if (isReplacedByCamera || iMediaModel.isVideoOn()) {
            this.stopStreaming(this.getMediaId());
            this.streamVideo(this.getMediaId());
        } else if (iMediaModel.isAudioOn()) {
            this.stopStreaming(this.getMediaId());
            this.streamAudio(this.getMediaId());
        }
        if (iMediaModel.isVideoOn()) {
            if (this.isRemoteVideoClose()) {
                if (!iMediaModel.isAudioOn()) {
                    this.stopStreaming(this.getMediaId());
                } else {
                    this.mPlayer.muteRemoteVideo(this.getMediaId(), true);
                }
            } else if (isFromEnablePullOnlyAudioSignal) {
                this.mPlayer.muteRemoteVideo(this.getMediaId(), false);
            } else {
                this.mPlayer.muteRemoteAudio(this.getMediaId(), !iMediaModel.isAudioOn());
            }
        } else if (!iMediaModel.isAudioOn()) {
            this.stopStreaming(this.getMediaId());
        }
    }

    private boolean initEnablePullAudioOnly(boolean disableOtherStudentVideo) {
        return this.iRouter != null && this.mediaModel != null && disableOtherStudentVideo && this.mediaModel.getUser().getType() == LPConstants.LPUserType.Student && !this.isLocalVideo;
    }

    public boolean getEnablePullAudioOnly() {
        return this.enablePullAudioOnly;
    }

    public void setName(String name) {
        this.$.id(R.id.window_video_name).text((CharSequence)name);
    }

    public boolean isJoinBlackboard() {
        return this.isJoinBlackboard;
    }

    public void setJoinBlackboard(boolean joinBlackboard) {
        this.isJoinBlackboard = joinBlackboard;
        if (this.enablePullAudioOnly && this.isVideoOn && this.videoView != null) {
            this.videoView.post(() -> {
                this.remoteVideoStatus = this.isJoinBlackboard || this.isGalleryLayout() ? 0 : 1;
                this.changeVideoState(this.mediaModel);
            });
        }
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        if (this.isDestroyed()) {
            return;
        }
        this.isOverlay = isMediaOverlay;
        if (this.getUserModel().getUserId().equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId())) {
            this.cameraView.setZOrderMediaOverlay(isMediaOverlay);
        } else {
            this.videoView.setZOrderMediaOverlay(isMediaOverlay);
        }
    }

    protected void streamVideo(String mediaId) {
        this.showLoading();
        if (this.mPlayer != null) {
            this.mPlayer.playVideo(mediaId, this.videoView);
        }
    }

    protected void streamAudio(String mediaId) {
        if (this.mPlayer != null) {
            this.mPlayer.playAudio(mediaId);
        }
    }

    protected void stopStreaming(String mediaId) {
        this.hideLoading();
        if (this.mPlayer != null) {
            this.mPlayer.playAVClose(mediaId);
        }
    }

    public void closeAV() {
        if (this.isLocalVideo()) {
            if (this.mRecorder != null) {
                this.mRecorder.stopPublishing();
            }
        } else {
            this.stopStreaming(this.getMediaId());
        }
    }

    private void changeMicLevel(LPConstants.VolumeLevel volumeLevel) {
        if (!this.isAudioOn()) {
            return;
        }
        int level = 0;
        switch (volumeLevel) {
            case NONE: {
                level = 1;
                break;
            }
            case LOW: {
                level = 2;
                break;
            }
            case MIDDLE: {
                level = 3;
                break;
            }
            case HIGH: {
                level = 4;
            }
        }
        this.ivSpeak.setImageLevel(level);
    }

    private void controlHansUp(String uid, boolean isAgreed) {
        if (isAgreed) {
            this.iRouter.getLiveRoom().getSpeakQueueVM().agreeSpeakApply(uid);
        } else {
            this.iRouter.getLiveRoom().getSpeakQueueVM().disagreeSpeakApply(uid);
        }
        this.llHandsUpControl.setVisibility(8);
    }

    public void setGroupColor(String color2, int id2) {
        if (this.mediaModel != null && this.mediaModel.getMediaSourceType() != LPConstants.MediaSourceType.MainCamera) {
            return;
        }
        View view = this.$.id(R.id.window_video_view_group).view();
        view.setVisibility(0);
        if (TextUtils.isEmpty((CharSequence)color2)) {
            view.setBackgroundColor(Color.parseColor((String)this.colors[(id2 - 1) % 16]));
        } else {
            view.setBackgroundColor(Color.parseColor((String)color2));
        }
    }

    public boolean disablePullStream() {
        return this.disablePullStream;
    }

    public boolean isShowWindow() {
        return this.showWindow;
    }

    public void setGroupItem(GroupItem groupItemModel) {
        boolean isDifferentGroup;
        this.groupItemModel = groupItemModel;
        IUserModel user = this.mediaModel.getUser();
        if (user instanceof LPUserModel) {
            ((LPUserModel)user).groupId = groupItemModel.id;
        }
        if (this.isLocalVideo()) {
            return;
        }
        boolean bl = isDifferentGroup = this.iRouter.getLiveRoom().getOnlineUserVM().isMediaGroup() && this.iRouter.getLiveRoom().getCurrentUser().getGroup() != groupItemModel.id;
        if (isDifferentGroup) {
            if (this.getMediaSourceType() == LPConstants.MediaSourceType.ExtCamera) {
                this.showWindow = false;
            } else if (this.getMediaSourceType() != LPConstants.MediaSourceType.MainCamera) {
                this.showWindow = true;
                return;
            }
        }
        if (isDifferentGroup) {
            this.disablePullStream = true;
            this.remoteVideoStatus = 4;
            this.stopStreaming(this.getMediaId());
            if (this.videoView != null) {
                this.videoView.setVisibility(8);
            }
            this.placeHolderContainer.setVisibility(0);
            this.ivPlaceholderOnlyAudio.setVisibility(8);
            this.ivPlaceholder.setVisibility(8);
            this.setAudioChange(this.isAudioOn);
            if (groupItemModel.id == 0) {
                this.$.id(R.id.tv_video_group).text((CharSequence)this.getString(R.string.bjy_group_not_group));
            } else {
                this.$.id(R.id.tv_video_group).text((CharSequence)groupItemModel.name);
            }
            this.$.id(R.id.tv_video_group).visibility(0);
            if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
                this.showWindow = false;
            }
            if (!this.showWindow) {
                this.iRouter.getSubjectByKey(EventKey.PlayerViewHide).onNext((Object)this);
            }
        } else if (this.disablePullStream) {
            this.disablePullStream = false;
            if (this.enablePullAudioOnly) {
                if (!this.isJoinBlackboard) {
                    this.remoteVideoStatus = 1;
                }
            } else {
                this.remoteVideoStatus = 0;
            }
            if (this.videoView != null) {
                this.videoView.setVisibility(0);
            }
            this.changeVideoState(this.mediaModel);
            this.setVideoOn(this.isVideoOn());
            this.setAudioOn(this.isAudioOn());
            this.$.id(R.id.tv_video_group).visibility(8);
            if (!this.showWindow) {
                this.showWindow = true;
                this.iRouter.getSubjectByKey(EventKey.PlayerViewHide).onNext((Object)this);
            }
        }
    }

    private void setAudioChange(boolean isAudioOn) {
        this.ivSpeak.setImageLevel(isAudioOn ? 1 : 0);
        if (this.mediaModel != null && this.mediaModel.getMediaSourceType() == LPConstants.MediaSourceType.MainCamera) {
            if (isAudioOn) {
                boolean isScreenShare;
                boolean bl = isScreenShare = this.videoFit == 1;
                if (this.isLocalVideo()) {
                    isScreenShare = this.mRecorder.isScreenSharing();
                }
                if (!isScreenShare) {
                    this.ivShadow.setImageResource(R.drawable.bjy_base_inner_shadow_1);
                } else {
                    this.ivShadow.setImageDrawable(null);
                }
            } else {
                this.ivShadow.setImageDrawable(null);
            }
        }
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    protected void changePlaceholderState(boolean checked) {
        if (!checked && !TextUtils.isEmpty((CharSequence)this.videoCloseBackGroundUrl)) {
            this.simpleTarget = Glide.with((Context)this.context).load(this.videoCloseBackGroundUrl).into((Target)new SimpleTarget<Drawable>(){

                public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                    VideoWindow.this.setPlaceholderResource(true, resource);
                }

                public void onLoadFailed(@Nullable Drawable errorDrawable) {
                    VideoWindow.this.setPlaceholderResource(false, VideoWindow.this.view.getContext().getResources().getDrawable(R.drawable.base_ic_video_camera_mute));
                    VideoWindow.this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_study_status_camera_mute);
                    super.onLoadFailed(errorDrawable);
                }
            });
        } else {
            this.setPlaceholderResource(false, this.view.getContext().getResources().getDrawable(R.drawable.base_ic_video_camera_mute));
            this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_study_status_camera_mute);
        }
        if (this.mediaModel != null) {
            if (this.videoState != LPConstants.MediaState.Normal) {
                if (this.videoState == LPConstants.MediaState.Unavailable) {
                    this.setPlaceholderResource(false, this.view.getContext().getResources().getDrawable(R.drawable.base_ic_video_camera_error));
                    this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_study_status_canot_use);
                } else if (this.videoState == LPConstants.MediaState.Backstage) {
                    this.setPlaceholderResource(false, this.view.getContext().getResources().getDrawable(R.drawable.base_ic_video_backstage));
                    this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_study_status_backstage);
                    this.ivPlaceholder.setVisibility(this.isVideoOn ? 4 : 0);
                    this.placeHolderContainer.setVisibility(this.isVideoOn ? 4 : 0);
                    this.ivPlaceholderOnlyAudio.setVisibility(8);
                } else {
                    this.setPlaceholderResource(false, this.view.getContext().getResources().getDrawable(R.drawable.base_ic_video_occupied));
                    this.$.id(R.id.tv_video_placeholder).text(R.string.bjysc_study_room_study_status_canot_use);
                }
            }
            if (!this.isAudioOn) {
                if (this.audioState == LPConstants.MediaState.Unavailable) {
                    this.ivSpeak.setImageResource(R.drawable.bjysc_video_ic_mic_error);
                } else {
                    this.ivSpeak.setImageResource(R.drawable.level_ic_video_mic);
                    this.setAudioChange(false);
                }
            }
            if (this.disablePullStream) {
                if (this.groupItemModel != null && this.groupItemModel.id != 0) {
                    this.$.id(R.id.tv_video_group).text((CharSequence)this.groupItemModel.name);
                } else {
                    this.$.id(R.id.tv_video_group).text((CharSequence)this.getString(R.string.bjy_group_not_group));
                }
                this.placeHolderContainer.setVisibility(0);
                this.ivPlaceholderOnlyAudio.setVisibility(8);
                this.ivPlaceholder.setVisibility(8);
                this.setAudioChange(this.isAudioOn);
            }
        }
    }

    protected void setPlaceholderResource(boolean isCustom, Drawable videoCloseDrawable) {
        if (this.iRouter == null) {
            return;
        }
        if (isCustom && this.videoCloseImageOriginParams == null) {
            this.videoCloseImageOriginParams = (ConstraintLayout.LayoutParams)this.ivPlaceholder.getLayoutParams();
            ConstraintLayout.LayoutParams newImageParams = new ConstraintLayout.LayoutParams(this.videoCloseImageOriginParams);
            newImageParams.width = -1;
            newImageParams.height = -1;
            newImageParams.bottomMargin = 0;
            this.ivPlaceholder.setLayoutParams((ViewGroup.LayoutParams)newImageParams);
            this.ivPlaceholder.setScaleType(ImageView.ScaleType.CENTER_CROP);
        } else if (!isCustom && this.videoCloseImageOriginParams != null) {
            this.ivPlaceholder.setLayoutParams((ViewGroup.LayoutParams)this.videoCloseImageOriginParams);
            this.ivPlaceholder.setScaleType(ImageView.ScaleType.FIT_CENTER);
            this.videoCloseImageOriginParams = null;
        }
        this.ivPlaceholder.setImageDrawable(videoCloseDrawable);
    }

    public void clearGroupColor() {
        this.$.id(R.id.window_video_view_group).view().setVisibility(8);
    }

    public String getName() {
        TextView tvName = (TextView)this.$.id(R.id.window_video_name).view();
        return tvName.getText().toString();
    }

    public String getUserId() {
        return null != this.mediaModel ? this.mediaModel.getUser().getUserId() : "";
    }

    public String getMediaId() {
        return null != this.mediaModel ? this.mediaModel.getMediaId() : "";
    }

    public boolean isOverlay() {
        return this.isOverlay;
    }

    public void showMenu(boolean isShowMenu) {
        this.isShowMenu = isShowMenu;
        this.ivMenu.setVisibility(8);
    }

    public boolean isShowMenu() {
        return this.isShowMenu && !this.isOnlyInBlackboard && this.isShowSingleTutorMenu();
    }

    public void setOnlyInBlackboard(boolean isOnlyInBlackboard) {
        this.isOnlyInBlackboard = isOnlyInBlackboard;
    }

    public void showHandsUpIcon(boolean isShow) {
        this.ivHandsUp.setVisibility(isShow && !this.iRouter.getLiveRoom().getStudyRoomVM().getStudyRoomMode().isGalleryLayout() ? 0 : 8);
    }

    public void showHandsUpControl(boolean isShow) {
        this.llHandsUpControl.setVisibility(isShow ? 0 : 8);
    }

    public void showTutorHelpIcon(boolean isShow) {
    }

    public void showTutorHandleIcon(boolean isShow) {
    }

    public boolean isLocalVideo() {
        return this.isLocalVideo;
    }

    public void setMenuState(boolean isPressed) {
        this.ivMenu.setSelected(isPressed);
    }

    public boolean isVideoOn() {
        if (this.isLocalVideo) {
            return this.mRecorder.isVideoAttached();
        }
        return this.isVideoOn;
    }

    public boolean isAudioOn() {
        if (this.isLocalVideo) {
            return this.mRecorder.isAudioAttached();
        }
        return this.isAudioOn;
    }

    public boolean isDrawAuthOn() {
        return this.isDrawAuthOn;
    }

    public void setDrawAuthOn(boolean authOn) {
        this.isDrawAuthOn = authOn;
        this.ivDrawAuth.setVisibility(authOn ? 0 : 8);
    }

    public void setPPTAuthOn(boolean pptAuthOn) {
        this.isPPTAuthOn = pptAuthOn;
        this.ivPPTAuth.setVisibility(pptAuthOn ? 0 : 8);
    }

    public boolean isPPTAuthOn() {
        return this.isPPTAuthOn;
    }

    public boolean isAssistCameraOn() {
        return this.isAssistCameraOn;
    }

    public void setAssistCameraOn(boolean assistCameraOn) {
        this.isAssistCameraOn = assistCameraOn;
    }

    public boolean isScreenShareOn() {
        return this.isScreenShareOn;
    }

    public void setScreenShareOn(boolean screenShareOn) {
        this.isScreenShareOn = screenShareOn;
    }

    public void setAudioOn(boolean audioOn) {
        this.isAudioOn = audioOn;
        this.setAudioChange(this.isAudioOn);
        this.ivPlaceholderOnlyAudio.setImageResource(this.isAudioOn ? R.drawable.ic_only_audio_normal : R.drawable.ic_only_audio_none);
        if (this.getUserId().equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId())) {
            this.showMenu(true);
        } else if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            this.showMenu(this.isVideoOn());
        } else if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
            this.showMenu(this.getUserModel().getType() != LPConstants.LPUserType.Teacher || this.isAudioOn() && this.isVideoOn());
        } else {
            this.showMenu(true);
        }
    }

    public void setVideoOn(boolean videoOn) {
        this.isVideoOn = videoOn;
        if (this.getUserId().equals(this.iRouter.getLiveRoom().getCurrentUser().getUserId())) {
            this.showMenu(true);
            this.changePlaceHolder();
        } else {
            this.videoView.setVisibility(this.isVideoOn && !this.isRemoteVideoClose() ? 0 : 8);
            this.changePlaceHolder();
            if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
                this.showMenu(this.isVideoOn());
            } else if (this.iRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
                this.showMenu(this.getUserModel().getType() != LPConstants.LPUserType.Teacher || this.isAudioOn() && this.isVideoOn());
            } else {
                this.showMenu(true);
            }
        }
    }

    private void changePlaceHolder() {
        this.ivPlaceholder.setVisibility(this.isVideoOn && !this.disablePullStream ? 4 : 0);
        this.changePlaceholderState(this.isVideoOn);
        if (this.isVideoOn) {
            if (this.isRemoteVideoClose()) {
                this.hideLoading();
                this.placeHolderContainer.setVisibility(0);
                if (!this.isRemoteVideoClose()) {
                    this.ivPlaceholderOnlyAudio.setVisibility(0);
                }
            } else {
                this.placeHolderContainer.setVisibility(8);
            }
        } else {
            this.placeHolderContainer.setVisibility(0);
            this.ivPlaceholderOnlyAudio.setVisibility(8);
        }
    }

    public String getSelfTutorId() {
        return this.iRouter.getSubjectValueByKey(EventKey.StudyStatusTutor, String.class, "");
    }

    public boolean isRemoteVideoClose() {
        return this.remoteVideoStatus != 0 && this.remoteVideoStatus != 2;
    }

    public boolean isRemoteAVideoClose() {
        return this.remoteVideoStatus == 4;
    }

    public void setVideoRemoteClose(int remoteVideoStatus) {
        this.remoteVideoStatus = remoteVideoStatus;
    }

    public void setRemoteVideoStatus(int remoteVideoStatus) {
        this.remoteVideoStatus = remoteVideoStatus;
        this.placeHolderContainer.setVisibility(this.isRemoteVideoClose() || !this.isVideoOn ? 0 : 8);
        this.ivPlaceholderOnlyAudio.setVisibility(this.isRemoteVideoClose() && !this.isRemoteAVideoClose() && !this.disablePullStream ? 0 : 8);
        this.videoView.setVisibility(this.isRemoteVideoClose() ? 8 : 0);
        if (this.cameraView.getVisibility() == 0) {
            this.cameraView.setVisibility(8);
        }
    }

    public void muteRemoteVideo(boolean mute) {
        if (this.mPlayer != null) {
            if (!mute && !this.mPlayer.isVideoPlaying(this.getMediaId())) {
                this.stopStreaming(this.getMediaId());
                this.streamVideo(this.getMediaId());
            } else {
                this.mPlayer.muteRemoteVideo(this.getMediaId(), mute);
            }
        }
    }

    int[] getMenuPosition() {
        return new int[]{this.currentX + this.getWindowPosition()[0], this.currentY + this.getWindowPosition()[1]};
    }

    public void setAwardTvVisibility(int visibility) {
        this.awardContainer.setVisibility(visibility);
    }

    public void setAwardCount(int count) {
        if (count > 0) {
            this.awardContainer.setVisibility(0);
        }
        this.awardCount.setText((CharSequence)String.valueOf(count));
    }

    private void initAward() {
        LPAwardConfig[] awardConfigs = this.iRouter.getLiveRoom().getToolBoxVM().getAwardConfigs();
        if (awardConfigs == null) {
            return;
        }
        int enableAwardTypeCount = 0;
        LPAwardConfig availableAward = null;
        for (LPAwardConfig lpAwardConfig : awardConfigs) {
            if (lpAwardConfig.isEnable != 1) continue;
            availableAward = lpAwardConfig;
            ++enableAwardTypeCount;
        }
        if (enableAwardTypeCount <= 1 && availableAward != null) {
            Glide.with((View)this.awardIcon).load(availableAward.logoUrl).into(this.awardIcon);
            this.availableAward = availableAward;
        } else {
            this.awardIcon.setImageResource(R.drawable.base_ic_video_award_default);
            this.availableAward = null;
        }
    }

    public void setAwardClickListener(IVideoWindowCallback callback) {
        this.initAward();
        this.$.id(R.id.window_video_awards).clicked(v -> {
            if (this.availableAward == null) {
                if (this.awardPopupWindow == null) {
                    this.awardPopupWindow = new AwardPopupWindow(this.context, this.getUserModel(), callback::onAwardTvClicked);
                }
                if (this.awardPopupWindow.isShowing()) {
                    this.awardPopupWindow.dismiss();
                } else {
                    this.awardPopupWindow.setUserModel(this.getUserModel());
                    this.awardPopupWindow.show(this.$.id(R.id.window_video_awards).view());
                }
            } else {
                if (!BaseUtilsKt.isAdmin((LiveRoom)this.iRouter.getLiveRoom())) {
                    return;
                }
                callback.onAwardTvClicked(this.getUserModel(), this.availableAward.key);
            }
        });
    }

    public LPConstants.MediaSourceType getMediaSourceType() {
        return this.mediaModel.getMediaSourceType();
    }

    public boolean isScreenShare() {
        return this.mediaModel.isScreenShare();
    }

    public void setBottomVisibility(int visibility) {
        this.clBottom.setVisibility(visibility);
    }

    private void showLoading() {
        if (this.loadingListener == null) {
            this.loadingListener = new LoadingListener(this);
            this.mPlayer.addPlayerListener((LPPlayerListener)this.loadingListener);
        }
        this.$.id(R.id.item_speak_speaker_loading_container).visible();
        if (this.animator == null) {
            this.animator = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f});
            this.animator.setDuration(500L);
            this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.animator.setRepeatCount(-1);
            this.animator.setRepeatMode(2);
        }
        this.animator.addUpdateListener(animation -> {
            float currentScale = ((Float)animation.getAnimatedValue()).floatValue();
            for (int value : this.loadingImgGroup) {
                if (currentScale >= 0.5f && currentScale <= 1.5f) {
                    this.$.id(value).view().setScaleY(currentScale <= 1.0f ? currentScale : 2.0f - currentScale);
                } else {
                    this.$.id(value).view().setScaleY(currentScale -= 1.0f);
                }
                this.$.id(value).view().requestLayout();
                currentScale += 0.25f;
            }
        });
        this.animator.start();
    }

    private void hideLoading() {
        if (this.$ == null) {
            return;
        }
        this.$.id(R.id.item_speak_speaker_loading_container).gone();
        if (this.animator != null) {
            this.animator.removeAllUpdateListeners();
            this.animator.cancel();
        }
        for (int loadingImgId : this.loadingImgGroup) {
            this.$.id(loadingImgId).view().clearAnimation();
        }
    }

    @Override
    protected void unSubscribe() {
        super.unSubscribe();
        if (this.animator != null) {
            this.animator.removeAllUpdateListeners();
            this.animator.cancel();
        }
    }

    @Override
    public void onDestroy() {
        this.disposables.clear();
        if (this.animator != null) {
            this.animator.removeAllUpdateListeners();
            this.animator.cancel();
        }
        RxUtils.dispose((Disposable)this.timer);
        this.closeAV();
        if (this.mPlayer != null) {
            this.mPlayer.removePlayerListener((LPPlayerListener)this.loadingListener);
        }
        if (this.awardPopupWindow != null) {
            this.awardPopupWindow.dismiss();
            this.awardPopupWindow.onDestroy();
            this.awardPopupWindow = null;
            this.availableAward = null;
        }
        this.mPlayer = null;
        this.mRecorder = null;
        this.upLossRateQueue.clear();
        this.downLinkLossRateQueue.clear();
        if (this.simpleTarget != null && this.context instanceof Activity && !((Activity)this.context).isDestroyed()) {
            Glide.with((Context)this.context).clear(this.simpleTarget);
        }
        super.onDestroy();
    }

    public boolean isDestroyed() {
        return !this.isWindowInit;
    }

    public void setRemoteVideoStreamType(BJYRtcCommon.DualStreamType streamType) {
        if (this.isLocalVideo()) {
            return;
        }
        this.mPlayer.setRemoteVideoStreamType(this.getMediaId(), streamType);
        this.defaultRemoteStreamType = streamType;
    }

    public void setResolutionText(int width, int height) {
        this.resolutionTest.setText((CharSequence)(width + "*" + height));
    }

    public void setAspectRatio(LPConstants.LPAspectRatio aspectRatio) {
        this.cameraView.setAspectRatio(aspectRatio);
        this.videoView.setAspectRatio(aspectRatio);
    }

    private void showPermissionNotGrantedDialog(String tip) {
        new CommonDialog(this.context, CommonDialog.ChoiceMode.Single_Blue).setIconDrawableId(R.drawable.ic_warning).setMainDisplayText(tip).setPositive(this.context.getResources().getText(R.string.bjysc_confirm).toString(), (dialog, which) -> dialog.dismiss()).show();
    }

    private /* synthetic */ void lambda$setMediaModel$33(IUserModel iUserModel, LPVideoSizeModel lpVideoSizeModel) throws Exception {
        if (lpVideoSizeModel.userId.equals(iUserModel.getUserId())) {
            this.setResolutionText(lpVideoSizeModel.width, lpVideoSizeModel.height);
        }
    }

    public class LoadingListener
    implements LPPlayerListener {
        private WeakReference<VideoWindow> videoWindowWeakReference;

        LoadingListener(VideoWindow videoWindow) {
            this.videoWindowWeakReference = new WeakReference<VideoWindow>(videoWindow);
        }

        public void onReadyToPlay(String mediaId) {
            if (Objects.equals(mediaId, VideoWindow.this.mediaModel.getMediaId())) {
                LPLogger.d((String)VideoWindow.this.TAG, (String)("onReadyToPlay mediaId=" + mediaId));
            }
            this.hideLoading(mediaId);
            VideoWindow.this.setRemoteVideoStreamType(VideoWindow.this.defaultRemoteStreamType);
        }

        public void onPlayAudioSuccess(String mediaId) {
        }

        public void onPlayVideoSuccess(String mediaId) {
            LPLogger.e((String)VideoWindow.this.TAG, (String)("onPlayVideoSuccess:" + mediaId + "\uff0cgetMediaId:" + VideoWindow.this.getMediaId() + ",isOverlay:" + VideoWindow.this.isOverlay));
            if (TextUtils.equals((CharSequence)VideoWindow.this.getMediaId(), (CharSequence)mediaId)) {
                VideoWindow.this.setZOrderMediaOverlay(VideoWindow.this.isOverlay);
            }
        }

        public void onPlayClose(String mediaId) {
        }

        private void hideLoading(String mediaId) {
            VideoWindow videoWindow = (VideoWindow)this.videoWindowWeakReference.get();
            if (videoWindow == null || videoWindow.getView() == null || !TextUtils.equals((CharSequence)mediaId, (CharSequence)videoWindow.getMediaId())) {
                return;
            }
            LPLogger.d((String)VideoWindow.this.TAG, (String)("hideLoading mediaId=" + mediaId));
            videoWindow.hideLoading();
        }
    }

    public static interface IVideoWindowCallback {
        public void onAwardTvClicked(IUserModel var1, String var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RemoteVideoStatus {
    }
}

