/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.window.toolbox.smallblackboard;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.model.SbbStatusModel;
import java.util.List;

public class SbbCommitStatusAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private List<SbbStatusModel> sbbStatusModelList;
    private static final int VIEW_TYPE_SBB = 0;
    private static final int VIEW_TYPE_LOADING = 1;
    public boolean isLoading;

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return new SbbCommitStatusViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_sbb_commit_status, null));
        }
        if (viewType == 1) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_snippet_loadmore, parent, false);
            return new SbbLoadingViewHolder(view);
        }
        return null;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        if (position >= this.sbbStatusModelList.size()) {
            return;
        }
        if (viewHolder instanceof SbbCommitStatusViewHolder) {
            SbbCommitStatusViewHolder holder = (SbbCommitStatusViewHolder)viewHolder;
            SbbStatusModel statusModel = this.sbbStatusModelList.get(position);
            switch (statusModel.sbbStatus) {
                case NORMAL: {
                    holder.checkIv.setVisibility(8);
                    holder.redDotIv.setVisibility(8);
                    break;
                }
                case COMMIT: {
                    holder.checkIv.setVisibility(0);
                    holder.redDotIv.setVisibility(0);
                    break;
                }
                case READ: {
                    holder.checkIv.setVisibility(0);
                    holder.redDotIv.setVisibility(8);
                    break;
                }
            }
            holder.commitStudentTv.setText((CharSequence)this.sbbStatusModelList.get((int)position).user.getName());
        } else {
            SbbLoadingViewHolder loadingViewHolder = (SbbLoadingViewHolder)viewHolder;
            loadingViewHolder.progressBar.setIndeterminate(true);
        }
    }

    public int getItemCount() {
        return this.sbbStatusModelList.size();
    }

    public int getItemViewType(int position) {
        return this.isLoading ? 1 : 0;
    }

    public void setData(List<SbbStatusModel> models) {
        this.sbbStatusModelList = models;
    }

    static class SbbLoadingViewHolder
    extends RecyclerView.ViewHolder {
        ProgressBar progressBar;

        public SbbLoadingViewHolder(@NonNull View itemView) {
            super(itemView);
            this.progressBar = (ProgressBar)itemView.findViewById(R.id.item_online_user_progress);
        }
    }

    static class SbbCommitStatusViewHolder
    extends RecyclerView.ViewHolder {
        ImageView checkIv;
        TextView commitStudentTv;
        ImageView redDotIv;

        public SbbCommitStatusViewHolder(View itemView) {
            super(itemView);
            this.checkIv = (ImageView)itemView.findViewById(R.id.sbb_commit_item_check_iv);
            this.commitStudentTv = (TextView)itemView.findViewById(R.id.sbb_commit_student_name);
            this.redDotIv = (ImageView)itemView.findViewById(R.id.sbb_red_dot);
        }
    }
}

