/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.view.GestureDetectorCompat;

public class LongPressImageView
extends AppCompatImageView {
    private GestureDetectorCompat gestureDetectorCompat;
    private LongPressGesture longPressGesture;
    private OnLongPressListener onLongPressListener;

    public LongPressImageView(Context context) {
        this(context, null);
    }

    public LongPressImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LongPressImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.longPressGesture = new LongPressGesture();
        this.gestureDetectorCompat = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)this.longPressGesture);
        this.setOnClickListener(v -> {});
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.gestureDetectorCompat.onTouchEvent(event);
        if (event.getAction() == 1) {
            if (this.getVisibility() != 0) {
                return super.onTouchEvent(event);
            }
            if (this.longPressGesture.isLongPressed) {
                this.longPressGesture.isLongPressed = false;
                if (this.onLongPressListener != null) {
                    this.onLongPressListener.onCancelLongPress((View)this);
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public void setOnLongPressListener(OnLongPressListener onLongPressListener) {
        this.onLongPressListener = onLongPressListener;
    }

    public static interface OnLongPressListener {
        public void onClick(View var1);

        public void onLongPress(View var1);

        public void onCancelLongPress(View var1);
    }

    class LongPressGesture
    extends GestureDetector.SimpleOnGestureListener {
        boolean isLongPressed;

        LongPressGesture() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (LongPressImageView.this.onLongPressListener != null) {
                LongPressImageView.this.onLongPressListener.onClick((View)LongPressImageView.this);
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
            if (LongPressImageView.this.onLongPressListener != null) {
                LongPressImageView.this.onLongPressListener.onLongPress((View)LongPressImageView.this);
            }
            this.isLongPressed = true;
        }
    }
}

