/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.groupclassui.layer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.groupclassui.R;
import com.baijiayun.groupclassui.container.ShapePaint;
import com.baijiayun.groupclassui.global.EventKey;
import com.baijiayun.groupclassui.layer.BaseLayerOfProfessionalClass;
import com.baijiayun.groupclassui.window.blackboard.BlackImageWindow;
import com.baijiayun.groupclassui.window.blackboard.BlackboardListener;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPGroupItem;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.List;

public class BlackboardLayer
extends BaseLayerOfProfessionalClass
implements BlackboardListener {
    private BlackImageWindow blackImageWindow;
    private ImageView bgLayout;
    private ShapePaint shapePaint;
    private int whiteboardHeight = 0;
    private SimpleTarget<Bitmap> simpleTarget;
    private Runnable runnable;
    private Disposable disposableOfGroupUpdate;
    private RelativeLayout groupLabel;
    private boolean showGroupLabel;

    public BlackboardLayer(@NonNull Context context) {
        super(context);
    }

    public void initView() {
        this.removeAllViews();
        if (this.blackImageWindow != null) {
            this.blackImageWindow.onDestroy();
        }
        this.blackImageWindow = new BlackImageWindow(this.getContext());
        this.blackImageWindow.initListener();
        this.bgLayout = new ImageView(this.getContext());
        this.bgLayout.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.bgLayout, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView(this.blackImageWindow.getView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.initWhiteboardViewHeight();
        if (this.shapePaint != null) {
            this.blackImageWindow.setShapePaint(this.shapePaint);
        }
        this.groupLabel = new RelativeLayout(this.getContext());
        this.addView((View)this.groupLabel);
        this.disposableOfGroupUpdate = this.router.getLiveRoom().getOnlineUserVM().getObservableOfOnGroupItem().observeOn(AndroidSchedulers.mainThread()).subscribe(lpGroupItems -> {
            if (this.router.getLiveRoom().getCurrentUser().getGroup() != 0 && this.router.getLiveRoom().getOnlineUserVM().isMediaGroup()) {
                for (LPGroupItem groupItem : lpGroupItems) {
                    if (groupItem.id != this.router.getLiveRoom().getCurrentUser().getGroup() || groupItem.groupItemModel == null) continue;
                    this.addText(this.getContext().getString(R.string.bjy_group_locate, new Object[]{groupItem.groupItemModel.name}));
                    break;
                }
            } else {
                this.showGroupToast((List<LPGroupItem>)lpGroupItems);
                this.groupLabel.removeAllViews();
                this.groupLabel.setVisibility(8);
                this.showGroupLabel = false;
            }
        });
    }

    private void showGroupToast(List<LPGroupItem> groupItemList) {
        int count = 0;
        for (LPGroupItem groupItem : groupItemList) {
            count += groupItem.count;
        }
        if (this.router.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            if (count == 0 || groupItemList.size() == 0) {
                if (this.showGroupLabel) {
                    this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(R.string.bjy_group_group_end));
                }
            } else if (this.showGroupLabel) {
                this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(R.string.bjy_group_group_remove));
            }
        }
    }

    @SuppressLint(value={"CheckResult"})
    private void addText(String message) {
        if (!this.showGroupLabel) {
            this.router.getSubjectByKey(EventKey.ReminderMessage).onNext((Object)this.getContext().getString(R.string.bjy_group_set_group));
        }
        this.showGroupLabel = true;
        this.groupLabel.removeAllViews();
        this.groupLabel.setVisibility(0);
        this.groupLabel.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_brand_container_color)).bottomRightRadius(this.getContext().getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        TextView textView = new TextView(this.getContext());
        textView.setText((CharSequence)message);
        textView.setTextSize(12.0f);
        textView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_assistant_text_color));
        RelativeLayout.LayoutParams tp = new RelativeLayout.LayoutParams(-2, -1);
        tp.addRule(15);
        tp.setMarginStart(UtilsKt.getDp((int)10));
        tp.setMarginEnd(UtilsKt.getDp((int)10));
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setGravity(8388627);
        textView.setTextAlignment(4);
        textView.measure(0, 0);
        int measuredWidth = textView.getMeasuredWidth();
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(measuredWidth + UtilsKt.getDp((int)20), this.getContext().getResources().getDimensionPixelSize(R.dimen.bjysc_remind_label_height));
        this.groupLabel.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.groupLabel.addView((View)textView, (ViewGroup.LayoutParams)tp);
    }

    @Override
    public boolean onRoomStatusChange(boolean isRoomActive) {
        boolean isLayerInit = super.onRoomStatusChange(isRoomActive);
        if (isLayerInit && !isRoomActive) {
            this.unSubscribe();
        }
        return true;
    }

    private void unSubscribe() {
        LPLogger.d((String)"wtf", (String)"blackboardLayer unSubscribe");
        this.removeCallbacks(this.runnable);
        if (this.blackImageWindow != null) {
            this.blackImageWindow.onDestroy();
        }
        this.blackImageWindow = null;
        Glide.with((Context)this.getContext().getApplicationContext()).clear(this.simpleTarget);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.disposableOfGroupUpdate);
        this.unSubscribe();
    }

    private void initWhiteboardViewHeight() {
        this.whiteboardHeight = this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE ? this.getMeasuredHeight() * this.router.getLiveRoom().getPartnerConfig().live1v1BlackboardPages : this.getMeasuredHeight() * this.router.getLiveRoom().getPartnerConfig().liveBlackboardPages;
        this.blackImageWindow.initWhiteBoardHeight(this.whiteboardHeight);
        this.bgLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.getMeasuredHeight()));
        this.runnable = this::initWhiteboardBackground;
        this.post(this.runnable);
    }

    private void initWhiteboardBackground() {
        if (this.router == null) {
            return;
        }
        String whiteboardBackgroundUrl = this.router.getLiveRoom().getWhiteboardBackgroundUrl();
        this.whiteboardHeight = this.router.getLiveRoom().getSmallClassTemplateType() == LPConstants.SmallClassTemplateType.ONEONONE ? this.getMeasuredHeight() * this.router.getLiveRoom().getPartnerConfig().live1v1BlackboardPages : this.getMeasuredHeight() * this.router.getLiveRoom().getPartnerConfig().liveBlackboardPages;
        this.bgLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.getMeasuredHeight()));
        this.blackImageWindow.initWhiteBoardHeight(this.whiteboardHeight);
        boolean isDefaultWhiteBoard = this.router.getLiveRoom().isDefaultWhiteBoard();
        if (!isDefaultWhiteBoard && !TextUtils.isEmpty((CharSequence)whiteboardBackgroundUrl)) {
            this.simpleTarget = new SimpleTarget<Bitmap>(){

                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    BitmapDrawable bitmapDrawable = new BitmapDrawable(BlackboardLayer.this.getResources(), resource);
                    bitmapDrawable.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
                    BlackboardLayer.this.bgLayout.setImageDrawable((Drawable)bitmapDrawable);
                }
            };
            Glide.with((Context)this.getContext()).asBitmap().load(whiteboardBackgroundUrl).into(this.simpleTarget);
        } else {
            ColorDrawable drawable2 = new ColorDrawable(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_blackboard_color));
            this.bgLayout.setImageDrawable((Drawable)drawable2);
        }
    }

    @Override
    public void scrollTo(float ratio) {
        this.blackImageWindow.scrollTo(ratio);
    }

    @Override
    public BlackImageWindow getBlackImageWindow() {
        return this.blackImageWindow;
    }

    @Override
    public void setShapePaint(ShapePaint shapePaint) {
        this.shapePaint = shapePaint;
    }
}

